/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.broadcastify;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class BroadcastifyCallConfiguration
extends BroadcastConfiguration {
    public static final String DEVELOPMENT_ENDPOINT = "https://api.broadcastify.com/call-upload-dev";
    public static final String PRODUCTION_ENDPOINT = "https://api.broadcastify.com/call-upload";
    private IntegerProperty mSystemID = new SimpleIntegerProperty();
    private StringProperty mApiKey = new SimpleStringProperty();
    private BooleanProperty mTestEnabled = new SimpleBooleanProperty(false);
    private IntegerProperty mTestInterval = new SimpleIntegerProperty(15);

    public BroadcastifyCallConfiguration() {
        this(BroadcastFormat.MP3);
    }

    public BroadcastifyCallConfiguration(BroadcastFormat format) {
        super(format);
        if (this.getHost() == null) {
            this.setHost(PRODUCTION_ENDPOINT);
        }
        this.mValid.unbind();
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mSystemID, (int)0), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mApiKey)), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost)));
    }

    public IntegerProperty systemIDProperty() {
        return this.mSystemID;
    }

    public StringProperty apiKeyProperty() {
        return this.mApiKey;
    }

    @JacksonXmlProperty(isAttribute=true, localName="api_key")
    public String getApiKey() {
        return (String)this.mApiKey.get();
    }

    public void setApiKey(String apiKey) {
        this.mApiKey.setValue(apiKey);
    }

    @JacksonXmlProperty(isAttribute=true, localName="system_id")
    public int getSystemID() {
        return this.mSystemID.get();
    }

    public void setSystemID(int systemID) {
        this.mSystemID.set(systemID);
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.BROADCASTIFY_CALL;
    }

    @JacksonXmlProperty(isAttribute=true, localName="test_enabled")
    public boolean isTestEnabled() {
        return this.mTestEnabled.get();
    }

    public void setTestEnabled(boolean enabled) {
        this.mTestEnabled.set(enabled);
    }

    @JacksonXmlProperty(isAttribute=true, localName="test_interval")
    public int getTestInterval() {
        return this.mTestInterval.get();
    }

    public void setTestInterval(int interval) {
        this.mTestInterval.set(interval);
    }

    @Override
    public BroadcastConfiguration copyOf() {
        BroadcastifyCallConfiguration copy = new BroadcastifyCallConfiguration();
        copy.setSystemID(this.getSystemID());
        return copy;
    }
}

