/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.broadcastify;

import io.github.dsheirer.audio.broadcast.broadcastify.FormField;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;

public class BroadcastifyCallBuilder {
    private static final String DASH_DASH = "--";
    private static final String BOUNDARY = "--sdrtrunk-sdrtrunk-sdrtrunk";
    private List<Part> mParts = new ArrayList<Part>();

    public String getBoundary() {
        return BOUNDARY;
    }

    public BroadcastifyCallBuilder addPart(FormField key, String value) {
        if (key != null && value != null) {
            this.mParts.add(new Part(this, key.getHeader(), value));
        }
        return this;
    }

    public BroadcastifyCallBuilder addPart(FormField key, Number value) {
        if (key != null && value != null) {
            this.mParts.add(new Part(this, key.getHeader(), value.toString()));
        }
        return this;
    }

    private static String formatPart(Part part, String boundary) {
        StringBuilder sb = new StringBuilder();
        sb.append(DASH_DASH).append(boundary).append("\r\n");
        sb.append("Content-Disposition: form-data; name=\"").append(part.mKey).append("\"\r\n\r\n");
        sb.append(part.getValue()).append("\r\n");
        return sb.toString();
    }

    private static String getClosingBoundary(String boundary) {
        StringBuilder sb = new StringBuilder();
        sb.append(DASH_DASH).append(boundary).append(DASH_DASH).append("\r\n");
        return sb.toString();
    }

    public HttpRequest.BodyPublisher build() {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.mParts) {
            sb.append(BroadcastifyCallBuilder.formatPart(part, BOUNDARY));
        }
        sb.append(BroadcastifyCallBuilder.getClosingBoundary(BOUNDARY));
        return HttpRequest.BodyPublishers.ofByteArray(sb.toString().getBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.mParts) {
            sb.append(BroadcastifyCallBuilder.formatPart(part, BOUNDARY));
        }
        sb.append(BroadcastifyCallBuilder.getClosingBoundary(BOUNDARY));
        return sb.toString();
    }

    public class Part {
        private String mKey;
        private String mValue;

        public Part(BroadcastifyCallBuilder this$0, String key, String value) {
            this.mKey = key;
            this.mValue = value;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

