/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.broadcastify;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.AbstractAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallBuilder;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallConfiguration;
import io.github.dsheirer.audio.broadcast.broadcastify.FormField;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.ConfigurationLongIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.util.ThreadPool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastifyCallBroadcaster
extends AbstractAudioBroadcaster<BroadcastifyCallConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastifyCallBroadcaster.class);
    private static final String ENCODING_TYPE_MP3 = "mp3";
    private static final String MULTIPART_TYPE = "multipart";
    private static final String DEFAULT_SUBTYPE = "form-data";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private ScheduledFuture<?> mBroadcastifyTestFuture;
    private Queue<AudioRecording> mAudioRecordingQueue = new LinkedTransferQueue<AudioRecording>();
    private ScheduledFuture<?> mAudioRecordingProcessorFuture;
    private HttpClient mHttpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
    private long mLastConnectionAttempt;
    private long mConnectionAttemptInterval = 5000L;

    public BroadcastifyCallBroadcaster(BroadcastifyCallConfiguration config, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(config);
    }

    @Override
    public void start() {
        this.setBroadcastState(BroadcastState.CONNECTING);
        String response = BroadcastifyCallBroadcaster.testConnection((BroadcastifyCallConfiguration)this.getBroadcastConfiguration());
        this.mLastConnectionAttempt = System.currentTimeMillis();
        if (response != null && response.toLowerCase().startsWith("ok")) {
            this.setBroadcastState(BroadcastState.CONNECTED);
        } else {
            mLog.error("Error connecting to Broadcastify calls server on startup [" + response + "]");
            this.setBroadcastState(BroadcastState.ERROR);
        }
        if (this.mBroadcastifyTestFuture == null && ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).isTestEnabled()) {
            this.mBroadcastifyTestFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new BroadcastifyCallTest(), ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getTestInterval(), ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getTestInterval(), TimeUnit.MINUTES);
        }
        if (this.mAudioRecordingProcessorFuture == null) {
            this.mAudioRecordingProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new AudioRecordingProcessor(), 0L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.mBroadcastifyTestFuture != null) {
            this.mBroadcastifyTestFuture.cancel(true);
            this.mBroadcastifyTestFuture = null;
        }
        if (this.mAudioRecordingProcessorFuture != null) {
            this.mAudioRecordingProcessorFuture.cancel(true);
            this.mAudioRecordingProcessorFuture = null;
            this.dispose();
            this.setBroadcastState(BroadcastState.DISCONNECTED);
        }
    }

    @Override
    public void dispose() {
        AudioRecording audioRecording = this.mAudioRecordingQueue.poll();
        while (audioRecording != null) {
            audioRecording.removePendingReplay();
            audioRecording = this.mAudioRecordingQueue.poll();
        }
    }

    private boolean connected() {
        if (this.getBroadcastState() != BroadcastState.CONNECTED && System.currentTimeMillis() - this.mLastConnectionAttempt > this.mConnectionAttemptInterval) {
            this.setBroadcastState(BroadcastState.CONNECTING);
            String response = BroadcastifyCallBroadcaster.testConnection((BroadcastifyCallConfiguration)this.getBroadcastConfiguration());
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (response != null && response.toLowerCase().startsWith("ok")) {
                this.setBroadcastState(BroadcastState.CONNECTED);
            } else {
                this.setBroadcastState(BroadcastState.ERROR);
            }
        }
        return this.getBroadcastState() == BroadcastState.CONNECTED;
    }

    @Override
    public int getAudioQueueSize() {
        return this.mAudioRecordingQueue.size();
    }

    @Override
    public void receive(AudioRecording audioRecording) {
        this.mAudioRecordingQueue.offer(audioRecording);
        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
    }

    private boolean isValid(AudioRecording audioRecording) {
        return audioRecording != null && System.currentTimeMillis() - audioRecording.getStartTime() <= ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getMaximumRecordingAge();
    }

    private void processRecordingQueue() {
        AudioRecording audioRecording;
        while (this.connected() && !this.mAudioRecordingQueue.isEmpty()) {
            audioRecording = this.mAudioRecordingQueue.poll();
            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
            if (!this.isValid(audioRecording) || audioRecording.getRecordingLength() <= 0L) continue;
            float durationSeconds = (float)audioRecording.getRecordingLength() / 1000.0f;
            long timestampSeconds = (int)((double)audioRecording.getStartTime() / 1000.0);
            String talkgroup = BroadcastifyCallBroadcaster.getTo(audioRecording);
            String radioId = BroadcastifyCallBroadcaster.getFrom(audioRecording);
            float frequency = BroadcastifyCallBroadcaster.getFrequency(audioRecording);
            BroadcastifyCallBuilder bodyBuilder = new BroadcastifyCallBuilder();
            bodyBuilder.addPart(FormField.API_KEY, ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getApiKey()).addPart(FormField.SYSTEM_ID, ((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getSystemID()).addPart(FormField.CALL_DURATION, Float.valueOf(durationSeconds)).addPart(FormField.TIMESTAMP, timestampSeconds).addPart(FormField.TALKGROUP_ID, talkgroup).addPart(FormField.RADIO_ID, radioId).addPart(FormField.FREQUENCY, Float.valueOf(frequency)).addPart(FormField.ENCODING, ENCODING_TYPE_MP3);
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(((BroadcastifyCallConfiguration)this.getBroadcastConfiguration()).getHost())).header("Content-Type", "multipart/form-data; boundary=" + bodyBuilder.getBoundary()).header("User-Agent", "sdrtrunk").header("Accept", "*/*").POST(bodyBuilder.build()).build();
                this.mHttpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).whenComplete((stringHttpResponse, throwable) -> {
                    if (throwable != null || stringHttpResponse.statusCode() != 200) {
                        if (!(throwable instanceof IOException) && !(throwable instanceof CompletionException)) {
                            mLog.error("Error while sending upload URL request" + throwable.getLocalizedMessage());
                            this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                        }
                        this.incrementErrorAudioCount();
                        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                    } else {
                        String urlResponse = (String)stringHttpResponse.body();
                        if (urlResponse.startsWith("0 ")) {
                            HttpRequest.BodyPublisher filePublisher = null;
                            try {
                                filePublisher = HttpRequest.BodyPublishers.ofFile(audioRecording.getPath());
                            }
                            catch (FileNotFoundException fnfe) {
                                mLog.error("Broadcastify calls API - audio recording file not found - ignoring upload");
                            }
                            if (filePublisher != null) {
                                HttpRequest fileRequest = HttpRequest.newBuilder().uri(URI.create(urlResponse.substring(2))).header("User-Agent", "sdrtrunk").header("Content-Type", "audio/mpeg").PUT(filePublisher).build();
                                this.mHttpClient.sendAsync(fileRequest, HttpResponse.BodyHandlers.ofString()).whenComplete((fileResponse, throwable1) -> {
                                    if (throwable1 != null || fileResponse.statusCode() != 200) {
                                        if (!(throwable1 instanceof IOException) && !(throwable1 instanceof CompletionException)) {
                                            this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                                            mLog.error("Broadcastify calls API file upload fail [" + fileResponse.statusCode() + "] response [" + (String)fileResponse.body() + "]");
                                        }
                                        this.incrementErrorAudioCount();
                                        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                                    } else {
                                        this.incrementStreamedAudioCount();
                                        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_STREAMED_COUNT_CHANGE));
                                    }
                                    audioRecording.removePendingReplay();
                                });
                            } else {
                                mLog.error("Broadcastify calls API - upload file not found [" + audioRecording.getPath().toString() + "]");
                                this.incrementErrorAudioCount();
                                this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                                audioRecording.removePendingReplay();
                            }
                        } else if (urlResponse.startsWith("1 SKIPPED")) {
                            audioRecording.removePendingReplay();
                        } else {
                            mLog.error("Broadcastify calls API upload URL request failed [" + urlResponse + "]");
                            this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                            this.incrementErrorAudioCount();
                            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                            audioRecording.removePendingReplay();
                        }
                    }
                });
            }
            catch (Exception e) {
                mLog.error("Unknown Error", (Throwable)e);
                this.setBroadcastState(BroadcastState.ERROR);
                this.incrementErrorAudioCount();
                this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                audioRecording.removePendingReplay();
            }
        }
        audioRecording = this.mAudioRecordingQueue.peek();
        while (audioRecording != null) {
            if (this.isValid(audioRecording)) {
                return;
            }
            this.mAudioRecordingQueue.poll();
            audioRecording.removePendingReplay();
            this.incrementAgedOffAudioCount();
            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_AGED_OFF_COUNT_CHANGE));
            audioRecording = this.mAudioRecordingQueue.peek();
        }
    }

    private static float getFrequency(AudioRecording audioRecording) {
        Long value;
        Identifier identifier = audioRecording.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL_FREQUENCY, Role.ANY);
        if (identifier instanceof ConfigurationLongIdentifier && (value = (Long)((ConfigurationLongIdentifier)identifier).getValue()) != null) {
            return (float)value.longValue() / 1000000.0f;
        }
        return 0.0f;
    }

    private static String getFrom(AudioRecording audioRecording) {
        for (Identifier identifier : audioRecording.getIdentifierCollection().getIdentifiers(Role.FROM)) {
            if (!(identifier instanceof RadioIdentifier)) continue;
            return ((Integer)((RadioIdentifier)identifier).getValue()).toString();
        }
        return "0";
    }

    private static String getTo(AudioRecording audioRecording) {
        Identifier identifier = audioRecording.getIdentifierCollection().getToIdentifier();
        if (identifier instanceof PatchGroupIdentifier) {
            PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
            return BroadcastifyCallBroadcaster.format(patchGroupIdentifier);
        }
        if (identifier instanceof TalkgroupIdentifier) {
            TalkgroupIdentifier talkgroupIdentifier = (TalkgroupIdentifier)identifier;
            return String.valueOf(RadioReferenceDecoder.convertToRadioReferenceTalkgroup((Integer)talkgroupIdentifier.getValue(), talkgroupIdentifier.getProtocol()));
        }
        if (identifier instanceof RadioIdentifier) {
            RadioIdentifier radioIdentifier = (RadioIdentifier)identifier;
            return ((Integer)radioIdentifier.getValue()).toString();
        }
        return "0";
    }

    public static String format(PatchGroupIdentifier patchGroupIdentifier) {
        PatchGroup patchGroup = (PatchGroup)patchGroupIdentifier.getValue();
        StringBuilder sb = new StringBuilder();
        sb.append(((Integer)patchGroup.getPatchGroup().getValue()).toString());
        for (TalkgroupIdentifier talkgroupIdentifier : patchGroup.getPatchedTalkgroupIdentifiers()) {
            sb.append(",").append(talkgroupIdentifier.getValue());
        }
        for (RadioIdentifier radioIdentifier : patchGroup.getPatchedRadioIdentifiers()) {
            sb.append(",").append(radioIdentifier.getValue());
        }
        return sb.toString();
    }

    public static String testConnection(BroadcastifyCallConfiguration configuration) {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
        BroadcastifyCallBuilder bodyBuilder = new BroadcastifyCallBuilder();
        bodyBuilder.addPart(FormField.API_KEY, configuration.getApiKey()).addPart(FormField.SYSTEM_ID, configuration.getSystemID()).addPart(FormField.TEST, 1);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(configuration.getHost())).header("Content-Type", "multipart/form-data; boundary=" + bodyBuilder.getBoundary()).header("User-Agent", "sdrtrunk").header("Accept", "*/*").POST(bodyBuilder.build()).build();
        HttpResponse.BodyHandler<String> responseHandler = HttpResponse.BodyHandlers.ofString();
        try {
            HttpResponse<String> response = httpClient.send(request, responseHandler);
            String responseBody = response.body();
            return (responseBody != null ? responseBody : "(no response)") + " Status Code:" + response.statusCode();
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    public static void main(String[] args) {
        mLog.debug("Starting ...");
        BroadcastifyCallConfiguration config = new BroadcastifyCallConfiguration();
        config.setHost("https://api.broadcastify.com/call-upload-dev");
        config.setApiKey("c33aae37-8572-11ea-bd8b-0ecc8ab9ccec");
        config.setSystemID(11);
        String response = BroadcastifyCallBroadcaster.testConnection(config);
        if (response == null) {
            mLog.debug("Test Successful!");
        } else if (response.contains("1 Invalid-API-Key")) {
            mLog.error("Invalid API Key");
        } else if (response.contains("1 API-Key-Access-Denied")) {
            mLog.error("System ID not valid for API Key");
        } else {
            mLog.debug("Response: " + response);
        }
        mLog.debug("Finished!");
    }

    public class BroadcastifyCallTest
    implements Runnable {
        @Override
        public void run() {
            String response = BroadcastifyCallBroadcaster.testConnection((BroadcastifyCallConfiguration)BroadcastifyCallBroadcaster.this.getBroadcastConfiguration());
            if (response != null && response.toLowerCase().startsWith("ok")) {
                mLog.info("Broadcastify Calls keep-alive success");
            } else {
                mLog.info("Broadcastify Calls keep-alive failure");
            }
        }
    }

    public class AudioRecordingProcessor
    implements Runnable {
        @Override
        public void run() {
            BroadcastifyCallBroadcaster.this.processRecordingQueue();
        }
    }
}

