/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.audio.broadcast.BroadcastModel;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.swing.JTableColumnWidthMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class BroadcastStatusPanel
extends JPanel {
    private JTable mTable;
    private JTableColumnWidthMonitor mColumnWidthMonitor;
    private JScrollPane mScrollPane;
    private BroadcastModel mBroadcastModel;
    private UserPreferences mUserPreferences;
    private String mPreferenceKey;

    public BroadcastStatusPanel(BroadcastModel broadcastModel, UserPreferences userPreferences, String preferenceKey) {
        this.mBroadcastModel = broadcastModel;
        this.mUserPreferences = userPreferences;
        this.mPreferenceKey = preferenceKey;
        this.init();
    }

    public JTable getTable() {
        return this.mTable;
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0 ", "[grow,fill]", "[grow,fill]"));
        this.mTable = new JTable(this.mBroadcastModel);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.mTable.getDefaultRenderer(String.class);
        renderer.setHorizontalAlignment(0);
        this.mTable.getColumnModel().getColumn(2).setCellRenderer(new StatusCellRenderer());
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(new ServerTypeRenderer());
        this.mColumnWidthMonitor = new JTableColumnWidthMonitor(this.mUserPreferences, this.mTable, this.mPreferenceKey);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.add(this.mScrollPane);
    }

    public class StatusCellRenderer
    extends DefaultTableCellRenderer {
        public StatusCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else if (value instanceof BroadcastState) {
                BroadcastState state = (BroadcastState)((Object)value);
                if (state == BroadcastState.CONNECTED) {
                    this.setBackground(Color.GREEN);
                    this.setForeground(table.getForeground());
                } else if (state == BroadcastState.DISABLED) {
                    this.setBackground(table.getBackground());
                    this.setForeground(Color.LIGHT_GRAY);
                } else if (state == BroadcastState.INVALID_SETTINGS || state == BroadcastState.NETWORK_UNAVAILABLE) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(table.getForeground());
                } else if (state.isErrorState()) {
                    this.setBackground(Color.RED);
                    this.setForeground(table.getForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public class ServerTypeRenderer
    extends DefaultTableCellRenderer {
        public ServerTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof BroadcastServerType) {
                BroadcastServerType broadcastServerType = (BroadcastServerType)((Object)value);
                component.setText(broadcastServerType.toString());
                Icon icon = new Icon("empty", broadcastServerType.getIconPath());
                ImageIcon imageIcon = icon.getIcon();
                ImageIcon scaledIcon = IconModel.getScaledIcon(imageIcon, 13);
                component.setIcon(scaledIcon);
            } else {
                component.setText(null);
                component.setIcon(null);
            }
            return component;
        }
    }
}

