/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.audio.broadcast.AbstractAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastFactory;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.ConfiguredBroadcast;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastModel
extends AbstractTableModel
implements Listener<AudioRecording> {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastModel.class);
    public static final String TEMPORARY_STREAM_DIRECTORY = "streaming";
    public static final String TEMPORARY_STREAM_FILE_SUFFIX = "temporary_streaming_file_";
    private static final String UNIQUE_NAME_REGEX = "(.*)\\((\\d*)\\)";
    public static final int COLUMN_BROADCAST_SERVER_TYPE = 0;
    public static final int COLUMN_STREAM_NAME = 1;
    public static final int COLUMN_BROADCASTER_STATUS = 2;
    public static final int COLUMN_BROADCASTER_QUEUE_SIZE = 3;
    public static final int COLUMN_BROADCASTER_STREAMED_COUNT = 4;
    public static final int COLUMN_BROADCASTER_AGED_OFF_COUNT = 5;
    public static final int COLUMN_BROADCASTER_ERROR_COUNT = 6;
    public static final String[] COLUMN_NAMES = new String[]{"Stream Type", "Name", "Status", "Queued", "Streamed/Uploaded", "Aged Off", "Upload Error"};
    private ObservableList<ConfiguredBroadcast> mConfiguredBroadcasts = FXCollections.observableArrayList(ConfiguredBroadcast.extractor());
    private List<AudioRecording> mRecordingQueue = new CopyOnWriteArrayList<AudioRecording>();
    private Map<Integer, AbstractAudioBroadcaster> mBroadcasterMap = new HashMap<Integer, AbstractAudioBroadcaster>();
    private IconModel mIconModel;
    private AliasModel mAliasModel;
    private Broadcaster<BroadcastEvent> mBroadcastEventBroadcaster = new Broadcaster();
    private BroadcastEventListener mBroadcastEventListener = new BroadcastEventListener();
    private UserPreferences mUserPreferences;

    public BroadcastModel(AliasModel aliasModel, IconModel iconModel, UserPreferences userPreferences) {
        this.mAliasModel = aliasModel;
        this.mIconModel = iconModel;
        this.mUserPreferences = userPreferences;
        ThreadPool.SCHEDULED.scheduleAtFixedRate(new RecordingDeletionMonitor(), 15L, 15L, TimeUnit.SECONDS);
        this.removeOrphanedTemporaryRecordings();
    }

    public ObservableList<ConfiguredBroadcast> getConfiguredBroadcasts() {
        return this.mConfiguredBroadcasts;
    }

    public void clear() {
        ArrayList<ConfiguredBroadcast> configuredBroadcasts = new ArrayList<ConfiguredBroadcast>((Collection<ConfiguredBroadcast>)this.mConfiguredBroadcasts);
        for (ConfiguredBroadcast configuredBroadcast : configuredBroadcasts) {
            this.removeBroadcastConfiguration(configuredBroadcast.getBroadcastConfiguration());
        }
    }

    public List<String> getBroadcastConfigurationNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            names.add(configuredBroadcast.getBroadcastConfiguration().getName());
        }
        return names;
    }

    public List<BroadcastConfiguration> getBroadcastConfigurations() {
        ArrayList<BroadcastConfiguration> configs = new ArrayList<BroadcastConfiguration>();
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            configs.add(configuredBroadcast.getBroadcastConfiguration());
        }
        return Collections.unmodifiableList(configs);
    }

    public void addBroadcastConfigurations(List<BroadcastConfiguration> configurations) {
        for (BroadcastConfiguration configuration : configurations) {
            this.addBroadcastConfiguration(configuration);
        }
    }

    public ConfiguredBroadcast addBroadcastConfiguration(BroadcastConfiguration configuration) {
        if (configuration != null) {
            this.ensureUniqueName(configuration);
            ConfiguredBroadcast configuredBroadcast = this.getConfiguredBroadcast(configuration);
            if (configuredBroadcast == null) {
                configuredBroadcast = new ConfiguredBroadcast(configuration);
                this.mConfiguredBroadcasts.add((Object)configuredBroadcast);
                int index = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
                this.fireTableRowsInserted(index, index);
                this.process(new BroadcastEvent(configuration, BroadcastEvent.Event.CONFIGURATION_ADD));
                return configuredBroadcast;
            }
        }
        return null;
    }

    private void ensureUniqueName(BroadcastConfiguration configuration) {
        if (configuration.getName() == null || configuration.getName().isEmpty()) {
            configuration.setName("New Configuration");
        }
        while (!this.isUniqueName(configuration.getName(), configuration)) {
            String currentName = configuration.getName();
            if (currentName.matches(UNIQUE_NAME_REGEX)) {
                int currentVersion = 1;
                StringBuilder sb = new StringBuilder();
                Matcher m = Pattern.compile(UNIQUE_NAME_REGEX).matcher(currentName);
                if (m.find()) {
                    String version = m.group(2);
                    try {
                        currentVersion = Integer.parseInt(version);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append(m.group(1)).append("(").append(++currentVersion).append(")");
                } else {
                    sb.append(configuration.getName()).append("(").append(currentVersion).append(")");
                }
                configuration.setName(sb.toString());
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(configuration.getName()).append("(2)");
            configuration.setName(sb.toString());
        }
    }

    public boolean isUniqueName(String name, BroadcastConfiguration configuration) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            BroadcastConfiguration toCompare = configuredBroadcast.getBroadcastConfiguration();
            if (toCompare == configuration || toCompare.getName() == null || !toCompare.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void removeBroadcastConfiguration(BroadcastConfiguration broadcastConfiguration) {
        ConfiguredBroadcast configuredBroadcast = this.getConfiguredBroadcast(broadcastConfiguration);
        if (configuredBroadcast != null) {
            int index = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
            this.mConfiguredBroadcasts.remove((Object)configuredBroadcast);
            if (configuredBroadcast.hasAudioBroadcaster()) {
                this.mBroadcasterMap.remove(broadcastConfiguration.getId());
                configuredBroadcast.getAudioBroadcaster().stop();
                configuredBroadcast.setAudioBroadcaster(null);
            }
            this.process(new BroadcastEvent(broadcastConfiguration, BroadcastEvent.Event.CONFIGURATION_DELETE));
            this.fireTableRowsDeleted(index, index);
        }
    }

    public AbstractAudioBroadcaster getBroadcaster(String streamName) {
        BroadcastConfiguration broadcastConfiguration = this.getBroadcastConfiguration(streamName);
        if (broadcastConfiguration != null) {
            return this.mBroadcasterMap.get(broadcastConfiguration.getId());
        }
        return null;
    }

    @Override
    public void receive(AudioRecording audioRecording) {
        if (audioRecording != null && !audioRecording.getBroadcastChannels().isEmpty()) {
            for (BroadcastChannel broadcastChannel : audioRecording.getBroadcastChannels()) {
                AbstractAudioBroadcaster audioBroadcaster;
                String channelName = broadcastChannel.getChannelName();
                if (channelName == null || (audioBroadcaster = this.getBroadcaster(channelName)) == null) continue;
                audioRecording.addPendingReplay();
                audioBroadcaster.receive(audioRecording);
            }
        }
        this.mRecordingQueue.add(audioRecording);
    }

    private void createBroadcaster(BroadcastConfiguration broadcastConfiguration) {
        ConfiguredBroadcast configuredBroadcast = this.getConfiguredBroadcast(broadcastConfiguration);
        if (configuredBroadcast != null && broadcastConfiguration.isEnabled()) {
            AbstractAudioBroadcaster audioBroadcaster;
            if (configuredBroadcast.hasAudioBroadcaster()) {
                this.deleteBroadcaster(configuredBroadcast);
            }
            if ((audioBroadcaster = BroadcastFactory.getBroadcaster(broadcastConfiguration, this.mAliasModel, this.mUserPreferences)) != null) {
                configuredBroadcast.setAudioBroadcaster(audioBroadcaster);
                audioBroadcaster.setListener(this.mBroadcastEventListener);
                audioBroadcaster.start();
                this.mBroadcasterMap.put(((BroadcastConfiguration)audioBroadcaster.getBroadcastConfiguration()).getId(), audioBroadcaster);
                int index = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
                if (index >= 0) {
                    this.fireTableRowsUpdated(index, index);
                }
                this.broadcast(new BroadcastEvent(audioBroadcaster, BroadcastEvent.Event.BROADCASTER_ADD));
            }
        }
    }

    private void deleteBroadcaster(ConfiguredBroadcast configuredBroadcast) {
        if (configuredBroadcast != null && configuredBroadcast.hasAudioBroadcaster()) {
            this.mBroadcasterMap.remove(configuredBroadcast.getBroadcastConfiguration().getId());
            AbstractAudioBroadcaster broadcaster = configuredBroadcast.getAudioBroadcaster();
            configuredBroadcast.setAudioBroadcaster(null);
            broadcaster.stop();
            broadcaster.removeListener();
            broadcaster.dispose();
            int index = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
            if (index >= 0) {
                this.fireTableRowsUpdated(index, index);
            }
            this.broadcast(new BroadcastEvent(broadcaster, BroadcastEvent.Event.BROADCASTER_DELETE));
        }
    }

    public BroadcastConfiguration getBroadcastConfiguration(String streamName) {
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            if (configuredBroadcast.getBroadcastConfiguration().getName() == null || !configuredBroadcast.getBroadcastConfiguration().getName().equals(streamName)) continue;
            return configuredBroadcast.getBroadcastConfiguration();
        }
        return null;
    }

    public void addListener(Listener<BroadcastEvent> listener) {
        this.mBroadcastEventBroadcaster.addListener(listener);
    }

    public void removeListener(Listener<BroadcastEvent> listener) {
        this.mBroadcastEventBroadcaster.removeListener(listener);
    }

    private ConfiguredBroadcast getConfiguredBroadcast(BroadcastConfiguration configuration) {
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            if (!configuredBroadcast.getBroadcastConfiguration().equals(configuration)) continue;
            return configuredBroadcast;
        }
        return null;
    }

    private ConfiguredBroadcast getConfiguredBroadcast(AbstractAudioBroadcaster broadcaster) {
        for (ConfiguredBroadcast configuredBroadcast : this.mConfiguredBroadcasts) {
            if (configuredBroadcast.getAudioBroadcaster() == null || !configuredBroadcast.getAudioBroadcaster().equals(broadcaster)) continue;
            return configuredBroadcast;
        }
        return null;
    }

    private void broadcast(BroadcastEvent event) {
        this.mBroadcastEventBroadcaster.broadcast(event);
    }

    public void process(BroadcastEvent broadcastEvent) {
        if (broadcastEvent.isBroadcastConfigurationEvent()) {
            switch (broadcastEvent.getEvent()) {
                case CONFIGURATION_ADD: {
                    this.createBroadcaster(broadcastEvent.getBroadcastConfiguration());
                    break;
                }
                case CONFIGURATION_CHANGE: {
                    BroadcastConfiguration broadcastConfiguration = broadcastEvent.getBroadcastConfiguration();
                    ConfiguredBroadcast configuredBroadcast = this.getConfiguredBroadcast(broadcastConfiguration);
                    this.deleteBroadcaster(configuredBroadcast);
                    if (broadcastConfiguration.isEnabled()) {
                        ThreadPool.SCHEDULED.schedule(new DelayedBroadcasterStartup(broadcastConfiguration), 1L, TimeUnit.SECONDS);
                    }
                    int index = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
                    this.fireTableRowsUpdated(index, index);
                    break;
                }
                case CONFIGURATION_DELETE: {
                    this.deleteBroadcaster(this.getConfiguredBroadcast(broadcastEvent.getBroadcastConfiguration()));
                }
            }
        } else if (broadcastEvent.isAudioBroadcasterEvent()) {
            ConfiguredBroadcast configuredBroadcast = this.getConfiguredBroadcast(broadcastEvent.getAudioBroadcaster());
            int row = this.mConfiguredBroadcasts.indexOf((Object)configuredBroadcast);
            switch (broadcastEvent.getEvent()) {
                case BROADCASTER_QUEUE_CHANGE: {
                    if (row < 0) break;
                    this.fireTableCellUpdated(row, 3);
                    break;
                }
                case BROADCASTER_STATE_CHANGE: {
                    if (row < 0) break;
                    this.fireTableCellUpdated(row, 2);
                    break;
                }
                case BROADCASTER_STREAMED_COUNT_CHANGE: {
                    if (row < 0) break;
                    this.fireTableCellUpdated(row, 4);
                    break;
                }
                case BROADCASTER_AGED_OFF_COUNT_CHANGE: {
                    if (row >= 0) {
                        this.fireTableCellUpdated(row, 5);
                    }
                }
                case BROADCASTER_ERROR_COUNT_CHANGE: {
                    if (row < 0) break;
                    this.fireTableCellUpdated(row, 6);
                }
            }
        }
        this.broadcast(broadcastEvent);
    }

    @Override
    public int getRowCount() {
        return this.mConfiguredBroadcasts.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            ConfiguredBroadcast configuredBroadcast;
            if (rowIndex <= this.mConfiguredBroadcasts.size() && (configuredBroadcast = (ConfiguredBroadcast)this.mConfiguredBroadcasts.get(rowIndex)) != null) {
                switch (columnIndex) {
                    case 0: {
                        return configuredBroadcast.getBroadcastServerType();
                    }
                    case 1: {
                        return configuredBroadcast.getBroadcastConfiguration().getName();
                    }
                    case 2: {
                        if (configuredBroadcast.hasAudioBroadcaster()) {
                            return configuredBroadcast.getAudioBroadcaster().getBroadcastState();
                        }
                        if (!configuredBroadcast.getBroadcastConfiguration().isEnabled()) {
                            return BroadcastState.DISABLED;
                        }
                        if (!configuredBroadcast.getBroadcastConfiguration().isValid()) {
                            return BroadcastState.INVALID_SETTINGS;
                        }
                        return BroadcastState.ERROR;
                    }
                    case 3: {
                        if (!configuredBroadcast.hasAudioBroadcaster()) break;
                        return configuredBroadcast.getAudioBroadcaster().getAudioQueueSize();
                    }
                    case 4: {
                        if (!configuredBroadcast.hasAudioBroadcaster()) break;
                        return configuredBroadcast.getAudioBroadcaster().getStreamedAudioCount();
                    }
                    case 5: {
                        if (!configuredBroadcast.hasAudioBroadcaster()) break;
                        return configuredBroadcast.getAudioBroadcaster().getAgedOffAudioCount();
                    }
                    case 6: {
                        if (!configuredBroadcast.hasAudioBroadcaster()) break;
                        return configuredBroadcast.getAudioBroadcaster().getAudioErrorCount();
                    }
                }
            }
        }
        catch (Exception e) {
            mLog.error("Error accessing data in broadcast model", (Throwable)e);
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return BroadcastState.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return Integer.class;
            }
            case 0: {
                return BroadcastServerType.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (0 <= column && column < COLUMN_NAMES.length) {
            return COLUMN_NAMES[column];
        }
        return null;
    }

    private void removeRecording(AudioRecording recording) {
        try {
            Files.delete(recording.getPath());
        }
        catch (IOException ioe) {
            mLog.error("Error deleting temporary internet recording file: " + recording.getPath().toString() + " - " + ioe.getMessage());
        }
    }

    private void removeOrphanedTemporaryRecordings() {
        ThreadPool.SCHEDULED.submit(new Runnable(this){

            @Override
            public void run() {
                block10: {
                    try {
                        Path path = SystemProperties.getInstance().getApplicationFolder(BroadcastModel.TEMPORARY_STREAM_DIRECTORY);
                        if (path == null || !Files.isDirectory(path, new LinkOption[0])) break block10;
                        StringBuilder sb = new StringBuilder();
                        sb.append(BroadcastModel.TEMPORARY_STREAM_FILE_SUFFIX);
                        sb.append("*.*");
                        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, sb.toString());){
                            directoryStream.forEach(new Consumer<Path>(this){

                                @Override
                                public void accept(Path path) {
                                    try {
                                        Files.delete(path);
                                    }
                                    catch (IOException ioe) {
                                        mLog.error("Couldn't delete orphaned temporary recording: " + path.toString(), (Throwable)ioe);
                                    }
                                }
                            });
                        }
                        catch (IOException ioe) {
                            mLog.error("Error discovering orphaned temporary stream recording files", (Throwable)ioe);
                        }
                    }
                    catch (Throwable t) {
                        mLog.error("Error during cleanup of orphaned temporary streaming recording files");
                    }
                }
            }
        });
    }

    public class BroadcastEventListener
    implements Listener<BroadcastEvent> {
        @Override
        public void receive(BroadcastEvent broadcastEvent) {
            BroadcastModel.this.process(broadcastEvent);
        }
    }

    public class RecordingDeletionMonitor
    implements Runnable {
        @Override
        public void run() {
            try {
                ArrayList<AudioRecording> recordingsToDelete = new ArrayList<AudioRecording>();
                for (AudioRecording recording : BroadcastModel.this.mRecordingQueue) {
                    if (recording.hasPendingReplays()) continue;
                    recordingsToDelete.add(recording);
                }
                if (!recordingsToDelete.isEmpty()) {
                    for (AudioRecording recordingToDelete : recordingsToDelete) {
                        BroadcastModel.this.mRecordingQueue.remove(recordingToDelete);
                        BroadcastModel.this.removeRecording(recordingToDelete);
                    }
                }
            }
            catch (Exception e) {
                mLog.error("Error while checking audio recording queue for recordings to delete", (Throwable)e);
            }
        }
    }

    public class DelayedBroadcasterStartup
    implements Runnable {
        private BroadcastConfiguration mBroadcastConfiguration;

        public DelayedBroadcasterStartup(BroadcastConfiguration configuration) {
            this.mBroadcastConfiguration = configuration;
        }

        @Override
        public void run() {
            BroadcastModel.this.createBroadcaster(this.mBroadcastConfiguration);
        }
    }
}

