/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.AudioSegmentRecorder;
import io.github.dsheirer.record.RecordFormat;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.util.TimeStamp;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioStreamingManager
implements Listener<AudioSegment> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioStreamingManager.class);
    private LinkedTransferQueue<AudioSegment> mNewAudioSegments = new LinkedTransferQueue();
    private List<AudioSegment> mAudioSegments = new ArrayList<AudioSegment>();
    private Listener<AudioRecording> mAudioRecordingListener;
    private BroadcastFormat mBroadcastFormat;
    private UserPreferences mUserPreferences;
    private ScheduledFuture<?> mAudioSegmentProcessorFuture;
    private int mNextRecordingNumber = 1;

    public AudioStreamingManager(Listener<AudioRecording> listener, BroadcastFormat broadcastFormat, UserPreferences userPreferences) {
        this.mAudioRecordingListener = listener;
        this.mBroadcastFormat = broadcastFormat;
        this.mUserPreferences = userPreferences;
    }

    @Override
    public void receive(AudioSegment audioSegment) {
        this.mNewAudioSegments.add(audioSegment);
    }

    public void start() {
        if (this.mAudioSegmentProcessorFuture == null) {
            this.mAudioSegmentProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new AudioSegmentProcessor(), 0L, 250L, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.mAudioSegmentProcessorFuture != null) {
            this.mAudioSegmentProcessorFuture.cancel(true);
            this.mAudioSegmentProcessorFuture = null;
        }
        for (AudioSegment audioSegment : this.mNewAudioSegments) {
            audioSegment.decrementConsumerCount();
        }
        this.mNewAudioSegments.clear();
        for (AudioSegment audioSegment : this.mAudioSegments) {
            audioSegment.decrementConsumerCount();
        }
        this.mAudioSegments.clear();
    }

    private void processAudioSegments() {
        this.mNewAudioSegments.drainTo(this.mAudioSegments);
        Iterator<AudioSegment> it = this.mAudioSegments.iterator();
        while (it.hasNext()) {
            AudioSegment audioSegment = it.next();
            if (audioSegment.isDuplicate() && this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicateStreamingSuppressionEnabled()) {
                it.remove();
                audioSegment.decrementConsumerCount();
                continue;
            }
            if (!audioSegment.completeProperty().get()) continue;
            it.remove();
            if (this.mAudioRecordingListener != null && audioSegment.hasBroadcastChannels()) {
                Path path = this.getTemporaryRecordingPath();
                long length = 0L;
                for (float[] audioBuffer : audioSegment.getAudioBuffers()) {
                    length += (long)audioBuffer.length;
                }
                length /= 8L;
                try {
                    AudioSegmentRecorder.record(audioSegment, path, RecordFormat.MP3, this.mUserPreferences);
                    IdentifierCollection identifierCollectionCopy = new IdentifierCollection(audioSegment.getIdentifierCollection().getIdentifiers());
                    AudioRecording audioRecording = new AudioRecording(path, audioSegment.getBroadcastChannels(), identifierCollectionCopy, audioSegment.getStartTimestamp(), length);
                    this.mAudioRecordingListener.receive(audioRecording);
                }
                catch (IOException ioe) {
                    mLog.error("Error recording temporary stream MP3");
                }
            }
            audioSegment.decrementConsumerCount();
        }
    }

    private Path getTemporaryRecordingPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("temporary_streaming_file_");
        if (this.mNextRecordingNumber < 0) {
            this.mNextRecordingNumber = 1;
        }
        int recordingNumber = this.mNextRecordingNumber++;
        sb.append(recordingNumber).append("_");
        sb.append(TimeStamp.getLongTimeStamp("_"));
        sb.append(this.mBroadcastFormat.getFileExtension());
        Path temporaryRecordingPath = this.mUserPreferences.getDirectoryPreference().getDirectoryStreaming().resolve(sb.toString());
        return temporaryRecordingPath;
    }

    public class AudioSegmentProcessor
    implements Runnable {
        @Override
        public void run() {
            try {
                AudioStreamingManager.this.processAudioSegments();
            }
            catch (Throwable t) {
                mLog.error("Error processing audio segments for streaming", t);
            }
        }
    }
}

