/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio;

import io.github.dsheirer.sample.ConversionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioUtils {
    private static final Logger mLog = LoggerFactory.getLogger(AudioUtils.class);

    public static byte[] convertTo16BitSamples(List<float[]> buffers) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            for (float[] audioBuffer : buffers) {
                ByteBuffer buffer = ConversionUtils.convertToSigned16BitSamples(audioBuffer);
                stream.write(buffer.array());
            }
        }
        catch (IOException e) {
            mLog.error("Error writing converted PCM bytes to output stream");
        }
        return stream.toByteArray();
    }

    public static byte[] convert(List<float[]> audioBuffers) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            for (float[] audioBuffer : audioBuffers) {
                ByteBuffer buffer = ConversionUtils.convertToSigned16BitSamples(audioBuffer);
                stream.write(buffer.array());
            }
        }
        catch (IOException e) {
            mLog.error("Error writing converted PCM bytes to output stream");
        }
        return stream.toByteArray();
    }

    public static List<float[]> normalize(List<float[]> audioBuffers) {
        float targetMax = 0.95f;
        float max = 0.1f;
        for (float[] audioBuffer : audioBuffers) {
            for (float value : audioBuffer) {
                float newMax = Math.max(max, Math.abs(value));
                if (Float.isNaN(newMax)) continue;
                max = newMax;
            }
        }
        if (targetMax == max) {
            return audioBuffers;
        }
        float gain = targetMax / max;
        for (float[] audioBuffer : audioBuffers) {
            int i = 0;
            while (i < audioBuffer.length) {
                int n = i++;
                audioBuffer[n] = audioBuffer[n] * gain;
            }
        }
        return audioBuffers;
    }
}

