/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioSegment
implements Listener<IdentifierUpdateNotification> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioSegment.class);
    private BooleanProperty mComplete = new SimpleBooleanProperty(false);
    private BooleanProperty mDuplicate = new SimpleBooleanProperty(false);
    private BooleanProperty mRecordAudio = new SimpleBooleanProperty(false);
    private IntegerProperty mMonitorPriority = new SimpleIntegerProperty(100);
    private ObservableSet<BroadcastChannel> mBroadcastChannels = FXCollections.observableSet(new HashSet());
    private MutableIdentifierCollection mIdentifierCollection = new MutableIdentifierCollection();
    private Broadcaster<IdentifierUpdateNotification> mIdentifierUpdateNotificationBroadcaster = new Broadcaster();
    private List<float[]> mAudioBuffers = new CopyOnWriteArrayList<float[]>();
    private AtomicInteger mConsumerCount = new AtomicInteger();
    private AliasList mAliasList;
    private long mStartTimestamp = System.currentTimeMillis();
    private long mSampleCount = 0L;
    private boolean mDisposing = false;
    private AudioSegment mLinkedAudioSegment;
    private int mTimeslot;

    public AudioSegment(AliasList aliasList, int timeslot) {
        this.mAliasList = aliasList;
        this.mTimeslot = timeslot;
        this.mIdentifierCollection.setTimeslot(timeslot);
    }

    public int getTimeslot() {
        return this.mTimeslot;
    }

    public long getStartTimestamp() {
        return this.mStartTimestamp;
    }

    public long getEndTimestamp() {
        return this.mStartTimestamp + this.getDuration();
    }

    public long getDuration() {
        return this.mSampleCount / 8L;
    }

    public BooleanProperty completeProperty() {
        return this.mComplete;
    }

    public boolean isComplete() {
        return this.mComplete.get();
    }

    public BooleanProperty duplicateProperty() {
        return this.mDuplicate;
    }

    public ObservableSet<BroadcastChannel> broadcastChannelsProperty() {
        return this.mBroadcastChannels;
    }

    public Set<BroadcastChannel> getBroadcastChannels() {
        return Collections.unmodifiableSet(this.mBroadcastChannels);
    }

    public boolean hasBroadcastChannels() {
        return !this.mBroadcastChannels.isEmpty();
    }

    public BooleanProperty recordAudioProperty() {
        return this.mRecordAudio;
    }

    public IntegerProperty monitorPriorityProperty() {
        return this.mMonitorPriority;
    }

    public boolean isDoNotMonitor() {
        return this.mMonitorPriority.get() <= -1;
    }

    public AliasList getAliasList() {
        return this.mAliasList;
    }

    public boolean isLinked() {
        return this.mLinkedAudioSegment != null;
    }

    public boolean isLinkedTo(AudioSegment audioSegment) {
        return this.isLinked() && audioSegment != null && this.mLinkedAudioSegment.equals(audioSegment);
    }

    public AudioSegment getLinkedAudioSegment() {
        return this.mLinkedAudioSegment;
    }

    public void linkTo(AudioSegment previousAudioSegment) {
        this.mLinkedAudioSegment = previousAudioSegment;
    }

    public IdentifierCollection getIdentifierCollection() {
        return this.mIdentifierCollection;
    }

    void addIdentifiers(Collection<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            this.addIdentifier(identifier);
        }
    }

    public List<float[]> getAudioBuffers() {
        return Collections.unmodifiableList(this.mAudioBuffers);
    }

    public int getAudioBufferCount() {
        return this.mAudioBuffers.size();
    }

    public float[] getAudioBuffer(int index) {
        if (0 <= index && index < this.getAudioBufferCount()) {
            return this.mAudioBuffers.get(index);
        }
        throw new IllegalArgumentException("Requested audio buffer at index [" + index + "] does not exist");
    }

    public boolean hasAudio() {
        return !this.mAudioBuffers.isEmpty();
    }

    private void dispose() {
        this.mDisposing = true;
        this.mAudioBuffers.clear();
        this.mIdentifierCollection.clear();
        this.mIdentifierUpdateNotificationBroadcaster.clear();
        this.mLinkedAudioSegment = null;
    }

    public void incrementConsumerCount() {
        this.mConsumerCount.incrementAndGet();
    }

    public void decrementConsumerCount() {
        int count = this.mConsumerCount.decrementAndGet();
        if (count <= 0) {
            this.dispose();
        }
    }

    public void addAudio(float[] audioBuffer) {
        if (audioBuffer == null) {
            throw new IllegalArgumentException("Can't add null audio buffer");
        }
        if (this.mDisposing) {
            throw new IllegalStateException("Can't add audio to an audio segment that is being disposed");
        }
        this.mAudioBuffers.add(audioBuffer);
        this.mSampleCount += (long)audioBuffer.length;
    }

    public void addIdentifierUpdateNotificationListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationBroadcaster.addListener(listener);
    }

    public void removeIdentifierUpdateNotificationListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationBroadcaster.removeListener(listener);
    }

    public void addIdentifier(Identifier identifier) {
        this.mIdentifierCollection.update(identifier);
        List<Alias> aliases = this.mAliasList.getAliases(identifier);
        for (Alias alias : aliases) {
            if (alias.isRecordable()) {
                this.mRecordAudio.set(true);
            }
            this.mBroadcastChannels.addAll(alias.getBroadcastChannels());
            int playbackPriority = alias.getPlaybackPriority();
            if (playbackPriority >= this.mMonitorPriority.get()) continue;
            this.mMonitorPriority.set(playbackPriority);
        }
    }

    public boolean isDuplicate() {
        return this.mDuplicate.get();
    }

    public void setDuplicate(boolean duplicate) {
        this.mDuplicate.set(duplicate);
    }

    @Override
    public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
        if (identifierUpdateNotification.getTimeslot() == this.getTimeslot()) {
            if (identifierUpdateNotification.isAdd() || identifierUpdateNotification.isSilentAdd()) {
                this.addIdentifier(identifierUpdateNotification.getIdentifier());
            }
            this.mIdentifierUpdateNotificationBroadcaster.broadcast(identifierUpdateNotification);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Audio Segment\n      Timeslot:").append(this.getTimeslot()).append("\n");
        sb.append("    Start Time:").append(new Date(this.getStartTimestamp()));
        sb.append("        Linked:").append(this.isLinked()).append("\n");
        sb.append("    Recordable:").append(this.recordAudioProperty().get()).append("\n");
        sb.append("Do Not Monitor:").append(this.isDoNotMonitor()).append("\n");
        sb.append("     Stream To:").append(this.getBroadcastChannels()).append("\n");
        sb.append("   Identifiers:\n").append(this.getIdentifierCollection()).append("\n");
        return sb.toString();
    }
}

