/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.talkgroup;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormat;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;

public class TalkgroupRange
extends AliasID
implements Comparable<TalkgroupRange> {
    private Protocol mProtocol = Protocol.UNKNOWN;
    private int mMinTalkgroup;
    private int mMaxTalkgroup;

    public TalkgroupRange() {
    }

    public TalkgroupRange(Protocol protocol, int minTalkgroup, int maxTalkgroup) {
        this.mProtocol = protocol;
        this.mMinTalkgroup = minTalkgroup;
        this.mMaxTalkgroup = maxTalkgroup;
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="min")
    public int getMinTalkgroup() {
        return this.mMinTalkgroup;
    }

    public void setMinTalkgroup(int minTalkgroup) {
        this.mMinTalkgroup = minTalkgroup;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="max")
    public int getMaxTalkgroup() {
        return this.mMaxTalkgroup;
    }

    public void setMaxTalkgroup(int maxTalkgroup) {
        this.mMaxTalkgroup = maxTalkgroup;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="protocol")
    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.mProtocol = protocol;
        this.updateValueProperty();
    }

    @Override
    public boolean isValid() {
        if (this.mProtocol == null || this.mProtocol == Protocol.UNKNOWN) {
            return false;
        }
        TalkgroupFormat talkgroupFormat = TalkgroupFormat.get(this.mProtocol);
        return talkgroupFormat.getMinimumValidValue() <= this.mMinTalkgroup && this.mMinTalkgroup <= talkgroupFormat.getMaximumValidValue() && talkgroupFormat.getMinimumValidValue() <= this.mMaxTalkgroup && this.mMaxTalkgroup <= talkgroupFormat.getMaximumValidValue() && this.mMinTalkgroup < this.mMaxTalkgroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Talkgroup Range:").append(TalkgroupFormatter.format(this.mProtocol, this.mMinTalkgroup));
        sb.append(" to ").append(TalkgroupFormatter.format(this.mProtocol, this.mMaxTalkgroup));
        sb.append(" Protocol:").append(this.mProtocol != null ? this.mProtocol : "unspecified");
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        if (id instanceof TalkgroupRange) {
            TalkgroupRange tgid = (TalkgroupRange)id;
            return this.getProtocol() == tgid.getProtocol() && this.getMinTalkgroup() == tgid.getMinTalkgroup() && this.getMaxTalkgroup() == tgid.getMaxTalkgroup();
        }
        return false;
    }

    public boolean contains(int talkgroupValue) {
        return this.getMinTalkgroup() <= talkgroupValue && talkgroupValue <= this.getMaxTalkgroup();
    }

    @Override
    public boolean overlaps(AliasID other) {
        return other instanceof TalkgroupRange && this.overlaps((TalkgroupRange)other);
    }

    public boolean overlaps(TalkgroupRange talkgroupRange) {
        return this.contains(talkgroupRange.getMinTalkgroup()) || this.contains(talkgroupRange.getMaxTalkgroup()) || this.getMinTalkgroup() < talkgroupRange.getMinTalkgroup() && talkgroupRange.getMaxTalkgroup() < this.getMaxTalkgroup() || talkgroupRange.getMinTalkgroup() < this.getMinTalkgroup() && this.getMaxTalkgroup() < talkgroupRange.getMaxTalkgroup();
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.TALKGROUP_RANGE;
    }

    @Override
    public int compareTo(TalkgroupRange other) {
        if (other == null) {
            return -1;
        }
        if (this.getProtocol().equals((Object)other.getProtocol())) {
            if (this.getMinTalkgroup() == other.getMinTalkgroup()) {
                return Integer.compare(this.getMaxTalkgroup(), other.getMaxTalkgroup());
            }
            return Integer.compare(this.getMinTalkgroup(), other.getMinTalkgroup());
        }
        return this.getProtocol().compareTo(other.getProtocol());
    }
}

