/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.talkgroup;

import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.APCO25TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.AnalogTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.DMRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.FleetsyncTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.LTRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.MDC1200TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.MPT1327TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.PassportTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.UnknownTalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;
import java.text.ParseException;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkgroupFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(TalkgroupFormatter.class);
    private static Map<Protocol, AbstractIntegerFormatter> mFormatterMap = new EnumMap<Protocol, AbstractIntegerFormatter>(Protocol.class);

    public static int parse(Protocol protocol, String value) throws ParseException {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.parse(value);
    }

    public static String format(Protocol protocol, int value) {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.format(value);
    }

    public static String format(Protocol protocol, int value, IntegerFormat format) {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.format(value, format);
    }

    static {
        AnalogTalkgroupFormatter analogTalkgroupFormatter = new AnalogTalkgroupFormatter();
        mFormatterMap.put(Protocol.AM, analogTalkgroupFormatter);
        mFormatterMap.put(Protocol.NBFM, analogTalkgroupFormatter);
        mFormatterMap.put(Protocol.APCO25, new APCO25TalkgroupFormatter());
        mFormatterMap.put(Protocol.DMR, new DMRTalkgroupFormatter());
        mFormatterMap.put(Protocol.FLEETSYNC, new FleetsyncTalkgroupFormatter());
        LTRTalkgroupFormatter ltr = new LTRTalkgroupFormatter();
        mFormatterMap.put(Protocol.LTR, ltr);
        mFormatterMap.put(Protocol.LTR_NET, ltr);
        mFormatterMap.put(Protocol.MDC1200, new MDC1200TalkgroupFormatter());
        mFormatterMap.put(Protocol.MPT1327, new MPT1327TalkgroupFormatter());
        mFormatterMap.put(Protocol.PASSPORT, new PassportTalkgroupFormatter());
        mFormatterMap.put(Protocol.UNKNOWN, new UnknownTalkgroupFormatter());
    }
}

