/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.talkgroup;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormat;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Talkgroup
extends AliasID
implements Comparable<Talkgroup> {
    private static final Logger mLog = LoggerFactory.getLogger(Talkgroup.class);
    private Protocol mProtocol = Protocol.UNKNOWN;
    private int mValue;

    public Talkgroup() {
    }

    public Talkgroup(Protocol protocol, int value) {
        this.mProtocol = protocol;
        this.mValue = value;
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="value")
    public int getValue() {
        return this.mValue;
    }

    public void setValue(int value) {
        this.mValue = value;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="protocol")
    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.mProtocol = protocol;
        this.updateValueProperty();
    }

    @Override
    public boolean isValid() {
        if (this.mProtocol == null || this.mProtocol == Protocol.UNKNOWN) {
            return false;
        }
        TalkgroupFormat talkgroupFormat = TalkgroupFormat.get(this.mProtocol);
        return talkgroupFormat.getMinimumValidValue() <= this.mValue && this.mValue <= talkgroupFormat.getMaximumValidValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String talkgroup = null;
        try {
            talkgroup = TalkgroupFormatter.format(this.mProtocol, this.mValue);
        }
        catch (Exception e) {
            mLog.error("Error formatting Talkgroup Protocol [" + String.valueOf((Object)this.mProtocol) + "] value [" + this.mValue + "]", (Throwable)e);
        }
        sb.append("Talkgroup:").append(talkgroup != null ? talkgroup : "error");
        sb.append(" Protocol:").append((Object)this.mProtocol);
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        if (id instanceof Talkgroup) {
            Talkgroup tgid = (Talkgroup)id;
            return this.getProtocol() == tgid.getProtocol() && this.getValue() == tgid.getValue();
        }
        return false;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.TALKGROUP;
    }

    @Override
    public int compareTo(Talkgroup other) {
        if (other == null) {
            return -1;
        }
        if (this.getProtocol().equals((Object)other.getProtocol())) {
            return Integer.compare(this.getValue(), other.getValue());
        }
        return this.getProtocol().compareTo(other.getProtocol());
    }
}

