/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.radio;

import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.APCO25TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.DMRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.UnknownTalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;
import java.text.ParseException;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(RadioFormatter.class);
    private static Map<Protocol, AbstractIntegerFormatter> mFormatterMap = new EnumMap<Protocol, AbstractIntegerFormatter>(Protocol.class);

    public static int parse(Protocol protocol, String value) throws ParseException {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.parse(value);
    }

    public static String format(Protocol protocol, int value) {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.format(value);
    }

    public static String format(Protocol protocol, int value, IntegerFormat format) {
        AbstractIntegerFormatter formatter = mFormatterMap.get((Object)protocol);
        if (formatter == null) {
            formatter = mFormatterMap.get((Object)Protocol.UNKNOWN);
        }
        return formatter.format(value, format);
    }

    static {
        mFormatterMap.put(Protocol.APCO25, new APCO25TalkgroupFormatter());
        mFormatterMap.put(Protocol.DMR, new DMRTalkgroupFormatter());
        mFormatterMap.put(Protocol.UNKNOWN, new UnknownTalkgroupFormatter());
    }
}

