/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.radio;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.radio.Radio;
import io.github.dsheirer.protocol.Protocol;

public class P25FullyQualifiedRadio
extends Radio {
    private int mWacn;
    private int mSystem;

    public P25FullyQualifiedRadio() {
    }

    public P25FullyQualifiedRadio(int wacn, int system, int id) {
        super(Protocol.APCO25, id);
        this.mWacn = wacn;
        this.mSystem = system;
    }

    @Override
    public AliasIDType getType() {
        return AliasIDType.P25_FULLY_QUALIFIED_RADIO_ID;
    }

    @JacksonXmlProperty(isAttribute=true, localName="wacn")
    public int getWacn() {
        return this.mWacn;
    }

    public void setWacn(int wacn) {
        this.mWacn = wacn;
    }

    @JacksonXmlProperty(isAttribute=true, localName="system")
    public int getSystem() {
        return this.mSystem;
    }

    public void setSystem(int system) {
        this.mSystem = system;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fully Qualified Radio ID:").append(this.getWacn());
        sb.append(".").append(this.getSystem());
        sb.append(".").append(this.getValue());
        sb.append(" Protocol:").append((Object)this.getProtocol());
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @JsonIgnore
    public String getHashKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWacn());
        sb.append(".").append(this.getSystem());
        sb.append(".").append(this.getValue());
        return sb.toString();
    }
}

