/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.lojack;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.module.decode.lj1200.LJ1200Message;

public class LoJackFunctionAndID
extends AliasID {
    private LJ1200Message.Function mFunction = LJ1200Message.Function.F0_UNKNOWN;
    private String mID = null;

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="id")
    public String getID() {
        return this.mID;
    }

    public void setID(String id) {
        this.mID = id;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="function")
    public LJ1200Message.Function getFunction() {
        return this.mFunction;
    }

    public void setFunction(LJ1200Message.Function function) {
        this.mFunction = function;
        this.updateValueProperty();
    }

    @Override
    public boolean isValid() {
        return this.mFunction != null && this.mID != null;
    }

    public String toString() {
        return "LoJack FUNCTION: " + this.mFunction.getLabel() + " ID:" + (this.mID == null ? "" : this.mID) + (this.isValid() ? "" : " **NOT VALID**");
    }

    public boolean matches(LJ1200Message.Function function, String id) {
        return this.mFunction == function && this.mID != null && id != null && id.matches(this.mID.replace("*", ".?"));
    }

    @Override
    public boolean matches(AliasID id) {
        LoJackFunctionAndID otherLojack;
        boolean retVal = false;
        if (this.mID != null && id instanceof LoJackFunctionAndID && (otherLojack = (LoJackFunctionAndID)id).getFunction() == this.mFunction) {
            String pattern = this.mID.replace("*", ".?");
            retVal = otherLojack.getID().matches(pattern);
        }
        return retVal;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.LOJACK;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mFunction == null ? 0 : this.mFunction.hashCode());
        result = 31 * result + (this.mID == null ? 0 : this.mID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoJackFunctionAndID other = (LoJackFunctionAndID)obj;
        if (this.mFunction != other.mFunction) {
            return false;
        }
        return !(this.mID == null ? other.mID != null : !this.mID.equals(other.mID));
    }
}

