/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.esn;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;

public class Esn
extends AliasID {
    private String mEsn;

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="esn")
    public String getEsn() {
        return this.mEsn;
    }

    @Override
    public boolean isValid() {
        return this.mEsn != null;
    }

    public void setEsn(String esn) {
        this.mEsn = esn;
        this.updateValueProperty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ESN: ").append(this.mEsn != null ? this.mEsn : "(empty)");
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        boolean retVal = false;
        if (this.mEsn != null && id instanceof Esn) {
            Esn esn = (Esn)id;
            String pattern = this.mEsn.replace("*", ".?");
            retVal = esn.getEsn().matches(pattern);
        }
        return retVal;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.ESN;
    }
}

