/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.action.script;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.action.AliasActionType;
import io.github.dsheirer.alias.action.RecurringAction;
import io.github.dsheirer.message.IMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAction
extends RecurringAction {
    private static final Logger mLog = LoggerFactory.getLogger(ScriptAction.class);
    private String mScript;

    public ScriptAction() {
        this.updateValueProperty();
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasActionType getType() {
        return AliasActionType.SCRIPT;
    }

    public String getScript() {
        return this.mScript;
    }

    public void setScript(String script) {
        this.mScript = script;
        this.updateValueProperty();
    }

    @Override
    public void performAction(Alias alias, IMessage message) {
        try {
            this.play();
        }
        catch (Exception e) {
            mLog.error("Couldn't execute script [" + this.mScript + "]", (Throwable)e);
        }
    }

    public void play() throws Exception {
        if (this.mScript != null) {
            ProcessBuilder pb = new ProcessBuilder(this.mScript);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            int exitCode = p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            if (exitCode != 0) {
                throw new RuntimeException("Exit Code: " + exitCode + " Console:" + sb.toString());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Run Script");
        if (this.getInterval() != null) {
            switch (this.getInterval()) {
                case ONCE: {
                    sb.append(" Once");
                    break;
                }
                case DELAYED_RESET: {
                    sb.append(" Once, Reset After ").append(this.getPeriod()).append(" Seconds");
                    break;
                }
                case UNTIL_DISMISSED: {
                    sb.append(" Every ").append(this.getPeriod()).append(" Seconds Until Dismissed");
                }
            }
        }
        if (this.getScript() == null) {
            sb.append(" - (script file empty)");
        }
        return sb.toString();
    }
}

