/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.action.beep;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.action.AliasActionType;
import io.github.dsheirer.alias.action.RecurringAction;
import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.gui.preference.playback.ToneFrequency;
import io.github.dsheirer.gui.preference.playback.ToneUtil;
import io.github.dsheirer.gui.preference.playback.ToneVolume;
import io.github.dsheirer.message.IMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeepAction
extends RecurringAction {
    private static final Logger mLog = LoggerFactory.getLogger(BeepAction.class);
    private byte[] mToneBytes;

    public BeepAction() {
        this.setInterval(RecurringAction.Interval.ONCE);
        float[] tone = ToneUtil.getTone(ToneFrequency.F700, ToneVolume.V10, 1000);
        ByteBuffer buffer = ByteBuffer.allocate(tone.length * 2).order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shortBuffer = buffer.asShortBuffer();
        for (float sample : tone) {
            shortBuffer.put((short)(sample * 32767.0f));
        }
        this.mToneBytes = buffer.array();
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasActionType getType() {
        return AliasActionType.BEEP;
    }

    @Override
    public void performAction(Alias alias, IMessage message) {
        DataLine.Info info = new DataLine.Info(Clip.class, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO);
        if (!AudioSystem.isLineSupported(info)) {
            mLog.error("Audio clip playback is not supported on this system");
            return;
        }
        try {
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, this.mToneBytes, 0, this.mToneBytes.length);
            clip.start();
        }
        catch (Exception e) {
            mLog.error("Error attempting to play audio test tone");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Beep");
        if (this.getInterval() != null) {
            switch (this.getInterval()) {
                case ONCE: {
                    sb.append(" Once");
                    break;
                }
                case DELAYED_RESET: {
                    sb.append(" Once, Reset After ").append(this.getPeriod()).append(" Seconds");
                    break;
                }
                case UNTIL_DISMISSED: {
                    sb.append(" Every ").append(this.getPeriod()).append(" Seconds Until Dismissed");
                }
            }
        }
        return sb.toString();
    }
}

