/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.alias.id.dcs.Dcs;
import io.github.dsheirer.alias.id.esn.Esn;
import io.github.dsheirer.alias.id.radio.P25FullyQualifiedRadio;
import io.github.dsheirer.alias.id.radio.Radio;
import io.github.dsheirer.alias.id.radio.RadioRange;
import io.github.dsheirer.alias.id.status.UnitStatusID;
import io.github.dsheirer.alias.id.status.UserStatusID;
import io.github.dsheirer.alias.id.talkgroup.P25FullyQualifiedTalkgroup;
import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.alias.id.tone.TonesID;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.dcs.DCSIdentifier;
import io.github.dsheirer.identifier.esn.ESNIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.FullyQualifiedRadioIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.status.UnitStatusIdentifier;
import io.github.dsheirer.identifier.status.UserStatusIdentifier;
import io.github.dsheirer.identifier.talkgroup.FullyQualifiedTalkgroupIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.identifier.tone.ToneIdentifier;
import io.github.dsheirer.identifier.tone.ToneSequence;
import io.github.dsheirer.module.decode.dcs.DCSCode;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasList {
    private static final Logger mLog = LoggerFactory.getLogger(AliasList.class);
    private Map<Protocol, TalkgroupAliasList> mTalkgroupProtocolMap = new EnumMap<Protocol, TalkgroupAliasList>(Protocol.class);
    private Map<Protocol, RadioAliasList> mRadioProtocolMap = new EnumMap<Protocol, RadioAliasList>(Protocol.class);
    private Map<DCSCode, Alias> mDCSCodeAliasMap = new EnumMap<DCSCode, Alias>(DCSCode.class);
    private Map<String, Alias> mESNMap = new HashMap<String, Alias>();
    private Map<Integer, Alias> mUnitStatusMap = new HashMap<Integer, Alias>();
    private Map<Integer, Alias> mUserStatusMap = new HashMap<Integer, Alias>();
    private Map<ToneSequence, Alias> mToneSequenceMap = new HashMap<ToneSequence, Alias>();
    private boolean mHasAliasActions = false;
    private String mName;
    private ObservableList<Alias> mAliases = FXCollections.observableArrayList(Alias.extractor());

    public AliasList(String name) {
        this.mName = name;
    }

    public ObservableList<Alias> aliases() {
        return this.mAliases;
    }

    public void addAlias(Alias alias) {
        if (alias != null) {
            alias.getAliasIdentifiers().stream().forEach(aliasID -> this.addAliasID((AliasID)aliasID, alias));
        }
        if (alias.hasActions()) {
            this.mHasAliasActions = true;
        }
        if (!this.mAliases.contains((Object)alias)) {
            this.mAliases.add((Object)alias);
        }
    }

    private void addAliasID(AliasID id, Alias alias) {
        if (id.isValid()) {
            try {
                switch (id.getType()) {
                    case TALKGROUP: {
                        Talkgroup talkgroup = (Talkgroup)id;
                        TalkgroupAliasList talkgroupAliasList = this.mTalkgroupProtocolMap.get((Object)talkgroup.getProtocol());
                        if (talkgroupAliasList == null) {
                            talkgroupAliasList = new TalkgroupAliasList(this);
                            this.mTalkgroupProtocolMap.put(talkgroup.getProtocol(), talkgroupAliasList);
                        }
                        talkgroupAliasList.add(talkgroup, alias);
                        break;
                    }
                    case TALKGROUP_RANGE: {
                        TalkgroupRange talkgroupRange = (TalkgroupRange)id;
                        TalkgroupAliasList talkgroupRangeAliasList = this.mTalkgroupProtocolMap.get((Object)talkgroupRange.getProtocol());
                        if (talkgroupRangeAliasList == null) {
                            talkgroupRangeAliasList = new TalkgroupAliasList(this);
                            this.mTalkgroupProtocolMap.put(talkgroupRange.getProtocol(), talkgroupRangeAliasList);
                        }
                        talkgroupRangeAliasList.add(talkgroupRange, alias);
                        break;
                    }
                    case P25_FULLY_QUALIFIED_RADIO_ID: {
                        P25FullyQualifiedRadio qualifiedRadio = (P25FullyQualifiedRadio)id;
                        RadioAliasList p25RadioAliasList = this.mRadioProtocolMap.get((Object)qualifiedRadio.getProtocol());
                        if (p25RadioAliasList == null) {
                            p25RadioAliasList = new RadioAliasList(this);
                            this.mRadioProtocolMap.put(qualifiedRadio.getProtocol(), p25RadioAliasList);
                        }
                        p25RadioAliasList.add(qualifiedRadio, alias);
                        break;
                    }
                    case P25_FULLY_QUALIFIED_TALKGROUP: {
                        P25FullyQualifiedTalkgroup qualifiedTalkgroup = (P25FullyQualifiedTalkgroup)id;
                        TalkgroupAliasList p25TalkgroupAliasList = this.mTalkgroupProtocolMap.get((Object)qualifiedTalkgroup.getProtocol());
                        if (p25TalkgroupAliasList == null) {
                            p25TalkgroupAliasList = new TalkgroupAliasList(this);
                            this.mTalkgroupProtocolMap.put(qualifiedTalkgroup.getProtocol(), p25TalkgroupAliasList);
                        }
                        p25TalkgroupAliasList.add(qualifiedTalkgroup, alias);
                        break;
                    }
                    case RADIO_ID: {
                        Radio radio = (Radio)id;
                        RadioAliasList radioAliasList = this.mRadioProtocolMap.get((Object)radio.getProtocol());
                        if (radioAliasList == null) {
                            radioAliasList = new RadioAliasList(this);
                            this.mRadioProtocolMap.put(radio.getProtocol(), radioAliasList);
                        }
                        radioAliasList.add(radio, alias);
                        break;
                    }
                    case RADIO_ID_RANGE: {
                        RadioRange radioRange = (RadioRange)id;
                        RadioAliasList radioRangeAliasList = this.mRadioProtocolMap.get((Object)radioRange.getProtocol());
                        if (radioRangeAliasList == null) {
                            radioRangeAliasList = new RadioAliasList(this);
                            this.mRadioProtocolMap.put(radioRange.getProtocol(), radioRangeAliasList);
                        }
                        radioRangeAliasList.add(radioRange, alias);
                        break;
                    }
                    case DCS: {
                        if (id instanceof Dcs) {
                            Dcs dcs = (Dcs)id;
                            this.mDCSCodeAliasMap.put(dcs.getDCSCode(), alias);
                        }
                        break;
                    }
                    case ESN: {
                        String esn = ((Esn)id).getEsn();
                        if (esn == null || esn.isEmpty()) break;
                        this.mESNMap.put(esn.toLowerCase(), alias);
                        break;
                    }
                    case STATUS: {
                        int userStatus = ((UserStatusID)id).getStatus();
                        if (this.mUserStatusMap.containsKey(userStatus) && !this.mUserStatusMap.get(userStatus).equals(alias)) {
                            id.setOverlap(true);
                            Alias existing = this.mUserStatusMap.get(userStatus);
                            for (AliasID aliasID : existing.getAliasIdentifiers()) {
                                if (!(aliasID instanceof UserStatusID) || ((UserStatusID)aliasID).getStatus() != userStatus) continue;
                                aliasID.setOverlap(true);
                            }
                        }
                        this.mUserStatusMap.put(userStatus, alias);
                        break;
                    }
                    case UNIT_STATUS: {
                        int unitStatus = ((UnitStatusID)id).getStatus();
                        if (this.mUnitStatusMap.containsKey(unitStatus) && !this.mUnitStatusMap.get(unitStatus).equals(alias)) {
                            id.setOverlap(true);
                            Alias existing = this.mUnitStatusMap.get(unitStatus);
                            for (AliasID aliasID : existing.getAliasIdentifiers()) {
                                if (!(aliasID instanceof UnitStatusID) || ((UnitStatusID)aliasID).getStatus() != unitStatus) continue;
                                aliasID.setOverlap(true);
                            }
                        }
                        this.mUnitStatusMap.put(unitStatus, alias);
                        break;
                    }
                    case TONES: {
                        ToneSequence toneSequence = ((TonesID)id).getToneSequence();
                        if (toneSequence == null) break;
                        if (this.mToneSequenceMap.containsKey(toneSequence) && !this.mToneSequenceMap.get(toneSequence).equals(alias)) {
                            id.setOverlap(true);
                            Alias existing = this.mToneSequenceMap.get(toneSequence);
                            for (AliasID aliasID : existing.getAliasIdentifiers()) {
                                if (!(aliasID instanceof TonesID) || !aliasID.equals(id)) continue;
                                aliasID.setOverlap(true);
                            }
                            break;
                        }
                        this.mToneSequenceMap.put(toneSequence, alias);
                    }
                }
            }
            catch (Exception e) {
                mLog.error("Couldn't add alias ID " + String.valueOf(id) + " for alias " + String.valueOf(alias));
            }
        }
    }

    public void removeAlias(Alias alias) {
        this.mAliases.remove((Object)alias);
        this.mTalkgroupProtocolMap.values().stream().forEach(talkgroupAliasList -> talkgroupAliasList.remove(alias));
        this.mRadioProtocolMap.values().stream().forEach(radioAliasList -> radioAliasList.remove(alias));
        Set<Alias> collection = Collections.singleton(alias);
        this.mESNMap.values().removeAll(collection);
        this.mUnitStatusMap.values().removeAll(collection);
        this.mUserStatusMap.values().removeAll(collection);
        this.mToneSequenceMap.values().removeAll(collection);
        this.validate();
    }

    public void validate() {
        HashSet<Alias> overlapAliases = new HashSet<Alias>();
        ArrayList<Alias> aliases = new ArrayList<Alias>((Collection<Alias>)this.mAliases);
        for (Alias alias2 : aliases) {
            for (AliasID aliasID : alias2.getAliasIdentifiers()) {
                if (!aliasID.overlapProperty().get()) continue;
                aliasID.setOverlap(false);
                overlapAliases.add(alias2);
            }
        }
        overlapAliases.stream().forEach(alias -> this.addAlias((Alias)alias));
    }

    public Alias getESNAlias(String esn) {
        Alias alias = null;
        if (esn != null) {
            alias = this.mESNMap.get(esn);
        }
        return alias;
    }

    public String toString() {
        return this.mName;
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return this.mName;
    }

    private boolean hasName() {
        return this.mName != null && !this.mName.isEmpty();
    }

    public void updateAlias(Alias alias) {
        this.removeAlias(alias);
        if (this.hasName() && this.getName().equals(alias.getAliasListName())) {
            this.addAlias(alias);
        }
    }

    public List<Alias> getAliases(Identifier identifier) {
        if (identifier != null) {
            switch (identifier.getForm()) {
                case TALKGROUP: {
                    TalkgroupIdentifier talkgroup = (TalkgroupIdentifier)identifier;
                    TalkgroupAliasList talkgroupAliasList = this.mTalkgroupProtocolMap.get((Object)identifier.getProtocol());
                    if (talkgroupAliasList == null) break;
                    return AliasList.toList(talkgroupAliasList.getAlias(talkgroup));
                }
                case PATCH_GROUP: {
                    RadioAliasList radioAliasList;
                    ArrayList<Alias> aliases = new ArrayList<Alias>();
                    PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
                    PatchGroup patchGroup = (PatchGroup)patchGroupIdentifier.getValue();
                    TalkgroupAliasList patchGroupAliasList = this.mTalkgroupProtocolMap.get((Object)patchGroupIdentifier.getProtocol());
                    if (patchGroupAliasList != null) {
                        Alias alias = patchGroupAliasList.getAlias(patchGroup.getPatchGroup());
                        if (alias != null) {
                            aliases.add(alias);
                        }
                        for (TalkgroupIdentifier patchedTalkgroup : patchGroup.getPatchedTalkgroupIdentifiers()) {
                            Alias patchedTalkgroupAlias = patchGroupAliasList.getAlias(patchedTalkgroup);
                            if (patchedTalkgroupAlias == null || aliases.contains(patchedTalkgroupAlias)) continue;
                            aliases.add(patchedTalkgroupAlias);
                        }
                    }
                    if (patchGroup.hasPatchedRadios() && (radioAliasList = this.mRadioProtocolMap.get((Object)patchGroupIdentifier.getProtocol())) != null) {
                        for (RadioIdentifier patchedRadio : patchGroup.getPatchedRadioIdentifiers()) {
                            Alias patchedRadioAlias = radioAliasList.getAlias(patchedRadio);
                            if (patchedRadioAlias == null || aliases.contains(patchedRadioAlias)) continue;
                            aliases.add(patchedRadioAlias);
                        }
                    }
                    return aliases;
                }
                case RADIO: {
                    RadioIdentifier radio = (RadioIdentifier)identifier;
                    RadioAliasList radioAliasList = this.mRadioProtocolMap.get((Object)identifier.getProtocol());
                    if (radioAliasList == null) break;
                    return AliasList.toList(radioAliasList.getAlias(radio));
                }
                case ESN: {
                    if (!(identifier instanceof ESNIdentifier)) break;
                    return AliasList.toList(this.getESNAlias((String)((ESNIdentifier)identifier).getValue()));
                }
                case UNIT_STATUS: {
                    if (!(identifier instanceof UnitStatusIdentifier)) break;
                    int status = (Integer)((UnitStatusIdentifier)identifier).getValue();
                    return AliasList.toList(this.mUserStatusMap.get(status));
                }
                case USER_STATUS: {
                    if (!(identifier instanceof UserStatusIdentifier)) break;
                    int status = (Integer)((UserStatusIdentifier)identifier).getValue();
                    return AliasList.toList(this.mUserStatusMap.get(status));
                }
                case TONE: {
                    DCSIdentifier dcsIdentifier;
                    DCSCode dcsCode;
                    if (identifier instanceof ToneIdentifier) {
                        ToneIdentifier toneIdentifier = (ToneIdentifier)identifier;
                        ToneSequence toneSequence = (ToneSequence)toneIdentifier.getValue();
                        if (toneSequence == null || !toneSequence.hasTones()) break;
                        for (Map.Entry<ToneSequence, Alias> entry : this.mToneSequenceMap.entrySet()) {
                            if (!entry.getKey().isContainedIn(toneSequence)) continue;
                            return AliasList.toList(entry.getValue());
                        }
                        break;
                    }
                    if (!(identifier instanceof DCSIdentifier) || (dcsCode = (DCSCode)((Object)(dcsIdentifier = (DCSIdentifier)identifier).getValue())) == null) break;
                    return AliasList.toList(this.mDCSCodeAliasMap.get((Object)dcsCode));
                }
            }
        }
        return Collections.emptyList();
    }

    private static List<Alias> toList(Alias alias) {
        if (alias != null) {
            return Collections.singletonList(alias);
        }
        return Collections.emptyList();
    }

    public boolean isStreamable(IdentifierCollection identifierCollection) {
        for (Identifier identifier : identifierCollection.getIdentifiers()) {
            List<Alias> aliases = this.getAliases(identifier);
            for (Alias alias : aliases) {
                if (alias == null || !alias.isStreamable()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRecordable(IdentifierCollection identifierCollection) {
        for (Identifier identifier : identifierCollection.getIdentifiers()) {
            List<Alias> aliases = this.getAliases(identifier);
            for (Alias alias : aliases) {
                if (alias == null || !alias.isRecordable()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAliasActions() {
        return this.mHasAliasActions;
    }

    public int getAudioPlaybackPriority(IdentifierCollection identifierCollection) {
        int priority = 100;
        for (Identifier identifier : identifierCollection.getIdentifiers()) {
            List<Alias> aliases = this.getAliases(identifier);
            for (Alias alias : aliases) {
                if (alias == null || alias.getPlaybackPriority() >= priority) continue;
                priority = alias.getPlaybackPriority();
            }
        }
        return priority;
    }

    public List<BroadcastChannel> getBroadcastChannels(IdentifierCollection identifierCollection) {
        ArrayList<BroadcastChannel> channels = new ArrayList<BroadcastChannel>();
        for (Identifier identifier : identifierCollection.getIdentifiers()) {
            List<Alias> aliases = this.getAliases(identifier);
            for (Alias alias : aliases) {
                if (alias == null || !alias.isStreamable()) continue;
                for (BroadcastChannel broadcastChannel : alias.getBroadcastChannels()) {
                    if (channels.contains(broadcastChannel)) continue;
                    channels.add(broadcastChannel);
                }
            }
        }
        return channels;
    }

    public class TalkgroupAliasList {
        private Map<String, Alias> mFullyQualifiedTalkgroupAliasMap = new HashMap<String, Alias>();
        private Map<Integer, Alias> mTalkgroupAliasMap = new TreeMap<Integer, Alias>();
        private Map<TalkgroupRange, Alias> mTalkgroupRangeAliasMap = new HashMap<TalkgroupRange, Alias>();

        public TalkgroupAliasList(AliasList this$0) {
        }

        public Alias getAlias(TalkgroupIdentifier identifier) {
            if (identifier instanceof FullyQualifiedTalkgroupIdentifier) {
                FullyQualifiedTalkgroupIdentifier fqti = (FullyQualifiedTalkgroupIdentifier)identifier;
                return this.mFullyQualifiedTalkgroupAliasMap.get(fqti.toString());
            }
            int value = (Integer)identifier.getValue();
            Alias mapValue = this.mTalkgroupAliasMap.get(value);
            if (mapValue != null) {
                return mapValue;
            }
            for (Map.Entry<TalkgroupRange, Alias> entry : this.mTalkgroupRangeAliasMap.entrySet()) {
                if (!entry.getKey().contains(value)) continue;
                return entry.getValue();
            }
            return null;
        }

        public void add(Talkgroup talkgroup, Alias alias) {
            if (talkgroup instanceof P25FullyQualifiedTalkgroup) {
                P25FullyQualifiedTalkgroup fqt = (P25FullyQualifiedTalkgroup)talkgroup;
                if (this.mFullyQualifiedTalkgroupAliasMap.containsKey(fqt.getHashKey())) {
                    Alias existing = this.mFullyQualifiedTalkgroupAliasMap.get(fqt.getHashKey());
                    if (!existing.equals(alias)) {
                        fqt.setOverlap(true);
                        for (AliasID aliasID : existing.getAliasIdentifiers()) {
                            P25FullyQualifiedTalkgroup existingFqt;
                            if (!(aliasID instanceof P25FullyQualifiedTalkgroup) || !(existingFqt = (P25FullyQualifiedTalkgroup)aliasID).getHashKey().contentEquals(fqt.getHashKey())) continue;
                            aliasID.setOverlap(true);
                        }
                    }
                } else {
                    this.mFullyQualifiedTalkgroupAliasMap.put(fqt.getHashKey(), alias);
                }
            } else {
                Alias existing;
                if (this.mTalkgroupAliasMap.containsKey(talkgroup.getValue()) && !(existing = this.mTalkgroupAliasMap.get(talkgroup.getValue())).equals(alias)) {
                    talkgroup.setOverlap(true);
                    for (AliasID aliasID : existing.getAliasIdentifiers()) {
                        if (!(aliasID instanceof Talkgroup) || ((Talkgroup)aliasID).getValue() != talkgroup.getValue()) continue;
                        aliasID.setOverlap(true);
                    }
                }
                this.mTalkgroupAliasMap.put(talkgroup.getValue(), alias);
            }
        }

        public void add(TalkgroupRange talkgroupRange, Alias alias) {
            for (Map.Entry<TalkgroupRange, Alias> entry : this.mTalkgroupRangeAliasMap.entrySet()) {
                if (!talkgroupRange.overlaps(entry.getKey()) || entry.getValue().equals(alias)) continue;
                talkgroupRange.setOverlap(true);
                entry.getKey().setOverlap(true);
            }
            this.mTalkgroupRangeAliasMap.put(talkgroupRange, alias);
        }

        public void remove(Alias alias) {
            this.mTalkgroupAliasMap.values().removeAll(Collections.singleton(alias));
            this.mTalkgroupRangeAliasMap.values().removeAll(Collections.singleton(alias));
        }
    }

    public class RadioAliasList {
        private Map<String, Alias> mFullyQualifiedRadioAliasMap = new HashMap<String, Alias>();
        private Map<Integer, Alias> mRadioAliasMap = new TreeMap<Integer, Alias>();
        private Map<RadioRange, Alias> mRadioRangeAliasMap = new HashMap<RadioRange, Alias>();

        public RadioAliasList(AliasList this$0) {
        }

        public Alias getAlias(RadioIdentifier identifier) {
            if (identifier instanceof FullyQualifiedRadioIdentifier) {
                FullyQualifiedRadioIdentifier fqri = (FullyQualifiedRadioIdentifier)identifier;
                return this.mFullyQualifiedRadioAliasMap.get(fqri.toString());
            }
            int value = (Integer)identifier.getValue();
            Alias mapValue = this.mRadioAliasMap.get(value);
            if (mapValue != null) {
                return mapValue;
            }
            for (Map.Entry<RadioRange, Alias> entry : this.mRadioRangeAliasMap.entrySet()) {
                if (!entry.getKey().contains(value)) continue;
                return entry.getValue();
            }
            return null;
        }

        public void add(Radio radio, Alias alias) {
            if (radio instanceof P25FullyQualifiedRadio) {
                P25FullyQualifiedRadio fqr = (P25FullyQualifiedRadio)radio;
                if (this.mFullyQualifiedRadioAliasMap.containsKey(fqr.getHashKey())) {
                    Alias existing = this.mFullyQualifiedRadioAliasMap.get(fqr.getHashKey());
                    if (!existing.equals(alias)) {
                        fqr.setOverlap(true);
                        for (AliasID aliasID : existing.getAliasIdentifiers()) {
                            P25FullyQualifiedRadio existingFqr;
                            if (!(aliasID instanceof P25FullyQualifiedRadio) || !(existingFqr = (P25FullyQualifiedRadio)aliasID).getHashKey().contentEquals(fqr.getHashKey())) continue;
                            aliasID.setOverlap(true);
                        }
                    }
                } else {
                    this.mFullyQualifiedRadioAliasMap.put(fqr.getHashKey(), alias);
                }
            } else {
                Alias existing;
                if (this.mRadioAliasMap.containsKey(radio.getValue()) && !(existing = this.mRadioAliasMap.get(radio.getValue())).equals(alias)) {
                    radio.setOverlap(true);
                    for (AliasID aliasID : existing.getAliasIdentifiers()) {
                        Radio existingRadio;
                        if (!(aliasID instanceof Radio) || (existingRadio = (Radio)aliasID).getValue() != radio.getValue()) continue;
                        aliasID.setOverlap(true);
                    }
                }
                this.mRadioAliasMap.put(radio.getValue(), alias);
            }
        }

        public void add(RadioRange radioRange, Alias alias) {
            for (Map.Entry<RadioRange, Alias> entry : this.mRadioRangeAliasMap.entrySet()) {
                if (!radioRange.overlaps(entry.getKey()) || entry.getValue().equals(alias)) continue;
                radioRange.setOverlap(true);
                entry.getKey().setOverlap(true);
            }
            this.mRadioRangeAliasMap.put(radioRange, alias);
        }

        public void remove(Alias alias) {
            this.mRadioAliasMap.values().removeAll(Collections.singleton(alias));
            this.mRadioRangeAliasMap.values().removeAll(Collections.singleton(alias));
        }
    }
}

