/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.Ellipse;
import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import java.util.NoSuchElementException;

class EllipseIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    BaseTransform transform;
    int index;
    public static final double CtrlVal = 0.5522847498307933;
    private static final double pcv = 0.7761423749153966;
    private static final double ncv = 0.22385762508460333;
    private static final double[][] ctrlpts = new double[][]{{1.0, 0.7761423749153966, 0.7761423749153966, 1.0, 0.5, 1.0}, {0.22385762508460333, 1.0, 0.0, 0.7761423749153966, 0.0, 0.5}, {0.0, 0.22385762508460333, 0.22385762508460333, 0.0, 0.5, 0.0}, {0.7761423749153966, 0.0, 1.0, 0.22385762508460333, 1.0, 0.5}};

    EllipseIterator(Ellipse ELLIPSE, BaseTransform TRANSFORM) {
        this.x = ELLIPSE.x;
        this.y = ELLIPSE.y;
        this.w = ELLIPSE.width;
        this.h = ELLIPSE.height;
        this.transform = TRANSFORM;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public Path.WindingRule getWindingRule() {
        return Path.WindingRule.WIND_NON_ZERO;
    }

    @Override
    public int currentSegment(double[] COORDS) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] ctrls = ctrlpts[3];
            COORDS[0] = this.x + ctrls[4] * this.w;
            COORDS[1] = this.y + ctrls[5] * this.h;
            if (this.transform != null) {
                this.transform.transform(COORDS, 0, COORDS, 0, 1);
            }
            return 0;
        }
        double[] ctrls = ctrlpts[this.index - 1];
        COORDS[0] = this.x + ctrls[0] * this.w;
        COORDS[1] = this.y + ctrls[1] * this.h;
        COORDS[2] = this.x + ctrls[2] * this.w;
        COORDS[3] = this.y + ctrls[3] * this.h;
        COORDS[4] = this.x + ctrls[4] * this.w;
        COORDS[5] = this.y + ctrls[5] * this.h;
        if (this.transform != null) {
            this.transform.transform(COORDS, 0, COORDS, 0, 3);
        }
        return 3;
    }
}

