/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.BezierCurve;
import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import java.util.NoSuchElementException;

class BezierCurveIterator
implements PathIterator {
    BezierCurve bezierCurve;
    BaseTransform transform;
    int index;

    BezierCurveIterator(BezierCurve bezierCurve, BaseTransform transform) {
        this.bezierCurve = bezierCurve;
        this.transform = transform;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public Path.WindingRule getWindingRule() {
        return Path.WindingRule.WIND_NON_ZERO;
    }

    @Override
    public int currentSegment(double[] COORDS) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("bezierCurve iterator iterator out of bounds");
        }
        if (this.index == 0) {
            COORDS[0] = this.bezierCurve.x1;
            COORDS[1] = this.bezierCurve.y1;
            type = 0;
        } else {
            COORDS[0] = this.bezierCurve.ctrlx1;
            COORDS[1] = this.bezierCurve.ctrly1;
            COORDS[2] = this.bezierCurve.ctrlx2;
            COORDS[3] = this.bezierCurve.ctrly2;
            COORDS[4] = this.bezierCurve.x2;
            COORDS[5] = this.bezierCurve.y2;
            type = 3;
        }
        if (this.transform != null) {
            this.transform.transform(COORDS, 0, COORDS, 0, this.index == 0 ? 1 : 3);
        }
        return type;
    }
}

