/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.LocationEvent;
import eu.hansolo.fx.charts.event.LocationEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class Location {
    private final LocationEvent UPDATE_EVENT = new LocationEvent(this, EventType.UPDATE);
    private String _name;
    private StringProperty name;
    private Instant _timestamp;
    private ObjectProperty<Instant> timestamp;
    private double _latitude;
    private DoubleProperty latitude;
    private double _longitude;
    private DoubleProperty longitude;
    private double _altitude;
    private DoubleProperty altitude;
    private String _info;
    private StringProperty info;
    private Color _color;
    private ObjectProperty<Color> color;
    private int zoomLevel;
    private List<LocationEventListener> listenerList;
    private EventHandler<MouseEvent> mouseEnterHandler;
    private EventHandler<MouseEvent> mousePressHandler;
    private EventHandler<MouseEvent> mouseReleaseHandler;
    private EventHandler<MouseEvent> mouseExitHandler;

    public Location() {
        this(0.0, 0.0, 0.0, Instant.now(), "", "", Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), "", "", Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, "", Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, Color COLOR) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, "", COLOR);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, String INFO) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, INFO, Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, String INFO, Color COLOR) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, INFO, COLOR);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, String NAME) {
        this(LATITUDE, LONGITUDE, ALTITUDE, Instant.now(), NAME, "", Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String NAME) {
        this(LATITUDE, LONGITUDE, ALTITUDE, TIMESTAMP, NAME, "", Color.BLUE);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String NAME, String INFO, Color COLOR) {
        this._name = NAME;
        this._latitude = LATITUDE;
        this._longitude = LONGITUDE;
        this._altitude = ALTITUDE;
        this._timestamp = TIMESTAMP;
        this._info = INFO;
        this._color = COLOR;
        this.zoomLevel = 15;
        this.listenerList = new CopyOnWriteArrayList<LocationEventListener>();
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public Instant getTimestamp() {
        return null == this.timestamp ? this._timestamp : (Instant)this.timestamp.get();
    }

    public long getTimestampInSeconds() {
        return this.getTimestamp().getEpochSecond();
    }

    public void setTimestamp(Instant TIMESTAMP) {
        if (null == this.timestamp) {
            this._timestamp = TIMESTAMP;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.timestamp.set((Object)TIMESTAMP);
        }
    }

    public ObjectProperty<Instant> timestampProperty() {
        if (null == this.timestamp) {
            this.timestamp = new ObjectPropertyBase<Instant>(this._timestamp){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "timestamp";
                }
            };
            this._timestamp = null;
        }
        return this.timestamp;
    }

    public double getLatitude() {
        return null == this.latitude ? this._latitude : this.latitude.get();
    }

    public void setLatitude(double LATITUDE) {
        if (null == this.latitude) {
            this._latitude = LATITUDE;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.latitude.set(LATITUDE);
        }
    }

    public DoubleProperty latitudeProperty() {
        if (null == this.latitude) {
            this.latitude = new DoublePropertyBase(this._latitude){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "latitude";
                }
            };
        }
        return this.latitude;
    }

    public double getLongitude() {
        return null == this.longitude ? this._longitude : this.longitude.get();
    }

    public void setLongitude(double LONGITUDE) {
        if (null == this.longitude) {
            this._longitude = LONGITUDE;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.longitude.set(LONGITUDE);
        }
    }

    public DoubleProperty longitudeProperty() {
        if (null == this.longitude) {
            this.longitude = new DoublePropertyBase(this._longitude){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "longitude";
                }
            };
        }
        return this.longitude;
    }

    public double getAltitude() {
        return null == this.altitude ? this._altitude : this.altitude.get();
    }

    public void setAltitude(double ALTITUDE) {
        if (null == this.altitude) {
            this._altitude = ALTITUDE;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.altitude.set(ALTITUDE);
        }
    }

    public DoubleProperty altitudeProperty() {
        if (null == this.altitude) {
            this.altitude = new DoublePropertyBase(this._altitude){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "altitude";
                }
            };
        }
        return this.altitude;
    }

    public String getInfo() {
        return null == this.info ? this._info : (String)this.info.get();
    }

    public void setInfo(String INFO) {
        if (null == this.info) {
            this._info = INFO;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.info.set((Object)INFO);
        }
    }

    public StringProperty infoProperty() {
        if (null == this.info) {
            this.info = new StringPropertyBase(this._info){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "info";
                }
            };
            this._info = null;
        }
        return this.info;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
            this.fireLocationEvent(this.UPDATE_EVENT);
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new ObjectPropertyBase<Color>(this._color){

                protected void invalidated() {
                    Location.this.fireLocationEvent(Location.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "color";
                }
            };
            this._color = null;
        }
        return this.color;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.getZonedDateTime(ZoneId.systemDefault());
    }

    public ZonedDateTime getZonedDateTime(ZoneId ZONE_ID) {
        return ZonedDateTime.ofInstant(this.getTimestamp(), ZONE_ID);
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int LEVEL) {
        this.zoomLevel = Helper.clamp(0, 17, LEVEL);
        this.fireLocationEvent(this.UPDATE_EVENT);
    }

    public void update(double LATITUDE, double LONGITUDE) {
        this.set(LATITUDE, LONGITUDE);
    }

    public void set(double LATITUDE, double LONGITUDE) {
        this.set(LATITUDE, LONGITUDE, this.getAltitude(), this.getTimestamp(), this.getInfo());
    }

    public void set(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP) {
        this.set(LATITUDE, LONGITUDE, ALTITUDE, TIMESTAMP, this.getInfo());
    }

    public void set(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String INFO) {
        if (null == this.latitude) {
            this._latitude = LATITUDE;
        } else {
            this.latitude.set(LATITUDE);
        }
        if (null == this.longitude) {
            this._longitude = LONGITUDE;
        } else {
            this.longitude.set(LONGITUDE);
        }
        if (null == this.altitude) {
            this._altitude = ALTITUDE;
        } else {
            this.altitude.set(ALTITUDE);
        }
        if (null == this.timestamp) {
            this._timestamp = TIMESTAMP;
        } else {
            this.timestamp.set((Object)TIMESTAMP);
        }
        if (null == this.info) {
            this._info = INFO;
        } else {
            this.info.set((Object)INFO);
        }
        this.fireLocationEvent(this.UPDATE_EVENT);
    }

    public void set(Location LOCATION) {
        if (null == this.name) {
            this._name = LOCATION.getName();
        } else {
            this.name.set((Object)LOCATION.getName());
        }
        if (null == this.latitude) {
            this._latitude = LOCATION.getLatitude();
        } else {
            this.latitude.set(LOCATION.getLatitude());
        }
        if (null == this.longitude) {
            this._longitude = LOCATION.getLongitude();
        } else {
            this.longitude.set(LOCATION.getLongitude());
        }
        if (null == this.altitude) {
            this._altitude = LOCATION.getAltitude();
        } else {
            this.altitude.set(LOCATION.getAltitude());
        }
        if (null == this.timestamp) {
            this._timestamp = LOCATION.getTimestamp();
        } else {
            this.timestamp.set((Object)LOCATION.getTimestamp());
        }
        if (null == this.info) {
            this._info = LOCATION.getInfo();
        } else {
            this.info.set((Object)LOCATION.getInfo());
        }
        if (null == this.color) {
            this._color = LOCATION.getColor();
        } else {
            this.color.set((Object)LOCATION.getColor());
        }
        this.zoomLevel = LOCATION.getZoomLevel();
        this.fireLocationEvent(this.UPDATE_EVENT);
    }

    public double getDistanceTo(Location LOCATION) {
        return this.calcDistanceInMeter(this, LOCATION);
    }

    public boolean isWithinRangeOf(Location LOCATION, double METERS) {
        return this.getDistanceTo(LOCATION) < METERS;
    }

    public double calcDistanceInMeter(Location P1, Location P2) {
        return this.calcDistanceInMeter(P1.getLatitude(), P1.getLongitude(), P2.getLatitude(), P2.getLongitude());
    }

    public double calcDistanceInKilometer(Location P1, Location P2) {
        return this.calcDistanceInMeter(P1, P2) / 1000.0;
    }

    public double calcDistanceInMeter(double LAT_1, double LON_1, double LAT_2, double LON_2) {
        double EARTH_RADIUS = 6371000.0;
        double LAT_1_RADIANS = Math.toRadians(LAT_1);
        double LAT_2_RADIANS = Math.toRadians(LAT_2);
        double DELTA_LAT_RADIANS = Math.toRadians(LAT_2 - LAT_1);
        double DELTA_LON_RADIANS = Math.toRadians(LON_2 - LON_1);
        double A = Math.sin(DELTA_LAT_RADIANS * 0.5) * Math.sin(DELTA_LAT_RADIANS * 0.5) + Math.cos(LAT_1_RADIANS) * Math.cos(LAT_2_RADIANS) * Math.sin(DELTA_LON_RADIANS * 0.5) * Math.sin(DELTA_LON_RADIANS * 0.5);
        double C = 2.0 * Math.atan2(Math.sqrt(A), Math.sqrt(1.0 - A));
        double DISTANCE = 6371000.0 * C;
        return DISTANCE;
    }

    public double getAltitudeDifferenceInMeter(Location LOCATION) {
        return this.getAltitude() - LOCATION.getAltitude();
    }

    public double getBearingTo(Location LOCATION) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), LOCATION.getLatitude(), LOCATION.getLongitude());
    }

    public double getBearingTo(double LATITUDE, double LONGITUDE) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), LATITUDE, LONGITUDE);
    }

    public boolean isZero() {
        return Double.compare(this.getLatitude(), 0.0) == 0 && Double.compare(this.getLongitude(), 0.0) == 0;
    }

    public double calcBearingInDegree(double LAT_1, double LON_1, double LAT_2, double LON_2) {
        double lat1 = Math.toRadians(LAT_1);
        double lon1 = Math.toRadians(LON_1);
        double lat2 = Math.toRadians(LAT_2);
        double lon2 = Math.toRadians(LON_2);
        double deltaLon = lon2 - lon1;
        double deltaPhi = Math.log(Math.tan(lat2 * 0.5 + 0.7853981633974483) / Math.tan(lat1 * 0.5 + 0.7853981633974483));
        if (Math.abs(deltaLon) > Math.PI) {
            deltaLon = deltaLon > 0.0 ? -(Math.PI * 2 - deltaLon) : Math.PI * 2 + deltaLon;
        }
        double bearing = (Math.toDegrees(Math.atan2(deltaLon, deltaPhi)) + 360.0) % 360.0;
        return bearing;
    }

    public String getCardinalDirectionFromBearing(double BEARING) {
        double bearing = BEARING % 360.0;
        for (CardinalDirection cardinalDirection : CardinalDirection.values()) {
            if (Double.compare(bearing, cardinalDirection.from) < 0 || Double.compare(bearing, cardinalDirection.to) >= 0) continue;
            return cardinalDirection.direction;
        }
        return "";
    }

    public void setOnLocationEvent(LocationEventListener LISTENER) {
        this.addLocationEventListener(LISTENER);
    }

    public void addLocationEventListener(LocationEventListener LISTENER) {
        if (!this.listenerList.contains(LISTENER)) {
            this.listenerList.add(LISTENER);
        }
    }

    public void removeLocationEventListener(LocationEventListener LISTENER) {
        if (this.listenerList.contains(LISTENER)) {
            this.listenerList.remove(LISTENER);
        }
    }

    public void fireLocationEvent(LocationEvent EVENT) {
        for (LocationEventListener listener : this.listenerList) {
            listener.onLocationEvent(EVENT);
        }
    }

    public EventHandler<MouseEvent> getMouseEnterHandler() {
        return this.mouseEnterHandler;
    }

    public void setMouseEnterHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseEnterHandler = HANDLER;
    }

    public EventHandler<MouseEvent> getMousePressHandler() {
        return this.mousePressHandler;
    }

    public void setMousePressHandler(EventHandler<MouseEvent> HANDLER) {
        this.mousePressHandler = HANDLER;
    }

    public EventHandler<MouseEvent> getMouseReleaseHandler() {
        return this.mouseReleaseHandler;
    }

    public void setMouseReleaseHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseReleaseHandler = HANDLER;
    }

    public EventHandler<MouseEvent> getMouseExitHandler() {
        return this.mouseExitHandler;
    }

    public void setMouseExitHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseExitHandler = HANDLER;
    }

    public boolean equals(Object OBJECT) {
        if (OBJECT instanceof Location) {
            Location LOCATION = (Location)OBJECT;
            return Double.compare(this.getLatitude(), LOCATION.getLatitude()) == 0 && Double.compare(this.getLongitude(), LOCATION.getLongitude()) == 0 && Double.compare(this.getAltitude(), LOCATION.getAltitude()) == 0;
        }
        return false;
    }

    public String toString() {
        return "{" + "  \"name     \":\"" + this.getName() + "\",\n" + "  \"timestamp\":\"" + this.getTimestamp() + "\",\n" + "  \"latitude \":" + this.getLatitude() + ",\n" + "  \"longitude\":" + this.getLongitude() + ",\n" + "  \"altitude \":" + this.getAltitude() + ",\n" + "  \"info     \":\"" + this.getInfo() + "\",\n" + "  \"color    \":\"" + Helper.colorToWeb(this.getColor()) + "\",\n" + "  \"zoomLevel\":" + this.getZoomLevel() + "\n" + "}";
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getLatitude());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getLongitude());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getAltitude());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static enum CardinalDirection {
        N("North", 348.75, 11.25),
        NNE("North North-East", 11.25, 33.75),
        NE("North-East", 33.75, 56.25),
        ENE("East North-East", 56.25, 78.75),
        E("East", 78.75, 101.25),
        ESE("East South-East", 101.25, 123.75),
        SE("South-East", 123.75, 146.25),
        SSE("South South-East", 146.25, 168.75),
        S("South", 168.75, 191.25),
        SSW("South South-West", 191.25, 213.75),
        SW("South-West", 213.75, 236.25),
        WSW("West South-West", 236.25, 258.75),
        W("West", 258.75, 281.25),
        WNW("West North-West", 281.25, 303.75),
        NW("North-West", 303.75, 326.25),
        NNW("North North-West", 326.25, 348.75);

        public String direction;
        public double from;
        public double to;

        private CardinalDirection(String DIRECTION, double FROM, double TO) {
            this.direction = DIRECTION;
            this.from = FROM;
            this.to = TO;
        }
    }
}

