/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.DataPoint;
import eu.hansolo.fx.charts.data.XYChartItem;
import eu.hansolo.fx.charts.tools.CatmullRom;
import eu.hansolo.fx.charts.tools.CtxBounds;
import eu.hansolo.fx.charts.tools.CtxCornerRadii;
import eu.hansolo.fx.charts.tools.CtxDimension;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.Point;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javafx.animation.Interpolator;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javax.imageio.ImageIO;

public class Helper {
    public static final double MAX_TICK_MARK_LENGTH = 0.125;
    public static final double MAX_TICK_MARK_WIDTH = 0.02;
    public static final String[] ABBREVIATIONS = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};

    public static final int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clamp(double MIN, double MAX, double VALUE) {
        if (Double.compare(VALUE, MIN) < 0) {
            return MIN;
        }
        if (Double.compare(VALUE, MAX) > 0) {
            return MAX;
        }
        return VALUE;
    }

    public static final Instant clamp(Instant MIN, Instant MAX, Instant VALUE) {
        if (VALUE.isBefore(MIN)) {
            return MIN;
        }
        if (VALUE.isAfter(MAX)) {
            return MAX;
        }
        return VALUE;
    }

    public static final LocalDateTime clamp(LocalDateTime MIN, LocalDateTime MAX, LocalDateTime VALUE) {
        if (VALUE.isBefore(MIN)) {
            return MIN;
        }
        if (VALUE.isAfter(MAX)) {
            return MAX;
        }
        return VALUE;
    }

    public static final LocalDate clamp(LocalDate MIN, LocalDate MAX, LocalDate VALUE) {
        if (VALUE.isBefore(MIN)) {
            return MIN;
        }
        if (VALUE.isAfter(MAX)) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clampMin(double MIN, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        return VALUE;
    }

    public static final double clampMax(double MAX, double VALUE) {
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double nearest(double LESS, double VALUE, double MORE) {
        double lessDiff = VALUE - LESS;
        double moreDiff = MORE - VALUE;
        return lessDiff < moreDiff ? LESS : MORE;
    }

    public static final double[] calcAutoScale(double MIN_VALUE, double MAX_VALUE) {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double minorTickSpace = 1.0;
        double majorTickSpace = 10.0;
        double niceRange = Helper.calcNiceNumber(MAX_VALUE - MIN_VALUE, false);
        majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        minorTickSpace = Helper.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        double niceMinValue = Math.floor(MIN_VALUE / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(MAX_VALUE / majorTickSpace) * majorTickSpace;
        return new double[]{minorTickSpace, majorTickSpace, niceMinValue, niceMaxValue};
    }

    public static final double calcNiceNumber(double RANGE, boolean ROUND) {
        double exponent = Math.floor(Math.log10(RANGE));
        double fraction = RANGE / Math.pow(10.0, exponent);
        double niceFraction = ROUND ? (Double.compare(fraction, 1.5) < 0 ? 1.0 : (Double.compare(fraction, 3.0) < 0 ? 2.0 : (Double.compare(fraction, 7.0) < 0 ? 5.0 : 10.0))) : (Double.compare(fraction, 1.0) <= 0 ? 1.0 : (Double.compare(fraction, 2.0) <= 0 ? 2.0 : (Double.compare(fraction, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public static final void rotateCtx(GraphicsContext CTX, double X, double Y, double ANGLE) {
        CTX.translate(X, Y);
        CTX.rotate(ANGLE);
        CTX.translate(-X, -Y);
    }

    public static final void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TickLabelOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
            case TANGENT: {
                if ((360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
        }
    }

    public static final void saveAsPng(Node NODE, String FILE_NAME) {
        WritableImage SNAPSHOT = NODE.snapshot(new SnapshotParameters(), null);
        String NAME = FILE_NAME.replace("\\.[a-zA-Z]{3,4}", "");
        File FILE = new File(NAME + ".png");
        try {
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)SNAPSHOT, null), "png", FILE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final List<Point> subdividePoints(List<Point> POINTS, int SUB_DIVISIONS) {
        Point[] points = POINTS.toArray(new Point[0]);
        return Arrays.asList(Helper.subdividePoints(points, SUB_DIVISIONS));
    }

    public static final Point[] subdividePoints(Point[] POINTS, int SUB_DIVISIONS) {
        assert (POINTS != null);
        assert (POINTS.length >= 3);
        int noOfPoints = POINTS.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * SUB_DIVISIONS + 1];
        double increments = 1.0 / (double)SUB_DIVISIONS;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            Point p0 = i == 0 ? POINTS[i] : POINTS[i - 1];
            Point p1 = POINTS[i];
            Point p2 = POINTS[i + 1];
            Point p3 = i + 2 == noOfPoints ? POINTS[i + 1] : POINTS[i + 2];
            CatmullRom<Point> crs = new CatmullRom<Point>(p0, p1, p2, p3);
            for (int j = 0; j <= SUB_DIVISIONS; ++j) {
                subdividedPoints[i * SUB_DIVISIONS + j] = crs.q((double)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static final List<DataPoint> subdivideDataPoints(List<DataPoint> POINTS, int SUB_DIVISIONS) {
        DataPoint[] points = POINTS.toArray(new DataPoint[0]);
        return Arrays.asList(Helper.subdividePoints(points, SUB_DIVISIONS));
    }

    public static final DataPoint[] subdividePoints(DataPoint[] POINTS, int SUB_DIVISIONS) {
        assert (POINTS != null);
        assert (POINTS.length >= 3);
        int noOfPoints = POINTS.length;
        DataPoint[] subdividedPoints = new DataPoint[(noOfPoints - 1) * SUB_DIVISIONS + 1];
        double increments = 1.0 / (double)SUB_DIVISIONS;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            DataPoint p0 = i == 0 ? POINTS[i] : POINTS[i - 1];
            DataPoint p1 = POINTS[i];
            DataPoint p2 = POINTS[i + 1];
            DataPoint p3 = i + 2 == noOfPoints ? POINTS[i + 1] : POINTS[i + 2];
            CatmullRom<DataPoint> crs = new CatmullRom<DataPoint>(p0, p1, p2, p3);
            for (int j = 0; j <= SUB_DIVISIONS; ++j) {
                subdividedPoints[i * SUB_DIVISIONS + j] = crs.q((double)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static final Point[] subdividePointsLinear(Point[] POINTS, int SUB_DIVISIONS) {
        assert (POINTS != null);
        assert (POINTS.length >= 3);
        int noOfPoints = POINTS.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * SUB_DIVISIONS + 1];
        double stepSize = (POINTS[1].getX() - POINTS[0].getX()) / (double)SUB_DIVISIONS;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            for (int j = 0; j <= SUB_DIVISIONS; ++j) {
                subdividedPoints[i * SUB_DIVISIONS + j] = Helper.calcIntermediatePoint(POINTS[i], POINTS[i + 1], stepSize * (double)j);
            }
        }
        return subdividedPoints;
    }

    public static final Point calcIntermediatePoint(Point LEFT_POINT, Point RIGHT_POINT, double INTERVAL_X) {
        double m = (RIGHT_POINT.getY() - LEFT_POINT.getY()) / (RIGHT_POINT.getX() - LEFT_POINT.getX());
        double x = INTERVAL_X;
        double y = m * x;
        return new Point(LEFT_POINT.getX() + x, LEFT_POINT.getY() + y);
    }

    public static final Point calcIntersectionOfTwoLines(Point A, Point B, Point C, Point D) {
        return Helper.calcIntersectionOfTwoLines(A.getX(), A.getY(), B.getX(), B.getY(), C.getX(), C.getY(), D.getX(), D.getY());
    }

    public static final Point calcIntersectionOfTwoLines(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4) {
        double a1 = Y2 - Y1;
        double b1 = X1 - X2;
        double c1 = a1 * X1 + b1 * Y1;
        double a2 = Y4 - Y3;
        double b2 = X3 - X4;
        double c2 = a2 * X3 + b2 * Y3;
        double determinant = a1 * b2 - a2 * b1;
        if (determinant == 0.0) {
            return new Point(Double.MAX_VALUE, Double.MAX_VALUE);
        }
        double x = (b2 * c1 - b1 * c2) / determinant;
        double y = (a1 * c2 - a2 * c1) / determinant;
        return new Point(x, y);
    }

    public static final Point calcIntersectionPoint(Point LEFT_POINT, Point RIGHT_POINT, double INTERSECTION_Y) {
        double[] xy = Helper.calculateInterSectionPoint(LEFT_POINT.getX(), LEFT_POINT.getY(), RIGHT_POINT.getX(), RIGHT_POINT.getY(), INTERSECTION_Y);
        return new Point(xy[0], xy[1]);
    }

    public static final double[] calculateInterSectionPoint(Point LEFT_POINT, Point RIGHT_POINT, double INTERSECTION_Y) {
        return Helper.calculateInterSectionPoint(LEFT_POINT.getX(), LEFT_POINT.getY(), RIGHT_POINT.getX(), RIGHT_POINT.getY(), INTERSECTION_Y);
    }

    public static final double[] calculateInterSectionPoint(double X1, double Y1, double X2, double Y2, double INTERSECTION_Y) {
        double m = (Y2 - Y1) / (X2 - X1);
        double interSectionX = (INTERSECTION_Y - Y1) / m;
        return new double[]{X1 + interSectionX, INTERSECTION_Y};
    }

    public static final double[] rotate(double PX, double PY, double RX, double RY, double ANGLE) {
        double x = RX + (Math.cos(ANGLE) * (PX - RX) - Math.sin(ANGLE) * (PY - RY));
        double y = RY + (Math.sin(ANGLE) * (PX - RX) + Math.cos(ANGLE) * (PY - RY));
        return new double[]{x, y};
    }

    public static final Point rotate(Point P1, Point ROTATION_CENTER, double ANGLE) {
        double[] xy = Helper.rotate(P1.getX(), P1.getY(), ROTATION_CENTER.getX(), ROTATION_CENTER.getY(), ANGLE);
        return new Point(xy[0], xy[1]);
    }

    public static final Color getColorWithOpacity(Color COLOR, double OPACITY) {
        double red = COLOR.getRed();
        double green = COLOR.getGreen();
        double blue = COLOR.getBlue();
        double opacity = Helper.clamp(0.0, 1.0, OPACITY);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    public static final boolean isPowerOf10(double VALUE) {
        double value;
        for (value = VALUE; value > 9.0 && value % 10.0 == 0.0; value /= 10.0) {
        }
        return value == 1.0;
    }

    public static final List<Color> createColorPalette(Color FROM_COLOR, Color TO_COLOR, int NO_OF_COLORS) {
        int steps = Helper.clamp(1, 50, NO_OF_COLORS) - 1;
        double step = 1.0 / (double)steps;
        double deltaRed = (TO_COLOR.getRed() - FROM_COLOR.getRed()) * step;
        double deltaGreen = (TO_COLOR.getGreen() - FROM_COLOR.getGreen()) * step;
        double deltaBlue = (TO_COLOR.getBlue() - FROM_COLOR.getBlue()) * step;
        double deltaOpacity = (TO_COLOR.getOpacity() - FROM_COLOR.getOpacity()) * step;
        ArrayList<Color> palette = new ArrayList<Color>(NO_OF_COLORS);
        Color currentColor = FROM_COLOR;
        palette.add(currentColor);
        for (int i = 0; i < steps; ++i) {
            double red = Helper.clamp(0.0, 1.0, currentColor.getRed() + deltaRed);
            double green = Helper.clamp(0.0, 1.0, currentColor.getGreen() + deltaGreen);
            double blue = Helper.clamp(0.0, 1.0, currentColor.getBlue() + deltaBlue);
            double opacity = Helper.clamp(0.0, 1.0, currentColor.getOpacity() + deltaOpacity);
            currentColor = Color.color((double)red, (double)green, (double)blue, (double)opacity);
            palette.add(currentColor);
        }
        return palette;
    }

    public static final Color getComplementaryColor(Color COLOR) {
        return Color.hsb((double)(COLOR.getHue() + 180.0), (double)COLOR.getSaturation(), (double)COLOR.getBrightness());
    }

    public static final Color[] getColorRangeMinMax(Color COLOR, int STEPS) {
        double hue = COLOR.getHue();
        double saturation = COLOR.getSaturation();
        double brightness = COLOR.getBrightness();
        double saturationStep = saturation / (double)STEPS;
        double brightnessStep = brightness / (double)STEPS;
        double halfSteps = STEPS / 2;
        Color fromColor = Color.hsb((double)hue, (double)saturation, (double)Helper.clamp(0.0, 1.0, brightness + brightnessStep * halfSteps));
        Color toColor = Color.hsb((double)hue, (double)saturation, (double)Helper.clamp(0.0, 1.0, brightness - brightnessStep * halfSteps));
        return new Color[]{fromColor, toColor};
    }

    public static final List<Color> createColorVariations(Color COLOR, int NO_OF_COLORS) {
        int noOfColors = Helper.clamp(1, 5, NO_OF_COLORS);
        double step = 0.8 / (double)noOfColors;
        double hue = COLOR.getHue();
        double brg = COLOR.getBrightness();
        ArrayList<Color> colors = new ArrayList<Color>(noOfColors);
        for (int i = 0; i < noOfColors; ++i) {
            colors.add(Color.hsb((double)hue, (double)(0.2 + (double)i * step), (double)brg));
        }
        return colors;
    }

    public static final LinearGradient createColorVariationGradient(Color COLOR, int NO_OF_COLORS) {
        List<Color> colorVariations = Helper.createColorVariations(COLOR, NO_OF_COLORS);
        ArrayList<Stop> stops = new ArrayList<Stop>(NO_OF_COLORS);
        double step = 1.0 / (double)NO_OF_COLORS;
        for (int i = 0; i < NO_OF_COLORS; ++i) {
            stops.add(new Stop((double)i * step, colorVariations.get(i)));
        }
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public static final double[] colorToYUV(Color COLOR) {
        double WEIGHT_FACTOR_RED = 0.299;
        double WEIGHT_FACTOR_GREEN = 0.587;
        double WEIGHT_FACTOR_BLUE = 0.144;
        double U_MAX = 0.436;
        double V_MAX = 0.615;
        double y = Helper.clamp(0.0, 1.0, 0.299 * COLOR.getRed() + 0.587 * COLOR.getGreen() + 0.144 * COLOR.getBlue());
        double u = Helper.clamp(-0.436, 0.436, 0.436 * ((COLOR.getBlue() - y) / 0.856));
        double v = Helper.clamp(-0.615, 0.615, 0.615 * ((COLOR.getRed() - y) / 0.7010000000000001));
        return new double[]{y, u, v};
    }

    public static final boolean isBright(Color COLOR) {
        return (double)Double.compare(Helper.colorToYUV(COLOR)[0], 0.5) >= 0.0;
    }

    public static final boolean isDark(Color COLOR) {
        return Helper.colorToYUV(COLOR)[0] < 0.5;
    }

    public static final boolean isInRectangle(double X, double Y, double MIN_X, double MIN_Y, double MAX_X, double MAX_Y) {
        return Double.compare(X, MIN_X) >= 0 && Double.compare(X, MAX_X) <= 0 && Double.compare(Y, MIN_Y) >= 0 && Double.compare(Y, MAX_Y) <= 0;
    }

    public static final boolean isInEllipse(double X, double Y, double ELLIPSE_CENTER_X, double ELLIPSE_CENTER_Y, double ELLIPSE_RADIUS_X, double ELLIPSE_RADIUS_Y) {
        return (double)Double.compare((X - ELLIPSE_CENTER_X) * (X - ELLIPSE_CENTER_X) / (ELLIPSE_RADIUS_X * ELLIPSE_RADIUS_X) + (Y - ELLIPSE_CENTER_Y) * (Y - ELLIPSE_CENTER_Y) / (ELLIPSE_RADIUS_Y * ELLIPSE_RADIUS_Y), 1.0) <= 0.0;
    }

    public static final boolean isInPolygon(double X, double Y, Polygon POLYGON) {
        ObservableList points = POLYGON.getPoints();
        int noOfPointsInPolygon = POLYGON.getPoints().size() / 2;
        double[] pointsX = new double[noOfPointsInPolygon];
        double[] pointsY = new double[noOfPointsInPolygon];
        int pointCounter = 0;
        for (int i = 0; i < points.size(); ++i) {
            if (i % 2 == 0) {
                pointsX[i] = (Double)points.get(pointCounter);
                continue;
            }
            pointsY[i] = (Double)points.get(pointCounter);
            ++pointCounter;
        }
        return Helper.isInPolygon(X, Y, noOfPointsInPolygon, pointsX, pointsY);
    }

    public static final boolean isInPolygon(double X, double Y, int NO_OF_POINTS_IN_POLYGON, double[] POINTS_X, double[] POINTS_Y) {
        if (NO_OF_POINTS_IN_POLYGON != POINTS_X.length || NO_OF_POINTS_IN_POLYGON != POINTS_Y.length) {
            return false;
        }
        boolean inside = false;
        int i = 0;
        int j = NO_OF_POINTS_IN_POLYGON - 1;
        while (i < NO_OF_POINTS_IN_POLYGON) {
            if (POINTS_Y[i] > Y != POINTS_Y[j] > Y && X < (POINTS_X[j] - POINTS_X[i]) * (Y - POINTS_Y[i]) / (POINTS_Y[j] - POINTS_Y[i]) + POINTS_X[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static final boolean isInRingSegment(double MOUSE_X, double MOUSE_Y, double X, double Y, double WIDTH, double HEIGHT, double START_ANGLE, double SEGMENT_ANGLE, double LINE_WIDTH) {
        double centerX = X + WIDTH * 0.5;
        double centerY = Y + HEIGHT * 0.5;
        double size = WIDTH < HEIGHT ? WIDTH : HEIGHT;
        double outerRadius = (size + LINE_WIDTH) * 0.5;
        double innerRadius = (size - LINE_WIDTH) * 0.5;
        return Helper.isInRingSegment(MOUSE_X, MOUSE_Y, centerX, centerY, outerRadius, innerRadius, START_ANGLE, SEGMENT_ANGLE);
    }

    public static final boolean isInRingSegment(double X, double Y, double CENTER_X, double CENTER_Y, double OUTER_RADIUS, double INNER_RADIUS, double START_ANGLE, double SEGMENT_ANGLE) {
        double angleOffset = 90.0;
        double pointRadius = Math.sqrt((X - CENTER_X) * (X - CENTER_X) + (Y - CENTER_Y) * (Y - CENTER_Y));
        double pointAngle = Helper.getAngleFromXY(X, Y, CENTER_X, CENTER_Y, angleOffset);
        return Double.compare(pointRadius, INNER_RADIUS) >= 0 && Double.compare(pointRadius, OUTER_RADIUS) <= 0 && Double.compare(pointAngle, START_ANGLE) >= 0 && Double.compare(pointAngle, START_ANGLE + SEGMENT_ANGLE) <= 0;
    }

    public static final double getAngleFromXY(double X, double Y, double CENTER_X, double CENTER_Y) {
        return Helper.getAngleFromXY(X, Y, CENTER_X, CENTER_Y, 90.0);
    }

    public static final double getAngleFromXY(double X, double Y, double CENTER_X, double CENTER_Y, double ANGLE_OFFSET) {
        double nx;
        double deltaY = Y - CENTER_Y;
        double deltaX = X - CENTER_X;
        double radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double ny = deltaY / radius;
        double theta = Math.atan2(ny, nx = deltaX / radius);
        theta = Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
        double angle = (theta + ANGLE_OFFSET) % 360.0;
        return angle;
    }

    public static final void drawRoundedRect(GraphicsContext CTX, CtxBounds BOUNDS, CtxCornerRadii RADII) {
        double x = BOUNDS.getX();
        double y = BOUNDS.getY();
        double width = BOUNDS.getWidth();
        double height = BOUNDS.getHeight();
        double xPlusWidth = x + width;
        double yPlusHeight = y + height;
        CTX.beginPath();
        CTX.moveTo(x + RADII.getTopLeft(), y);
        CTX.lineTo(xPlusWidth - RADII.getTopRight(), y);
        CTX.quadraticCurveTo(xPlusWidth, y, xPlusWidth, y + RADII.getTopRight());
        CTX.lineTo(xPlusWidth, yPlusHeight - RADII.getBottomRight());
        CTX.quadraticCurveTo(xPlusWidth, yPlusHeight, xPlusWidth - RADII.getBottomRight(), yPlusHeight);
        CTX.lineTo(x + RADII.getBottomLeft(), yPlusHeight);
        CTX.quadraticCurveTo(x, yPlusHeight, x, yPlusHeight - RADII.getBottomLeft());
        CTX.lineTo(x, y + RADII.getTopLeft());
        CTX.quadraticCurveTo(x, y, x + RADII.getTopLeft(), y);
        CTX.closePath();
    }

    public static final Color getColorAt(LinearGradient GRADIENT, double FRACTION) {
        List stops = GRADIENT.getStops();
        double fraction = FRACTION < 0.0 ? 0.0 : (FRACTION > 1.0 ? 1.0 : FRACTION);
        Stop lowerStop = new Stop(0.0, ((Stop)stops.get(0)).getColor());
        Stop upperStop = new Stop(1.0, ((Stop)stops.get(stops.size() - 1)).getColor());
        for (Stop stop : stops) {
            double currentFraction = stop.getOffset();
            if (Double.compare(currentFraction, fraction) == 0) {
                return stop.getColor();
            }
            if (Double.compare(currentFraction, fraction) < 0) {
                lowerStop = new Stop(currentFraction, stop.getColor());
                continue;
            }
            upperStop = new Stop(currentFraction, stop.getColor());
            break;
        }
        double interpolationFraction = (fraction - lowerStop.getOffset()) / (upperStop.getOffset() - lowerStop.getOffset());
        return (Color)Interpolator.LINEAR.interpolate((Object)lowerStop.getColor(), (Object)upperStop.getColor(), interpolationFraction);
    }

    public static final String format(double NUMBER, int DECIMALS) {
        return Helper.format(NUMBER, Helper.clamp(0, 12, DECIMALS), Locale.US);
    }

    public static final String format(double NUMBER, int DECIMALS, Locale LOCALE) {
        String formatString = "%." + Helper.clamp(0, 12, DECIMALS) + "f";
        for (int i = ABBREVIATIONS.length - 1; i >= 0; --i) {
            double value = Math.pow(1000.0, i + 1);
            if (Double.compare(NUMBER, -value) > 0 && Double.compare(NUMBER, value) < 0) continue;
            return String.format(LOCALE, formatString, NUMBER / value) + ABBREVIATIONS[i];
        }
        return String.format(LOCALE, formatString, NUMBER);
    }

    public static final <T extends Point> boolean isInPolygon(double X, double Y, List<T> POLYGON) {
        int noOfPointsInPolygon = POLYGON.size();
        double[] pointsX = new double[noOfPointsInPolygon];
        double[] pointsY = new double[noOfPointsInPolygon];
        for (int i = 0; i < noOfPointsInPolygon; ++i) {
            pointsX[i] = ((Point)POLYGON.get(i)).getX();
            pointsY[i] = ((Point)POLYGON.get(i)).getY();
        }
        return Helper.isInPolygon(X, Y, noOfPointsInPolygon, pointsX, pointsY);
    }

    public static final double squareDistance(double X1, double Y1, double X2, double Y2) {
        double deltaX = X1 - X2;
        double deltaY = Y1 - Y2;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public static final double[] toHSL(Color COLOR) {
        return Helper.rgbToHSL(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue());
    }

    public static final double[] rgbToHSL(double RED, double GREEN, double BLUE) {
        double min = Math.min(RED, Math.min(GREEN, BLUE));
        double max = Math.max(RED, Math.max(GREEN, BLUE));
        double hue = 0.0;
        if (max == min) {
            hue = 0.0;
        } else if (max == RED) {
            hue = (60.0 * (GREEN - BLUE) / (max - min) + 360.0) % 360.0;
        } else if (max == GREEN) {
            hue = 60.0 * (BLUE - RED) / (max - min) + 120.0;
        } else if (max == BLUE) {
            hue = 60.0 * (RED - GREEN) / (max - min) + 240.0;
        }
        double luminance = (max + min) / 2.0;
        double saturation = 0.0;
        saturation = Double.compare(max, min) == 0 ? 0.0 : (luminance <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{hue, saturation, luminance};
    }

    public static final Color hslToRGB(double hue, double saturation, double luminance) {
        double g;
        double b;
        double r;
        if (Double.compare(saturation, 0.0) == 0) {
            r = 1.0;
            b = 1.0;
            g = 1.0;
        } else {
            double q = luminance < 0.5 ? luminance * (1.0 + saturation) : luminance + saturation - luminance * saturation;
            double p = 2.0 * luminance - q;
            r = Helper.clamp(0.0, 1.0, Helper.hue2RGB(p, q, hue + 0.33));
            g = Helper.clamp(0.0, 1.0, Helper.hue2RGB(p, q, hue));
            b = Helper.clamp(0.0, 1.0, Helper.hue2RGB(p, q, hue - 0.33));
        }
        return Color.color((double)r, (double)g, (double)b);
    }

    private static final double hue2RGB(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        } else if (t > 1.0) {
            t -= 1.0;
        }
        if (t >= 0.66) {
            return p;
        }
        if (t >= 0.5) {
            return p + (q - p) * (0.66 - t) * 6.0;
        }
        if (t >= 0.33) {
            return q;
        }
        return p + (q - p) * 6.0 * t;
    }

    public static final String colorToRGB(Color COLOR) {
        String hex = COLOR.toString().replace("0x", "");
        String hexRed = hex.substring(0, 2).toUpperCase();
        String hexGreen = hex.substring(2, 4).toUpperCase();
        String hexBlue = hex.substring(4, 6).toUpperCase();
        String intRed = Integer.toString(Integer.parseInt(hexRed, 16));
        String intGreen = Integer.toString(Integer.parseInt(hexGreen, 16));
        String intBlue = Integer.toString(Integer.parseInt(hexBlue, 16));
        return String.join((CharSequence)"", "colorToRGB(", intRed, ", ", intGreen, ", ", intBlue, ")");
    }

    public static final String colorToRGBA(Color COLOR) {
        return Helper.colorToRGBA(COLOR, COLOR.getOpacity());
    }

    public static final String colorToRGBA(Color COLOR, double ALPHA) {
        String hex = COLOR.toString().replace("0x", "");
        String hexRed = hex.substring(0, 2).toUpperCase();
        String hexGreen = hex.substring(2, 4).toUpperCase();
        String hexBlue = hex.substring(4, 6).toUpperCase();
        String intRed = Integer.toString(Integer.parseInt(hexRed, 16));
        String intGreen = Integer.toString(Integer.parseInt(hexGreen, 16));
        String intBlue = Integer.toString(Integer.parseInt(hexBlue, 16));
        String alpha = String.format(Locale.US, "%.3f", Helper.clamp(0.0, 1.0, ALPHA));
        return String.join((CharSequence)"", "colorToRGBA(", intRed, ", ", intGreen, ", ", intBlue, ",", alpha, ")");
    }

    public static final String colorToWeb(Color COLOR) {
        return COLOR.toString().replace("0x", "#").substring(0, 7);
    }

    public static final List<DataPoint> createSmoothedHull(List<DataPoint> POINTS, int SUB_DIVISIONS) {
        List<DataPoint> hullPolygon = Helper.createHull(POINTS);
        return Helper.subdivideDataPoints(hullPolygon, SUB_DIVISIONS);
    }

    public static final <T extends Point> List<T> createHull(List<T> POINTS) {
        ArrayList<Point> convexHull = new ArrayList<Point>();
        if (POINTS.size() < 3) {
            return new ArrayList<T>(POINTS);
        }
        int minDataPoint = -1;
        int maxDataPoint = -1;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int i = 0; i < POINTS.size(); ++i) {
            if (((Point)POINTS.get(i)).getX() < (double)minX) {
                minX = (int)((Point)POINTS.get(i)).getX();
                minDataPoint = i;
            }
            if (!(((Point)POINTS.get(i)).getX() > (double)maxX)) continue;
            maxX = (int)((Point)POINTS.get(i)).getX();
            maxDataPoint = i;
        }
        Point minPoint = (Point)POINTS.get(minDataPoint);
        Point maxPoint = (Point)POINTS.get(maxDataPoint);
        convexHull.add(minPoint);
        convexHull.add(maxPoint);
        POINTS.remove(minPoint);
        POINTS.remove(maxPoint);
        ArrayList<Point> leftSet = new ArrayList<Point>();
        ArrayList<Point> rightSet = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point p = (Point)POINTS.get(i);
            if (Helper.pointLocation(minPoint, maxPoint, p) == -1) {
                leftSet.add(p);
                continue;
            }
            if (Helper.pointLocation(minPoint, maxPoint, p) != 1) continue;
            rightSet.add(p);
        }
        Helper.hullSet(minPoint, maxPoint, rightSet, convexHull);
        Helper.hullSet(maxPoint, minPoint, leftSet, convexHull);
        return convexHull;
    }

    private static final <T extends Point> double distance(T P1, T P2, T P3) {
        double deltaX = P2.getX() - P1.getX();
        double deltaY = P2.getY() - P1.getY();
        double num = deltaX * (P1.getY() - P3.getY()) - deltaY * (P1.getX() - P3.getX());
        return Math.abs(num);
    }

    private static final <T extends Point> void hullSet(T P1, T P2, List<T> POINTS, List<T> HULL) {
        int insertPosition = HULL.indexOf(P2);
        if (POINTS.size() == 0) {
            return;
        }
        if (POINTS.size() == 1) {
            Point point = (Point)POINTS.get(0);
            POINTS.remove(point);
            HULL.add(insertPosition, point);
            return;
        }
        int dist = Integer.MIN_VALUE;
        int furthestDataPoint = -1;
        for (int i = 0; i < POINTS.size(); ++i) {
            Point point = (Point)POINTS.get(i);
            double distance = Helper.distance(P1, P2, point);
            if (!(distance > (double)dist)) continue;
            dist = (int)distance;
            furthestDataPoint = i;
        }
        Point point = (Point)POINTS.get(furthestDataPoint);
        POINTS.remove(furthestDataPoint);
        HULL.add(insertPosition, point);
        ArrayList<Point> leftSetAP = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point M = (Point)POINTS.get(i);
            if (Helper.pointLocation(P1, point, M) != 1) continue;
            leftSetAP.add(M);
        }
        ArrayList<Point> leftSetPB = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point M = (Point)POINTS.get(i);
            if (Helper.pointLocation(point, P2, M) != 1) continue;
            leftSetPB.add(M);
        }
        Helper.hullSet(P1, point, leftSetAP, HULL);
        Helper.hullSet(point, P2, leftSetPB, HULL);
    }

    private static final <T extends Point> int pointLocation(T P1, T P2, T P3) {
        double cp1 = (P2.getX() - P1.getX()) * (P3.getY() - P1.getY()) - (P2.getY() - P1.getY()) * (P3.getX() - P1.getX());
        return cp1 > 0.0 ? 1 : (Double.compare(cp1, 0.0) == 0 ? 0 : -1);
    }

    public static final Color interpolateColor(Color COLOR1, Color COLOR2, double FRACTION) {
        return Helper.interpolateColor(COLOR1, COLOR2, FRACTION, -1.0);
    }

    public static final Color getColorWithOpacityAt(LinearGradient GRADIENT, double FRACTION, double TARGET_OPACITY) {
        List stops = GRADIENT.getStops();
        double fraction = FRACTION < 0.0 ? 0.0 : (FRACTION > 1.0 ? 1.0 : FRACTION);
        Stop lowerStop = new Stop(0.0, ((Stop)stops.get(0)).getColor());
        Stop upperStop = new Stop(1.0, ((Stop)stops.get(stops.size() - 1)).getColor());
        for (Stop stop : stops) {
            double currentFraction = stop.getOffset();
            if (Double.compare(currentFraction, fraction) == 0) {
                return stop.getColor();
            }
            if (Double.compare(currentFraction, fraction) < 0) {
                lowerStop = new Stop(currentFraction, stop.getColor());
                continue;
            }
            upperStop = new Stop(currentFraction, stop.getColor());
            break;
        }
        double interpolationFraction = (fraction - lowerStop.getOffset()) / (upperStop.getOffset() - lowerStop.getOffset());
        return Helper.interpolateColor(lowerStop.getColor(), upperStop.getColor(), interpolationFraction, TARGET_OPACITY);
    }

    public static final Color interpolateColor(Color COLOR1, Color COLOR2, double FRACTION, double TARGET_OPACITY) {
        double fraction = Helper.clamp(0.0, 1.0, FRACTION);
        double targetOpacity = TARGET_OPACITY < 0.0 ? TARGET_OPACITY : Helper.clamp(0.0, 1.0, FRACTION);
        double RED1 = COLOR1.getRed();
        double GREEN1 = COLOR1.getGreen();
        double BLUE1 = COLOR1.getBlue();
        double OPACITY1 = COLOR1.getOpacity();
        double RED2 = COLOR2.getRed();
        double GREEN2 = COLOR2.getGreen();
        double BLUE2 = COLOR2.getBlue();
        double OPACITY2 = COLOR2.getOpacity();
        double DELTA_RED = RED2 - RED1;
        double DELTA_GREEN = GREEN2 - GREEN1;
        double DELTA_BLUE = BLUE2 - BLUE1;
        double DELTA_OPACITY = OPACITY2 - OPACITY1;
        double red = RED1 + DELTA_RED * fraction;
        double green = GREEN1 + DELTA_GREEN * fraction;
        double blue = BLUE1 + DELTA_BLUE * fraction;
        double opacity = targetOpacity < 0.0 ? OPACITY1 + DELTA_OPACITY * fraction : targetOpacity;
        red = Helper.clamp(0.0, 1.0, red);
        green = Helper.clamp(0.0, 1.0, green);
        blue = Helper.clamp(0.0, 1.0, blue);
        opacity = Helper.clamp(0.0, 1.0, opacity);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    public static final <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static final ZoneOffset getZoneOffset() {
        return Helper.getZoneOffset(ZoneId.systemDefault());
    }

    public static final ZoneOffset getZoneOffset(ZoneId ZONE_ID) {
        return ZONE_ID.getRules().getOffset(Instant.now());
    }

    public static final long toMillis(LocalDateTime DATE_TIME, ZoneOffset ZONE_OFFSET) {
        return Helper.toSeconds(DATE_TIME, ZONE_OFFSET) * 1000L;
    }

    public static final long toSeconds(LocalDateTime DATE_TIME, ZoneOffset ZONE_OFFSET) {
        return DATE_TIME.toEpochSecond(ZONE_OFFSET);
    }

    public static final double toNumericValue(LocalDateTime DATE) {
        return Helper.toNumericValue(DATE, ZoneId.systemDefault());
    }

    public static final double toNumericValue(LocalDateTime DATE, ZoneId ZONE_ID) {
        return Helper.toSeconds(DATE, Helper.getZoneOffset(ZONE_ID));
    }

    public static final LocalDateTime toRealValue(double VALUE) {
        return Helper.secondsToLocalDateTime((long)VALUE);
    }

    public static final LocalDateTime toRealValue(double VALUE, ZoneId ZONE_ID) {
        return Helper.secondsToLocalDateTime((long)VALUE, ZONE_ID);
    }

    public static final LocalDateTime secondsToLocalDateTime(long SECONDS) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(SECONDS), ZoneId.systemDefault());
    }

    public static final LocalDateTime secondsToLocalDateTime(long SECONDS, ZoneId ZONE_ID) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(SECONDS), ZONE_ID);
    }

    public static final String secondsToHHMMString(long SECONDS) {
        long[] hhmmss = Helper.secondsToHHMMSS(SECONDS);
        return String.format("%02d:%02d:%02d", hhmmss[0], hhmmss[1], hhmmss[2]);
    }

    public static final long[] secondsToHHMMSS(long SECONDS) {
        long seconds = SECONDS % 60L;
        long minutes = SECONDS / 60L % 60L;
        long hours = SECONDS / 3600L % 24L;
        return new long[]{hours, minutes, seconds};
    }

    public static final void enableNode(Node NODE, boolean ENABLE) {
        NODE.setVisible(ENABLE);
        NODE.setManaged(ENABLE);
    }

    public static final void orderChartItems(List<ChartItem> ITEMS, Order ORDER) {
        if (Order.ASCENDING == ORDER) {
            Collections.sort(ITEMS, Comparator.comparingDouble(ChartItem::getValue));
        } else {
            Collections.sort(ITEMS, Comparator.comparingDouble(ChartItem::getValue).reversed());
        }
    }

    public static final void orderXYChartItemsByX(List<XYChartItem> ITEMS, Order ORDER) {
        if (Order.ASCENDING == ORDER) {
            Collections.sort(ITEMS, Comparator.comparingDouble(XYChartItem::getX));
        } else {
            Collections.sort(ITEMS, Comparator.comparingDouble(XYChartItem::getX).reversed());
        }
    }

    public static final CtxDimension getTextDimension(String TEXT, Font FONT) {
        Text text = new Text(TEXT);
        text.setFont(FONT);
        double textWidth = text.getBoundsInLocal().getWidth();
        double textHeight = text.getBoundsInLocal().getHeight();
        text = null;
        CtxDimension dim = new CtxDimension(textWidth, textHeight);
        return dim;
    }

    public static final void drawTextWithBackground(GraphicsContext CTX, String TEXT, Font FONT, Color TEXT_BACKGROUND, Color TEXT_FILL, double X, double Y) {
        CtxDimension dim = Helper.getTextDimension(TEXT, FONT);
        double textWidth = dim.getWidth() * 1.2;
        double textHeight = dim.getHeight();
        CTX.save();
        CTX.setFont(FONT);
        CTX.setTextBaseline(VPos.CENTER);
        CTX.setTextAlign(TextAlignment.CENTER);
        CTX.setFill((Paint)TEXT_BACKGROUND);
        CTX.fillRect(X - textWidth * 0.5, Y - textHeight * 0.5, textWidth, textHeight);
        CTX.setFill((Paint)TEXT_FILL);
        CTX.fillText(TEXT, X, Y);
        CTX.restore();
    }

    public static enum Interval {
        DECADE(ChronoUnit.DECADES, 1, 311040000L, 155520000L, 31104000L),
        YEAR(ChronoUnit.YEARS, 1, 31104000L, 15552000L, 2592000L),
        MONTH_6(ChronoUnit.MONTHS, 6, 15552000L, 2592000L, 2592000L),
        MONTH_3(ChronoUnit.MONTHS, 3, 7776000L, 2592000L, 864000L),
        MONTH_1(ChronoUnit.MONTHS, 1, 2592000L, 864000L, 86400L),
        DAY(ChronoUnit.DAYS, 1, 86400L, 43200L, 3600L),
        HOUR_12(ChronoUnit.HOURS, 12, 43200L, 3600L, 1800L),
        HOUR_6(ChronoUnit.HOURS, 6, 21600L, 3600L, 900L),
        HOUR_3(ChronoUnit.HOURS, 3, 10800L, 3600L, 300L),
        HOUR_1(ChronoUnit.HOURS, 1, 3600L, 900L, 300L),
        MINUTE_15(ChronoUnit.MINUTES, 15, 900L, 300L, 60L),
        MINUTE_5(ChronoUnit.MINUTES, 5, 300L, 60L, 10L),
        MINUTE_1(ChronoUnit.MINUTES, 1, 60L, 5L, 1L),
        SECOND_15(ChronoUnit.SECONDS, 15, 15L, 5L, 1L),
        SECOND_5(ChronoUnit.SECONDS, 5, 5L, 1L, 1L),
        SECOND_1(ChronoUnit.SECONDS, 1, 1L, 1L, 1L);

        private final ChronoUnit INTERVAL;
        private final int AMOUNT;
        private final long MAJOR_TICK_SPACE;
        private final long MEDIUM_TICK_SPACE;
        private final long MINOR_TICK_SPACE;

        private Interval(ChronoUnit INTERVAL, int AMOUNT, long MAJOR_TICK_SPACE, long MEDIUM_TICK_SPACE, long MINOR_TICK_SPACE) {
            this.INTERVAL = INTERVAL;
            this.AMOUNT = AMOUNT;
            this.MAJOR_TICK_SPACE = MAJOR_TICK_SPACE;
            this.MEDIUM_TICK_SPACE = MEDIUM_TICK_SPACE;
            this.MINOR_TICK_SPACE = MINOR_TICK_SPACE;
        }

        public ChronoUnit getInterval() {
            return this.INTERVAL;
        }

        public int getAmount() {
            return this.AMOUNT;
        }

        public long getMajorTickSpace() {
            return this.MAJOR_TICK_SPACE;
        }

        public long getMediumTickSpace() {
            return this.MEDIUM_TICK_SPACE;
        }

        public long getMinorTickSpace() {
            return this.MINOR_TICK_SPACE;
        }
    }
}

