/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

public class CtxDimension {
    private double minX;
    private double oldMinX;
    private double minY;
    private double oldMinY;
    private double maxX;
    private double oldMaxX;
    private double maxY;
    private double oldMaxY;
    private double width;
    private double oldWidth;
    private double height;
    private double oldHeight;

    public CtxDimension() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public CtxDimension(double WIDTH, double HEIGHT) {
        this(0.0, 0.0, WIDTH, HEIGHT);
    }

    public CtxDimension(double MIN_X, double MIN_Y, double MAX_X, double MAX_Y) {
        this.minX = MIN_X;
        this.oldMinX = MIN_X;
        this.minY = MIN_Y;
        this.oldMinY = MIN_Y;
        this.maxX = MAX_X;
        this.oldMaxX = MAX_X;
        this.maxY = MAX_Y;
        this.oldMaxY = MAX_Y;
        this.oldWidth = this.width = MAX_X - MIN_X;
        this.oldHeight = this.height = MAX_Y - MIN_Y;
    }

    public double getOldMinX() {
        return this.oldMinX;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double X) {
        this.oldWidth = this.width;
        this.oldMinX = this.minX;
        this.minX = X;
        this.width = this.maxX - this.minX;
    }

    public double getOldMaxX() {
        return this.oldMaxX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double X) {
        this.oldWidth = this.width;
        this.oldMaxX = this.maxX;
        this.maxX = X;
        this.width = this.maxX - this.minX;
    }

    public double getOldMinY() {
        return this.oldMinY;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double Y) {
        this.oldHeight = this.height;
        this.oldMinY = this.minY;
        this.minY = Y;
        this.height = this.maxY - this.minY;
    }

    public double getOldMaxY() {
        return this.oldMaxY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double Y) {
        this.oldHeight = this.height;
        this.oldMaxY = this.maxY;
        this.maxY = Y;
        this.height = this.maxY - this.minY;
    }

    public void shiftX(double SHIFT_X) {
        this.setMinX(this.minX + SHIFT_X);
        this.setMaxX(this.maxX + SHIFT_X);
    }

    public void shiftY(double SHIFT_Y) {
        this.setMinY(this.minY + SHIFT_Y);
        this.setMaxY(this.maxY + SHIFT_Y);
    }

    public double getOldWidth() {
        return this.oldWidth;
    }

    public double getWidth() {
        return this.width;
    }

    public double getOldHeight() {
        return this.oldHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public double getCenterX() {
        return this.minX + this.getWidth() * 0.5;
    }

    public double getCenterY() {
        return this.minY + this.getHeight() * 0.5;
    }

    public void set(CtxDimension DIM) {
        this.setMinX(DIM.getMinX());
        this.setMinY(DIM.getMinY());
        this.setMaxX(DIM.getMaxX());
        this.setMaxY(DIM.getMaxY());
    }

    public void set(double MIN_X, double MIN_Y, double MAX_X, double MAX_Y) {
        this.setMinX(MIN_X);
        this.setMinY(MIN_Y);
        this.setMaxX(MAX_X);
        this.setMaxY(MAX_Y);
    }

    public boolean contains(double X, double Y) {
        return Double.compare(X, this.getMinX()) >= 0 && Double.compare(X, this.getMaxX()) <= 0 && Double.compare(Y, this.getMinY()) >= 0 && Double.compare(Y, this.getMaxY()) <= 0;
    }

    public String toString() {
        return "{\n" + "  \"minX\"  : " + this.getMinX() + ",\n" + "  \"minY\"  : " + this.getMinY() + ",\n" + "  \"maxX\"  : " + this.getMaxX() + ",\n" + "  \"maxY\"  : " + this.getMaxY() + ",\n" + "  \"width\" : " + this.getWidth() + ",\n" + "  \"height\": " + this.getHeight() + "\n" + "}";
    }
}

