/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.XYZItem;
import eu.hansolo.fx.charts.series.Series;
import java.util.Comparator;
import java.util.List;
import javafx.collections.ObservableList;

public class XYZSeries<T extends XYZItem>
extends Series {
    public XYZSeries() {
        this(null, ChartType.BUBBLE, "");
    }

    public XYZSeries(List<T> ITEMS, ChartType TYPE) {
        this(ITEMS, TYPE, "");
    }

    public XYZSeries(List<T> ITEMS, ChartType TYPE, String NAME) {
        super(ITEMS, TYPE, NAME);
    }

    public XYZSeries(List<T> ITEMS, ChartType TYPE, String NAME, Symbol SYMBOL) {
        super(ITEMS, TYPE, NAME, SYMBOL);
    }

    @Override
    public ObservableList<T> getItems() {
        return this.items;
    }

    public double getMinX() {
        return this.getItems().stream().min(Comparator.comparingDouble(XYZItem::getX)).get().getX();
    }

    public double getMaxX() {
        return this.getItems().stream().max(Comparator.comparingDouble(XYZItem::getX)).get().getX();
    }

    public double getMinY() {
        return this.getItems().stream().min(Comparator.comparingDouble(XYZItem::getY)).get().getY();
    }

    public double getMaxY() {
        return this.getItems().stream().max(Comparator.comparingDouble(XYZItem::getY)).get().getY();
    }

    public double getMinZ() {
        return this.getItems().stream().min(Comparator.comparingDouble(XYZItem::getZ)).get().getZ();
    }

    public double getMaxZ() {
        return this.getItems().stream().max(Comparator.comparingDouble(XYZItem::getZ)).get().getZ();
    }

    public double getRangeX() {
        return this.getMaxX() - this.getMinX();
    }

    public double getRangeY() {
        return this.getMaxY() - this.getMinY();
    }

    public double getRangeZ() {
        return this.getMaxZ() - this.getMinZ();
    }

    public double getSumOfXValues() {
        return this.getItems().stream().mapToDouble(XYZItem::getX).sum();
    }

    public double getSumOfYValues() {
        return this.getItems().stream().mapToDouble(XYZItem::getY).sum();
    }

    public double getSumOfZValues() {
        return this.getItems().stream().mapToDouble(XYZItem::getZ).sum();
    }
}

