/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.heatmap;

import eu.hansolo.fx.charts.heatmap.HeatMap;
import eu.hansolo.fx.charts.heatmap.OpacityDistribution;
import eu.hansolo.fx.charts.tools.ColorMapping;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class HeatMapBuilder<B extends HeatMapBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected HeatMapBuilder() {
    }

    public static final HeatMapBuilder create() {
        return new HeatMapBuilder();
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        return this.prefSize(new Dimension2D(WIDTH, HEIGHT));
    }

    public final B prefSize(Dimension2D PREF_SIZE) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)PREF_SIZE));
        return (B)this;
    }

    public final B width(double WIDTH) {
        this.properties.put("width", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B height(double HEIGHT) {
        this.properties.put("height", (Property)new SimpleDoubleProperty(HEIGHT));
        return (B)this;
    }

    public final B colorMapping(ColorMapping COLOR_MAPPING) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)COLOR_MAPPING));
        return (B)this;
    }

    public final B spotRadius(double SPOT_RADIUS) {
        this.properties.put("spotRadius", (Property)new SimpleDoubleProperty(SPOT_RADIUS));
        return (B)this;
    }

    public final B fadeColors(boolean FADE_COLORS) {
        this.properties.put("fadeColors", (Property)new SimpleBooleanProperty(FADE_COLORS));
        return (B)this;
    }

    public final B heatMapOpacity(double HEAT_MAP_OPACITY) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(HEAT_MAP_OPACITY));
        return (B)this;
    }

    public final B opacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.properties.put("opacityDistribution", (Property)new SimpleObjectProperty((Object)OPACITY_DISTRIBUTION));
        return (B)this;
    }

    public final HeatMap build() {
        double width = 400.0;
        double height = 400.0;
        ColorMapping colorMapping = ColorMapping.LIME_YELLOW_RED;
        double spotRadius = 15.5;
        boolean fadeColors = false;
        double heatMapOpacity = 0.5;
        OpacityDistribution opacityDistribution = OpacityDistribution.CUSTOM;
        for (String key : this.properties.keySet()) {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                width = dim.getWidth();
                height = dim.getHeight();
                continue;
            }
            if ("width".equals(key)) {
                width = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("height".equals(key)) {
                height = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("colorMapping".equals(key)) {
                colorMapping = (ColorMapping)((Object)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("spotRadius".equals(key)) {
                spotRadius = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("fadeColors".equals(key)) {
                fadeColors = ((BooleanProperty)this.properties.get(key)).get();
                continue;
            }
            if ("heatMapOpacity".equals(key)) {
                heatMapOpacity = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if (!"opacityDistribution".equals(key)) continue;
            opacityDistribution = (OpacityDistribution)((Object)((ObjectProperty)this.properties.get(key)).get());
        }
        return new HeatMap(width, height, colorMapping, spotRadius, fadeColors, heatMapOpacity, opacityDistribution);
    }
}

