/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ChartArea;
import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYZItem;
import eu.hansolo.fx.charts.series.XYZSeries;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class XYZPane<T extends XYZItem>
extends Region
implements ChartArea {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 0.0;
    private static final double MINIMUM_HEIGHT = 0.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static double aspectRatio;
    private boolean keepAspect;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private List<XYZSeries<T>> listOfSeries;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double scaleX;
    private double scaleY;
    private double scaleZ;
    private double _lowerBoundX;
    private DoubleProperty lowerBoundX;
    private double _upperBoundX;
    private DoubleProperty upperBoundX;
    private double _lowerBoundY;
    private DoubleProperty lowerBoundY;
    private double _upperBoundY;
    private DoubleProperty upperBoundY;
    private double _lowerBoundZ;
    private DoubleProperty lowerBoundZ;
    private double _upperBoundZ;
    private DoubleProperty upperBoundZ;

    public XYZPane(XYZSeries<T> ... SERIES) {
        this((Paint)Color.TRANSPARENT, SERIES);
    }

    public XYZPane(Paint BACKGROUND, XYZSeries<T> ... SERIES) {
        this.getStylesheets().add((Object)XYPane.class.getResource("chart.css").toExternalForm());
        aspectRatio = 1.0;
        this.keepAspect = false;
        this._chartBackground = BACKGROUND;
        this.listOfSeries = FXCollections.observableArrayList((Object[])SERIES);
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.scaleZ = 1.0;
        this._lowerBoundX = 0.0;
        this._upperBoundX = 100.0;
        this._lowerBoundY = 0.0;
        this._upperBoundY = 100.0;
        this._lowerBoundZ = 0.0;
        this._upperBoundZ = 100.0;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().setAll((Object[])new String[]{"chart", "xyz-chart"});
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.listOfSeries.forEach(series -> series.setOnSeriesEvent(seriesEvent -> this.redraw()));
    }

    protected double computeMinWidth(double HEIGHT) {
        return 0.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 0.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    @Override
    public void setChartBackground(Paint PAINT) {
        if (null == this.chartBackground) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public double getLowerBoundX() {
        return null == this.lowerBoundX ? this._lowerBoundX : this.lowerBoundX.get();
    }

    public void setLowerBoundX(double VALUE) {
        if (null == this.lowerBoundX) {
            this._lowerBoundX = VALUE;
            this.redraw();
        } else {
            this.lowerBoundX.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundXProperty() {
        if (null == this.lowerBoundX) {
            this.lowerBoundX = new DoublePropertyBase(this._lowerBoundX){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "lowerBoundX";
                }
            };
        }
        return this.lowerBoundX;
    }

    public double getUpperBoundX() {
        return null == this.upperBoundX ? this._upperBoundX : this.upperBoundX.get();
    }

    public void setUpperBoundX(double VALUE) {
        if (null == this.upperBoundX) {
            this._upperBoundX = VALUE;
            this.redraw();
        } else {
            this.upperBoundX.set(VALUE);
        }
    }

    public DoubleProperty upperBoundXProperty() {
        if (null == this.upperBoundX) {
            this.upperBoundX = new DoublePropertyBase(this._upperBoundX){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "upperBoundX";
                }
            };
        }
        return this.upperBoundX;
    }

    public double getLowerBoundY() {
        return null == this.lowerBoundY ? this._lowerBoundY : this.lowerBoundY.get();
    }

    public void setLowerBoundY(double VALUE) {
        if (null == this.lowerBoundY) {
            this._lowerBoundY = VALUE;
            this.redraw();
        } else {
            this.lowerBoundY.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundYProperty() {
        if (null == this.lowerBoundY) {
            this.lowerBoundY = new DoublePropertyBase(this._lowerBoundY){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "lowerBoundY";
                }
            };
        }
        return this.lowerBoundY;
    }

    public double getUpperBoundY() {
        return null == this.upperBoundY ? this._upperBoundY : this.upperBoundY.get();
    }

    public void setUpperBoundY(double VALUE) {
        if (null == this.upperBoundY) {
            this._upperBoundY = VALUE;
            this.redraw();
        } else {
            this.upperBoundY.set(VALUE);
        }
    }

    public DoubleProperty upperBoundYProperty() {
        if (null == this.upperBoundY) {
            this.upperBoundY = new DoublePropertyBase(this._upperBoundY){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "upperBoundY";
                }
            };
        }
        return this.upperBoundY;
    }

    public double getLowerBoundZ() {
        return null == this.lowerBoundZ ? this._lowerBoundZ : this.lowerBoundZ.get();
    }

    public void setLowerBoundZ(double VALUE) {
        if (null == this.lowerBoundZ) {
            this._lowerBoundZ = VALUE;
            this.redraw();
        } else {
            this.lowerBoundZ.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundZProperty() {
        if (null == this.lowerBoundZ) {
            this.lowerBoundZ = new DoublePropertyBase(this._lowerBoundZ){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "lowerBoundZ";
                }
            };
        }
        return this.lowerBoundZ;
    }

    public double getUpperBoundZ() {
        return null == this.upperBoundZ ? this._upperBoundZ : this.upperBoundZ.get();
    }

    public void setUpperBoundZ(double VALUE) {
        if (null == this.upperBoundZ) {
            this._upperBoundZ = VALUE;
            this.redraw();
        } else {
            this.upperBoundZ.set(VALUE);
        }
    }

    public DoubleProperty upperBoundZProperty() {
        if (null == this.upperBoundZ) {
            this.upperBoundZ = new DoublePropertyBase(this._upperBoundZ){

                protected void invalidated() {
                    XYZPane.this.redraw();
                }

                public Object getBean() {
                    return XYZPane.this;
                }

                public String getName() {
                    return "upperBoundZ";
                }
            };
        }
        return this.upperBoundZ;
    }

    public double getRangeX() {
        return this.getUpperBoundX() - this.getLowerBoundX();
    }

    public double getRangeY() {
        return this.getUpperBoundY() - this.getLowerBoundY();
    }

    public double getRangeZ() {
        return this.getUpperBoundZ() - this.getLowerBoundZ();
    }

    public double getDataMinX() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMinX).min().getAsDouble();
    }

    public double getDataMaxX() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMaxX).max().getAsDouble();
    }

    public double getDataMinY() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMinY).min().getAsDouble();
    }

    public double getDataMaxY() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMaxY).max().getAsDouble();
    }

    public double getDataMinZ() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMinZ).min().getAsDouble();
    }

    public double getDataMaxZ() {
        return this.listOfSeries.stream().mapToDouble(XYZSeries::getMaxZ).max().getAsDouble();
    }

    public double getDataRangeX() {
        return this.getDataMaxX() - this.getDataMinX();
    }

    public double getDataRangeY() {
        return this.getDataMaxY() - this.getDataMinY();
    }

    public double getDataRangeZ() {
        return this.getDataMaxZ() - this.getDataMinZ();
    }

    public List<XYZSeries<T>> getListOfSeries() {
        return this.listOfSeries;
    }

    private void drawChart() {
        if (null == this.listOfSeries || this.listOfSeries.isEmpty()) {
            return;
        }
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        this.listOfSeries.forEach(series -> {
            ChartType TYPE = series.getChartType();
            switch (TYPE) {
                case BUBBLE: {
                    this.drawBubble((XYZSeries<T>)series);
                }
            }
        });
    }

    private void drawBubble(XYZSeries<T> SERIES) {
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        double LOWER_BOUND_Z = this.getLowerBoundZ();
        Paint seriesFill = SERIES.getFill();
        Paint seriesStroke = SERIES.getStroke();
        for (XYZItem item : SERIES.getItems()) {
            double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            double diameter = (item.getZ() - LOWER_BOUND_Z) * this.scaleZ;
            double radius = diameter * 0.5;
            Symbol itemSymbol = item.getSymbol();
            if (Symbol.NONE == itemSymbol) {
                this.ctx.setFill(seriesFill);
                this.ctx.setStroke(seriesStroke);
            } else {
                this.ctx.setFill((Paint)item.getFill());
                this.ctx.setStroke((Paint)item.getStroke());
            }
            this.ctx.fillOval(x - radius, this.height - y - radius, diameter, diameter);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.keepAspect) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.scaleX = this.width / this.getRangeX();
            this.scaleY = this.height / this.getRangeY();
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

