/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Grid;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYItem;
import java.util.Arrays;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;

@DefaultProperty(value="children")
public class XYChart<T extends XYItem>
extends Region {
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double width;
    private double height;
    private XYPane<T> xyPane;
    private List<Axis> axis;
    private Axis yAxisL;
    private Axis yAxisC;
    private Axis yAxisR;
    private Axis xAxisT;
    private Axis xAxisC;
    private Axis xAxisB;
    private double topAxisHeight;
    private double rightAxisWidth;
    private double bottomAxisHeight;
    private double leftAxisWidth;
    private Grid grid;
    private boolean hasLeftYAxis;
    private boolean hasCenterYAxis;
    private boolean hasRightYAxis;
    private boolean hasTopXAxis;
    private boolean hasCenterXAxis;
    private boolean hasBottomXAxis;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private AnchorPane pane;

    public XYChart(XYPane<T> XY_PANE, Axis ... AXIS) {
        this(XY_PANE, (Grid)null, AXIS);
    }

    public XYChart(XYPane<T> XY_PANE, Grid GRID, Axis ... AXIS) {
        if (null == XY_PANE) {
            throw new IllegalArgumentException("XYPane has not to be null");
        }
        if (XY_PANE.containsPolarChart()) {
            throw new IllegalArgumentException("XYPane contains Polar chart type");
        }
        this.xyPane = XY_PANE;
        this.axis = Arrays.asList(AXIS);
        this.grid = GRID;
        this.width = 400.0;
        this.height = 250.0;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 250.0);
            }
        }
        this.checkForAxis();
        this.adjustChartRange();
        this.adjustAxisAnchors();
        this.pane = new AnchorPane(new Node[]{this.xyPane});
        this.pane.getChildren().addAll(this.axis);
        this.setGrid(this.grid);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
            this.xyPane.redraw();
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    XYChart.this.xyPane.redraw();
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return null == this.subTitle ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUB_TITLE) {
        if (null == this.subTitle) {
            this._subTitle = SUB_TITLE;
            this.xyPane.redraw();
        } else {
            this.subTitle.set((Object)SUB_TITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (null == this.subTitle) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    XYChart.this.xyPane.redraw();
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public boolean isReferenceZero() {
        return this.xyPane.isReferenceZero();
    }

    public void setReferenceZero(boolean IS_ZERO) {
        this.xyPane.setReferenceZero(IS_ZERO);
    }

    public void setGrid(Grid GRID) {
        if (null == GRID) {
            return;
        }
        if (null != this.grid) {
            this.pane.getChildren().remove((Object)this.grid);
        }
        this.grid = GRID;
        this.pane.getChildren().add(0, (Object)this.grid);
        this.adjustGridAnchors();
    }

    public XYPane<T> getXYPane() {
        return this.xyPane;
    }

    public void refresh() {
        this.xyPane.redraw();
    }

    private void checkForAxis() {
        this.axis.forEach(axis -> {
            Position position = axis.getPosition();
            block0 : switch (axis.getOrientation()) {
                case HORIZONTAL: {
                    switch (position) {
                        case TOP: {
                            this.hasTopXAxis = true;
                            this.topAxisHeight = axis.getPrefHeight();
                            this.xAxisT = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterXAxis = true;
                            this.xAxisC = axis;
                            break block0;
                        }
                        case BOTTOM: {
                            this.hasBottomXAxis = true;
                            this.bottomAxisHeight = axis.getPrefHeight();
                            this.xAxisB = axis;
                            break block0;
                        }
                    }
                    this.hasTopXAxis = false;
                    this.hasCenterXAxis = false;
                    this.hasBottomXAxis = false;
                    break;
                }
                case VERTICAL: {
                    switch (position) {
                        case LEFT: {
                            this.hasLeftYAxis = true;
                            this.leftAxisWidth = axis.getPrefWidth();
                            this.yAxisL = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterYAxis = true;
                            this.yAxisC = axis;
                            break block0;
                        }
                        case RIGHT: {
                            this.hasRightYAxis = true;
                            this.rightAxisWidth = axis.getPrefWidth();
                            this.yAxisR = axis;
                            break block0;
                        }
                    }
                    this.hasLeftYAxis = false;
                    this.hasCenterYAxis = false;
                    this.hasRightYAxis = false;
                }
            }
        });
    }

    private void adjustChartRange() {
        if (this.hasBottomXAxis) {
            this.xyPane.setLowerBoundX(this.xAxisB.getMinValue());
            this.xyPane.setUpperBoundX(this.xAxisB.getMaxValue());
        } else if (this.hasTopXAxis) {
            this.xyPane.setLowerBoundX(this.xAxisT.getMinValue());
            this.xyPane.setUpperBoundX(this.xAxisT.getMaxValue());
        }
        if (this.hasLeftYAxis) {
            this.xyPane.setLowerBoundY(this.yAxisL.getMinValue());
            this.xyPane.setUpperBoundY(this.yAxisL.getMaxValue());
        } else if (this.hasRightYAxis) {
            this.xyPane.setLowerBoundY(this.yAxisR.getMinValue());
            this.xyPane.setUpperBoundY(this.yAxisR.getMaxValue());
        }
    }

    private void adjustAxisAnchors() {
        this.axis.forEach(axis -> {
            if (Orientation.HORIZONTAL == axis.getOrientation()) {
                AnchorPane.setLeftAnchor((Node)axis, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor((Node)axis, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
                AnchorPane.setLeftAnchor(this.xyPane, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor(this.xyPane, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
            } else {
                AnchorPane.setTopAnchor((Node)axis, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor((Node)axis, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
                AnchorPane.setTopAnchor(this.xyPane, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor(this.xyPane, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
            }
        });
        if (this.hasCenterYAxis) {
            AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.yAxisC.getZeroPosition());
        }
        if (this.hasCenterXAxis) {
            AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.xAxisC.getZeroPosition());
        }
    }

    private void adjustGridAnchors() {
        if (null == this.grid) {
            return;
        }
        AnchorPane.setLeftAnchor((Node)this.grid, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
        AnchorPane.setRightAnchor((Node)this.grid, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
        AnchorPane.setTopAnchor((Node)this.grid, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
        AnchorPane.setBottomAnchor((Node)this.grid, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
        }
    }
}

