/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ParallelCoordinatesChart;
import eu.hansolo.fx.charts.data.DataObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class ParallelCoordinatesChartBuilder<B extends ParallelCoordinatesChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ParallelCoordinatesChartBuilder() {
    }

    public static final ParallelCoordinatesChartBuilder create() {
        return new ParallelCoordinatesChartBuilder();
    }

    public final B items(DataObject ... ITEMS) {
        this.properties.put("itemArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<DataObject> ITEMS) {
        this.properties.put("itemList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B axisColor(Color COLOR) {
        this.properties.put("axisColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B headerColor(Color COLOR) {
        this.properties.put("headerColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B unitColor(Color COLOR) {
        this.properties.put("unitColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickMarksVisible(boolean VISIBLE) {
        this.properties.put("tickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B selectedColor(Color COLOR) {
        this.properties.put("selectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B unselectedColor(Color COLOR) {
        this.properties.put("unselectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectionRectColor(Color COLOR) {
        this.properties.put("selectionRectColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final ParallelCoordinatesChart build() {
        ParallelCoordinatesChart CONTROL = new ParallelCoordinatesChart();
        if (this.properties.keySet().contains("itemArray")) {
            CONTROL.setItems((DataObject[])((ObjectProperty)this.properties.get("itemArray")).get());
        }
        if (this.properties.keySet().contains("itemList")) {
            CONTROL.setItems((List)((ObjectProperty)this.properties.get("itemList")).get());
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("axisColor".equals(key)) {
                CONTROL.setAxisColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("headerColor".equals(key)) {
                CONTROL.setHeaderColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unitColor".equals(key)) {
                CONTROL.setUnitColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelColor".equals(key)) {
                CONTROL.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("locale".equals(key)) {
                CONTROL.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarksVisible".equals(key)) {
                CONTROL.setTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selectedColor".equals(key)) {
                CONTROL.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unselectedColor".equals(key)) {
                CONTROL.setUnselectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"selectionRectColor".equals(key)) continue;
            CONTROL.setSelectionRectColor((Color)((ObjectProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

