/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.event.SelectionEvent;
import eu.hansolo.fx.charts.event.SelectionEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class CoxcombChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size = 250.0;
    private double width = 250.0;
    private double height = 250.0;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ObservableList<ChartItem> items;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private boolean _autoTextColor;
    private BooleanProperty autoTextColor;
    private Order _order;
    private ObjectProperty<Order> order;
    private boolean _equalSegmentAngles;
    private BooleanProperty equalSegmentAngles;
    private ItemEventListener itemListener;
    private ListChangeListener<ChartItem> itemListListener;
    private EventHandler<MouseEvent> mouseHandler;
    private CopyOnWriteArrayList<SelectionEventListener> listeners;
    private InfoPopup popup;

    public CoxcombChart() {
        this(new ArrayList<ChartItem>());
    }

    public CoxcombChart(ChartItem ... ITEMS) {
        this(Arrays.asList(ITEMS));
    }

    public CoxcombChart(List<ChartItem> ITEMS) {
        this.items = FXCollections.observableArrayList(ITEMS);
        this._textColor = Color.WHITE;
        this._autoTextColor = true;
        this._order = Order.DESCENDING;
        this._equalSegmentAngles = false;
        this.itemListener = e -> this.reorder(this.getOrder());
        this.itemListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                    this.reorder(this.getOrder());
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
                this.reorder(this.getOrder());
            }
            this.redraw();
        };
        this.mouseHandler = e -> this.handleMouseEvent((MouseEvent)e);
        this.listeners = new CopyOnWriteArrayList();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"coxcomb-chart");
        this.popup = new InfoPopup();
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.forEach(item -> item.setOnItemEvent(this.itemListener));
        this.items.addListener(this.itemListListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.setOnSelectionEvent(e -> {
            this.popup.update(e);
            this.popup.animatedShow(this.getScene().getWindow());
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.forEach(item -> item.removeItemEventListener(this.itemListener));
        this.items.removeListener(this.itemListListener);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    public List<ChartItem> getItems() {
        return this.items;
    }

    public void setItems(ChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<ChartItem> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(ChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void addItems(ChartItem ... ITEMS) {
        this.addItems(Arrays.asList(ITEMS));
    }

    public void addItems(List<ChartItem> ITEMS) {
        ITEMS.forEach(item -> this.addItem((ChartItem)item));
    }

    public void removeItem(ChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public void removeItems(ChartItem ... ITEMS) {
        this.removeItems(Arrays.asList(ITEMS));
    }

    public void removeItems(List<ChartItem> ITEMS) {
        ITEMS.forEach(item -> this.removeItem((ChartItem)item));
    }

    public void sortItemsAscending() {
        Collections.sort(this.items, Comparator.comparingDouble(ChartItem::getValue));
    }

    public void sortItemsDescending() {
        Collections.sort(this.items, Comparator.comparingDouble(ChartItem::getValue).reversed());
    }

    public double sumOfAllItems() {
        return this.items.stream().mapToDouble(ChartItem::getValue).sum();
    }

    public double getMinValue() {
        return this.items.stream().mapToDouble(ChartItem::getValue).min().getAsDouble();
    }

    public double getMaxValue() {
        return this.items.stream().mapToDouble(ChartItem::getValue).max().getAsDouble();
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    CoxcombChart.this.redraw();
                }

                public Object getBean() {
                    return CoxcombChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public Order getOrder() {
        return null == this.order ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order ORDER) {
        if (null == this.order) {
            this._order = ORDER;
            this.reorder(this._order);
        } else {
            this.order.set((Object)ORDER);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (null == this.order) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    CoxcombChart.this.reorder((Order)((Object)this.get()));
                }

                public Object getBean() {
                    return CoxcombChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    public boolean isAutoTextColor() {
        return null == this.autoTextColor ? this._autoTextColor : this.autoTextColor.get();
    }

    public void setAutoTextColor(boolean AUTO) {
        if (null == this.autoTextColor) {
            this._autoTextColor = AUTO;
            this.redraw();
        } else {
            this.autoTextColor.set(AUTO);
        }
    }

    public BooleanProperty autoTextColorProperty() {
        if (null == this.autoTextColor) {
            this.autoTextColor = new BooleanPropertyBase(this._autoTextColor){

                protected void invalidated() {
                    CoxcombChart.this.redraw();
                }

                public Object getBean() {
                    return CoxcombChart.this;
                }

                public String getName() {
                    return "autoTextColor";
                }
            };
        }
        return this.autoTextColor;
    }

    public boolean getEqualSegmentAngles() {
        return null == this.equalSegmentAngles ? this._equalSegmentAngles : this.equalSegmentAngles.get();
    }

    public void setEqualSegmentAngles(boolean SET) {
        if (null == this.equalSegmentAngles) {
            this._equalSegmentAngles = SET;
            this.redraw();
        } else {
            this.equalSegmentAngles.set(SET);
        }
    }

    public BooleanProperty equalSegmentAnglesProperty() {
        if (null == this.equalSegmentAngles) {
            this.equalSegmentAngles = new BooleanPropertyBase(this._equalSegmentAngles){

                protected void invalidated() {
                    CoxcombChart.this.redraw();
                }

                public Object getBean() {
                    return CoxcombChart.this;
                }

                public String getName() {
                    return "equalSegmentAngles";
                }
            };
        }
        return this.equalSegmentAngles;
    }

    public void handleMouseEvent(MouseEvent EVT) {
        double X = EVT.getX();
        double Y = EVT.getY();
        this.popup.setX(EVT.getScreenX());
        this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
        int noOfChartItems = this.items.size();
        boolean equalsAngles = this.getEqualSegmentAngles();
        double barWidth = this.size * 0.04;
        double minValue = this.getMinValue();
        double maxValue = this.getMaxValue();
        double valueRange = maxValue - minValue;
        double sum = this.sumOfAllItems();
        double stepSize = equalsAngles ? 360.0 / (double)noOfChartItems : 360.0 / sum;
        double angle = equalsAngles ? stepSize : 0.0;
        double startAngle = 0.0;
        double baseXY = this.size * 0.345;
        double baseWH = this.size * 0.31;
        double xy = this.size * 0.32;
        double minWH = this.size * 0.36;
        double maxWH = this.size * 0.64;
        double whRange = maxWH - minWH;
        double wh = minWH;
        double whStep = equalsAngles ? whRange / valueRange : whRange / (double)noOfChartItems;
        for (int i = 0; i < noOfChartItems; ++i) {
            ChartItem item = (ChartItem)this.items.get(i);
            if (equalsAngles) {
                barWidth = item.getValue() * whStep;
                xy = baseXY - barWidth * 0.5;
                wh = baseWH + barWidth;
                startAngle += angle;
            } else {
                angle = item.getValue() * stepSize;
                startAngle += angle;
                xy -= whStep / 2.0;
                wh += whStep;
                barWidth += whStep;
            }
            if (!Helper.isInRingSegment(X, Y, xy, xy, wh, wh, Math.abs(360.0 - startAngle), angle, barWidth)) continue;
            this.fireSelectionEvent(new SelectionEvent<ChartItem>(item));
            break;
        }
    }

    private void reorder(Order ORDER) {
        if (ORDER == Order.ASCENDING) {
            this.sortItemsAscending();
        } else {
            this.sortItemsDescending();
        }
    }

    public void setOnSelectionEvent(SelectionEventListener LISTENER) {
        this.addSelectionEventListener(LISTENER);
    }

    public void addSelectionEventListener(SelectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSelectionEventListener(SelectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllSelectionEventListeners() {
        this.listeners.clear();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        for (SelectionEventListener listener : this.listeners) {
            listener.onSelectionEvent(EVENT);
        }
    }

    private void drawChart() {
        Order order = this.getOrder();
        int noOfChartItems = this.items.size();
        boolean equalAngles = this.getEqualSegmentAngles();
        double center = this.size * 0.5;
        double barWidth = this.size * 0.04;
        double minValue = this.getMinValue();
        double maxValue = this.getMaxValue();
        double valueRange = maxValue - minValue;
        double sum = this.sumOfAllItems();
        double stepSize = equalAngles ? 360.0 / (double)noOfChartItems : 360.0 / sum;
        double angle = 0.0;
        double startAngle = 90.0;
        double baseXY = this.size * 0.345;
        double baseWH = this.size * 0.31;
        double xy = this.size * 0.32;
        double minWH = this.size * 0.36;
        double maxWH = this.size * 0.64;
        double whRange = maxWH - minWH;
        double wh = minWH;
        double whStep = equalAngles ? whRange / valueRange : whRange / (double)noOfChartItems;
        Color textColor = this.getTextColor();
        boolean isAutoColor = this.isAutoTextColor();
        DropShadow shadow = new DropShadow(BlurType.GAUSSIAN, Color.rgb((int)0, (int)0, (int)0, (double)0.75), this.size * 0.02, 0.0, 0.0, 0.0);
        double spread = this.size * 0.005;
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        this.ctx.setFont(Font.font((double)(this.size * 0.03)));
        for (int i = 0; i < noOfChartItems; ++i) {
            double nextBarWidth;
            ChartItem nextItem;
            ChartItem item = (ChartItem)this.items.get(i);
            double value = item.getValue();
            startAngle += angle;
            if (equalAngles) {
                barWidth = value * whStep;
                xy = baseXY - barWidth * 0.5;
                wh = baseWH + barWidth;
                angle = stepSize;
            } else {
                xy -= whStep / 2.0;
                wh += whStep;
                barWidth += whStep;
                angle = value * stepSize;
            }
            double endAngle = startAngle + angle;
            double radius = wh * 0.5;
            double clippingRadius = radius + barWidth * 0.5;
            this.ctx.save();
            this.ctx.setLineWidth(barWidth);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(xy, xy, wh, wh, startAngle, angle, ArcType.OPEN);
            this.ctx.save();
            this.ctx.beginPath();
            if (equalAngles && Order.DESCENDING == order && i < noOfChartItems - 1) {
                nextItem = (ChartItem)this.items.get(i + 1);
                nextBarWidth = nextItem.getValue() * whStep;
                double nextWH = baseWH + nextBarWidth;
                double nextRadius = nextWH * 0.5;
                clippingRadius = nextRadius + nextBarWidth * 0.5;
            }
            this.ctx.arc(center, center, clippingRadius, clippingRadius, 0.0, 360.0);
            this.ctx.clip();
            if (i != noOfChartItems - 1 && angle > 2.0) {
                double x = Math.cos(Math.toRadians(endAngle - 5.0));
                double y = -Math.sin(Math.toRadians(endAngle - 5.0));
                shadow.setOffsetX(x * spread);
                shadow.setOffsetY(y * spread);
                if (equalAngles && Order.DESCENDING == order && i < noOfChartItems - 1) {
                    nextItem = (ChartItem)this.items.get(i + 1);
                    nextBarWidth = nextItem.getValue() * whStep;
                    double nextXY = baseXY - nextBarWidth * 0.5;
                    double nextWH = baseWH + nextBarWidth;
                    this.ctx.save();
                    this.ctx.setLineWidth(nextBarWidth);
                    this.ctx.setEffect((Effect)shadow);
                    this.ctx.strokeArc(nextXY, nextXY, nextWH, nextWH, endAngle, 2.0, ArcType.OPEN);
                    this.ctx.restore();
                    if (i == 0) {
                        x = Math.cos(Math.toRadians(startAngle + 5.0));
                        y = -Math.sin(Math.toRadians(startAngle + 5.0));
                        shadow.setOffsetX(x * spread);
                        shadow.setOffsetY(y * spread);
                        this.ctx.setEffect((Effect)shadow);
                        nextBarWidth = minValue * whStep;
                        nextXY = baseXY - nextBarWidth * 0.5;
                        nextWH = baseWH + nextBarWidth;
                        this.ctx.setLineWidth(nextBarWidth);
                        this.ctx.strokeArc(nextXY, nextXY, nextWH, nextWH, startAngle, -2.0, ArcType.OPEN);
                    }
                } else {
                    this.ctx.save();
                    this.ctx.setEffect((Effect)shadow);
                    this.ctx.strokeArc(xy, xy, wh, wh, endAngle, 2.0, ArcType.OPEN);
                    this.ctx.restore();
                    if (i == 0) {
                        x = Math.cos(Math.toRadians(startAngle + 5.0));
                        y = -Math.sin(Math.toRadians(startAngle + 5.0));
                        shadow.setOffsetX(x * spread);
                        shadow.setOffsetY(y * spread);
                        this.ctx.setEffect((Effect)shadow);
                        this.ctx.strokeArc(xy, xy, wh, wh, startAngle, -2.0, ArcType.OPEN);
                    }
                }
            }
            this.ctx.restore();
            this.ctx.restore();
            if (!(angle > 12.0) || !(barWidth > 10.0)) continue;
            double tx = center + radius * Math.cos(Math.toRadians(endAngle - angle * 0.5));
            double ty = center - radius * Math.sin(Math.toRadians(endAngle - angle * 0.5));
            if (isAutoColor) {
                this.ctx.setFill((Paint)(Helper.isDark(item.getFill()) ? Color.WHITE : Color.BLACK));
            } else {
                this.ctx.setFill((Paint)textColor);
            }
            this.ctx.fillText(String.format(Locale.US, "%.0f%%", value / sum * 100.0), tx, ty, barWidth);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

