/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.editor.ChoiceMatch;

class HistoryListModel
extends AbstractListModel {
    private static final long serialVersionUID = -374115548677017807L;
    private List<Object> history = new ArrayList<Object>();
    private List<Object> shownHistory = this.history;
    private Object lastAdded;
    private Comparator stringComparator;
    private int maxHistory;

    HistoryListModel() {
    }

    public void initialize(List<Object> history) {
        this.lastAdded = null;
        this.shownHistory = history;
        this.history.clear();
        if (!history.isEmpty()) {
            this.history.addAll(history.subList(0, Math.min(this.maxHistory, history.size())));
        }
    }

    public List<Object> getShownHistory() {
        return new ArrayList<Object>(this.shownHistory);
    }

    public void setStringContent(Comparator<String> stringComparator) {
        if (this.stringComparator != stringComparator) {
            this.stringComparator = stringComparator;
            this.clear();
        }
    }

    public int clearRestrictions() {
        this.shownHistory = this.history;
        return this.shownHistory.size();
    }

    public boolean restrict(Object exclude) {
        int index = this.shownHistory.indexOf(exclude);
        if (index != -1) {
            if (this.shownHistory == this.history) {
                this.shownHistory = new ArrayList<Object>(this.history);
            }
            this.shownHistory.remove(index);
            this.fireIntervalAdded(this, index, index);
            return true;
        }
        return false;
    }

    @Override
    public Object getElementAt(int index) {
        return this.shownHistory.get(index);
    }

    public boolean add(Object st) {
        boolean ret = false;
        boolean removed = this.history.remove(st);
        if (this.maxHistory > 0 && this.lastAdded != null && this.lastAdded.toString().length() > 0 && !this.lastAdded.equals(st)) {
            this.history.add(0, this.lastAdded);
            int size = this.history.size();
            if (size > this.maxHistory) {
                this.history.remove(--size);
                removed = true;
            } else {
                ret = true;
                if (!removed) {
                    this.fireIntervalAdded(this, 0, 0);
                }
            }
        }
        if (removed) {
            this.fireContentsChanged(this, 0, this.history.size());
            ret = true;
        }
        this.lastAdded = st;
        this.shownHistory = this.history;
        return ret;
    }

    public boolean isEmpty() {
        return this.shownHistory.isEmpty();
    }

    public void clear() {
        int size = this.history.size();
        if (size > 0) {
            this.history.clear();
            this.shownHistory = this.history;
            this.fireIntervalRemoved(this, 0, size);
        }
        this.lastAdded = null;
    }

    @Override
    public int getSize() {
        return this.shownHistory.size();
    }

    public void setMaxHistory(int size) {
        this.maxHistory = size;
        int current = this.history.size();
        if (current > size) {
            for (int i = current - 1; i >= size; --i) {
                this.history.remove(i);
            }
            this.shownHistory = this.history;
            this.fireContentsChanged(this, this.maxHistory, current);
        }
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public List getList() {
        return this.history;
    }

    public ChoiceMatch getClosestMatch(Object hint) {
        ChoiceMatch ret = new ChoiceMatch();
        if (this.stringComparator != null && hint instanceof String) {
            String strStart = (String)hint;
            int strLen = strStart.length();
            int historyLen = this.shownHistory.size();
            while (historyLen-- > 0) {
                Object content = this.shownHistory.get(historyLen);
                String str = content.toString();
                int len = ChoiceMatch.getMatchingLength(strStart, str, this.stringComparator);
                if ((len <= 0 || len < ret.len) && ret.len != 0) continue;
                ret.content = content;
                ret.index = historyLen;
                ret.len = len;
                if (len != strLen || str.length() != strLen) continue;
                ret.exact = true;
                return ret;
            }
        } else {
            ret.index = this.shownHistory.indexOf(hint);
            if (ret.index != -1) {
                ret.exact = true;
                ret.content = hint;
            }
        }
        return ret;
    }
}

