/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.text.TextFlow;
import org.controlsfx.control.HyperlinkLabel;

public class HyperlinkLabelSkin
extends SkinBase<HyperlinkLabel> {
    private static final String HYPERLINK_START = "[";
    private static final String HYPERLINK_END = "]";
    private final TextFlow textFlow;
    private final EventHandler<ActionEvent> eventHandler = event -> {
        EventHandler<ActionEvent> onActionHandler = ((HyperlinkLabel)this.getSkinnable()).getOnAction();
        if (onActionHandler != null) {
            onActionHandler.handle(event);
        }
    };

    public HyperlinkLabelSkin(HyperlinkLabel control) {
        super((Control)control);
        this.textFlow = new TextFlow();
        this.getChildren().add((Object)this.textFlow);
        this.updateText();
        this.updateFocusTraversable(((HyperlinkLabel)this.getSkinnable()).isFocusTraversable());
        this.registerChangeListener((ObservableValue)control.focusedProperty(), e -> {
            if (((HyperlinkLabel)this.getSkinnable()).isFocused()) {
                this.textFlow.getChildren().stream().filter(Node::isFocusTraversable).findFirst().ifPresent(Node::requestFocus);
            }
        });
        this.registerChangeListener((ObservableValue)control.focusTraversableProperty(), e -> this.updateFocusTraversable(((HyperlinkLabel)this.getSkinnable()).isFocusTraversable()));
        this.registerChangeListener((ObservableValue)control.textProperty(), e -> this.updateText());
    }

    private void updateFocusTraversable(Boolean nv) {
        this.textFlow.getChildren().stream().filter(node -> node instanceof Hyperlink).forEach(node -> node.setFocusTraversable(nv.booleanValue()));
    }

    private void updateText() {
        String text = ((HyperlinkLabel)this.getSkinnable()).getText();
        if (text == null || text.isEmpty()) {
            this.textFlow.getChildren().clear();
            return;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        int start = 0;
        int textLength = text.length();
        while (start != -1 && start < textLength) {
            Label label;
            int startPos = text.indexOf(HYPERLINK_START, start);
            int endPos = text.indexOf(HYPERLINK_END, startPos);
            if ((startPos == -1 || endPos == -1) && textLength > start) {
                label = new Label(text.substring(start));
                nodes.add(label);
                break;
            }
            label = new Label(text.substring(start, startPos));
            nodes.add(label);
            Hyperlink hyperlink = new Hyperlink(text.substring(startPos + 1, endPos));
            hyperlink.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            hyperlink.setOnAction(this.eventHandler);
            nodes.add(hyperlink);
            start = endPos + 1;
        }
        this.textFlow.getChildren().setAll(nodes);
    }
}

