/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mpg;

import java.util.List;
import net.sourceforge.lame.mp3.FrameSkip;
import net.sourceforge.lame.mp3.MP3Data;
import net.sourceforge.lame.mp3.PlottingData;
import net.sourceforge.lame.mpg.Common;
import net.sourceforge.lame.mpg.Frame;
import net.sourceforge.lame.mpg.Interface;

public class MPGLib {
    public static final int MP3_ERR = -1;
    public static final int MP3_OK = 0;
    static final int MP3_NEED_MORE = 1;
    private static final int[][] smpls = new int[][]{{0, 384, 1152, 1152}, {0, 384, 1152, 576}};
    private static final int OUTSIZE_CLIPPED = 4096;
    private static final int OUTSIZE_UNCLIPPED = 2304;
    Interface interf;

    public void setModules(Interface i) {
        this.interf = i;
    }

    protected void COPY_MONO(float[] pcm_l, int pcm_lPos, int processed_samples, float[] p) {
        int p_samples = 0;
        for (int i = 0; i < processed_samples; ++i) {
            pcm_l[pcm_lPos++] = p[p_samples++];
        }
    }

    protected void COPY_STEREO(float[] pcm_l, int pcm_lPos, float[] pcm_r, int pcm_rPos, int processed_samples, float[] p) {
        int p_samples = 0;
        for (int i = 0; i < processed_samples; ++i) {
            pcm_l[pcm_lPos++] = p[p_samples++];
            pcm_r[pcm_rPos++] = p[p_samples++];
        }
    }

    private int decode1_headersB_clipchoice(mpstr_tag pmp, byte[] buffer, int bufferPos, int len, float[] pcm_l, int pcm_lPos, float[] pcm_r, int pcm_rPos, MP3Data mp3data, FrameSkip enc, float[] p, int psize, IDecoder decodeMP3_ptr) {
        mp3data.header_parsed = false;
        ProcessedBytes pb = new ProcessedBytes();
        int ret = decodeMP3_ptr.decode(pmp, buffer, bufferPos, len, p, psize, pb);
        int processed_samples = pb.pb;
        if (pmp.header_parsed || pmp.fsizeold > 0 || pmp.framesize > 0) {
            mp3data.header_parsed = true;
            mp3data.stereo = pmp.fr.stereo;
            mp3data.samplerate = Common.freqs[pmp.fr.sampling_frequency];
            mp3data.mode = pmp.fr.mode;
            mp3data.mode_ext = pmp.fr.mode_ext;
            mp3data.setFrameSize(smpls[pmp.fr.lsf][pmp.fr.lay]);
            mp3data.bitrate = pmp.fsizeold > 0 ? (int)((double)(8 * (4 + pmp.fsizeold) * mp3data.samplerate) / (1000.0 * (double)mp3data.getFrameSize()) + 0.5) : (pmp.framesize > 0 ? (int)((double)(8 * (4 + pmp.framesize) * mp3data.samplerate) / (1000.0 * (double)mp3data.getFrameSize()) + 0.5) : Common.tabsel_123[pmp.fr.lsf][pmp.fr.lay - 1][pmp.fr.bitrate_index]);
            if (pmp.num_frames > 0) {
                mp3data.setTotalFrames(pmp.num_frames);
                mp3data.setNumSamples(mp3data.getFrameSize() * pmp.num_frames);
                enc.setEncoderDelay(pmp.enc_delay);
                enc.setEncoderPadding(pmp.enc_padding);
            }
        }
        block0 : switch (ret) {
            case 0: {
                switch (pmp.fr.stereo) {
                    case 1: {
                        this.COPY_MONO(pcm_l, pcm_lPos, processed_samples, p);
                        break block0;
                    }
                    case 2: {
                        this.COPY_STEREO(pcm_l, pcm_lPos, pcm_r, pcm_rPos, processed_samples >>= 1, p);
                        break block0;
                    }
                }
                processed_samples = -1;
                assert (false);
                break;
            }
            case 1: {
                processed_samples = 0;
                break;
            }
            case -1: {
                processed_samples = -1;
                break;
            }
            default: {
                processed_samples = -1;
                assert (false);
                break;
            }
        }
        return processed_samples;
    }

    public mpstr_tag hip_decode_init() {
        return this.interf.InitMP3();
    }

    public int hip_decode_exit(mpstr_tag hip) {
        if (hip != null) {
            this.interf.ExitMP3(hip);
            hip = null;
        }
        return 0;
    }

    public int hip_decode1_unclipped(mpstr_tag hip, byte[] buffer, int bufferPos, int len, float[] pcm_l, float[] pcm_r) {
        MP3Data mp3data = new MP3Data();
        FrameSkip enc = new FrameSkip();
        if (hip != null) {
            IDecoder dec = new IDecoder(){

                @Override
                public int decode(mpstr_tag mp, byte[] in, int bufferPos, int isize, float[] out, int osize, ProcessedBytes done) {
                    return MPGLib.this.interf.decodeMP3_unclipped(mp, in, bufferPos, isize, out, osize, done);
                }
            };
            float[] out = new float[2304];
            return this.decode1_headersB_clipchoice(hip, buffer, bufferPos, len, pcm_l, 0, pcm_r, 0, mp3data, enc, out, 2304, dec);
        }
        return 0;
    }

    public int hip_decode1_headers(mpstr_tag hip, byte[] buffer, int len, float[] pcm_l, float[] pcm_r, MP3Data mp3data, FrameSkip enc) {
        if (hip != null) {
            IDecoder dec = new IDecoder(){

                @Override
                public int decode(mpstr_tag mp, byte[] in, int bufferPos, int isize, float[] out, int osize, ProcessedBytes done) {
                    return MPGLib.this.interf.decodeMP3(mp, in, bufferPos, isize, out, osize, done);
                }
            };
            float[] out = new float[4096];
            return this.decode1_headersB_clipchoice(hip, buffer, 0, len, pcm_l, 0, pcm_r, 0, mp3data, enc, out, 4096, dec);
        }
        return -1;
    }

    void hip_set_pinfo(mpstr_tag hip, PlottingData pinfo) {
        if (hip != null) {
            hip.pinfo = pinfo;
        }
    }

    static class ProcessedBytes {
        int pb;

        ProcessedBytes() {
        }
    }

    public static class mpstr_tag {
        List<buf> list;
        boolean vbr_header;
        int num_frames;
        int enc_delay;
        int enc_padding;
        boolean header_parsed;
        boolean side_parsed;
        boolean data_parsed;
        boolean free_format;
        boolean old_free_format;
        int bsize;
        int framesize;
        int ssize;
        int dsize;
        int fsizeold;
        int fsizeold_nopadding;
        Frame fr = new Frame();
        byte[][] bsspace = new byte[2][3904];
        float[][][] hybrid_block = new float[2][2][576];
        int[] hybrid_blc = new int[2];
        long header;
        int bsnum;
        float[][][] synth_buffs = new float[2][2][272];
        int synth_bo;
        boolean sync_bitstream;
        int bitindex;
        byte[] wordpointer;
        int wordpointerPos;
        PlottingData pinfo;
    }

    public static class buf {
        byte[] pnt;
        int size;
        int pos;
    }

    static interface IDecoder {
        public int decode(mpstr_tag var1, byte[] var2, int var3, int var4, float[] var5, int var6, ProcessedBytes var7);
    }
}

