/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import java.util.Arrays;
import net.sourceforge.lame.mp3.CalcNoiseData;
import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.IIISideInfo;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.QuantizePVT;
import net.sourceforge.lame.mp3.Tables;

public class Takehiro {
    public static final int[] slen1_tab = new int[]{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
    public static final int[] slen2_tab = new int[]{0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3};
    private static final int[] huf_tbl_noESC = new int[]{1, 2, 5, 7, 7, 10, 10, 13, 13, 13, 13, 13, 13, 13, 13};
    private static final int[] slen1_n = new int[]{1, 1, 1, 1, 8, 2, 2, 2, 4, 4, 4, 8, 8, 8, 16, 16};
    private static final int[] slen2_n = new int[]{1, 2, 4, 8, 1, 2, 4, 8, 2, 4, 8, 2, 4, 8, 4, 8};
    private static final int[] scale_short = new int[]{0, 18, 36, 54, 54, 36, 54, 72, 54, 72, 90, 72, 90, 108, 108, 126};
    private static final int[] scale_mixed = new int[]{0, 18, 36, 54, 51, 35, 53, 71, 52, 70, 88, 69, 87, 105, 104, 122};
    private static final int[] scale_long = new int[]{0, 10, 20, 30, 33, 21, 31, 41, 32, 42, 52, 43, 53, 63, 64, 74};
    private static final int[][] max_range_sfac_tab = new int[][]{{15, 15, 7, 7}, {15, 15, 7, 0}, {7, 3, 0, 0}, {15, 31, 31, 0}, {7, 7, 7, 0}, {3, 3, 0, 0}};
    private static final int[] log2tab = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};
    QuantizePVT qupvt;
    private int[][] subdv_table = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {1, 2}, {2, 2}, {2, 3}, {2, 3}, {3, 4}, {3, 4}, {3, 4}, {4, 5}, {4, 5}, {4, 6}, {5, 6}, {5, 6}, {5, 7}, {6, 7}, {6, 7}};

    public final void setModules(QuantizePVT qupvt) {
        this.qupvt = qupvt;
    }

    private void quantize_lines_xrpow_01(int l, float istep, float[] xr, int xrPos, int[] ix, int ixPos) {
        float compareval0 = 0.59459996f / istep;
        assert (l > 0);
        l >>= 1;
        while (l-- != 0) {
            ix[ixPos++] = compareval0 > xr[xrPos++] ? 0 : 1;
            ix[ixPos++] = compareval0 > xr[xrPos++] ? 0 : 1;
        }
    }

    private void quantize_lines_xrpow(int l, float istep, float[] xr, int xrPos, int[] ix, int ixPos) {
        float x1;
        float x0;
        assert (l > 0);
        int remaining = (l >>= 1) % 2;
        l >>= 1;
        while (l-- != 0) {
            x0 = xr[xrPos++] * istep;
            x1 = xr[xrPos++] * istep;
            int rx0 = (int)x0;
            float x2 = xr[xrPos++] * istep;
            int rx1 = (int)x1;
            float x3 = xr[xrPos++] * istep;
            int rx2 = (int)x2;
            int rx3 = (int)x3;
            ix[ixPos++] = (int)(x0 += this.qupvt.adj43[rx0]);
            ix[ixPos++] = (int)(x1 += this.qupvt.adj43[rx1]);
            ix[ixPos++] = (int)(x2 += this.qupvt.adj43[rx2]);
            ix[ixPos++] = (int)(x3 += this.qupvt.adj43[rx3]);
        }
        if (remaining != 0) {
            x0 = xr[xrPos++] * istep;
            x1 = xr[xrPos++] * istep;
            int rx0 = (int)x0;
            int rx1 = (int)x1;
            ix[ixPos++] = (int)(x0 += this.qupvt.adj43[rx0]);
            ix[ixPos++] = (int)(x1 += this.qupvt.adj43[rx1]);
        }
    }

    private void quantize_xrpow(float[] xp, int[] pi, float istep, GrInfo codInfo, CalcNoiseData prevNoise) {
        int j = 0;
        int accumulate = 0;
        int accumulate01 = 0;
        int xpPos = 0;
        int[] iData = pi;
        int iDataPos = 0;
        int[] acc_iData = iData;
        int acc_iDataPos = 0;
        float[] acc_xp = xp;
        int acc_xpPos = 0;
        boolean prev_data_use = prevNoise != null && codInfo.global_gain == prevNoise.global_gain;
        int sfbmax = codInfo.block_type == 2 ? 38 : 21;
        for (int sfb = 0; sfb <= sfbmax; ++sfb) {
            int step = -1;
            if (prev_data_use || codInfo.block_type == 0) {
                step = codInfo.global_gain - (codInfo.scalefac[sfb] + (codInfo.preflag != 0 ? this.qupvt.pretab[sfb] : 0) << codInfo.scalefac_scale + 1) - codInfo.subblock_gain[codInfo.window[sfb]] * 8;
            }
            assert (codInfo.width[sfb] >= 0);
            if (prev_data_use && prevNoise.step[sfb] == step) {
                if (accumulate != 0) {
                    this.quantize_lines_xrpow(accumulate, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                    accumulate = 0;
                }
                if (accumulate01 != 0) {
                    this.quantize_lines_xrpow_01(accumulate01, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                    accumulate01 = 0;
                }
            } else {
                int l = codInfo.width[sfb];
                if (j + codInfo.width[sfb] > codInfo.max_nonzero_coeff) {
                    int usefullsize = codInfo.max_nonzero_coeff - j + 1;
                    Arrays.fill(pi, codInfo.max_nonzero_coeff, 576, 0);
                    l = usefullsize;
                    if (l < 0) {
                        l = 0;
                    }
                    sfb = sfbmax + 1;
                }
                if (0 == accumulate && 0 == accumulate01) {
                    acc_iData = iData;
                    acc_iDataPos = iDataPos;
                    acc_xp = xp;
                    acc_xpPos = xpPos;
                }
                if (prevNoise != null && prevNoise.sfb_count1 > 0 && sfb >= prevNoise.sfb_count1 && prevNoise.step[sfb] > 0 && step >= prevNoise.step[sfb]) {
                    if (accumulate != 0) {
                        this.quantize_lines_xrpow(accumulate, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                        accumulate = 0;
                        acc_iData = iData;
                        acc_iDataPos = iDataPos;
                        acc_xp = xp;
                        acc_xpPos = xpPos;
                    }
                    accumulate01 += l;
                } else {
                    if (accumulate01 != 0) {
                        this.quantize_lines_xrpow_01(accumulate01, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                        accumulate01 = 0;
                        acc_iData = iData;
                        acc_iDataPos = iDataPos;
                        acc_xp = xp;
                        acc_xpPos = xpPos;
                    }
                    accumulate += l;
                }
                if (l <= 0) {
                    if (accumulate01 != 0) {
                        this.quantize_lines_xrpow_01(accumulate01, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                        accumulate01 = 0;
                    }
                    if (accumulate == 0) break;
                    this.quantize_lines_xrpow(accumulate, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
                    accumulate = 0;
                    break;
                }
            }
            if (sfb > sfbmax) continue;
            iDataPos += codInfo.width[sfb];
            xpPos += codInfo.width[sfb];
            j += codInfo.width[sfb];
        }
        if (accumulate != 0) {
            this.quantize_lines_xrpow(accumulate, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
            accumulate = 0;
        }
        if (accumulate01 != 0) {
            this.quantize_lines_xrpow_01(accumulate01, istep, acc_xp, acc_xpPos, acc_iData, acc_iDataPos);
            accumulate01 = 0;
        }
    }

    private int ix_max(int[] ix, int ixPos, int endPos) {
        int max1 = 0;
        int max2 = 0;
        do {
            int x1 = ix[ixPos++];
            int x2 = ix[ixPos++];
            if (max1 < x1) {
                max1 = x1;
            }
            if (max2 >= x2) continue;
            max2 = x2;
        } while (ixPos < endPos);
        if (max1 < max2) {
            max1 = max2;
        }
        return max1;
    }

    private int count_bit_ESC(int[] ix, int ixPos, int end, int t1, int t2, Bits s) {
        int sum2;
        int linbits = Tables.ht[t1].xlen * 65536 + Tables.ht[t2].xlen;
        int sum = 0;
        do {
            int x = ix[ixPos++];
            int y = ix[ixPos++];
            if (x != 0) {
                if (x > 14) {
                    x = 15;
                    sum += linbits;
                }
                x *= 16;
            }
            if (y != 0) {
                if (y > 14) {
                    y = 15;
                    sum += linbits;
                }
                x += y;
            }
            sum += Tables.largetbl[x];
        } while (ixPos < end);
        if ((sum >>= 16) > (sum2 = sum & 0xFFFF)) {
            sum = sum2;
            t1 = t2;
        }
        s.bits += sum;
        return t1;
    }

    private int count_bit_noESC(int[] ix, int ixPos, int end, Bits s) {
        int sum1 = 0;
        int[] hlen1 = Tables.ht[1].hlen;
        do {
            int x = ix[ixPos + 0] * 2 + ix[ixPos + 1];
            sum1 += hlen1[x];
        } while ((ixPos += 2) < end);
        s.bits += sum1;
        return 1;
    }

    private int count_bit_noESC_from2(int[] ix, int ixPos, int end, int t1, Bits s) {
        int sum2;
        int sum = 0;
        int xlen = Tables.ht[t1].xlen;
        int[] hlen = t1 == 2 ? Tables.table23 : Tables.table56;
        do {
            int x = ix[ixPos + 0] * xlen + ix[ixPos + 1];
            sum += hlen[x];
        } while ((ixPos += 2) < end);
        if ((sum >>= 16) > (sum2 = sum & 0xFFFF)) {
            sum = sum2;
            ++t1;
        }
        s.bits += sum;
        return t1;
    }

    private int count_bit_noESC_from3(int[] ix, int ixPos, int end, int t1, Bits s) {
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        int xlen = Tables.ht[t1].xlen;
        int[] hlen1 = Tables.ht[t1].hlen;
        int[] hlen2 = Tables.ht[t1 + 1].hlen;
        int[] hlen3 = Tables.ht[t1 + 2].hlen;
        do {
            int x = ix[ixPos + 0] * xlen + ix[ixPos + 1];
            sum1 += hlen1[x];
            sum2 += hlen2[x];
            sum3 += hlen3[x];
        } while ((ixPos += 2) < end);
        int t = t1;
        if (sum1 > sum2) {
            sum1 = sum2;
            ++t;
        }
        if (sum1 > sum3) {
            sum1 = sum3;
            t = t1 + 2;
        }
        s.bits += sum1;
        return t;
    }

    private int choose_table(int[] ix, int ixPos, int endPos, Bits s) {
        int choice;
        int choice2;
        int max = this.ix_max(ix, ixPos, endPos);
        switch (max) {
            case 0: {
                return max;
            }
            case 1: {
                return this.count_bit_noESC(ix, ixPos, endPos, s);
            }
            case 2: 
            case 3: {
                return this.count_bit_noESC_from2(ix, ixPos, endPos, huf_tbl_noESC[max - 1], s);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.count_bit_noESC_from3(ix, ixPos, endPos, huf_tbl_noESC[max - 1], s);
            }
        }
        if (max > 8206) {
            s.bits = 100000;
            return -1;
        }
        max -= 15;
        for (choice2 = 24; choice2 < 32 && Tables.ht[choice2].linmax < max; ++choice2) {
        }
        for (choice = choice2 - 8; choice < 24 && Tables.ht[choice].linmax < max; ++choice) {
        }
        return this.count_bit_ESC(ix, ixPos, endPos, choice, choice2, s);
    }

    public int noquant_count_bits(LameInternalFlags gfc, GrInfo gi, CalcNoiseData prev_noise) {
        Bits bi;
        int[] ix = gi.l3_enc;
        int i = Math.min(576, gi.max_nonzero_coeff + 2 >> 1 << 1);
        if (prev_noise != null) {
            prev_noise.sfb_count1 = 0;
        }
        while (i > 1 && (ix[i - 1] | ix[i - 2]) == 0) {
            i -= 2;
        }
        gi.count1 = i;
        int a1 = 0;
        int a2 = 0;
        while (i > 3 && (((long)ix[i - 1] | (long)ix[i - 2] | (long)ix[i - 3] | (long)ix[i - 4]) & 0xFFFFFFFFL) <= 1L) {
            int p = ((ix[i - 4] * 2 + ix[i - 3]) * 2 + ix[i - 2]) * 2 + ix[i - 1];
            a1 += Tables.t32l[p];
            a2 += Tables.t33l[p];
            i -= 4;
        }
        int bits = a1;
        gi.count1table_select = 0;
        if (a1 > a2) {
            bits = a2;
            gi.count1table_select = 1;
        }
        gi.count1bits = bits;
        gi.big_values = i;
        if (i == 0) {
            return bits;
        }
        if (gi.block_type == 2) {
            a1 = 3 * gfc.scalefac_band.s[3];
            if (a1 > gi.big_values) {
                a1 = gi.big_values;
            }
            a2 = gi.big_values;
        } else if (gi.block_type == 0) {
            assert (i <= 576);
            a1 = gi.region0_count = gfc.bv_scf[i - 2];
            a2 = gi.region1_count = gfc.bv_scf[i - 1];
            assert (a1 + a2 + 2 < 21);
            a2 = gfc.scalefac_band.l[a1 + a2 + 2];
            a1 = gfc.scalefac_band.l[a1 + 1];
            if (a2 < i) {
                bi = new Bits(bits);
                gi.table_select[2] = this.choose_table(ix, a2, i, bi);
                bits = bi.bits;
            }
        } else {
            gi.region0_count = 7;
            gi.region1_count = 13;
            a1 = gfc.scalefac_band.l[8];
            a2 = i;
            if (a1 > a2) {
                a1 = a2;
            }
        }
        a1 = Math.min(a1, i);
        a2 = Math.min(a2, i);
        assert (a1 >= 0);
        assert (a2 >= 0);
        if (0 < a1) {
            bi = new Bits(bits);
            gi.table_select[0] = this.choose_table(ix, 0, a1, bi);
            bits = bi.bits;
        }
        if (a1 < a2) {
            bi = new Bits(bits);
            gi.table_select[1] = this.choose_table(ix, a1, a2, bi);
            bits = bi.bits;
        }
        if (gfc.use_best_huffman == 2) {
            gi.part2_3_length = bits;
            this.best_huffman_divide(gfc, gi);
            bits = gi.part2_3_length;
        }
        if (prev_noise != null && gi.block_type == 0) {
            int sfb = 0;
            while (gfc.scalefac_band.l[sfb] < gi.big_values) {
                ++sfb;
            }
            prev_noise.sfb_count1 = sfb;
        }
        return bits;
    }

    public int count_bits(LameInternalFlags gfc, float[] xr, GrInfo gi, CalcNoiseData prev_noise) {
        int[] ix = gi.l3_enc;
        float w = 8206.0f / this.qupvt.IPOW20(gi.global_gain);
        if (gi.xrpow_max > w) {
            return 100000;
        }
        this.quantize_xrpow(xr, ix, this.qupvt.IPOW20(gi.global_gain), gi, prev_noise);
        if ((gfc.substep_shaping & 2) != 0) {
            int j = 0;
            int gain = gi.global_gain + gi.scalefac_scale;
            float roundfac = 0.63452166f / this.qupvt.IPOW20(gain);
            for (int sfb = 0; sfb < gi.sfbmax; ++sfb) {
                int width = gi.width[sfb];
                assert (width >= 0);
                if (0 == gfc.pseudohalf[sfb]) {
                    j += width;
                    continue;
                }
                int k = j;
                j += width;
                while (k < j) {
                    ix[k] = xr[k] >= roundfac ? ix[k] : 0;
                    ++k;
                }
            }
        }
        return this.noquant_count_bits(gfc, gi, prev_noise);
    }

    private void recalc_divide_init(LameInternalFlags gfc, GrInfo cod_info, int[] ix, int[] r01_bits, int[] r01_div, int[] r0_tbl, int[] r1_tbl) {
        int a1;
        int r0;
        int bigv = cod_info.big_values;
        for (r0 = 0; r0 <= 22; ++r0) {
            r01_bits[r0] = 100000;
        }
        for (r0 = 0; r0 < 16 && (a1 = gfc.scalefac_band.l[r0 + 1]) < bigv; ++r0) {
            int a2;
            int r0bits = 0;
            Bits bi = new Bits(r0bits);
            int r0t = this.choose_table(ix, 0, a1, bi);
            r0bits = bi.bits;
            for (int r1 = 0; r1 < 8 && (a2 = gfc.scalefac_band.l[r0 + r1 + 2]) < bigv; ++r1) {
                int bits = r0bits;
                bi = new Bits(bits);
                int r1t = this.choose_table(ix, a1, a2, bi);
                bits = bi.bits;
                if (r01_bits[r0 + r1] <= bits) continue;
                r01_bits[r0 + r1] = bits;
                r01_div[r0 + r1] = r0;
                r0_tbl[r0 + r1] = r0t;
                r1_tbl[r0 + r1] = r1t;
            }
        }
    }

    private void recalc_divide_sub(LameInternalFlags gfc, GrInfo cod_info2, GrInfo gi, int[] ix, int[] r01_bits, int[] r01_div, int[] r0_tbl, int[] r1_tbl) {
        int bits;
        int a2;
        int bigv = cod_info2.big_values;
        for (int r2 = 2; r2 < 23 && (a2 = gfc.scalefac_band.l[r2]) < bigv && gi.part2_3_length > (bits = r01_bits[r2 - 2] + cod_info2.count1bits); ++r2) {
            Bits bi = new Bits(bits);
            int r2t = this.choose_table(ix, a2, bigv, bi);
            bits = bi.bits;
            if (gi.part2_3_length <= bits) continue;
            gi.assign(cod_info2);
            gi.part2_3_length = bits;
            gi.region0_count = r01_div[r2 - 2];
            gi.region1_count = r2 - 2 - r01_div[r2 - 2];
            gi.table_select[0] = r0_tbl[r2 - 2];
            gi.table_select[1] = r1_tbl[r2 - 2];
            gi.table_select[2] = r2t;
        }
    }

    public void best_huffman_divide(LameInternalFlags gfc, GrInfo gi) {
        int i;
        GrInfo cod_info2 = new GrInfo();
        int[] ix = gi.l3_enc;
        int[] r01_bits = new int[23];
        int[] r01_div = new int[23];
        int[] r0_tbl = new int[23];
        int[] r1_tbl = new int[23];
        if (gi.block_type == 2 && gfc.mode_gr == 1) {
            return;
        }
        cod_info2.assign(gi);
        if (gi.block_type == 0) {
            this.recalc_divide_init(gfc, gi, ix, r01_bits, r01_div, r0_tbl, r1_tbl);
            this.recalc_divide_sub(gfc, cod_info2, gi, ix, r01_bits, r01_div, r0_tbl, r1_tbl);
        }
        if ((i = cod_info2.big_values) == 0 || (ix[i - 2] | ix[i - 1]) > 1) {
            return;
        }
        i = gi.count1 + 2;
        if (i > 576) {
            return;
        }
        cod_info2.assign(gi);
        cod_info2.count1 = i;
        int a1 = 0;
        int a2 = 0;
        assert (i <= 576);
        while (i > cod_info2.big_values) {
            int p = ((ix[i - 4] * 2 + ix[i - 3]) * 2 + ix[i - 2]) * 2 + ix[i - 1];
            a1 += Tables.t32l[p];
            a2 += Tables.t33l[p];
            i -= 4;
        }
        cod_info2.big_values = i;
        cod_info2.count1table_select = 0;
        if (a1 > a2) {
            a1 = a2;
            cod_info2.count1table_select = 1;
        }
        cod_info2.count1bits = a1;
        if (cod_info2.block_type == 0) {
            this.recalc_divide_sub(gfc, cod_info2, gi, ix, r01_bits, r01_div, r0_tbl, r1_tbl);
        } else {
            cod_info2.part2_3_length = a1;
            a1 = gfc.scalefac_band.l[8];
            if (a1 > i) {
                a1 = i;
            }
            if (a1 > 0) {
                Bits bi = new Bits(cod_info2.part2_3_length);
                cod_info2.table_select[0] = this.choose_table(ix, 0, a1, bi);
                cod_info2.part2_3_length = bi.bits;
            }
            if (i > a1) {
                Bits bi = new Bits(cod_info2.part2_3_length);
                cod_info2.table_select[1] = this.choose_table(ix, a1, i, bi);
                cod_info2.part2_3_length = bi.bits;
            }
            if (gi.part2_3_length > cod_info2.part2_3_length) {
                gi.assign(cod_info2);
            }
        }
    }

    private void scfsi_calc(int ch, IIISideInfo l3_side) {
        int sfb;
        GrInfo gi = l3_side.tt[1][ch];
        GrInfo g0 = l3_side.tt[0][ch];
        for (int i = 0; i < Tables.scfsi_band.length - 1; ++i) {
            for (sfb = Tables.scfsi_band[i]; sfb < Tables.scfsi_band[i + 1] && (g0.scalefac[sfb] == gi.scalefac[sfb] || gi.scalefac[sfb] < 0); ++sfb) {
            }
            if (sfb != Tables.scfsi_band[i + 1]) continue;
            for (sfb = Tables.scfsi_band[i]; sfb < Tables.scfsi_band[i + 1]; ++sfb) {
                gi.scalefac[sfb] = -1;
            }
            l3_side.scfsi[ch][i] = 1;
        }
        int s1 = 0;
        int c1 = 0;
        for (sfb = 0; sfb < 11; ++sfb) {
            if (gi.scalefac[sfb] == -1) continue;
            ++c1;
            if (s1 >= gi.scalefac[sfb]) continue;
            s1 = gi.scalefac[sfb];
        }
        int s2 = 0;
        int c2 = 0;
        while (sfb < 21) {
            if (gi.scalefac[sfb] != -1) {
                ++c2;
                if (s2 < gi.scalefac[sfb]) {
                    s2 = gi.scalefac[sfb];
                }
            }
            ++sfb;
        }
        for (int i = 0; i < 16; ++i) {
            int c;
            if (s1 >= slen1_n[i] || s2 >= slen2_n[i] || gi.part2_length <= (c = slen1_tab[i] * c1 + slen2_tab[i] * c2)) continue;
            gi.part2_length = c;
            gi.scalefac_compress = i;
        }
    }

    public void best_scalefac_store(LameInternalFlags gfc, int gr, int ch, IIISideInfo l3_side) {
        int sfb;
        GrInfo gi = l3_side.tt[gr][ch];
        int recalc = 0;
        int j = 0;
        for (sfb = 0; sfb < gi.sfbmax; ++sfb) {
            int l;
            int width = gi.width[sfb];
            assert (width >= 0);
            j += width;
            for (l = -width; l < 0 && gi.l3_enc[l + j] == 0; ++l) {
            }
            if (l != 0) continue;
            recalc = -2;
            gi.scalefac[sfb] = -2;
        }
        if (0 == gi.scalefac_scale && 0 == gi.preflag) {
            int s = 0;
            for (sfb = 0; sfb < gi.sfbmax; ++sfb) {
                if (gi.scalefac[sfb] <= 0) continue;
                s |= gi.scalefac[sfb];
            }
            if (!(s & true) && s != 0) {
                for (sfb = 0; sfb < gi.sfbmax; ++sfb) {
                    if (gi.scalefac[sfb] <= 0) continue;
                    int n = sfb;
                    gi.scalefac[n] = gi.scalefac[n] >> 1;
                }
                recalc = 1;
                gi.scalefac_scale = 1;
            }
        }
        if (0 == gi.preflag && gi.block_type != 2 && gfc.mode_gr == 2) {
            for (sfb = 11; sfb < 21 && (gi.scalefac[sfb] >= this.qupvt.pretab[sfb] || gi.scalefac[sfb] == -2); ++sfb) {
            }
            if (sfb == 21) {
                for (sfb = 11; sfb < 21; ++sfb) {
                    if (gi.scalefac[sfb] <= 0) continue;
                    int n = sfb;
                    gi.scalefac[n] = gi.scalefac[n] - this.qupvt.pretab[sfb];
                }
                recalc = 1;
                gi.preflag = 1;
            }
        }
        for (int i = 0; i < 4; ++i) {
            l3_side.scfsi[ch][i] = 0;
        }
        if (gfc.mode_gr == 2 && gr == 1 && l3_side.tt[0][ch].block_type != 2 && l3_side.tt[1][ch].block_type != 2) {
            this.scfsi_calc(ch, l3_side);
            recalc = 0;
        }
        for (sfb = 0; sfb < gi.sfbmax; ++sfb) {
            if (gi.scalefac[sfb] != -2) continue;
            gi.scalefac[sfb] = 0;
        }
        if (recalc != 0) {
            if (gfc.mode_gr == 2) {
                this.scale_bitcount(gi);
            } else {
                this.scale_bitcount_lsf(gfc, gi);
            }
        }
    }

    private boolean all_scalefactors_not_negative(int[] scalefac, int n) {
        for (int i = 0; i < n; ++i) {
            if (scalefac[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean scale_bitcount(GrInfo cod_info) {
        int sfb;
        int[] tab;
        int max_slen1 = 0;
        int max_slen2 = 0;
        int[] scalefac = cod_info.scalefac;
        assert (this.all_scalefactors_not_negative(scalefac, cod_info.sfbmax));
        if (cod_info.block_type == 2) {
            tab = scale_short;
            if (cod_info.mixed_block_flag != 0) {
                tab = scale_mixed;
            }
        } else {
            tab = scale_long;
            if (0 == cod_info.preflag) {
                for (sfb = 11; sfb < 21 && scalefac[sfb] >= this.qupvt.pretab[sfb]; ++sfb) {
                }
                if (sfb == 21) {
                    cod_info.preflag = 1;
                    for (sfb = 11; sfb < 21; ++sfb) {
                        int n = sfb;
                        scalefac[n] = scalefac[n] - this.qupvt.pretab[sfb];
                    }
                }
            }
        }
        for (sfb = 0; sfb < cod_info.sfbdivide; ++sfb) {
            if (max_slen1 >= scalefac[sfb]) continue;
            max_slen1 = scalefac[sfb];
        }
        while (sfb < cod_info.sfbmax) {
            if (max_slen2 < scalefac[sfb]) {
                max_slen2 = scalefac[sfb];
            }
            ++sfb;
        }
        cod_info.part2_length = 100000;
        for (int k = 0; k < 16; ++k) {
            if (max_slen1 >= slen1_n[k] || max_slen2 >= slen2_n[k] || cod_info.part2_length <= tab[k]) continue;
            cod_info.part2_length = tab[k];
            cod_info.scalefac_compress = k;
        }
        return cod_info.part2_length == 100000;
    }

    public boolean scale_bitcount_lsf(LameInternalFlags gfc, GrInfo cod_info) {
        int nr_sfb;
        int partition;
        int sfb;
        int[] partition_table;
        int row_in_table;
        int i;
        int[] max_sfac = new int[4];
        int[] scalefac = cod_info.scalefac;
        int table_number = cod_info.preflag != 0 ? 2 : 0;
        for (i = 0; i < 4; ++i) {
            max_sfac[i] = 0;
        }
        if (cod_info.block_type == 2) {
            row_in_table = 1;
            partition_table = this.qupvt.nr_of_sfb_block[table_number][row_in_table];
            sfb = 0;
            for (partition = 0; partition < 4; ++partition) {
                nr_sfb = partition_table[partition] / 3;
                i = 0;
                while (i < nr_sfb) {
                    for (int window = 0; window < 3; ++window) {
                        if (scalefac[sfb * 3 + window] <= max_sfac[partition]) continue;
                        max_sfac[partition] = scalefac[sfb * 3 + window];
                    }
                    ++i;
                    ++sfb;
                }
            }
        } else {
            row_in_table = 0;
            partition_table = this.qupvt.nr_of_sfb_block[table_number][row_in_table];
            sfb = 0;
            for (partition = 0; partition < 4; ++partition) {
                nr_sfb = partition_table[partition];
                i = 0;
                while (i < nr_sfb) {
                    if (scalefac[sfb] > max_sfac[partition]) {
                        max_sfac[partition] = scalefac[sfb];
                    }
                    ++i;
                    ++sfb;
                }
            }
        }
        boolean over = false;
        for (partition = 0; partition < 4; ++partition) {
            if (max_sfac[partition] <= max_range_sfac_tab[table_number][partition]) continue;
            over = true;
        }
        if (!over) {
            cod_info.sfb_partition_table = this.qupvt.nr_of_sfb_block[table_number][row_in_table];
            for (partition = 0; partition < 4; ++partition) {
                cod_info.slen[partition] = log2tab[max_sfac[partition]];
            }
            int slen1 = cod_info.slen[0];
            int slen2 = cod_info.slen[1];
            int slen3 = cod_info.slen[2];
            int slen4 = cod_info.slen[3];
            switch (table_number) {
                case 0: {
                    cod_info.scalefac_compress = (slen1 * 5 + slen2 << 4) + (slen3 << 2) + slen4;
                    break;
                }
                case 1: {
                    cod_info.scalefac_compress = 400 + (slen1 * 5 + slen2 << 2) + slen3;
                    break;
                }
                case 2: {
                    cod_info.scalefac_compress = 500 + slen1 * 3 + slen2;
                    break;
                }
                default: {
                    System.err.printf("intensity stereo not implemented yet\n", new Object[0]);
                }
            }
        }
        if (!over) {
            assert (cod_info.sfb_partition_table != null);
            cod_info.part2_length = 0;
            for (partition = 0; partition < 4; ++partition) {
                cod_info.part2_length += cod_info.slen[partition] * cod_info.sfb_partition_table[partition];
            }
        }
        return over;
    }

    public void huffman_init(LameInternalFlags gfc) {
        for (int i = 2; i <= 576; i += 2) {
            int scfb_anz = 0;
            while (gfc.scalefac_band.l[++scfb_anz] < i) {
            }
            int bv_index = this.subdv_table[scfb_anz][0];
            while (gfc.scalefac_band.l[bv_index + 1] > i) {
                --bv_index;
            }
            if (bv_index < 0) {
                bv_index = this.subdv_table[scfb_anz][0];
            }
            gfc.bv_scf[i - 2] = bv_index;
            bv_index = this.subdv_table[scfb_anz][1];
            while (gfc.scalefac_band.l[bv_index + gfc.bv_scf[i - 2] + 2] > i) {
                --bv_index;
            }
            if (bv_index < 0) {
                bv_index = this.subdv_table[scfb_anz][1];
            }
            gfc.bv_scf[i - 1] = bv_index;
        }
    }

    static class Bits {
        int bits;

        public Bits(int b) {
            this.bits = b;
        }
    }
}

