/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.ABRPresets;
import net.sourceforge.lame.mp3.Lame;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.VBRPresets;
import net.sourceforge.lame.mp3.VbrMode;

public class Presets {
    private static final VBRPresets[] vbr_old_switch_map = new VBRPresets[]{new VBRPresets(0, 9, 9, 0, 5.2f, 125.0f, -4.2f, -6.3f, 4.8f, 1.0f, 0.0f, 0.0f, 2, 21, 0.97f), new VBRPresets(1, 9, 9, 0, 5.3f, 125.0f, -3.6f, -5.6f, 4.5f, 1.5f, 0.0f, 0.0f, 2, 21, 1.35f), new VBRPresets(2, 9, 9, 0, 5.6f, 125.0f, -2.2f, -3.5f, 2.8f, 2.0f, 0.0f, 0.0f, 2, 21, 1.49f), new VBRPresets(3, 9, 9, 1, 5.8f, 130.0f, -1.8f, -2.8f, 2.6f, 3.0f, -4.0f, 0.0f, 2, 20, 1.64f), new VBRPresets(4, 9, 9, 1, 6.0f, 135.0f, -0.7f, -1.1f, 1.1f, 3.5f, -8.0f, 0.0f, 2, 0, 1.79f), new VBRPresets(5, 9, 9, 1, 6.4f, 140.0f, 0.5f, 0.4f, -7.5f, 4.0f, -12.0f, 2.0E-4f, 0, 0, 1.95f), new VBRPresets(6, 9, 9, 1, 6.6f, 145.0f, 0.67f, 0.65f, -14.7f, 6.5f, -19.0f, 4.0E-4f, 0, 0, 2.3f), new VBRPresets(7, 9, 9, 1, 6.6f, 145.0f, 0.8f, 0.75f, -19.7f, 8.0f, -22.0f, 6.0E-4f, 0, 0, 2.7f), new VBRPresets(8, 9, 9, 1, 6.6f, 145.0f, 1.2f, 1.15f, -27.5f, 10.0f, -23.0f, 7.0E-4f, 0, 0, 0.0f), new VBRPresets(9, 9, 9, 1, 6.6f, 145.0f, 1.6f, 1.6f, -36.0f, 11.0f, -25.0f, 8.0E-4f, 0, 0, 0.0f), new VBRPresets(10, 9, 9, 1, 6.6f, 145.0f, 2.0f, 2.0f, -36.0f, 12.0f, -25.0f, 8.0E-4f, 0, 0, 0.0f)};
    private static final VBRPresets[] vbr_psy_switch_map = new VBRPresets[]{new VBRPresets(0, 9, 9, 0, 4.2f, 25.0f, -7.0f, -4.0f, 7.5f, 1.0f, 0.0f, 0.0f, 2, 26, 0.97f), new VBRPresets(1, 9, 9, 0, 4.2f, 25.0f, -5.6f, -3.6f, 4.5f, 1.5f, 0.0f, 0.0f, 2, 21, 1.35f), new VBRPresets(2, 9, 9, 0, 4.2f, 25.0f, -4.4f, -1.8f, 2.0f, 2.0f, 0.0f, 0.0f, 2, 18, 1.49f), new VBRPresets(3, 9, 9, 1, 4.2f, 25.0f, -3.4f, -1.25f, 1.1f, 3.0f, -4.0f, 0.0f, 2, 15, 1.64f), new VBRPresets(4, 9, 9, 1, 4.2f, 25.0f, -2.2f, 0.1f, 0.0f, 3.5f, -8.0f, 0.0f, 2, 0, 1.79f), new VBRPresets(5, 9, 9, 1, 4.2f, 25.0f, -1.0f, 1.65f, -7.7f, 4.0f, -12.0f, 2.0E-4f, 0, 0, 1.95f), new VBRPresets(6, 9, 9, 1, 4.2f, 25.0f, -0.0f, 2.47f, -7.7f, 6.5f, -19.0f, 4.0E-4f, 0, 0, 2.0f), new VBRPresets(7, 9, 9, 1, 4.2f, 25.0f, 0.5f, 2.0f, -14.5f, 8.0f, -22.0f, 6.0E-4f, 0, 0, 2.0f), new VBRPresets(8, 9, 9, 1, 4.2f, 25.0f, 1.0f, 2.4f, -22.0f, 10.0f, -23.0f, 7.0E-4f, 0, 0, 2.0f), new VBRPresets(9, 9, 9, 1, 4.2f, 25.0f, 1.5f, 2.95f, -30.0f, 11.0f, -25.0f, 8.0E-4f, 0, 0, 2.0f), new VBRPresets(10, 9, 9, 1, 4.2f, 25.0f, 2.0f, 2.95f, -36.0f, 12.0f, -30.0f, 8.0E-4f, 0, 0, 2.0f)};
    private static final ABRPresets[] abr_switch_map = new ABRPresets[]{new ABRPresets(8, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -30.0f, 11.0f, 0.0012f, 1), new ABRPresets(16, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -25.0f, 11.0f, 0.001f, 1), new ABRPresets(24, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -20.0f, 11.0f, 0.001f, 1), new ABRPresets(32, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -15.0f, 11.0f, 0.001f, 1), new ABRPresets(40, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -10.0f, 11.0f, 9.0E-4f, 1), new ABRPresets(48, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -10.0f, 11.0f, 9.0E-4f, 1), new ABRPresets(56, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -6.0f, 11.0f, 8.0E-4f, 1), new ABRPresets(64, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, -2.0f, 11.0f, 8.0E-4f, 1), new ABRPresets(80, 9, 9, 0, 0.0f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, 0.0f, 8.0f, 7.0E-4f, 1), new ABRPresets(96, 9, 9, 0, 2.5f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, 1.0f, 5.5f, 6.0E-4f, 1), new ABRPresets(112, 9, 9, 0, 2.25f, 6.6f, 145.0f, 0.0f, 0.95f, 0.0f, 2.0f, 4.5f, 5.0E-4f, 1), new ABRPresets(128, 9, 9, 0, 1.95f, 6.4f, 140.0f, 0.0f, 0.95f, 0.0f, 3.0f, 4.0f, 2.0E-4f, 1), new ABRPresets(160, 9, 9, 1, 1.79f, 6.0f, 135.0f, 0.0f, 0.95f, -2.0f, 5.0f, 3.5f, 0.0f, 1), new ABRPresets(192, 9, 9, 1, 1.49f, 5.6f, 125.0f, 0.0f, 0.97f, -4.0f, 7.0f, 3.0f, 0.0f, 0), new ABRPresets(224, 9, 9, 1, 1.25f, 5.2f, 125.0f, 0.0f, 0.98f, -6.0f, 9.0f, 2.0f, 0.0f, 0), new ABRPresets(256, 9, 9, 1, 0.97f, 5.2f, 125.0f, 0.0f, 1.0f, -8.0f, 10.0f, 1.0f, 0.0f, 0), new ABRPresets(320, 9, 9, 1, 0.9f, 5.2f, 125.0f, 0.0f, 1.0f, -10.0f, 12.0f, 0.0f, 0.0f, 0)};
    Lame lame;

    public final void setModules(Lame lame) {
        this.lame = lame;
    }

    private void apply_vbr_preset(LameGlobalFlags gfp, int a, int enforce) {
        VBRPresets[] vbr_preset = gfp.getVBR() == VbrMode.vbr_rh ? vbr_old_switch_map : vbr_psy_switch_map;
        float x = gfp.VBR_q_frac;
        VBRPresets p = vbr_preset[a];
        VBRPresets q = vbr_preset[a + 1];
        VBRPresets set = p;
        p.st_lrm += x * (q.st_lrm - p.st_lrm);
        p.st_s += x * (q.st_s - p.st_s);
        p.masking_adj += x * (q.masking_adj - p.masking_adj);
        p.masking_adj_short += x * (q.masking_adj_short - p.masking_adj_short);
        p.ath_lower += x * (q.ath_lower - p.ath_lower);
        p.ath_curve += x * (q.ath_curve - p.ath_curve);
        p.ath_sensitivity += x * (q.ath_sensitivity - p.ath_sensitivity);
        p.interch += x * (q.interch - p.interch);
        p.msfix += x * (q.msfix - p.msfix);
        this.lame_set_VBR_q(gfp, set.vbr_q);
        if (enforce != 0) {
            gfp.quant_comp = set.quant_comp;
        } else if (Math.abs(gfp.quant_comp - -1) <= 0) {
            gfp.quant_comp = set.quant_comp;
        }
        if (enforce != 0) {
            gfp.quant_comp_short = set.quant_comp_s;
        } else if (Math.abs(gfp.quant_comp_short - -1) <= 0) {
            gfp.quant_comp_short = set.quant_comp_s;
        }
        if (set.expY != 0) {
            boolean bl = gfp.experimentalY = set.expY != 0;
        }
        if (enforce != 0) {
            gfp.internal_flags.nsPsy.attackthre = set.st_lrm;
        } else if (!(Math.abs(gfp.internal_flags.nsPsy.attackthre - -1.0f) > 0.0f)) {
            gfp.internal_flags.nsPsy.attackthre = set.st_lrm;
        }
        if (enforce != 0) {
            gfp.internal_flags.nsPsy.attackthre_s = set.st_s;
        } else if (!(Math.abs(gfp.internal_flags.nsPsy.attackthre_s - -1.0f) > 0.0f)) {
            gfp.internal_flags.nsPsy.attackthre_s = set.st_s;
        }
        if (enforce != 0) {
            gfp.maskingadjust = set.masking_adj;
        } else if (!(Math.abs(gfp.maskingadjust - 0.0f) > 0.0f)) {
            gfp.maskingadjust = set.masking_adj;
        }
        if (enforce != 0) {
            gfp.maskingadjust_short = set.masking_adj_short;
        } else if (!(Math.abs(gfp.maskingadjust_short - 0.0f) > 0.0f)) {
            gfp.maskingadjust_short = set.masking_adj_short;
        }
        if (enforce != 0) {
            gfp.ATHlower = -set.ath_lower / 10.0f;
        } else if (!(Math.abs((double)(-gfp.ATHlower) * 10.0 - 0.0) > 0.0)) {
            gfp.ATHlower = -set.ath_lower / 10.0f;
        }
        if (enforce != 0) {
            gfp.ATHcurve = set.ath_curve;
        } else if (!(Math.abs(gfp.ATHcurve - -1.0f) > 0.0f)) {
            gfp.ATHcurve = set.ath_curve;
        }
        if (enforce != 0) {
            gfp.athaa_sensitivity = set.ath_sensitivity;
        } else if (!(Math.abs(gfp.athaa_sensitivity - -1.0f) > 0.0f)) {
            gfp.athaa_sensitivity = set.ath_sensitivity;
        }
        if (set.interch > 0.0f) {
            if (enforce != 0) {
                gfp.interChRatio = set.interch;
            } else if (!(Math.abs(gfp.interChRatio - -1.0f) > 0.0f)) {
                gfp.interChRatio = set.interch;
            }
        }
        if (set.safejoint > 0) {
            gfp.exp_nspsytune |= set.safejoint;
        }
        if (set.sfb21mod > 0) {
            gfp.exp_nspsytune |= set.sfb21mod << 20;
        }
        if (enforce != 0) {
            gfp.msfix = set.msfix;
        } else if (!(Math.abs(gfp.msfix - -1.0f) > 0.0f)) {
            gfp.msfix = set.msfix;
        }
        if (enforce == 0) {
            gfp.setVBRQuality(a);
            gfp.VBR_q_frac = x;
        }
    }

    private int apply_abr_preset(LameGlobalFlags gfp, int preset, int enforce) {
        int actual_bitrate = preset;
        int r = this.lame.nearestBitrateFullIndex(preset);
        gfp.setVBR(VbrMode.vbr_abr);
        gfp.VBR_mean_bitrate_kbps = actual_bitrate;
        gfp.VBR_mean_bitrate_kbps = Math.min(gfp.VBR_mean_bitrate_kbps, 320);
        gfp.VBR_mean_bitrate_kbps = Math.max(gfp.VBR_mean_bitrate_kbps, 8);
        gfp.setBitRate(gfp.VBR_mean_bitrate_kbps);
        if (gfp.VBR_mean_bitrate_kbps > 320) {
            gfp.disable_reservoir = true;
        }
        if (Presets.abr_switch_map[r].safejoint > 0) {
            gfp.exp_nspsytune |= 2;
        }
        if (Presets.abr_switch_map[r].sfscale > 0) {
            gfp.internal_flags.noise_shaping = 2;
        }
        if (Math.abs(Presets.abr_switch_map[r].nsbass) > 0.0f) {
            int k = (int)(Presets.abr_switch_map[r].nsbass * 4.0f);
            if (k < 0) {
                k += 64;
            }
            gfp.exp_nspsytune |= k << 2;
        }
        if (enforce != 0) {
            gfp.quant_comp = Presets.abr_switch_map[r].quant_comp;
        } else if (Math.abs(gfp.quant_comp - -1) <= 0) {
            gfp.quant_comp = Presets.abr_switch_map[r].quant_comp;
        }
        if (enforce != 0) {
            gfp.quant_comp_short = Presets.abr_switch_map[r].quant_comp_s;
        } else if (Math.abs(gfp.quant_comp_short - -1) <= 0) {
            gfp.quant_comp_short = Presets.abr_switch_map[r].quant_comp_s;
        }
        if (enforce != 0) {
            gfp.msfix = Presets.abr_switch_map[r].nsmsfix;
        } else if (!(Math.abs(gfp.msfix - -1.0f) > 0.0f)) {
            gfp.msfix = Presets.abr_switch_map[r].nsmsfix;
        }
        if (enforce != 0) {
            gfp.internal_flags.nsPsy.attackthre = Presets.abr_switch_map[r].st_lrm;
        } else if (!(Math.abs(gfp.internal_flags.nsPsy.attackthre - -1.0f) > 0.0f)) {
            gfp.internal_flags.nsPsy.attackthre = Presets.abr_switch_map[r].st_lrm;
        }
        if (enforce != 0) {
            gfp.internal_flags.nsPsy.attackthre_s = Presets.abr_switch_map[r].st_s;
        } else if (!(Math.abs(gfp.internal_flags.nsPsy.attackthre_s - -1.0f) > 0.0f)) {
            gfp.internal_flags.nsPsy.attackthre_s = Presets.abr_switch_map[r].st_s;
        }
        if (enforce != 0) {
            gfp.scale = Presets.abr_switch_map[r].scale;
        } else if (!(Math.abs(gfp.scale - -1.0f) > 0.0f)) {
            gfp.scale = Presets.abr_switch_map[r].scale;
        }
        if (enforce != 0) {
            gfp.maskingadjust = Presets.abr_switch_map[r].masking_adj;
        } else if (!(Math.abs(gfp.maskingadjust - 0.0f) > 0.0f)) {
            gfp.maskingadjust = Presets.abr_switch_map[r].masking_adj;
        }
        if (Presets.abr_switch_map[r].masking_adj > 0.0f) {
            if (enforce != 0) {
                gfp.maskingadjust_short = (float)((double)Presets.abr_switch_map[r].masking_adj * 0.9);
            } else if (!(Math.abs(gfp.maskingadjust_short - 0.0f) > 0.0f)) {
                gfp.maskingadjust_short = (float)((double)Presets.abr_switch_map[r].masking_adj * 0.9);
            }
        } else if (enforce != 0) {
            gfp.maskingadjust_short = (float)((double)Presets.abr_switch_map[r].masking_adj * 1.1);
        } else if (!(Math.abs(gfp.maskingadjust_short - 0.0f) > 0.0f)) {
            gfp.maskingadjust_short = (float)((double)Presets.abr_switch_map[r].masking_adj * 1.1);
        }
        if (enforce != 0) {
            gfp.ATHlower = -Presets.abr_switch_map[r].ath_lower / 10.0f;
        } else if (!(Math.abs(-gfp.ATHlower * 10.0f - 0.0f) > 0.0f)) {
            gfp.ATHlower = -Presets.abr_switch_map[r].ath_lower / 10.0f;
        }
        if (enforce != 0) {
            gfp.ATHcurve = Presets.abr_switch_map[r].ath_curve;
        } else if (!(Math.abs(gfp.ATHcurve - -1.0f) > 0.0f)) {
            gfp.ATHcurve = Presets.abr_switch_map[r].ath_curve;
        }
        if (enforce != 0) {
            gfp.interChRatio = Presets.abr_switch_map[r].interch;
        } else if (!(Math.abs(gfp.interChRatio - -1.0f) > 0.0f)) {
            gfp.interChRatio = Presets.abr_switch_map[r].interch;
        }
        return preset;
    }

    public final int apply_preset(LameGlobalFlags gfp, int preset, int enforce) {
        switch (preset) {
            case 1000: {
                preset = 470;
                gfp.setVBR(VbrMode.vbr_mtrh);
                break;
            }
            case 1006: {
                preset = 460;
                gfp.setVBR(VbrMode.vbr_rh);
                break;
            }
            case 1007: {
                preset = 460;
                gfp.setVBR(VbrMode.vbr_mtrh);
                break;
            }
            case 1001: {
                preset = 480;
                gfp.setVBR(VbrMode.vbr_rh);
                break;
            }
            case 1004: {
                preset = 480;
                gfp.setVBR(VbrMode.vbr_mtrh);
                break;
            }
            case 1002: {
                preset = 500;
                gfp.setVBR(VbrMode.vbr_rh);
                break;
            }
            case 1005: {
                preset = 500;
                gfp.setVBR(VbrMode.vbr_mtrh);
                break;
            }
            case 1003: {
                gfp.preset = preset = 320;
                this.apply_abr_preset(gfp, preset, enforce);
                gfp.setVBR(VbrMode.vbr_off);
                return preset;
            }
        }
        gfp.preset = preset;
        switch (preset) {
            case 410: {
                this.apply_vbr_preset(gfp, 9, enforce);
                return preset;
            }
            case 420: {
                this.apply_vbr_preset(gfp, 8, enforce);
                return preset;
            }
            case 430: {
                this.apply_vbr_preset(gfp, 7, enforce);
                return preset;
            }
            case 440: {
                this.apply_vbr_preset(gfp, 6, enforce);
                return preset;
            }
            case 450: {
                this.apply_vbr_preset(gfp, 5, enforce);
                return preset;
            }
            case 460: {
                this.apply_vbr_preset(gfp, 4, enforce);
                return preset;
            }
            case 470: {
                this.apply_vbr_preset(gfp, 3, enforce);
                return preset;
            }
            case 480: {
                this.apply_vbr_preset(gfp, 2, enforce);
                return preset;
            }
            case 490: {
                this.apply_vbr_preset(gfp, 1, enforce);
                return preset;
            }
            case 500: {
                this.apply_vbr_preset(gfp, 0, enforce);
                return preset;
            }
        }
        if (8 <= preset && preset <= 320) {
            return this.apply_abr_preset(gfp, preset, enforce);
        }
        gfp.preset = 0;
        return preset;
    }

    public int lame_set_VBR_q(LameGlobalFlags gfp, int VBR_q) {
        int ret = 0;
        if (0 > VBR_q) {
            ret = -1;
            VBR_q = 0;
        }
        if (9 < VBR_q) {
            ret = -1;
            VBR_q = 9;
        }
        gfp.setVBRQuality(VBR_q);
        gfp.VBR_q_frac = 0.0f;
        return ret;
    }
}

