/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.BitStream;
import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.III_psy_ratio;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.MPEGMode;
import net.sourceforge.lame.mp3.NewMDCT;
import net.sourceforge.lame.mp3.PsyModel;
import net.sourceforge.lame.mp3.QuantizePVT;
import net.sourceforge.lame.mp3.VBRTag;
import net.sourceforge.lame.mp3.VbrMode;

public class Encoder {
    public static final int ENCDELAY = 576;
    public static final int POSTDELAY = 1152;
    public static final int MDCTDELAY = 48;
    public static final int FFTOFFSET = 272;
    public static final int DECDELAY = 528;
    public static final int SBLIMIT = 32;
    public static final int CBANDS = 64;
    public static final int SBPSY_l = 21;
    public static final int SBPSY_s = 12;
    public static final int SBMAX_l = 22;
    public static final int SBMAX_s = 13;
    public static final int PSFB21 = 6;
    public static final int PSFB12 = 6;
    public static final int BLKSIZE = 1024;
    public static final int HBLKSIZE = 513;
    public static final int BLKSIZE_s = 256;
    public static final int HBLKSIZE_s = 129;
    public static final int NORM_TYPE = 0;
    public static final int START_TYPE = 1;
    public static final int SHORT_TYPE = 2;
    public static final int STOP_TYPE = 3;
    public static final int MPG_MD_LR_LR = 0;
    public static final int MPG_MD_LR_I = 1;
    public static final int MPG_MD_MS_LR = 2;
    public static final int MPG_MD_MS_I = 3;
    private static final float[] fircoef = new float[]{-0.1039435f, -0.18920651f, -0.216236f, -0.155915f, 3.898045E-17f, 0.2338725f, 0.50455f, 0.756825f, 0.93549f};
    public PsyModel psy;
    BitStream bs;
    VBRTag vbr;
    QuantizePVT qupvt;
    private NewMDCT newMDCT = new NewMDCT();

    public final void setModules(BitStream bs, PsyModel psy, QuantizePVT qupvt, VBRTag vbr) {
        this.bs = bs;
        this.psy = psy;
        this.vbr = vbr;
        this.qupvt = qupvt;
    }

    private void adjust_ATH(LameInternalFlags gfc) {
        if (gfc.ATH.useAdjust == 0) {
            gfc.ATH.adjust = 1.0f;
            return;
        }
        float max_pow = gfc.loudness_sq[0][0];
        float gr2_max = gfc.loudness_sq[1][0];
        if (gfc.channels_out == 2) {
            max_pow += gfc.loudness_sq[0][1];
            gr2_max += gfc.loudness_sq[1][1];
        } else {
            max_pow += max_pow;
            gr2_max += gr2_max;
        }
        if (gfc.mode_gr == 2) {
            max_pow = Math.max(max_pow, gr2_max);
        }
        max_pow = (float)((double)max_pow * 0.5);
        if ((double)(max_pow *= gfc.ATH.aaSensitivityP) > 0.03125) {
            if ((double)gfc.ATH.adjust >= 1.0) {
                gfc.ATH.adjust = 1.0f;
            } else if (gfc.ATH.adjust < gfc.ATH.adjustLimit) {
                gfc.ATH.adjust = gfc.ATH.adjustLimit;
            }
            gfc.ATH.adjustLimit = 1.0f;
        } else {
            float adj_lim_new = 31.98f * max_pow + 6.25E-4f;
            if (gfc.ATH.adjust >= adj_lim_new) {
                gfc.ATH.adjust = (float)((double)gfc.ATH.adjust * ((double)adj_lim_new * 0.075 + 0.925));
                if (gfc.ATH.adjust < adj_lim_new) {
                    gfc.ATH.adjust = adj_lim_new;
                }
            } else if (gfc.ATH.adjustLimit >= adj_lim_new) {
                gfc.ATH.adjust = adj_lim_new;
            } else if (gfc.ATH.adjust < gfc.ATH.adjustLimit) {
                gfc.ATH.adjust = gfc.ATH.adjustLimit;
            }
            gfc.ATH.adjustLimit = adj_lim_new;
        }
    }

    private void updateStats(LameInternalFlags gfc) {
        assert (0 <= gfc.bitrate_index && gfc.bitrate_index < 16);
        assert (0 <= gfc.mode_ext && gfc.mode_ext < 4);
        int[] nArray = gfc.bitrate_stereoMode_Hist[gfc.bitrate_index];
        nArray[4] = nArray[4] + 1;
        int[] nArray2 = gfc.bitrate_stereoMode_Hist[15];
        nArray2[4] = nArray2[4] + 1;
        if (gfc.channels_out == 2) {
            int[] nArray3 = gfc.bitrate_stereoMode_Hist[gfc.bitrate_index];
            int n = gfc.mode_ext;
            nArray3[n] = nArray3[n] + 1;
            int[] nArray4 = gfc.bitrate_stereoMode_Hist[15];
            int n2 = gfc.mode_ext;
            nArray4[n2] = nArray4[n2] + 1;
        }
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                int bt = gfc.l3_side.tt[gr][ch].block_type;
                if (gfc.l3_side.tt[gr][ch].mixed_block_flag != 0) {
                    bt = 4;
                }
                int[] nArray5 = gfc.bitrate_blockType_Hist[gfc.bitrate_index];
                int n = bt;
                nArray5[n] = nArray5[n] + 1;
                int[] nArray6 = gfc.bitrate_blockType_Hist[gfc.bitrate_index];
                nArray6[5] = nArray6[5] + 1;
                int[] nArray7 = gfc.bitrate_blockType_Hist[15];
                int n3 = bt;
                nArray7[n3] = nArray7[n3] + 1;
                int[] nArray8 = gfc.bitrate_blockType_Hist[15];
                nArray8[5] = nArray8[5] + 1;
            }
        }
    }

    private void lame_encode_frame_init(LameGlobalFlags gfp, float[][] inbuf) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc.lame_encode_frame_init == 0) {
            float[] primebuff0 = new float[2014];
            float[] primebuff1 = new float[2014];
            gfc.lame_encode_frame_init = 1;
            int j = 0;
            for (int i = 0; i < 286 + 576 * (1 + gfc.mode_gr); ++i) {
                if (i < 576 * gfc.mode_gr) {
                    primebuff0[i] = 0.0f;
                    if (gfc.channels_out != 2) continue;
                    primebuff1[i] = 0.0f;
                    continue;
                }
                primebuff0[i] = inbuf[0][j];
                if (gfc.channels_out == 2) {
                    primebuff1[i] = inbuf[1][j];
                }
                ++j;
            }
            for (int gr = 0; gr < gfc.mode_gr; ++gr) {
                for (int ch = 0; ch < gfc.channels_out; ++ch) {
                    gfc.l3_side.tt[gr][ch].block_type = 2;
                }
            }
            this.newMDCT.mdct_sub48(gfc, primebuff0, primebuff1);
            assert (gfc.mf_size >= 1024 + gfp.getFrameSize() - 272);
            assert (gfc.mf_size >= 512 + gfp.getFrameSize() - 32);
        }
    }

    public final int lame_encode_mp3_frame(LameGlobalFlags gfp, float[] inbuf_l, float[] inbuf_r, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        float[][] pe_use;
        III_psy_ratio[][] masking;
        int ch;
        int gr;
        III_psy_ratio[][] masking_LR = new III_psy_ratio[2][2];
        masking_LR[0][0] = new III_psy_ratio();
        masking_LR[0][1] = new III_psy_ratio();
        masking_LR[1][0] = new III_psy_ratio();
        masking_LR[1][1] = new III_psy_ratio();
        III_psy_ratio[][] masking_MS = new III_psy_ratio[2][2];
        masking_MS[0][0] = new III_psy_ratio();
        masking_MS[0][1] = new III_psy_ratio();
        masking_MS[1][0] = new III_psy_ratio();
        masking_MS[1][1] = new III_psy_ratio();
        float[][] inbuf = new float[2][];
        LameInternalFlags gfc = gfp.internal_flags;
        float[][] tot_ener = new float[2][4];
        float[] ms_ener_ratio = new float[]{0.5f, 0.5f};
        float[][] pe = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        float[][] pe_MS = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        inbuf[0] = inbuf_l;
        inbuf[1] = inbuf_r;
        if (gfc.lame_encode_frame_init == 0) {
            this.lame_encode_frame_init(gfp, inbuf);
        }
        gfc.padding = 0;
        if ((gfc.slot_lag -= gfc.frac_SpF) < 0) {
            gfc.slot_lag += gfp.getOutSampleRate();
            gfc.padding = 1;
        }
        if (gfc.psymodel != 0) {
            float[][] bufp = new float[2][];
            int bufpPos = 0;
            int[] blocktype = new int[2];
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    bufp[ch] = inbuf[ch];
                    bufpPos = 576 + gr * 576 - 272;
                }
                int ret = gfp.getVBR() == VbrMode.vbr_mtrh || gfp.getVBR() == VbrMode.vbr_mt ? this.psy.L3psycho_anal_vbr(gfp, bufp, bufpPos, gr, masking_LR, masking_MS, pe[gr], pe_MS[gr], tot_ener[gr], blocktype) : this.psy.L3psycho_anal_ns(gfp, bufp, bufpPos, gr, masking_LR, masking_MS, pe[gr], pe_MS[gr], tot_ener[gr], blocktype);
                if (ret != 0) {
                    return -4;
                }
                if (gfp.getMode() == MPEGMode.JOINT_STEREO) {
                    ms_ener_ratio[gr] = tot_ener[gr][2] + tot_ener[gr][3];
                    if (ms_ener_ratio[gr] > 0.0f) {
                        ms_ener_ratio[gr] = tot_ener[gr][3] / ms_ener_ratio[gr];
                    }
                }
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    GrInfo cod_info = gfc.l3_side.tt[gr][ch];
                    cod_info.block_type = blocktype[ch];
                    cod_info.mixed_block_flag = 0;
                }
            }
        } else {
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    gfc.l3_side.tt[gr][ch].block_type = 0;
                    gfc.l3_side.tt[gr][ch].mixed_block_flag = 0;
                    pe[gr][ch] = 700.0f;
                    pe_MS[gr][ch] = 700.0f;
                }
            }
        }
        this.adjust_ATH(gfc);
        this.newMDCT.mdct_sub48(gfc, inbuf[0], inbuf[1]);
        gfc.mode_ext = 0;
        if (gfp.force_ms) {
            gfc.mode_ext = 2;
        } else if (gfp.getMode() == MPEGMode.JOINT_STEREO) {
            float sum_pe_MS = 0.0f;
            float sum_pe_LR = 0.0f;
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    sum_pe_MS += pe_MS[gr][ch];
                    sum_pe_LR += pe[gr][ch];
                }
            }
            if ((double)sum_pe_MS <= 1.0 * (double)sum_pe_LR) {
                GrInfo[] gi0 = gfc.l3_side.tt[0];
                GrInfo[] gi1 = gfc.l3_side.tt[gfc.mode_gr - 1];
                if (gi0[0].block_type == gi0[1].block_type && gi1[0].block_type == gi1[1].block_type) {
                    gfc.mode_ext = 2;
                }
            }
        }
        if (gfc.mode_ext == 2) {
            masking = masking_MS;
            pe_use = pe_MS;
        } else {
            masking = masking_LR;
            pe_use = pe;
        }
        if (gfp.analysis && gfc.pinfo != null) {
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    gfc.pinfo.ms_ratio[gr] = gfc.ms_ratio[gr];
                    gfc.pinfo.ms_ener_ratio[gr] = ms_ener_ratio[gr];
                    gfc.pinfo.blocktype[gr][ch] = gfc.l3_side.tt[gr][ch].block_type;
                    gfc.pinfo.pe[gr][ch] = pe_use[gr][ch];
                    System.arraycopy(gfc.l3_side.tt[gr][ch].xr, 0, gfc.pinfo.xr[gr][ch], 0, 576);
                    if (gfc.mode_ext != 2) continue;
                    gfc.pinfo.ers[gr][ch] = gfc.pinfo.ers[gr][ch + 2];
                    System.arraycopy(gfc.pinfo.energy[gr][ch + 2], 0, gfc.pinfo.energy[gr][ch], 0, gfc.pinfo.energy[gr][ch].length);
                }
            }
        }
        if (gfp.getVBR() == VbrMode.vbr_off || gfp.getVBR() == VbrMode.vbr_abr) {
            int i;
            for (i = 0; i < 18; ++i) {
                gfc.nsPsy.pefirbuf[i] = gfc.nsPsy.pefirbuf[i + 1];
            }
            float f = 0.0f;
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    f += pe_use[gr][ch];
                }
            }
            gfc.nsPsy.pefirbuf[18] = f;
            f = gfc.nsPsy.pefirbuf[9];
            for (i = 0; i < 9; ++i) {
                f += (gfc.nsPsy.pefirbuf[i] + gfc.nsPsy.pefirbuf[18 - i]) * fircoef[i];
            }
            f = (float)(3350 * gfc.mode_gr * gfc.channels_out) / f;
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                ch = 0;
                while (ch < gfc.channels_out) {
                    float[] fArray = pe_use[gr];
                    int n = ch++;
                    fArray[n] = fArray[n] * f;
                }
            }
        }
        gfc.iteration_loop.iteration_loop(gfp, pe_use, ms_ener_ratio, masking);
        this.bs.format_bitstream(gfp);
        int mp3count = this.bs.copy_buffer(gfc, mp3buf, mp3bufPos, mp3buf_size, 1);
        if (gfp.bWriteVbrTag) {
            this.vbr.addVbrFrame(gfp);
        }
        if (gfp.analysis && gfc.pinfo != null) {
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                int j;
                for (j = 0; j < 272; ++j) {
                    gfc.pinfo.pcmdata[ch][j] = gfc.pinfo.pcmdata[ch][j + gfp.getFrameSize()];
                }
                for (j = 272; j < 1600; ++j) {
                    gfc.pinfo.pcmdata[ch][j] = inbuf[ch][j - 272];
                }
            }
            this.qupvt.set_frame_pinfo(gfp, masking);
        }
        this.updateStats(gfc);
        return mp3count;
    }
}

