/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.lowlevel;

import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.lame.mp3.Lame;
import net.sourceforge.lame.mp3.MPEGMode;
import net.sourceforge.lame.mp3.VbrMode;
import net.sourceforge.lame.mp3.Version;

public class LameEncoder {
    public static final AudioFormat.Encoding MPEG1L3 = new AudioFormat.Encoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L3 = new AudioFormat.Encoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = new AudioFormat.Encoding("MPEG2DOT5L3");
    public static final String P_VBR = "vbr";
    public static final String P_CHMODE = "chmode";
    public static final String P_BITRATE = "bitrate";
    public static final String P_QUALITY = "quality";
    public static final int MPEG_VERSION_2 = 0;
    public static final int MPEG_VERSION_1 = 1;
    public static final int MPEG_VERSION_2DOT5 = 2;
    public static final int BITRATE_AUTO = -1;
    public static int DEFAULT_BITRATE = -1;
    private int bitRate = DEFAULT_BITRATE;
    private static final int DEFAULT_PCM_BUFFER_SIZE = 32768;
    public static int DEFAULT_QUALITY = 5;
    private int quality = DEFAULT_QUALITY;
    public static boolean DEFAULT_VBR = false;
    private boolean vbrMode = DEFAULT_VBR;
    private Lame lame = new Lame();
    private Version version = new Version();
    private int sampleSizeInBits;
    private ByteOrder byteOrder;
    private MPEGMode chMode;
    private int effQuality;
    private int effBitRate;
    private VbrMode effVbr;
    private MPEGMode effChMode;
    private int effSampleRate;
    private int effEncoding;

    public LameEncoder(AudioFormat sourceFormat) {
        this.readParams(sourceFormat, null);
        this.initParams(sourceFormat);
    }

    public LameEncoder(AudioFormat sourceFormat, AudioFormat targetFormat) {
        this.readParams(sourceFormat, targetFormat.properties());
        this.initParams(sourceFormat);
    }

    public LameEncoder(AudioFormat sourceFormat, int bitRate, MPEGMode channelMode, int quality, boolean VBR) {
        this.bitRate = bitRate;
        this.chMode = channelMode;
        this.quality = quality;
        this.vbrMode = VBR;
        this.initParams(sourceFormat);
    }

    private void readParams(AudioFormat sourceFormat, Map<String, Object> props) {
        if (props != null) {
            this.readProps(props);
        }
    }

    private void initParams(AudioFormat sourceFormat) {
        int result;
        this.sampleSizeInBits = sourceFormat.getSampleSizeInBits();
        ByteOrder byteOrder = this.byteOrder = sourceFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        if (sourceFormat.getSampleRate() < 32000.0f && this.bitRate > 160) {
            this.bitRate = 160;
        }
        if ((result = this.initParams(sourceFormat.getChannels(), Math.round(sourceFormat.getSampleRate()), this.bitRate, this.chMode, this.quality, this.vbrMode, sourceFormat.isBigEndian())) < 0) {
            throw new IllegalArgumentException("parameters not supported by LAME (returned " + result + ")");
        }
    }

    private int initParams(int channels, int sampleRate, int bitrate, MPEGMode mode, int quality, boolean VBR, boolean bigEndian) {
        this.lame.getFlags().setInNumChannels(channels);
        this.lame.getFlags().setInSampleRate(sampleRate);
        this.lame.getFlags().setMode(mode);
        if (VBR) {
            this.lame.getFlags().setVBR(VbrMode.vbr_default);
            this.lame.getFlags().setVBRQuality(quality);
        } else if (bitrate != -1) {
            this.lame.getFlags().setBitRate(bitrate);
        }
        this.lame.getFlags().setQuality(quality);
        this.lame.getId3().init(this.lame.getFlags());
        this.lame.getFlags().setWriteId3tagAutomatic(false);
        this.lame.getFlags().setFindReplayGain(true);
        int rc = this.lame.initParams();
        this.effSampleRate = this.lame.getFlags().getOutSampleRate();
        this.effBitRate = this.lame.getFlags().getBitRate();
        this.effChMode = this.lame.getFlags().getMode();
        this.effVbr = this.lame.getFlags().getVBR();
        this.effQuality = VBR ? this.lame.getFlags().getVBRQuality() : this.lame.getFlags().getQuality();
        return rc;
    }

    public final String getEncoderVersion() {
        return this.version.getLameVersion();
    }

    public final int getPCMBufferSize() {
        return 32768;
    }

    public final int getMP3BufferSize() {
        return this.getPCMBufferSize() / 2 + 1024;
    }

    private int doEncodeBuffer(byte[] pcm, int pcmOffset, int length, byte[] encoded) {
        float[][] buffer;
        int samplesRead;
        block21: {
            int sampleBufferPos;
            int[] sampleBuffer;
            block20: {
                int i;
                int bytesPerSample = this.sampleSizeInBits >> 3;
                samplesRead = length / bytesPerSample;
                sampleBuffer = new int[samplesRead];
                sampleBufferPos = samplesRead;
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    if (bytesPerSample == 1) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 24;
                        }
                    }
                    if (bytesPerSample == 2) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 16 | (pcm[pcmOffset + i + 1] & 0xFF) << 24;
                        }
                    }
                    if (bytesPerSample == 3) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 8 | (pcm[pcmOffset + i + 1] & 0xFF) << 16 | (pcm[pcmOffset + i + 2] & 0xFF) << 24;
                        }
                    }
                    if (bytesPerSample == 4) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = pcm[pcmOffset + i] & 0xFF | (pcm[pcmOffset + i + 1] & 0xFF) << 8 | (pcm[pcmOffset + i + 2] & 0xFF) << 16 | (pcm[pcmOffset + i + 3] & 0xFF) << 24;
                        }
                    }
                } else {
                    if (bytesPerSample == 1) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF ^ 0x80) << 24 | 0x7F0000;
                        }
                    }
                    if (bytesPerSample == 2) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 24 | (pcm[pcmOffset + i + 1] & 0xFF) << 16;
                        }
                    }
                    if (bytesPerSample == 3) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 24 | (pcm[pcmOffset + i + 1] & 0xFF) << 16 | (pcm[pcmOffset + i + 2] & 0xFF) << 8;
                        }
                    }
                    if (bytesPerSample == 4) {
                        i = samplesRead * bytesPerSample;
                        while ((i -= bytesPerSample) >= 0) {
                            sampleBuffer[--sampleBufferPos] = (pcm[pcmOffset + i] & 0xFF) << 24 | (pcm[pcmOffset + i + 1] & 0xFF) << 16 | (pcm[pcmOffset + i + 2] & 0xFF) << 8 | pcm[pcmOffset + i + 3] & 0xFF;
                        }
                    }
                }
                sampleBufferPos = samplesRead;
                buffer = new float[2][samplesRead /= this.lame.getFlags().getInNumChannels()];
                if (this.lame.getFlags().getInNumChannels() != 2) break block20;
                int i2 = samplesRead;
                while (--i2 >= 0) {
                    buffer[1][i2] = sampleBuffer[--sampleBufferPos];
                    buffer[0][i2] = sampleBuffer[--sampleBufferPos];
                }
                break block21;
            }
            if (this.lame.getFlags().getInNumChannels() != 1) break block21;
            Arrays.fill(buffer[1], 0, samplesRead, 0.0f);
            int i = samplesRead;
            while (--i >= 0) {
                float f = sampleBuffer[--sampleBufferPos];
                buffer[1][i] = f;
                buffer[0][i] = f;
            }
        }
        return this.lame.encodeBuffer(buffer[0], buffer[1], samplesRead, encoded);
    }

    public final int encodeBuffer(byte[] pcm, int pcmOffset, int pcmLength, byte[] encoded) throws ArrayIndexOutOfBoundsException {
        if (pcmLength < 0 || pcmOffset + pcmLength > pcm.length) {
            throw new IllegalArgumentException("inconsistent parameters");
        }
        int result = this.doEncodeBuffer(pcm, pcmOffset, pcmLength, encoded);
        if (result < 0) {
            if (result == -1) {
                throw new ArrayIndexOutOfBoundsException("Encode buffer too small");
            }
            throw new RuntimeException("crucial error in encodeBuffer.");
        }
        return result;
    }

    public final int encodeFinish(byte[] encoded) {
        return this.lame.encodeFlush(encoded);
    }

    public final void close() {
        this.lame.close();
    }

    private void readProps(Map<String, Object> props) {
        this.quality = (Integer)props.get(P_QUALITY);
        this.bitRate = (Integer)props.get(P_BITRATE);
        this.chMode = (MPEGMode)((Object)props.get(P_CHMODE));
        this.vbrMode = (Boolean)props.get(P_VBR);
    }

    public final AudioFormat getEffectiveFormat() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUALITY, this.getEffectiveQuality());
        map.put(P_BITRATE, this.getEffectiveBitRate());
        map.put(P_CHMODE, (Object)this.getEffectiveChannelMode());
        map.put(P_VBR, this.getEffectiveVBR());
        map.put("encoder.name", "LAME");
        map.put("encoder.version", this.getEncoderVersion());
        int channels = this.chMode == MPEGMode.MONO ? 1 : 2;
        return new AudioFormat(this.getEffectiveEncoding(), this.getEffectiveSampleRate(), -1, channels, -1, -1.0f, false, map);
    }

    public final int getEffectiveQuality() {
        if (this.effQuality >= 9) {
            return 9;
        }
        if (this.effQuality >= 7) {
            return 7;
        }
        if (this.effQuality >= 5) {
            return 5;
        }
        if (this.effQuality >= 2) {
            return 2;
        }
        return 1;
    }

    public final int getEffectiveBitRate() {
        return this.effBitRate;
    }

    public final MPEGMode getEffectiveChannelMode() {
        return this.effChMode;
    }

    public final boolean getEffectiveVBR() {
        return this.effVbr != VbrMode.vbr_off;
    }

    public final int getEffectiveSampleRate() {
        return this.effSampleRate;
    }

    public final AudioFormat.Encoding getEffectiveEncoding() {
        if (this.effEncoding == 0) {
            if (this.getEffectiveSampleRate() < 16000) {
                return MPEG2DOT5L3;
            }
            return MPEG2L3;
        }
        if (this.effEncoding == 2) {
            return MPEG2DOT5L3;
        }
        return MPEG1L3;
    }
}

