/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.lowlevel;

import java.nio.ByteBuffer;
import net.sourceforge.lame.mp3.FrameSkip;
import net.sourceforge.lame.mp3.GetAudio;
import net.sourceforge.lame.mp3.Lame;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.MP3Data;

public class LameDecoder {
    private Lame lame = new Lame();

    public LameDecoder(String mp3File) {
        this.lame.getFlags().setWriteId3tagAutomatic(false);
        this.lame.initParams();
        this.lame.getParser().setInputFormat(GetAudio.SoundFileFormat.sf_mp3);
        FrameSkip frameSkip = new FrameSkip();
        this.lame.getAudio().initInFile(this.lame.getFlags(), mp3File, frameSkip);
        int skipStart = 0;
        int skipEnd = 0;
        if (this.lame.getParser().silent < 10) {
            System.out.printf("\rinput:  %s%s(%g kHz, %d channel%s, ", mp3File, mp3File.length() > 26 ? "\n\t" : "  ", (double)this.lame.getFlags().getInSampleRate() / 1000.0, this.lame.getFlags().getInNumChannels(), this.lame.getFlags().getInNumChannels() != 1 ? "s" : "");
        }
        if (frameSkip.getEncoderDelay() > -1 || frameSkip.getEncoderPadding() > -1) {
            if (frameSkip.getEncoderDelay() > -1) {
                skipStart = frameSkip.getEncoderDelay() + 528 + 1;
            }
            if (frameSkip.getEncoderPadding() > -1) {
                skipEnd = frameSkip.getEncoderPadding() - 529;
            }
        } else {
            skipStart = this.lame.getFlags().getEncoderDelay() + 528 + 1;
        }
        System.out.printf("MPEG-%d%s Layer %s", 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", "III");
        System.out.printf(")\noutput: (16 bit, Microsoft WAVE)\n", new Object[0]);
        if (skipStart > 0) {
            System.out.printf("skipping initial %d samples (encoder+decoder delay)\n", skipStart);
        }
        if (skipEnd > 0) {
            System.out.printf("skipping final %d samples (encoder padding-decoder delay)\n", skipEnd);
        }
        int totalFrames = this.lame.getParser().getMp3InputData().getNumSamples() / this.lame.getParser().getMp3InputData().getFrameSize();
        this.lame.getParser().getMp3InputData().setTotalFrames(totalFrames);
        assert (this.lame.getFlags().getInNumChannels() >= 1 && this.lame.getFlags().getInNumChannels() <= 2);
    }

    public final boolean decode(ByteBuffer sampleBuffer) {
        float[][] buffer = new float[2][1152];
        LameGlobalFlags flags = this.lame.getFlags();
        int iread = this.lame.getAudio().get_audio16(flags, buffer);
        if (iread >= 0) {
            MP3Data mp3InputData = this.lame.getParser().getMp3InputData();
            int framesDecodedCounter = mp3InputData.getFramesDecodedCounter() + iread / mp3InputData.getFrameSize();
            mp3InputData.setFramesDecodedCounter(framesDecodedCounter);
            for (int i = 0; i < iread; ++i) {
                int sample = (int)buffer[0][i] & 0xFFFF;
                sampleBuffer.array()[(i << flags.getInNumChannels()) + 0] = (byte)(sample & 0xFF);
                sampleBuffer.array()[(i << flags.getInNumChannels()) + 1] = (byte)(sample >> 8 & 0xFF);
                if (flags.getInNumChannels() != 2) continue;
                sample = (int)buffer[1][i] & 0xFFFF;
                sampleBuffer.array()[(i << flags.getInNumChannels()) + 2] = (byte)(sample & 0xFF);
                sampleBuffer.array()[(i << flags.getInNumChannels()) + 3] = (byte)(sample >> 8 & 0xFF);
            }
        }
        return iread > 0;
    }

    public final void close() {
        this.lame.close();
    }

    public final int getChannels() {
        return this.lame.getFlags().getInNumChannels();
    }

    public final int getSampleRate() {
        return this.lame.getFlags().getInSampleRate();
    }

    public final int getFrameSize() {
        return this.lame.getFlags().getFrameSize();
    }
}

