/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import org.usb4java.EndpointDescriptor;
import org.usb4java.InterfaceDescriptor;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.Configuration;
import org.usb4java.javax.Endpoint;
import org.usb4java.javax.descriptors.SimpleUsbInterfaceDescriptor;

final class Interface
implements UsbInterface {
    private final Configuration configuration;
    private final UsbInterfaceDescriptor descriptor;
    private final Map<Byte, Endpoint> endpoints = new HashMap<Byte, Endpoint>();

    Interface(Configuration configuration, InterfaceDescriptor descriptor) {
        this.configuration = configuration;
        this.descriptor = new SimpleUsbInterfaceDescriptor(descriptor);
        for (EndpointDescriptor endpointDescriptor : descriptor.endpoint()) {
            Endpoint endpoint = new Endpoint(this, endpointDescriptor);
            this.endpoints.put(endpointDescriptor.bEndpointAddress(), endpoint);
        }
    }

    private void checkActive() {
        if (!this.configuration.isActive()) {
            throw new UsbNotActiveException("Configuration is not active");
        }
        if (!this.isActive()) {
            throw new UsbNotActiveException("Setting is not active");
        }
    }

    private void checkConnected() {
        this.configuration.getUsbDevice().checkConnected();
    }

    public void claim() throws UsbException {
        this.claim(null);
    }

    public void claim(UsbInterfacePolicy policy) throws UsbException {
        this.checkActive();
        this.checkConnected();
        AbstractDevice device = this.configuration.getUsbDevice();
        device.claimInterface(this.descriptor.bInterfaceNumber(), policy != null && policy.forceClaim((UsbInterface)this));
        this.configuration.setUsbInterface(this.descriptor.bInterfaceNumber(), this);
    }

    public void release() throws UsbException {
        this.checkActive();
        this.checkConnected();
        this.configuration.getUsbDevice().releaseInterface(this.descriptor.bInterfaceNumber());
    }

    public boolean isClaimed() {
        return this.configuration.getUsbDevice().isInterfaceClaimed(this.descriptor.bInterfaceNumber());
    }

    public boolean isActive() {
        return this.configuration.getUsbInterface(this.descriptor.bInterfaceNumber()) == this;
    }

    public int getNumSettings() {
        return this.configuration.getNumSettings(this.descriptor.bInterfaceNumber());
    }

    public byte getActiveSettingNumber() {
        this.checkActive();
        return this.configuration.getUsbInterface(this.descriptor.bInterfaceNumber()).getUsbInterfaceDescriptor().bAlternateSetting();
    }

    public Interface getActiveSetting() {
        this.checkActive();
        return this.configuration.getUsbInterface(this.descriptor.bInterfaceNumber());
    }

    public Interface getSetting(byte number) {
        return this.configuration.getSettings(this.descriptor.bInterfaceNumber()).get(number & 0xFF);
    }

    public boolean containsSetting(byte number) {
        return this.configuration.getSettings(this.descriptor.bInterfaceNumber()).containsKey(number & 0xFF);
    }

    public List<Interface> getSettings() {
        return Collections.unmodifiableList(new ArrayList<Interface>(this.configuration.getSettings(this.descriptor.bInterfaceNumber()).values()));
    }

    public List<Endpoint> getUsbEndpoints() {
        return Collections.unmodifiableList(new ArrayList<Endpoint>(this.endpoints.values()));
    }

    public Endpoint getUsbEndpoint(byte address) {
        return this.endpoints.get(address);
    }

    public boolean containsUsbEndpoint(byte address) {
        return this.endpoints.containsKey(address);
    }

    public Configuration getUsbConfiguration() {
        return this.configuration;
    }

    public UsbInterfaceDescriptor getUsbInterfaceDescriptor() {
        return this.descriptor;
    }

    public String getInterfaceString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte iInterface = this.descriptor.iInterface();
        if (iInterface == 0) {
            return null;
        }
        return this.configuration.getUsbDevice().getString(iInterface);
    }

    public String toString() {
        return String.format("USB interface %02x", this.descriptor.bInterfaceNumber());
    }
}

