#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for Java Runtime Environment (JRE) STIG
#
# Profile Description:
# The Java Runtime Environment (JRE) is a bundle developed
# and offered by Oracle Corporation which includes the Java Virtual Machine
# (JVM), class libraries, and other components necessary to run Java
# applications and applets. Certain default settings within the JRE pose
# a security risk so it is necessary to deploy system wide properties to
# ensure a higher degree of security when utilizing the JRE.
# The IBM Corporation also develops and bundles the Java Runtime Environment
# (JRE) as well as Red Hat with OpenJDK.
#
# Profile ID:  stig
# Benchmark ID:  JRE
# Benchmark Version:  0.1.60
# XCCDF Version:  1.1
#
# This file was generated by OpenSCAP 1.3.5 using:
# $ oscap xccdf generate fix --profile stig --fix-type bash xccdf-file.xml
#
# This Bash Remediation Script is generated from an OpenSCAP profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 26) for 'java_jre_blacklist_check'
###############################################################################
(>&2 echo "Remediating rule 1/26: 'java_jre_blacklist_check'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.blacklist.check=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.blacklist.check=.*/deployment.security.blacklist.check=true/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.blacklist.check=true" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_blacklist_check'

###############################################################################
# BEGIN fix (2 / 26) for 'java_jre_blacklist_check_locked'
###############################################################################
(>&2 echo "Remediating rule 2/26: 'java_jre_blacklist_check_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.webjava.enabled.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.webjava.enabled.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_blacklist_check_locked'

###############################################################################
# BEGIN fix (3 / 26) for 'java_jre_clean_previous_version'
###############################################################################
(>&2 echo "Remediating rule 3/26: 'java_jre_clean_previous_version'")

if grep --silent ^clean_requirements_on_remove /etc/yum.conf ; then
        sed -i "s/^clean_requirements_on_remove.*/clean_requirements_on_remove=1/g" /etc/yum.conf
else
        echo -e "\n# Set clean_requirements_on_remove to 1 per security requirements" >> /etc/yum.conf
        echo "clean_requirements_on_remove=1" >> /etc/yum.conf
fi

# END fix for 'java_jre_clean_previous_version'

###############################################################################
# BEGIN fix (4 / 26) for 'java_jre_deployment_properties_exists'
###############################################################################
(>&2 echo "Remediating rule 4/26: 'java_jre_deployment_properties_exists'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

chmod 644 ${JAVA_PROPERTIES}

# END fix for 'java_jre_deployment_properties_exists'

###############################################################################
# BEGIN fix (5 / 26) for 'java_jre_disable_untrusted_sources'
###############################################################################
(>&2 echo "Remediating rule 5/26: 'java_jre_disable_untrusted_sources'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.askgrantdialog.notinca=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.askgrantdialog.notinca=.*/deployment.security.askgrantdialog.notinca=false/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.askgrantdialog.notinca=false" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_disable_untrusted_sources'

###############################################################################
# BEGIN fix (6 / 26) for 'java_jre_disable_untrusted_sources_locked'
###############################################################################
(>&2 echo "Remediating rule 6/26: 'java_jre_disable_untrusted_sources_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.askgrantdialog.notinca.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.askgrantdialog.notinca.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_disable_untrusted_sources_locked'

###############################################################################
# BEGIN fix (7 / 26) for 'java_jre_enable_jws'
###############################################################################
(>&2 echo "Remediating rule 7/26: 'java_jre_enable_jws'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.webjava.enabled=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.webjava.enabled=.*/deployment.webjava.enabled=true/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.webjava.enabled=true" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_enable_jws'

###############################################################################
# BEGIN fix (8 / 26) for 'java_jre_enable_jws_locked'
###############################################################################
(>&2 echo "Remediating rule 8/26: 'java_jre_enable_jws_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.webjava.enabled.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.webjava.enabled.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_enable_jws_locked'

###############################################################################
# BEGIN fix (9 / 26) for 'java_jre_insecure_prompt'
###############################################################################
(>&2 echo "Remediating rule 9/26: 'java_jre_insecure_prompt'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.insecure.jres=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.insecure.jres=.*/deployment.insecure.jres=PROMPT/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.insecure.jres=PROMPT" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_insecure_prompt'

###############################################################################
# BEGIN fix (10 / 26) for 'java_jre_insecure_prompt_locked'
###############################################################################
(>&2 echo "Remediating rule 10/26: 'java_jre_insecure_prompt_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.insecure.jres.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.insecure.jres.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_insecure_prompt_locked'

###############################################################################
# BEGIN fix (11 / 26) for 'java_jre_lock_untrusted_sources'
###############################################################################
(>&2 echo "Remediating rule 11/26: 'java_jre_lock_untrusted_sources'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.askgrantdialog.show=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.askgrantdialog.show=.*/deployment.security.askgrantdialog.show=false/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.askgrantdialog.show=false" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_lock_untrusted_sources'

###############################################################################
# BEGIN fix (12 / 26) for 'java_jre_lock_untrusted_sources_locked'
###############################################################################
(>&2 echo "Remediating rule 12/26: 'java_jre_lock_untrusted_sources_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.askgrantdialog.show.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.askgrantdialog.show.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_lock_untrusted_sources_locked'

###############################################################################
# BEGIN fix (13 / 26) for 'java_jre_security_revocation_check'
###############################################################################
(>&2 echo "Remediating rule 13/26: 'java_jre_security_revocation_check'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.revocation.check=.*" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.revocation.check=.*/deployment.security.revocation.check=ALL_CERTIFICATES/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.revocation.check=ALL_CERTIFICATES" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_security_revocation_check'

###############################################################################
# BEGIN fix (14 / 26) for 'java_jre_security_revocation_check_locked'
###############################################################################
(>&2 echo "Remediating rule 14/26: 'java_jre_security_revocation_check_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.revocation.check.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.revocation.check.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_security_revocation_check_locked'

###############################################################################
# BEGIN fix (15 / 26) for 'java_jre_unsigned_applications'
###############################################################################
(>&2 echo "Remediating rule 15/26: 'java_jre_unsigned_applications'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.level=.*$" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.level=.*/deployment.security.level=VERY_HIGH/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.level=VERY_HIGH" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_unsigned_applications'

###############################################################################
# BEGIN fix (16 / 26) for 'java_jre_unsigned_applications_locked'
###############################################################################
(>&2 echo "Remediating rule 16/26: 'java_jre_unsigned_applications_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.level.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.level.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_unsigned_applications_locked'

###############################################################################
# BEGIN fix (17 / 26) for 'java_jre_updated'
###############################################################################
(>&2 echo "Remediating rule 17/26: 'java_jre_updated'")


yum -y update

# END fix for 'java_jre_updated'

###############################################################################
# BEGIN fix (18 / 26) for 'java_jre_validation_crl'
###############################################################################
(>&2 echo "Remediating rule 18/26: 'java_jre_validation_crl'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.validation.crl=.*" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.validation.crl=.*/deployment.security.validation.crl=true/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.validation.crl=true" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_validation_crl'

###############################################################################
# BEGIN fix (19 / 26) for 'java_jre_validation_crl_locked'
###############################################################################
(>&2 echo "Remediating rule 19/26: 'java_jre_validation_crl_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.validation.crl.locked$" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.validation.crl.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_validation_crl_locked'

###############################################################################
# BEGIN fix (20 / 26) for 'java_jre_validation_ocsp'
###############################################################################
(>&2 echo "Remediating rule 20/26: 'java_jre_validation_ocsp'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.validation.ocsp=.*" ${JAVA_PROPERTIES} && \
sed -i "s/deployment.security.validation.ocsp=.*/deployment.security.validation.ocsp=true/g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.security.validation.ocsp=true" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_validation_ocsp'

###############################################################################
# BEGIN fix (21 / 26) for 'java_jre_validation_ocsp_locked'
###############################################################################
(>&2 echo "Remediating rule 21/26: 'java_jre_validation_ocsp_locked'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

grep -q "^deployment.security.validation.ocsp.locked$" ${JAVA_PROPERTIES}

if ! [ $? -eq 0 ] ; then
  echo "deployment.security.validation.ocsp.locked" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_validation_ocsp_locked'

###############################################################################
# BEGIN fix (22 / 26) for 'java_jre_accepted_sites_exists'
###############################################################################
(>&2 echo "Remediating rule 22/26: 'java_jre_accepted_sites_exists'")
JAVA_FILE="/etc/.java/deployment/exception.sites"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_FILE} ]; then
  touch ${JAVA_FILE} && chmod 644 ${JAVA_FILE}
fi

chmod 644 ${JAVA_FILE}

# END fix for 'java_jre_accepted_sites_exists'

###############################################################################
# BEGIN fix (23 / 26) for 'java_jre_accepted_sites_properties'
###############################################################################
(>&2 echo "Remediating rule 23/26: 'java_jre_accepted_sites_properties'")
JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_PROPERTIES} ]; then
  touch ${JAVA_PROPERTIES} && chmod 644 ${JAVA_PROPERTIES}
fi

JAVA_FILE="/etc/.java/deployment/exception.sites"

grep -q "^deployment.user.security.exception.sites=.*" ${JAVA_PROPERTIES} && \
sed -i "s;deployment.user.security.exception.sites=.*;deployment.user.security.exception.sites=${JAVA_FILE};g" ${JAVA_PROPERTIES}
if ! [ $? -eq 0 ] ; then
  echo "deployment.user.security.exception.sites=${JAVA_FILE}" >> ${JAVA_PROPERTIES}
fi

# END fix for 'java_jre_accepted_sites_properties'

###############################################################################
# BEGIN fix (24 / 26) for 'java_jre_deployment_config_exists'
###############################################################################
(>&2 echo "Remediating rule 24/26: 'java_jre_deployment_config_exists'")
JAVA_CONFIG="/etc/.java/deployment/deployment.config"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_CONFIG} ]; then
  touch ${JAVA_CONFIG} && chmod 644 ${JAVA_CONFIG}
fi

chmod 644 ${JAVA_CONFIG}

# END fix for 'java_jre_deployment_config_exists'

###############################################################################
# BEGIN fix (25 / 26) for 'java_jre_deployment_config_mandatory'
###############################################################################
(>&2 echo "Remediating rule 25/26: 'java_jre_deployment_config_mandatory'")
JAVA_CONFIG="/etc/.java/deployment/deployment.config"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_CONFIG} ]; then
  touch ${JAVA_CONFIG} && chmod 644 ${JAVA_CONFIG}
fi

grep -q "^deployment.system.config.mandatory=.*" ${JAVA_CONFIG} && \
sed -i "s/deployment.system.config.mandatory=.*/deployment.system.config.mandatory=true/g" ${JAVA_CONFIG}
if ! [ $? -eq 0 ] ; then
  echo "deployment.system.config.mandatory=true" >> ${JAVA_CONFIG}
fi

# END fix for 'java_jre_deployment_config_mandatory'

###############################################################################
# BEGIN fix (26 / 26) for 'java_jre_deployment_config_properties'
###############################################################################
(>&2 echo "Remediating rule 26/26: 'java_jre_deployment_config_properties'")
JAVA_CONFIG="/etc/.java/deployment/deployment.config"
JAVA_DIR="/etc/.java/deployment"

if [ ! -d ${JAVA_DIR} ] ; then
  mkdir -p -m 755 ${JAVA_DIR}
fi

if [ ! -e ${JAVA_CONFIG} ]; then
  touch ${JAVA_CONFIG} && chmod 644 ${JAVA_CONFIG}
fi

JAVA_PROPERTIES="/etc/.java/deployment/deployment.properties"

grep -q "^deployment.system.config=.*" ${JAVA_CONFIG} && \
sed -i "s;deployment.system.config=.*;deployment.system.config=file:\/\/${JAVA_PROPERTIES};g" ${JAVA_CONFIG}
if ! [ $? -eq 0 ] ; then
  echo "deployment.system.config=file://${JAVA_PROPERTIES}" >> ${JAVA_CONFIG}
fi

# END fix for 'java_jre_deployment_config_properties'

