#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for Upstream Firefox STIG
#
# Profile Description:
# This profile is developed under the DoD consensus model and DISA FSO Vendor STIG process,
# serving as the upstream development environment for the Firefox STIG.
# As a result of the upstream/downstream relationship between the SCAP Security Guide project
# and the official DISA FSO STIG baseline, users should expect variance between SSG and DISA FSO content.
# For official DISA FSO STIG content, refer to https://public.cyber.mil/stigs/downloads/?_dl_facet_stigs=app-security%2Cbrowser-guidance.
# While this profile is packaged by Red Hat as part of the SCAP Security Guide package, please note
# that commercial support of this SCAP content is NOT available. This profile is provided as example
# SCAP content with no endorsement for suitability or production readiness. Support for this
# profile is provided by the upstream SCAP Security Guide community on a best-effort basis. The
# upstream project homepage is https://www.open-scap.org/security-policies/scap-security-guide/.
#
# Profile ID:  stig
# Benchmark ID:  FIREFOX
# Benchmark Version:  0.1.60
# XCCDF Version:  1.1
#
# This file was generated by OpenSCAP 1.3.5 using:
# $ oscap xccdf generate fix --profile stig --fix-type bash xccdf-file.xml
#
# This Bash Remediation Script is generated from an OpenSCAP profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 22) for 'firefox_preferences-addons_plugin_updates'
###############################################################################
(>&2 echo "Remediating rule 1/22: 'firefox_preferences-addons_plugin_updates'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("extensions.update.enabled", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("extensions.update.enabled".*/lockPref("extensions.update.enabled", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("extensions.update.enabled", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-addons_plugin_updates'

###############################################################################
# BEGIN fix (2 / 22) for 'firefox_preferences-auto-download_actions'
###############################################################################
(>&2 echo "Remediating rule 2/22: 'firefox_preferences-auto-download_actions'")


firefox_cfg="mozilla.cfg"
value="true"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("browser.helperApps.alwaysAsk.force", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("browser.helperApps.alwaysAsk.force".*/lockPref("browser.helperApps.alwaysAsk.force", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("browser.helperApps.alwaysAsk.force", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-auto-download_actions'

###############################################################################
# BEGIN fix (3 / 22) for 'firefox_preferences-autofill_forms'
###############################################################################
(>&2 echo "Remediating rule 3/22: 'firefox_preferences-autofill_forms'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("browser.formfill.enable", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("browser.formfill.enable".*/lockPref("browser.formfill.enable", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("browser.formfill.enable", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-autofill_forms'

###############################################################################
# BEGIN fix (4 / 22) for 'firefox_preferences-autofill_passwords'
###############################################################################
(>&2 echo "Remediating rule 4/22: 'firefox_preferences-autofill_passwords'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("signon.autofillForms", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("signon.autofillForms".*/lockPref("signon.autofillForms", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("signon.autofillForms", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-autofill_passwords'

###############################################################################
# BEGIN fix (5 / 22) for 'firefox_preferences-background_data'
###############################################################################
(>&2 echo "Remediating rule 5/22: 'firefox_preferences-background_data'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("datareporting.policy.dataSubmissionEnabled", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("datareporting.policy.dataSubmissionEnabled".*/lockPref("datareporting.policy.dataSubmissionEnabled", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("datareporting.policy.dataSubmissionEnabled", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-background_data'

###############################################################################
# BEGIN fix (6 / 22) for 'firefox_preferences-development_tools'
###############################################################################
(>&2 echo "Remediating rule 6/22: 'firefox_preferences-development_tools'")


firefox_cfg="mozilla.cfg"
value="true"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("devtools.policy.disabled", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("devtools.policy.disabled".*/lockPref("devtools.policy.disabled", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("devtools.policy.disabled", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-development_tools'

###############################################################################
# BEGIN fix (7 / 22) for 'firefox_preferences-install_extensions'
###############################################################################
(>&2 echo "Remediating rule 7/22: 'firefox_preferences-install_extensions'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("xpinstall.enabled", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("xpinstall.enabled".*/lockPref("xpinstall.enabled", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("xpinstall.enabled", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-install_extensions'

###############################################################################
# BEGIN fix (8 / 22) for 'firefox_preferences-javascript_context_menus'
###############################################################################
(>&2 echo "Remediating rule 8/22: 'firefox_preferences-javascript_context_menus'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("dom.event.contextmenu.enabled", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("dom.event.contextmenu.enabled".*/lockPref("dom.event.contextmenu.enabled", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("dom.event.contextmenu.enabled", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-javascript_context_menus'

###############################################################################
# BEGIN fix (9 / 22) for 'firefox_preferences-javascript_window_changes'
###############################################################################
(>&2 echo "Remediating rule 9/22: 'firefox_preferences-javascript_window_changes'")


firefox_cfg="mozilla.cfg"
value="true"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("dom.disable_window_flip", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("dom.disable_window_flip".*/lockPref("dom.disable_window_flip", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("dom.disable_window_flip", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-javascript_window_changes'

###############################################################################
# BEGIN fix (10 / 22) for 'firefox_preferences-javascript_window_resizing'
###############################################################################
(>&2 echo "Remediating rule 10/22: 'firefox_preferences-javascript_window_resizing'")


firefox_cfg="mozilla.cfg"
value="true"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("dom.disable_window_move_resize", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("dom.disable_window_move_resize".*/lockPref("dom.disable_window_move_resize", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("dom.disable_window_move_resize", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-javascript_window_resizing'

###############################################################################
# BEGIN fix (11 / 22) for 'firefox_preferences-open_confirmation'
###############################################################################
(>&2 echo "Remediating rule 11/22: 'firefox_preferences-open_confirmation'")

var_required_file_types='application/pdf,application/fdf,application/xfdf,application/lsl,application/lso,application/lss,application/iqy,application/rqy,application/xlk,application/xls,application/xlt,application/pot,application/pps,application/ppt,application/dos,application/dot,application/wks,application/bat,application/ps,application/eps,application/wch,application/wcm,application/wb1,application/wb3,application/rtf,application/doc,application/mdb,application/mde,application/wbk,application/ad,application/adp'



firefox_cfg="mozilla.cfg"
value="\"${var_required_file_types}\""
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("plugin.disable_full_page_plugin_for_types", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's|lockPref("plugin.disable_full_page_plugin_for_types".*|lockPref("plugin.disable_full_page_plugin_for_types", '"$value)"';|g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("plugin.disable_full_page_plugin_for_types", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-open_confirmation'

###############################################################################
# BEGIN fix (12 / 22) for 'firefox_preferences-password_store'
###############################################################################
(>&2 echo "Remediating rule 12/22: 'firefox_preferences-password_store'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("signon.rememberSignons", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("signon.rememberSignons".*/lockPref("signon.rememberSignons", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("signon.rememberSignons", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-password_store'

###############################################################################
# BEGIN fix (13 / 22) for 'firefox_preferences-pop-up_windows'
###############################################################################
(>&2 echo "Remediating rule 13/22: 'firefox_preferences-pop-up_windows'")


firefox_cfg="mozilla.cfg"
value="true"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("dom.disable_window_open_feature.status", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("dom.disable_window_open_feature.status".*/lockPref("dom.disable_window_open_feature.status", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("dom.disable_window_open_feature.status", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-pop-up_windows'

###############################################################################
# BEGIN fix (14 / 22) for 'firefox_preferences-search_update'
###############################################################################
(>&2 echo "Remediating rule 14/22: 'firefox_preferences-search_update'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("browser.search.update", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("browser.search.update".*/lockPref("browser.search.update", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("browser.search.update", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-search_update'

###############################################################################
# BEGIN fix (15 / 22) for 'firefox_preferences-shell_protocol'
###############################################################################
(>&2 echo "Remediating rule 15/22: 'firefox_preferences-shell_protocol'")


firefox_cfg="mozilla.cfg"
value="false"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("network.protocol-handler.external.shell", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("network.protocol-handler.external.shell".*/lockPref("network.protocol-handler.external.shell", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("network.protocol-handler.external.shell", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-shell_protocol'

###############################################################################
# BEGIN fix (16 / 22) for 'firefox_preferences-ssl_protocol_tls'
###############################################################################
(>&2 echo "Remediating rule 16/22: 'firefox_preferences-ssl_protocol_tls'")


firefox_cfg="mozilla.cfg"
value="2"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("security.tls.version.min", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("security.tls.version.min".*/lockPref("security.tls.version.min", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("security.tls.version.min", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

firefox_cfg="mozilla.cfg"
value="4"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("security.tls.version.max", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("security.tls.version.max".*/lockPref("security.tls.version.max", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("security.tls.version.max", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-ssl_protocol_tls'

###############################################################################
# BEGIN fix (17 / 22) for 'firefox_preferences-verification'
###############################################################################
(>&2 echo "Remediating rule 17/22: 'firefox_preferences-verification'")


firefox_cfg="mozilla.cfg"
value="\"Ask Every Time\""
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Make sure the Firefox .cfg file exists and has the appropriate permissions
        if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
            echo "//" "${firefox_dir}/${firefox_cfg}"
            chmod 644 "${firefox_dir}/${firefox_cfg}"
        elif ! [ $(head -1 "${firefox_dir}/${firefox_cfg}" | grep "^//$") ]; then
            sed -i '1 i\//' "${firefox_dir}/${firefox_cfg}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^lockPref("security.default_personal_cert", ' "${firefox_dir}/${firefox_cfg}"; then
            
            sed -i 's/lockPref("security.default_personal_cert".*/lockPref("security.default_personal_cert", '"$value)"';/g' "${firefox_dir}/${firefox_cfg}"
        else
            echo 'lockPref("security.default_personal_cert", '"$value"');' >> "${firefox_dir}/${firefox_cfg}"
        fi
    fi
done

# END fix for 'firefox_preferences-verification'

###############################################################################
# BEGIN fix (18 / 22) for 'installed_firefox_version_supported'
###############################################################################
(>&2 echo "Remediating rule 18/22: 'installed_firefox_version_supported'")
(>&2 echo "FIX FOR THIS RULE 'installed_firefox_version_supported' IS MISSING!")

# END fix for 'installed_firefox_version_supported'

###############################################################################
# BEGIN fix (19 / 22) for 'firefox_preferences-dod_root_certificate_installed'
###############################################################################
(>&2 echo "Remediating rule 19/22: 'firefox_preferences-dod_root_certificate_installed'")
(>&2 echo "FIX FOR THIS RULE 'firefox_preferences-dod_root_certificate_installed' IS MISSING!")

# END fix for 'firefox_preferences-dod_root_certificate_installed'

###############################################################################
# BEGIN fix (20 / 22) for 'firefox_preferences-enable_ca_trust'
###############################################################################
(>&2 echo "Remediating rule 20/22: 'firefox_preferences-enable_ca_trust'")
P11=$(readlink /etc/alternatives/libnssckbi.so*)
P11LIB="/usr/lib/pkcs11/p11-kit-trust.so"
P11LIB64="/usr/lib64/pkcs11/p11-kit-trust.so"

if ! [[ ${P11} == "${P11LIB64}" ]] || ! [[ ${P11} == "${P11LIB}" ]] ; then
   /usr/bin/update-ca-trust enable
fi

# END fix for 'firefox_preferences-enable_ca_trust'

###############################################################################
# BEGIN fix (21 / 22) for 'firefox_preferences-lock_settings_config_file'
###############################################################################
(>&2 echo "Remediating rule 21/22: 'firefox_preferences-lock_settings_config_file'")


value="\"mozilla.cfg\""
firefox_js="local-settings.js"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"
firefox_pref="defaults/pref"
firefox_preferences="defaults/preferences"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Different versions of Firefox have different preferences directories, check for them and set the right one
        if [ -d "${firefox_dir}/${firefox_preferences}" ] ; then
            firefox_pref_dir="${firefox_dir}/${firefox_preferences}"
        elif [ -d "${firefox_dir}/${firefox_pref}" ] ; then
            firefox_pref_dir="${firefox_dir}/${firefox_pref}"
        else
            firefox_pref_dir="${firefox_dir}/${firefox_preferences}"
            mkdir -m 755 -p "${firefox_pref_dir}"
        fi

        # Make sure the Firefox .js file exists and has the appropriate permissions
        if ! [ -f "${firefox_pref_dir}/${firefox_js}" ] ; then
            touch "${firefox_pref_dir}/${firefox_js}"
            chmod 644 "${firefox_pref_dir}/${firefox_js}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^pref("general.config.filename", ' "${firefox_pref_dir}/${firefox_js}"; then
            
            sed -i 's/pref("general.config.filename".*/pref("general.config.filename", '"$value)"';/g' "${firefox_pref_dir}/${firefox_js}"
        else
            echo 'pref("general.config.filename", '"$value"');' >> "${firefox_pref_dir}/${firefox_js}"
        fi
    fi
done

# END fix for 'firefox_preferences-lock_settings_config_file'

###############################################################################
# BEGIN fix (22 / 22) for 'firefox_preferences-lock_settings_obscure'
###############################################################################
(>&2 echo "Remediating rule 22/22: 'firefox_preferences-lock_settings_obscure'")


value="0"
firefox_js="local-settings.js"
firefox_dirs="/usr/lib/firefox /usr/lib64/firefox /usr/local/lib/firefox /usr/local/lib64/firefox"
firefox_pref="defaults/pref"
firefox_preferences="defaults/preferences"

# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    # If the Firefox directory exists, then Firefox is installed
    if [ -d "${firefox_dir}" ]; then
        # Different versions of Firefox have different preferences directories, check for them and set the right one
        if [ -d "${firefox_dir}/${firefox_preferences}" ] ; then
            firefox_pref_dir="${firefox_dir}/${firefox_preferences}"
        elif [ -d "${firefox_dir}/${firefox_pref}" ] ; then
            firefox_pref_dir="${firefox_dir}/${firefox_pref}"
        else
            firefox_pref_dir="${firefox_dir}/${firefox_preferences}"
            mkdir -m 755 -p "${firefox_pref_dir}"
        fi

        # Make sure the Firefox .js file exists and has the appropriate permissions
        if ! [ -f "${firefox_pref_dir}/${firefox_js}" ] ; then
            touch "${firefox_pref_dir}/${firefox_js}"
            chmod 644 "${firefox_pref_dir}/${firefox_js}"
        fi

        # If the key exists, change it. Otherwise, add it to the config_file.
        if LC_ALL=C grep -m 1 -q '^pref("general.config.obscure_value", ' "${firefox_pref_dir}/${firefox_js}"; then
            
            sed -i 's/pref("general.config.obscure_value".*/pref("general.config.obscure_value", '"$value)"';/g' "${firefox_pref_dir}/${firefox_js}"
        else
            echo 'pref("general.config.obscure_value", '"$value"');' >> "${firefox_pref_dir}/${firefox_js}"
        fi
    fi
done

# END fix for 'firefox_preferences-lock_settings_obscure'

