#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for Upstream STIG for Google Chromium
#
# Profile Description:
# This profile is developed under the DoD consensus model and DISA FSO Vendor STIG process,
# serving as the upstream development environment for the Google Chromium STIG.
# As a result of the upstream/downstream relationship between the SCAP Security Guide project
# and the official DISA FSO STIG baseline, users should expect variance between SSG and DISA FSO content.
# For official DISA FSO STIG content, refer to https://public.cyber.mil/stigs/downloads/?_dl_facet_stigs=app-security%2Cbrowser-guidance.
# While this profile is packaged by Red Hat as part of the SCAP Security Guide package, please note
# that commercial support of this SCAP content is NOT available. This profile is provided as example
# SCAP content with no endorsement for suitability or production readiness. Support for this
# profile is provided by the upstream SCAP Security Guide community on a best-effort basis. The
# upstream project homepage is https://www.open-scap.org/security-policies/scap-security-guide/.
#
# Profile ID:  stig
# Benchmark ID:  CHROMIUM
# Benchmark Version:  0.1.60
# XCCDF Version:  1.1
#
# This file was generated by OpenSCAP 1.3.5 using:
# $ oscap xccdf generate fix --profile stig --fix-type bash xccdf-file.xml
#
# This Bash Remediation Script is generated from an OpenSCAP profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 37) for 'chromium_blacklist_extension_installation'
###############################################################################
(>&2 echo "Remediating rule 1/37: 'chromium_blacklist_extension_installation'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="ExtensionInstallBlacklist"
POL_SETTING_VAL="\[\"*\"\]"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_blacklist_extension_installation'

###############################################################################
# BEGIN fix (2 / 37) for 'chromium_block_desktop_notifications'
###############################################################################
(>&2 echo "Remediating rule 2/37: 'chromium_block_desktop_notifications'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultNotificationsSetting"
POL_SETTING_VAL="2"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_block_desktop_notifications'

###############################################################################
# BEGIN fix (3 / 37) for 'chromium_check_cert_revocation'
###############################################################################
(>&2 echo "Remediating rule 3/37: 'chromium_check_cert_revocation'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="EnableOnlineRevocationChecks"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_check_cert_revocation'

###############################################################################
# BEGIN fix (4 / 37) for 'chromium_default_block_plugins'
###############################################################################
(>&2 echo "Remediating rule 4/37: 'chromium_default_block_plugins'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultPluginsSetting"
POL_SETTING_VAL="3"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_default_block_plugins'

###############################################################################
# BEGIN fix (5 / 37) for 'chromium_default_search_provider'
###############################################################################
(>&2 echo "Remediating rule 5/37: 'chromium_default_search_provider'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultSearchProviderEnabled"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_default_search_provider'

###############################################################################
# BEGIN fix (6 / 37) for 'chromium_default_search_provider_name'
###############################################################################
(>&2 echo "Remediating rule 6/37: 'chromium_default_search_provider_name'")

var_default_search_provider_name='https://www.google.com'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultSearchProviderName"
POL_SETTING_VAL=$(echo ${var_default_search_provider_name} | sed 's/\//\\\/\\/')

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${var_default_search_provider_name}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'\".*/\"'${POL_SETTING}'\": \"'${POL_SETTING_VAL}'\",/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_default_search_provider_name'

###############################################################################
# BEGIN fix (7 / 37) for 'chromium_disable_3d_graphics_api'
###############################################################################
(>&2 echo "Remediating rule 7/37: 'chromium_disable_3d_graphics_api'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="Disable3DAPIs"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_3d_graphics_api'

###############################################################################
# BEGIN fix (8 / 37) for 'chromium_disable_autocomplete'
###############################################################################
(>&2 echo "Remediating rule 8/37: 'chromium_disable_autocomplete'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="AutoFillEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_autocomplete'

###############################################################################
# BEGIN fix (9 / 37) for 'chromium_disable_automatic_installation'
###############################################################################
(>&2 echo "Remediating rule 9/37: 'chromium_disable_automatic_installation'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DisablePluginFinder"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_automatic_installation'

###############################################################################
# BEGIN fix (10 / 37) for 'chromium_disable_background_processing'
###############################################################################
(>&2 echo "Remediating rule 10/37: 'chromium_disable_background_processing'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="BackgroundModeEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_background_processing'

###############################################################################
# BEGIN fix (11 / 37) for 'chromium_disable_cleartext_passwords'
###############################################################################
(>&2 echo "Remediating rule 11/37: 'chromium_disable_cleartext_passwords'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="PasswordManagerAllowShowPasswords"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_cleartext_passwords'

###############################################################################
# BEGIN fix (12 / 37) for 'chromium_disable_cloud_print_sharing'
###############################################################################
(>&2 echo "Remediating rule 12/37: 'chromium_disable_cloud_print_sharing'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="CloudPringProxyEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_cloud_print_sharing'

###############################################################################
# BEGIN fix (13 / 37) for 'chromium_disable_firewall_traversal'
###############################################################################
(>&2 echo "Remediating rule 13/37: 'chromium_disable_firewall_traversal'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="RemoteAccessHostFirewallTraversal"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_firewall_traversal'

###############################################################################
# BEGIN fix (14 / 37) for 'chromium_disable_google_sync'
###############################################################################
(>&2 echo "Remediating rule 14/37: 'chromium_disable_google_sync'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="SyncDisabled"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_google_sync'

###############################################################################
# BEGIN fix (15 / 37) for 'chromium_disable_incognito_mode'
###############################################################################
(>&2 echo "Remediating rule 15/37: 'chromium_disable_incognito_mode'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="IncognitoModeAvailability"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_incognito_mode'

###############################################################################
# BEGIN fix (16 / 37) for 'chromium_disable_metrics_reporting'
###############################################################################
(>&2 echo "Remediating rule 16/37: 'chromium_disable_metrics_reporting'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="MetricsReportingEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_metrics_reporting'

###############################################################################
# BEGIN fix (17 / 37) for 'chromium_disable_network_prediction'
###############################################################################
(>&2 echo "Remediating rule 17/37: 'chromium_disable_network_prediction'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DnsPrefetchingEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_network_prediction'

###############################################################################
# BEGIN fix (18 / 37) for 'chromium_disable_outdated_plugins'
###############################################################################
(>&2 echo "Remediating rule 18/37: 'chromium_disable_outdated_plugins'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="AllowOutdatedPlugins"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_outdated_plugins'

###############################################################################
# BEGIN fix (19 / 37) for 'chromium_disable_password_manager'
###############################################################################
(>&2 echo "Remediating rule 19/37: 'chromium_disable_password_manager'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="PasswordManagerEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_password_manager'

###############################################################################
# BEGIN fix (20 / 37) for 'chromium_disable_plugin_blacklist'
###############################################################################
(>&2 echo "Remediating rule 20/37: 'chromium_disable_plugin_blacklist'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DisabledPlugins"
POL_SETTING_VAL="\[\"*\"\]"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_plugin_blacklist'

###############################################################################
# BEGIN fix (21 / 37) for 'chromium_disable_popups'
###############################################################################
(>&2 echo "Remediating rule 21/37: 'chromium_disable_popups'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultPopupsSetting"
POL_SETTING_VAL="2"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_popups'

###############################################################################
# BEGIN fix (22 / 37) for 'chromium_disable_protocol_schemas'
###############################################################################
(>&2 echo "Remediating rule 22/37: 'chromium_disable_protocol_schemas'")

var_url_blacklist='javascript://*'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="URLBlacklist"
POL_SETTING_VAL=$(echo ${var_url_blacklist}| sed 's/\//\\\/\\/')

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": \["'${var_url_blacklist}'"\],' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": \[\"'${POL_SETTING_VAL}'\"\],/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_protocol_schemas'

###############################################################################
# BEGIN fix (23 / 37) for 'chromium_disable_saved_passwords'
###############################################################################
(>&2 echo "Remediating rule 23/37: 'chromium_disable_saved_passwords'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="ImportSavedPasswords"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_saved_passwords'

###############################################################################
# BEGIN fix (24 / 37) for 'chromium_disable_search_suggestions'
###############################################################################
(>&2 echo "Remediating rule 24/37: 'chromium_disable_search_suggestions'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="SearchSuggestEnabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_search_suggestions'

###############################################################################
# BEGIN fix (25 / 37) for 'chromium_disable_session_cookies'
###############################################################################
(>&2 echo "Remediating rule 25/37: 'chromium_disable_session_cookies'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="CookiesSessionOnlyForUrls"
POL_SETTING_VAL="none"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": \["'${POL_SETTING_VAL}'"\],' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": \[\"'${POL_SETTING_VAL}'\"\],/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_session_cookies'

###############################################################################
# BEGIN fix (26 / 37) for 'chromium_disable_thirdparty_cookies'
###############################################################################
(>&2 echo "Remediating rule 26/37: 'chromium_disable_thirdparty_cookies'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="BlockThirdPartyCookies"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disable_thirdparty_cookies'

###############################################################################
# BEGIN fix (27 / 37) for 'chromium_disallow_location_tracking'
###############################################################################
(>&2 echo "Remediating rule 27/37: 'chromium_disallow_location_tracking'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultGeolocationSetting"
POL_SETTING_VAL="2"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_disallow_location_tracking'

###############################################################################
# BEGIN fix (28 / 37) for 'chromium_enable_approved_plugins'
###############################################################################
(>&2 echo "Remediating rule 28/37: 'chromium_enable_approved_plugins'")
(>&2 echo "FIX FOR THIS RULE 'chromium_enable_approved_plugins' IS MISSING!")

# END fix for 'chromium_enable_approved_plugins'

###############################################################################
# BEGIN fix (29 / 37) for 'chromium_enable_browser_history'
###############################################################################
(>&2 echo "Remediating rule 29/37: 'chromium_enable_browser_history'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="SavingBrowserHistoryDisabled"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_enable_browser_history'

###############################################################################
# BEGIN fix (30 / 37) for 'chromium_enable_encrypted_searching'
###############################################################################
(>&2 echo "Remediating rule 30/37: 'chromium_enable_encrypted_searching'")

var_enable_encrypted_searching='https://www.google.com/#q={searchTerms}'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="DefaultSearchProviderSearchURL"
POL_SETTING_VAL=$(echo ${var_enable_encrypted_searching} | sed 's/\//\\\/\\/')

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${var_enable_encrypted_searching}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's;\"'${POL_SETTING}'\".*;\"'${POL_SETTING}'\": \"'${POL_SETTING_VAL}'\",;g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_enable_encrypted_searching'

###############################################################################
# BEGIN fix (31 / 37) for 'chromium_enable_safe_browsing'
###############################################################################
(>&2 echo "Remediating rule 31/37: 'chromium_enable_safe_browsing'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="SafeBrowsingEnabled"
POL_SETTING_VAL="true"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_enable_safe_browsing'

###############################################################################
# BEGIN fix (32 / 37) for 'chromium_extension_whitelist'
###############################################################################
(>&2 echo "Remediating rule 32/37: 'chromium_extension_whitelist'")

var_extension_whitelist='oiigbmnaadbkfbmpbfijlflahbdbdgdf'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="ExtensionInstallWhitelist"
POL_SETTING_VAL=$(echo ${var_extension_whitelist} | sed 's/\//\\\/\\/')

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${var_extension_whitelist}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'\".*/\"'${POL_SETTING}'\": \"'${POL_SETTING_VAL}'\",/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_extension_whitelist'

###############################################################################
# BEGIN fix (33 / 37) for 'chromium_http_authentication'
###############################################################################
(>&2 echo "Remediating rule 33/37: 'chromium_http_authentication'")

var_auth_schema='negotiate'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="AuthSchemes"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${var_auth_schemes}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": \"'${var_auth_schemes}'\",/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_http_authentication'

###############################################################################
# BEGIN fix (34 / 37) for 'chromium_plugins_require_authorization'
###############################################################################
(>&2 echo "Remediating rule 34/37: 'chromium_plugins_require_authorization'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="AlwaysAuthorizePlugins"
POL_SETTING_VAL="false"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": '${POL_SETTING_VAL}',' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'.*/\"'${POL_SETTING}'\": '${POL_SETTING_VAL}',/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_plugins_require_authorization'

###############################################################################
# BEGIN fix (35 / 37) for 'chromium_policy_file'
###############################################################################
(>&2 echo "Remediating rule 35/37: 'chromium_policy_file'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"

if [ ! -d ${CHROME_POL_DIR} ] ; then
   mkdir -p -m 755 ${CHROME_POL_DIR}
fi

if [ ! -f ${CHROME_POL_DIR}/${CHROME_POL_FILE} ] ; then
   touch ${CHROME_POL_DIR}/${CHROME_POL_FILE}
   chmod 644 ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

grep -q -E '^\{' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
if ! [ $? -eq 0 ] ; then
   if [ -s ${CHROME_POL_DIR}/${CHROME_POL_FILE} ] ; then
      sed -i '1s/^/\{\n/' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
   else
      echo -e "{" >> ${CHROME_POL_DIR}/${CHROME_POL_FILE}
   fi
fi

tail -1 ${CHROME_POL_DIR}/${CHROME_POL_FILE} | grep -q -E '^\}'
if ! [ $? -eq 0 ] ; then
   echo -e "}" >> ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi 

# END fix for 'chromium_policy_file'

###############################################################################
# BEGIN fix (36 / 37) for 'chromium_trusted_home_page'
###############################################################################
(>&2 echo "Remediating rule 36/37: 'chromium_trusted_home_page'")

var_trusted_home_page='about:blank'


CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="HomepageLocation"
POL_SETTING_VAL=$(echo ${var_trusted_home_page} | sed 's/\//\\\/\\/')

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${var_trusted_home_page}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'\".*/\"'${POL_SETTING}'\": \"'${POL_SETTING_VAL}'\",/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_trusted_home_page'

###############################################################################
# BEGIN fix (37 / 37) for 'chromium_whitelist_plugin_urls'
###############################################################################
(>&2 echo "Remediating rule 37/37: 'chromium_whitelist_plugin_urls'")
CHROME_POL_FILE="chrome_stig_policy.json"
CHROME_POL_DIR="/etc/chromium/policies/managed/"
POL_SETTING="PluginsAllowedForUrls"
POL_SETTING_VAL="none"

grep -q ${POL_SETTING} ${CHROME_POL_DIR}/${CHROME_POL_FILE}

if ! [ $? -eq 0 ] ; then
   sed -i -e '/{/a \  "'${POL_SETTING}'": "'${POL_SETTING_VAL}'",' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
else
   sed -i -e 's/\"'${POL_SETTING}'\".*/\"'${POL_SETTING}'\": \"'${POL_SETTING_VAL}'\",/g' ${CHROME_POL_DIR}/${CHROME_POL_FILE}
fi

# END fix for 'chromium_whitelist_plugin_urls'

