"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.Module = void 0;
const path = require('path');
const bindings = require('bindings');
exports.Module = bindings({
    bindings: 'saleae_graph_interface.node',
    module_root: path.dirname(__dirname),
    try: [
        ['module_root', 'build', 'Release', 'bindings'],
        ['module_root', 'build', 'Debug', 'bindings'],
        ['module_root', 'bin', `${process.platform}-${process.arch}-${process.versions.modules}`, 'graph-interface.node'],
        ['module_root', 'bin', `${process.platform}-${process.arch}-89`, 'graph-interface.node'],
    ],
});
class Instance extends exports.Module.Instance {
    constructor() {
        super(...arguments);
        this._notifyMessageCallbacks = [];
        this._previousSend = Promise.resolve();
    }
    send(message) {
        const sendRequest = () => {
            return this._send(JSON.stringify(message));
        };
        const promise = this._previousSend.then(sendRequest, sendRequest);
        this._previousSend = promise;
        return promise;
    }
    async recv() {
        while (true) {
            const message = this._tryRecv();
            if (typeof message === 'string') {
                return JSON.parse(message);
            }
            else {
                await new Promise(resolve => {
                    this._notifyMessageCallbacks.push(resolve);
                });
            }
        }
    }
    _onNotifyMessage() {
        const callbacks = this._notifyMessageCallbacks;
        this._notifyMessageCallbacks = [];
        for (const callback of callbacks) {
            callback();
        }
    }
}
exports.Instance = Instance;
//# sourceMappingURL=instance.js.map