# encoding: utf-8

# Copyright 2010-2013 Ayumu Nojima (野島 歩) and Martin J. Dürst (duerst@it.aoyama.ac.jp)
# available under the same licence as Ruby itself
# (see http://www.ruby-lang.org/en/LICENSE.txt)

# automatically generated by rake generate_tables

class Eprun

  ACCENTS = "
    [\314\200-\315\216\315\220-\315\257\322\203-\322\207\326\221-\326\275\326\277\327\201\327\202\327\204\327\205\327\207\330\220-\330\232\331\213-\331\237\331\260\333\226-\333\234\333\237-\333\244\333\247\333\250\333\252-\333\255\334\221" +
    "\334\260-\335\212\337\253-\337\263\340\240\226-\340\240\231\340\240\233-\340\240\243\340\240\245-\340\240\247\340\240\251-\340\240\255\340\241\231-\340\241\233\340\243\244-\340\243\276\340\244\274\340\245\215\340\245\221-\340\245\224\340\246\274\340\246\276\340\247\215\340\247\227\340\250\274" +
    "\340\251\215\340\252\274\340\253\215\340\254\274\340\254\276\340\255\215\340\255\226\340\255\227\340\256\276\340\257\215\340\257\227\340\261\215\340\261\225\340\261\226\340\262\274\340\263\202\340\263\215\340\263\225\340\263\226" +
    "\340\264\276\340\265\215\340\265\227\340\267\212\340\267\217\340\267\237\340\270\270-\340\270\272\340\271\210-\340\271\213\340\272\270\340\272\271\340\273\210-\340\273\213\340\274\230\340\274\231\340\274\265\340\274\267\340\274\271\340\275\261\340\275\262\340\275\264" +
    "\340\275\272-\340\275\275\340\276\200\340\276\202-\340\276\204\340\276\206\340\276\207\340\277\206\341\200\256\341\200\267\341\200\271\341\200\272\341\202\215\341\215\235-\341\215\237\341\234\224\341\234\264\341\237\222\341\237\235\341\242\251\341\244\271-\341\244\273" +
    "\341\250\227\341\250\230\341\251\240\341\251\265-\341\251\274\341\251\277\341\254\264\341\254\265\341\255\204\341\255\253-\341\255\263\341\256\252\341\256\253\341\257\246\341\257\262\341\257\263\341\260\267\341\263\220-\341\263\222\341\263\224-\341\263\240\341\263\242-\341\263\250\341\263\255\341\263\264" +
    "\341\267\200-\341\267\246\341\267\274-\341\267\277\342\203\220-\342\203\234\342\203\241\342\203\245-\342\203\260\342\263\257-\342\263\261\342\265\277\342\267\240-\342\267\277\343\200\252-\343\200\257\343\202\231\343\202\232\352\231\257\352\231\264-\352\231\275\352\232\237\352\233\260\352\233\261\352\240\206\352\243\204" +
    "\352\243\240-\352\243\261\352\244\253-\352\244\255\352\245\223\352\246\263\352\247\200\352\252\260\352\252\262-\352\252\264\352\252\267\352\252\270\352\252\276\352\252\277\352\253\201\352\253\266\352\257\255\357\254\236\357\270\240-\357\270\246\360\220\207\275\360\220\250\215" +
    "\360\220\250\217\360\220\250\270-\360\220\250\272\360\220\250\277\360\221\201\206\360\221\202\271\360\221\202\272\360\221\204\200-\360\221\204\202\360\221\204\247\360\221\204\263\360\221\204\264\360\221\207\200\360\221\232\266\360\221\232\267\360\235\205\245-\360\235\205\251\360\235\205\255-\360\235\205\262\360\235\205\273-\360\235\206\202\360\235\206\205-\360\235\206\213\360\235\206\252-\360\235\206\255\360\235\211\202-\360\235\211\204]
  "
  REGEXP_D_STRING = "  # composition starters and composition exclusions
    [\303\200-\303\205\303\207-\303\217\303\221-\303\226\303\231-\303\235\303\240-\303\245\303\247-\303\257\303\261-\303\266\303\271-\303\275\303\277-\304\217\304\222-\304\245\304\250-\304\260\304\264-\304\267\304\271-\304\276\305\203-\305\210\305\214-\305\221\305\224-\305\245" +
    "\305\250-\305\276\306\240\306\241\306\257\306\260\307\215-\307\234\307\236-\307\243\307\246-\307\260\307\264\307\265\307\270-\310\233\310\236\310\237\310\246-\310\263\315\200\315\201\315\203\315\204\315\264\315\276\316\205-\316\212\316\214" +
    "\316\216-\316\220\316\252-\316\260\317\212-\317\216\317\223\317\224\320\200\320\201\320\203\320\207\320\214-\320\216\320\231\320\271\321\220\321\221\321\223\321\227\321\234-\321\236\321\266\321\267\323\201\323\202" +
    "\323\220-\323\223\323\226\323\227\323\232-\323\237\323\242-\323\247\323\252-\323\265\323\270\323\271\330\242-\330\246\333\200\333\202\333\223\340\244\251\340\244\261\340\244\264\340\245\230-\340\245\237\340\247\213\340\247\214\340\247\234\340\247\235" +
    "\340\247\237\340\250\263\340\250\266\340\251\231-\340\251\233\340\251\236\340\255\210\340\255\213\340\255\214\340\255\234\340\255\235\340\256\224\340\257\212-\340\257\214\340\261\210\340\263\200\340\263\207\340\263\210\340\263\212\340\263\213\340\265\212-\340\265\214\340\267\232" +
    "\340\267\234-\340\267\236\340\275\203\340\275\215\340\275\222\340\275\227\340\275\234\340\275\251\340\275\263\340\275\265\340\275\266\340\275\270\340\276\201\340\276\223\340\276\235\340\276\242\340\276\247\340\276\254" +
    "\340\276\271\341\200\246\341\254\206\341\254\210\341\254\212\341\254\214\341\254\216\341\254\222\341\254\273\341\254\275\341\255\200\341\255\201\341\255\203\341\270\200-\341\272\231\341\272\233\341\272\240-\341\273\271\341\274\200-\341\274\225" +
    "\341\274\230-\341\274\235\341\274\240-\341\275\205\341\275\210-\341\275\215\341\275\220-\341\275\227\341\275\231\341\275\233\341\275\235\341\275\237-\341\275\275\341\276\200-\341\276\264\341\276\266-\341\276\274\341\276\276\341\277\201-\341\277\204\341\277\206-\341\277\223\341\277\226-\341\277\233\341\277\235-\341\277\257\341\277\262-\341\277\264" +
    "\341\277\266-\341\277\275\342\200\200\342\200\201\342\204\246\342\204\252\342\204\253\342\206\232\342\206\233\342\206\256\342\207\215-\342\207\217\342\210\204\342\210\211\342\210\214\342\210\244\342\210\246\342\211\201\342\211\204\342\211\207\342\211\211" +
    "\342\211\240\342\211\242\342\211\255-\342\211\261\342\211\264\342\211\265\342\211\270\342\211\271\342\212\200\342\212\201\342\212\204\342\212\205\342\212\210\342\212\211\342\212\254-\342\212\257\342\213\240-\342\213\243\342\213\252-\342\213\255\342\214\251\342\214\252\342\253\234\343\201\214\343\201\216\343\201\220" +
    "\343\201\222\343\201\224\343\201\226\343\201\230\343\201\232\343\201\234\343\201\236\343\201\240\343\201\242\343\201\245\343\201\247\343\201\251\343\201\260\343\201\261\343\201\263\343\201\264\343\201\266\343\201\267\343\201\271\343\201\272" +
    "\343\201\274\343\201\275\343\202\224\343\202\236\343\202\254\343\202\256\343\202\260\343\202\262\343\202\264\343\202\266\343\202\270\343\202\272\343\202\274\343\202\276\343\203\200\343\203\202\343\203\205" +
    "\343\203\207\343\203\211\343\203\220\343\203\221\343\203\223\343\203\224\343\203\226\343\203\227\343\203\231\343\203\232\343\203\234\343\203\235\343\203\264\343\203\267-\343\203\272\343\203\276\357\244\200-\357\250\215\357\250\220\357\250\222\357\250\225-\357\250\236\357\250\240\357\250\242" +
    "\357\250\245\357\250\246\357\250\252-\357\251\255\357\251\260-\357\253\231\357\254\235\357\254\237\357\254\252-\357\254\266\357\254\270-\357\254\274\357\254\276\357\255\200\357\255\201\357\255\203\357\255\204\357\255\206-\357\255\216\360\221\202\232\360\221\202\234\360\221\202\253\360\221\204\256\360\221\204\257\360\235\205\236-\360\235\205\244" +
    "\360\235\206\273-\360\235\207\200\360\257\240\200-\360\257\250\235]\[\314\200-\315\216\315\220-\315\257\322\203-\322\207\326\221-\326\275\326\277\327\201\327\202\327\204\327\205\327\207\330\220-\330\232\331\213-\331\237\331\260\333\226-\333\234\333\237-\333\244\333\247\333\250\333\252-\333\255\334\221" +
    "\334\260-\335\212\337\253-\337\263\340\240\226-\340\240\231\340\240\233-\340\240\243\340\240\245-\340\240\247\340\240\251-\340\240\255\340\241\231-\340\241\233\340\243\244-\340\243\276\340\244\274\340\245\215\340\245\221-\340\245\224\340\246\274\340\246\276\340\247\215\340\247\227\340\250\274" +
    "\340\251\215\340\252\274\340\253\215\340\254\274\340\254\276\340\255\215\340\255\226\340\255\227\340\256\276\340\257\215\340\257\227\340\261\215\340\261\225\340\261\226\340\262\274\340\263\202\340\263\215\340\263\225\340\263\226" +
    "\340\264\276\340\265\215\340\265\227\340\267\212\340\267\217\340\267\237\340\270\270-\340\270\272\340\271\210-\340\271\213\340\272\270\340\272\271\340\273\210-\340\273\213\340\274\230\340\274\231\340\274\265\340\274\267\340\274\271\340\275\261\340\275\262\340\275\264" +
    "\340\275\272-\340\275\275\340\276\200\340\276\202-\340\276\204\340\276\206\340\276\207\340\277\206\341\200\256\341\200\267\341\200\271\341\200\272\341\202\215\341\215\235-\341\215\237\341\234\224\341\234\264\341\237\222\341\237\235\341\242\251\341\244\271-\341\244\273" +
    "\341\250\227\341\250\230\341\251\240\341\251\265-\341\251\274\341\251\277\341\254\264\341\254\265\341\255\204\341\255\253-\341\255\263\341\256\252\341\256\253\341\257\246\341\257\262\341\257\263\341\260\267\341\263\220-\341\263\222\341\263\224-\341\263\240\341\263\242-\341\263\250\341\263\255\341\263\264" +
    "\341\267\200-\341\267\246\341\267\274-\341\267\277\342\203\220-\342\203\234\342\203\241\342\203\245-\342\203\260\342\263\257-\342\263\261\342\265\277\342\267\240-\342\267\277\343\200\252-\343\200\257\343\202\231\343\202\232\352\231\257\352\231\264-\352\231\275\352\232\237\352\233\260\352\233\261\352\240\206\352\243\204" +
    "\352\243\240-\352\243\261\352\244\253-\352\244\255\352\245\223\352\246\263\352\247\200\352\252\260\352\252\262-\352\252\264\352\252\267\352\252\270\352\252\276\352\252\277\352\253\201\352\253\266\352\257\255\357\254\236\357\270\240-\357\270\246\360\220\207\275\360\220\250\215" +
    "\360\220\250\217\360\220\250\270-\360\220\250\272\360\220\250\277\360\221\201\206\360\221\202\271\360\221\202\272\360\221\204\200-\360\221\204\202\360\221\204\247\360\221\204\263\360\221\204\264\360\221\207\200\360\221\232\266\360\221\232\267\360\235\205\245-\360\235\205\251\360\235\205\255-\360\235\205\262\360\235\205\273-\360\235\206\202\360\235\206\205-\360\235\206\213\360\235\206\252-\360\235\206\255\360\235\211\202-\360\235\211\204]*
    |  # characters that can be the result of a composition, except composition starters
    [\74-\76\101-\120\122-\132\141-\160\162-\172\302\250\303\206\303\230\303\246\303\270\305\277\306\267\312\222\316\221\316\225\316\227" +
    "\316\231\316\237\316\241\316\245\316\251\316\261\316\265\316\267\316\271\316\277\317\201\317\205\317\211\317\222\320\206\320\220" +
    "\320\223\320\225-\320\230\320\232\320\236\320\243\320\247\320\253\320\255\320\260\320\263\320\265-\320\270\320\272\320\276\321\203\321\207\321\213" +
    "\321\215\321\226\321\264\321\265\323\230\323\231\323\250\323\251\330\247\331\210\331\212\333\201\333\222\333\225\340\244\250\340\244\260\340\244\263\340\247\207\340\255\207" +
    "\340\256\222\340\257\206\340\257\207\340\261\206\340\262\277\340\263\206\340\265\206\340\265\207\340\267\231\341\200\245\341\254\205\341\254\207\341\254\211\341\254\213\341\254\215\341\254\221\341\254\272\341\254\274" +
    "\341\254\276\341\254\277\341\255\202\341\276\277\341\277\276\342\206\220\342\206\222\342\206\224\342\207\220\342\207\222\342\207\224\342\210\203\342\210\210\342\210\213\342\210\243\342\210\245\342\210\274" +
    "\342\211\203\342\211\205\342\211\210\342\211\215\342\211\241\342\211\244\342\211\245\342\211\262\342\211\263\342\211\266\342\211\267\342\211\272-\342\211\275\342\212\202\342\212\203\342\212\206\342\212\207\342\212\221\342\212\222\342\212\242\342\212\250\342\212\251\342\212\253\342\212\262-\342\212\265" +
    "\343\201\206\343\201\213\343\201\215\343\201\217\343\201\221\343\201\223\343\201\225\343\201\227\343\201\231\343\201\233\343\201\235\343\201\237\343\201\241\343\201\244\343\201\246\343\201\250" +
    "\343\201\257\343\201\262\343\201\265\343\201\270\343\201\273\343\202\235\343\202\246\343\202\253\343\202\255\343\202\257\343\202\261\343\202\263\343\202\265\343\202\267\343\202\271\343\202\273" +
    "\343\202\275\343\202\277\343\203\201\343\203\204\343\203\206\343\203\210\343\203\217\343\203\222\343\203\225\343\203\230\343\203\233\343\203\257-\343\203\262\343\203\275\360\221\202\231\360\221\202\233\360\221\202\245" +
    "\360\221\204\261\360\221\204\262]?\[\314\200-\315\216\315\220-\315\257\322\203-\322\207\326\221-\326\275\326\277\327\201\327\202\327\204\327\205\327\207\330\220-\330\232\331\213-\331\237\331\260\333\226-\333\234\333\237-\333\244\333\247\333\250\333\252-\333\255\334\221" +
    "\334\260-\335\212\337\253-\337\263\340\240\226-\340\240\231\340\240\233-\340\240\243\340\240\245-\340\240\247\340\240\251-\340\240\255\340\241\231-\340\241\233\340\243\244-\340\243\276\340\244\274\340\245\215\340\245\221-\340\245\224\340\246\274\340\246\276\340\247\215\340\247\227\340\250\274" +
    "\340\251\215\340\252\274\340\253\215\340\254\274\340\254\276\340\255\215\340\255\226\340\255\227\340\256\276\340\257\215\340\257\227\340\261\215\340\261\225\340\261\226\340\262\274\340\263\202\340\263\215\340\263\225\340\263\226" +
    "\340\264\276\340\265\215\340\265\227\340\267\212\340\267\217\340\267\237\340\270\270-\340\270\272\340\271\210-\340\271\213\340\272\270\340\272\271\340\273\210-\340\273\213\340\274\230\340\274\231\340\274\265\340\274\267\340\274\271\340\275\261\340\275\262\340\275\264" +
    "\340\275\272-\340\275\275\340\276\200\340\276\202-\340\276\204\340\276\206\340\276\207\340\277\206\341\200\256\341\200\267\341\200\271\341\200\272\341\202\215\341\215\235-\341\215\237\341\234\224\341\234\264\341\237\222\341\237\235\341\242\251\341\244\271-\341\244\273" +
    "\341\250\227\341\250\230\341\251\240\341\251\265-\341\251\274\341\251\277\341\254\264\341\254\265\341\255\204\341\255\253-\341\255\263\341\256\252\341\256\253\341\257\246\341\257\262\341\257\263\341\260\267\341\263\220-\341\263\222\341\263\224-\341\263\240\341\263\242-\341\263\250\341\263\255\341\263\264" +
    "\341\267\200-\341\267\246\341\267\274-\341\267\277\342\203\220-\342\203\234\342\203\241\342\203\245-\342\203\260\342\263\257-\342\263\261\342\265\277\342\267\240-\342\267\277\343\200\252-\343\200\257\343\202\231\343\202\232\352\231\257\352\231\264-\352\231\275\352\232\237\352\233\260\352\233\261\352\240\206\352\243\204" +
    "\352\243\240-\352\243\261\352\244\253-\352\244\255\352\245\223\352\246\263\352\247\200\352\252\260\352\252\262-\352\252\264\352\252\267\352\252\270\352\252\276\352\252\277\352\253\201\352\253\266\352\257\255\357\254\236\357\270\240-\357\270\246\360\220\207\275\360\220\250\215" +
    "\360\220\250\217\360\220\250\270-\360\220\250\272\360\220\250\277\360\221\201\206\360\221\202\271\360\221\202\272\360\221\204\200-\360\221\204\202\360\221\204\247\360\221\204\263\360\221\204\264\360\221\207\200\360\221\232\266\360\221\232\267\360\235\205\245-\360\235\205\251\360\235\205\255-\360\235\205\262\360\235\205\273-\360\235\206\202\360\235\206\205-\360\235\206\213\360\235\206\252-\360\235\206\255\360\235\211\202-\360\235\211\204]+
    |  # precomposed Hangul syllables
    [\352\260\200-\355\236\244]
  "
  REGEXP_C_STRING = "  # composition exclusions
    [\315\200\315\201\315\203\315\204\315\264\315\276\316\207\340\245\230-\340\245\237\340\247\234\340\247\235\340\247\237\340\250\263\340\250\266\340\251\231-\340\251\233\340\251\236\340\255\234\340\255\235\340\275\203\340\275\215\340\275\222" +
    "\340\275\227\340\275\234\340\275\251\340\275\263\340\275\265\340\275\266\340\275\270\340\276\201\340\276\223\340\276\235\340\276\242\340\276\247\340\276\254\340\276\271\341\275\261\341\275\263\341\275\265" +
    "\341\275\267\341\275\271\341\275\273\341\275\275\341\276\273\341\276\276\341\277\211\341\277\213\341\277\223\341\277\233\341\277\243\341\277\253\341\277\256\341\277\257\341\277\271\341\277\273\341\277\275" +
    "\342\200\200\342\200\201\342\204\246\342\204\252\342\204\253\342\214\251\342\214\252\342\253\234\357\244\200-\357\250\215\357\250\220\357\250\222\357\250\225-\357\250\236\357\250\240\357\250\242\357\250\245\357\250\246\357\250\252-\357\251\255\357\251\260-\357\253\231\357\254\235\357\254\237" +
    "\357\254\252-\357\254\266\357\254\270-\357\254\274\357\254\276\357\255\200\357\255\201\357\255\203\357\255\204\357\255\206-\357\255\216\360\235\205\236-\360\235\205\244\360\235\206\273-\360\235\207\200\360\257\240\200-\360\257\250\235]\[\314\200-\315\216\315\220-\315\257\322\203-\322\207\326\221-\326\275\326\277\327\201\327\202\327\204\327\205\327\207\330\220-\330\232\331\213-\331\237\331\260\333\226-\333\234\333\237-\333\244\333\247\333\250\333\252-\333\255\334\221" +
    "\334\260-\335\212\337\253-\337\263\340\240\226-\340\240\231\340\240\233-\340\240\243\340\240\245-\340\240\247\340\240\251-\340\240\255\340\241\231-\340\241\233\340\243\244-\340\243\276\340\244\274\340\245\215\340\245\221-\340\245\224\340\246\274\340\246\276\340\247\215\340\247\227\340\250\274" +
    "\340\251\215\340\252\274\340\253\215\340\254\274\340\254\276\340\255\215\340\255\226\340\255\227\340\256\276\340\257\215\340\257\227\340\261\215\340\261\225\340\261\226\340\262\274\340\263\202\340\263\215\340\263\225\340\263\226" +
    "\340\264\276\340\265\215\340\265\227\340\267\212\340\267\217\340\267\237\340\270\270-\340\270\272\340\271\210-\340\271\213\340\272\270\340\272\271\340\273\210-\340\273\213\340\274\230\340\274\231\340\274\265\340\274\267\340\274\271\340\275\261\340\275\262\340\275\264" +
    "\340\275\272-\340\275\275\340\276\200\340\276\202-\340\276\204\340\276\206\340\276\207\340\277\206\341\200\256\341\200\267\341\200\271\341\200\272\341\202\215\341\215\235-\341\215\237\341\234\224\341\234\264\341\237\222\341\237\235\341\242\251\341\244\271-\341\244\273" +
    "\341\250\227\341\250\230\341\251\240\341\251\265-\341\251\274\341\251\277\341\254\264\341\254\265\341\255\204\341\255\253-\341\255\263\341\256\252\341\256\253\341\257\246\341\257\262\341\257\263\341\260\267\341\263\220-\341\263\222\341\263\224-\341\263\240\341\263\242-\341\263\250\341\263\255\341\263\264" +
    "\341\267\200-\341\267\246\341\267\274-\341\267\277\342\203\220-\342\203\234\342\203\241\342\203\245-\342\203\260\342\263\257-\342\263\261\342\265\277\342\267\240-\342\267\277\343\200\252-\343\200\257\343\202\231\343\202\232\352\231\257\352\231\264-\352\231\275\352\232\237\352\233\260\352\233\261\352\240\206\352\243\204" +
    "\352\243\240-\352\243\261\352\244\253-\352\244\255\352\245\223\352\246\263\352\247\200\352\252\260\352\252\262-\352\252\264\352\252\267\352\252\270\352\252\276\352\252\277\352\253\201\352\253\266\352\257\255\357\254\236\357\270\240-\357\270\246\360\220\207\275\360\220\250\215" +
    "\360\220\250\217\360\220\250\270-\360\220\250\272\360\220\250\277\360\221\201\206\360\221\202\271\360\221\202\272\360\221\204\200-\360\221\204\202\360\221\204\247\360\221\204\263\360\221\204\264\360\221\207\200\360\221\232\266\360\221\232\267\360\235\205\245-\360\235\205\251\360\235\205\255-\360\235\205\262\360\235\205\273-\360\235\206\202\360\235\206\205-\360\235\206\213\360\235\206\252-\360\235\206\255\360\235\211\202-\360\235\211\204]*
    |  # composition starters and characters that can be the result of a composition
    [\74-\76\101-\120\122-\132\141-\160\162-\172\302\250\303\200-\303\217\303\221-\303\226\303\230-\303\235\303\240-\303\257\303\261-\303\266\303\270-\303\275\303\277-\304\217\304\222-\304\245\304\250-\304\260\304\264-\304\267" +
    "\304\271-\304\276\305\203-\305\210\305\214-\305\221\305\224-\305\245\305\250-\305\277\306\240\306\241\306\257\306\260\306\267\307\215-\307\234\307\236-\307\243\307\246-\307\260\307\264\307\265\307\270-\310\233\310\236\310\237\310\246-\310\263\312\222" +
    "\316\205\316\206\316\210-\316\212\316\214\316\216-\316\221\316\225\316\227\316\231\316\237\316\241\316\245\316\251-\316\261\316\265\316\267\316\271\316\277\317\201" +
    "\317\205\317\211-\317\216\317\222-\317\224\320\200\320\201\320\203\320\206\320\207\320\214-\320\216\320\220\320\223\320\225-\320\232\320\236\320\243\320\247\320\253\320\255\320\260" +
    "\320\263\320\265-\320\272\320\276\321\203\321\207\321\213\321\215\321\220\321\221\321\223\321\226\321\227\321\234-\321\236\321\264-\321\267\323\201\323\202\323\220-\323\223\323\226-\323\237\323\242-\323\265" +
    "\323\270\323\271\330\242-\330\247\331\210\331\212\333\200-\333\202\333\222\333\223\333\225\340\244\250\340\244\251\340\244\260\340\244\261\340\244\263\340\244\264\340\247\207\340\247\213\340\247\214\340\255\207\340\255\210\340\255\213\340\255\214\340\256\222\340\256\224" +
    "\340\257\206\340\257\207\340\257\212-\340\257\214\340\261\206\340\261\210\340\262\277\340\263\200\340\263\206-\340\263\210\340\263\212\340\263\213\340\265\206\340\265\207\340\265\212-\340\265\214\340\267\231\340\267\232\340\267\234-\340\267\236\341\200\245\341\200\246\341\254\205-\341\254\216\341\254\221\341\254\222\341\254\272-\341\255\203\341\270\200-\341\272\231" +
    "\341\272\233\341\272\240-\341\273\271\341\274\200-\341\274\225\341\274\230-\341\274\235\341\274\240-\341\275\205\341\275\210-\341\275\215\341\275\220-\341\275\227\341\275\231\341\275\233\341\275\235\341\275\237-\341\275\260\341\275\262\341\275\264\341\275\266\341\275\270\341\275\272" +
    "\341\275\274\341\276\200-\341\276\264\341\276\266-\341\276\272\341\276\274\341\276\277\341\277\201-\341\277\204\341\277\206-\341\277\210\341\277\212\341\277\214-\341\277\222\341\277\226-\341\277\232\341\277\235-\341\277\242\341\277\244-\341\277\252\341\277\254\341\277\255\341\277\262-\341\277\264\341\277\266-\341\277\270\341\277\272" +
    "\341\277\274\341\277\276\342\206\220\342\206\222\342\206\224\342\206\232\342\206\233\342\206\256\342\207\215-\342\207\220\342\207\222\342\207\224\342\210\203\342\210\204\342\210\210\342\210\211\342\210\213\342\210\214\342\210\243-\342\210\246\342\210\274\342\211\201" +
    "\342\211\203-\342\211\205\342\211\207-\342\211\211\342\211\215\342\211\240-\342\211\242\342\211\244\342\211\245\342\211\255-\342\211\275\342\212\200-\342\212\211\342\212\221\342\212\222\342\212\242\342\212\250\342\212\251\342\212\253-\342\212\257\342\212\262-\342\212\265\342\213\240-\342\213\243\342\213\252-\342\213\255\343\201\206\343\201\213-\343\201\242" +
    "\343\201\244-\343\201\251\343\201\257-\343\201\275\343\202\224\343\202\235\343\202\236\343\202\246\343\202\253-\343\203\202\343\203\204-\343\203\211\343\203\217-\343\203\235\343\203\257-\343\203\262\343\203\264\343\203\267-\343\203\272\343\203\275\343\203\276\360\221\202\231-\360\221\202\234\360\221\202\245\360\221\202\253\360\221\204\256\360\221\204\257" +
    "\360\221\204\261\360\221\204\262]?\[\314\200-\315\216\315\220-\315\257\322\203-\322\207\326\221-\326\275\326\277\327\201\327\202\327\204\327\205\327\207\330\220-\330\232\331\213-\331\237\331\260\333\226-\333\234\333\237-\333\244\333\247\333\250\333\252-\333\255\334\221" +
    "\334\260-\335\212\337\253-\337\263\340\240\226-\340\240\231\340\240\233-\340\240\243\340\240\245-\340\240\247\340\240\251-\340\240\255\340\241\231-\340\241\233\340\243\244-\340\243\276\340\244\274\340\245\215\340\245\221-\340\245\224\340\246\274\340\246\276\340\247\215\340\247\227\340\250\274" +
    "\340\251\215\340\252\274\340\253\215\340\254\274\340\254\276\340\255\215\340\255\226\340\255\227\340\256\276\340\257\215\340\257\227\340\261\215\340\261\225\340\261\226\340\262\274\340\263\202\340\263\215\340\263\225\340\263\226" +
    "\340\264\276\340\265\215\340\265\227\340\267\212\340\267\217\340\267\237\340\270\270-\340\270\272\340\271\210-\340\271\213\340\272\270\340\272\271\340\273\210-\340\273\213\340\274\230\340\274\231\340\274\265\340\274\267\340\274\271\340\275\261\340\275\262\340\275\264" +
    "\340\275\272-\340\275\275\340\276\200\340\276\202-\340\276\204\340\276\206\340\276\207\340\277\206\341\200\256\341\200\267\341\200\271\341\200\272\341\202\215\341\215\235-\341\215\237\341\234\224\341\234\264\341\237\222\341\237\235\341\242\251\341\244\271-\341\244\273" +
    "\341\250\227\341\250\230\341\251\240\341\251\265-\341\251\274\341\251\277\341\254\264\341\254\265\341\255\204\341\255\253-\341\255\263\341\256\252\341\256\253\341\257\246\341\257\262\341\257\263\341\260\267\341\263\220-\341\263\222\341\263\224-\341\263\240\341\263\242-\341\263\250\341\263\255\341\263\264" +
    "\341\267\200-\341\267\246\341\267\274-\341\267\277\342\203\220-\342\203\234\342\203\241\342\203\245-\342\203\260\342\263\257-\342\263\261\342\265\277\342\267\240-\342\267\277\343\200\252-\343\200\257\343\202\231\343\202\232\352\231\257\352\231\264-\352\231\275\352\232\237\352\233\260\352\233\261\352\240\206\352\243\204" +
    "\352\243\240-\352\243\261\352\244\253-\352\244\255\352\245\223\352\246\263\352\247\200\352\252\260\352\252\262-\352\252\264\352\252\267\352\252\270\352\252\276\352\252\277\352\253\201\352\253\266\352\257\255\357\254\236\357\270\240-\357\270\246\360\220\207\275\360\220\250\215" +
    "\360\220\250\217\360\220\250\270-\360\220\250\272\360\220\250\277\360\221\201\206\360\221\202\271\360\221\202\272\360\221\204\200-\360\221\204\202\360\221\204\247\360\221\204\263\360\221\204\264\360\221\207\200\360\221\232\266\360\221\232\267\360\235\205\245-\360\235\205\251\360\235\205\255-\360\235\205\262\360\235\205\273-\360\235\206\202\360\235\206\205-\360\235\206\213\360\235\206\252-\360\235\206\255\360\235\211\202-\360\235\211\204]+
    |  # Hangul syllables with separate trailer
    [\352\260\200\352\260\234\352\260\270\352\261\224\352\261\260\352\262\214\352\262\250\352\263\204\352\263\240\352\263\274\352\264\230\352\264\264\352\265\220\352\265\254\352\266\210\352\266\244" +
    "\352\267\200\352\267\234\352\267\270\352\270\224\352\270\260\352\271\214\352\271\250\352\272\204\352\272\240\352\272\274\352\273\230\352\273\264\352\274\220\352\274\254\352\275\210\352\275\244" +
    "\352\276\200\352\276\234\352\276\270\352\277\224\352\277\260\353\200\214\353\200\250\353\201\204\353\201\240\353\201\274\353\202\230\353\202\264\353\203\220\353\203\254\353\204\210\353\204\244" +
    "\353\205\200\353\205\234\353\205\270\353\206\224\353\206\260\353\207\214\353\207\250\353\210\204\353\210\240\353\210\274\353\211\230\353\211\264\353\212\220\353\212\254\353\213\210\353\213\244" +
    "\353\214\200\353\214\234\353\214\270\353\215\224\353\215\260\353\216\214\353\216\250\353\217\204\353\217\240\353\217\274\353\220\230\353\220\264\353\221\220\353\221\254\353\222\210\353\222\244" +
    "\353\223\200\353\223\234\353\223\270\353\224\224\353\224\260\353\225\214\353\225\250\353\226\204\353\226\240\353\226\274\353\227\230\353\227\264\353\230\220\353\230\254\353\231\210\353\231\244" +
    "\353\232\200\353\232\234\353\232\270\353\233\224\353\233\260\353\234\214\353\234\250\353\235\204\353\235\240\353\235\274\353\236\230\353\236\264\353\237\220\353\237\254\353\240\210\353\240\244" +
    "\353\241\200\353\241\234\353\241\270\353\242\224\353\242\260\353\243\214\353\243\250\353\244\204\353\244\240\353\244\274\353\245\230\353\245\264\353\246\220\353\246\254\353\247\210\353\247\244" +
    "\353\250\200\353\250\234\353\250\270\353\251\224\353\251\260\353\252\214\353\252\250\353\253\204\353\253\240\353\253\274\353\254\230\353\254\264\353\255\220\353\255\254\353\256\210\353\256\244" +
    "\353\257\200\353\257\234\353\257\270\353\260\224\353\260\260\353\261\214\353\261\250\353\262\204\353\262\240\353\262\274\353\263\230\353\263\264\353\264\220\353\264\254\353\265\210\353\265\244" +
    "\353\266\200\353\266\234\353\266\270\353\267\224\353\267\260\353\270\214\353\270\250\353\271\204\353\271\240\353\271\274\353\272\230\353\272\264\353\273\220\353\273\254\353\274\210\353\274\244" +
    "\353\275\200\353\275\234\353\275\270\353\276\224\353\276\260\353\277\214\353\277\250\354\200\204\354\200\240\354\200\274\354\201\230\354\201\264\354\202\220\354\202\254\354\203\210\354\203\244" +
    "\354\204\200\354\204\234\354\204\270\354\205\224\354\205\260\354\206\214\354\206\250\354\207\204\354\207\240\354\207\274\354\210\230\354\210\264\354\211\220\354\211\254\354\212\210\354\212\244" +
    "\354\213\200\354\213\234\354\213\270\354\214\224\354\214\260\354\215\214\354\215\250\354\216\204\354\216\240\354\216\274\354\217\230\354\217\264\354\220\220\354\220\254\354\221\210\354\221\244" +
    "\354\222\200\354\222\234\354\222\270\354\223\224\354\223\260\354\224\214\354\224\250\354\225\204\354\225\240\354\225\274\354\226\230\354\226\264\354\227\220\354\227\254\354\230\210\354\230\244" +
    "\354\231\200\354\231\234\354\231\270\354\232\224\354\232\260\354\233\214\354\233\250\354\234\204\354\234\240\354\234\274\354\235\230\354\235\264\354\236\220\354\236\254\354\237\210\354\237\244" +
    "\354\240\200\354\240\234\354\240\270\354\241\224\354\241\260\354\242\214\354\242\250\354\243\204\354\243\240\354\243\274\354\244\230\354\244\264\354\245\220\354\245\254\354\246\210\354\246\244" +
    "\354\247\200\354\247\234\354\247\270\354\250\224\354\250\260\354\251\214\354\251\250\354\252\204\354\252\240\354\252\274\354\253\230\354\253\264\354\254\220\354\254\254\354\255\210\354\255\244" +
    "\354\256\200\354\256\234\354\256\270\354\257\224\354\257\260\354\260\214\354\260\250\354\261\204\354\261\240\354\261\274\354\262\230\354\262\264\354\263\220\354\263\254\354\264\210\354\264\244" +
    "\354\265\200\354\265\234\354\265\270\354\266\224\354\266\260\354\267\214\354\267\250\354\270\204\354\270\240\354\270\274\354\271\230\354\271\264\354\272\220\354\272\254\354\273\210\354\273\244" +
    "\354\274\200\354\274\234\354\274\270\354\275\224\354\275\260\354\276\214\354\276\250\354\277\204\354\277\240\354\277\274\355\200\230\355\200\264\355\201\220\355\201\254\355\202\210\355\202\244" +
    "\355\203\200\355\203\234\355\203\270\355\204\224\355\204\260\355\205\214\355\205\250\355\206\204\355\206\240\355\206\274\355\207\230\355\207\264\355\210\220\355\210\254\355\211\210\355\211\244" +
    "\355\212\200\355\212\234\355\212\270\355\213\224\355\213\260\355\214\214\355\214\250\355\215\204\355\215\240\355\215\274\355\216\230\355\216\264\355\217\220\355\217\254\355\220\210\355\220\244" +
    "\355\221\200\355\221\234\355\221\270\355\222\224\355\222\260\355\223\214\355\223\250\355\224\204\355\224\240\355\224\274\355\225\230\355\225\264\355\226\220\355\226\254\355\227\210\355\227\244" +
    "\355\230\200\355\230\234\355\230\270\355\231\224\355\231\260\355\232\214\355\232\250\355\233\204\355\233\240\355\233\274\355\234\230\355\234\264\355\235\220\355\235\254\355\236\210][\341\206\250-\341\207\202]
    |  # decomposed Hangul syllables
    [\341\204\200-\341\204\222][\341\205\241-\341\205\265][\341\206\250-\341\207\202]?
  "
  REGEXP_K_STRING = "
    [\302\240\302\250\302\252\302\257\302\262-\302\265\302\270-\302\272\302\274-\302\276\304\262\304\263\304\277\305\200\305\211\305\277\307\204-\307\214\307\261-\307\263\312\260-\312\270\313\230-\313\235\313\240-\313\244" +
    "\315\272\316\204\316\205\317\220-\317\226\317\260-\317\262\317\264\317\265\317\271\326\207\331\265-\331\270\340\270\263\340\272\263\340\273\234\340\273\235\340\274\214\340\275\267\340\275\271\341\203\274\341\264\254-\341\264\256" +
    "\341\264\260-\341\264\272\341\264\274-\341\265\215\341\265\217-\341\265\252\341\265\270\341\266\233-\341\266\277\341\272\232\341\272\233\341\276\275\341\276\277-\341\277\201\341\277\215-\341\277\217\341\277\235-\341\277\237\341\277\255\341\277\256\341\277\275\341\277\276\342\200\200-\342\200\212\342\200\221\342\200\227\342\200\244-\342\200\246" +
    "\342\200\257\342\200\263\342\200\264\342\200\266\342\200\267\342\200\274\342\200\276\342\201\207-\342\201\211\342\201\227\342\201\237\342\201\260\342\201\261\342\201\264-\342\202\216\342\202\220-\342\202\234\342\202\250\342\204\200-\342\204\203\342\204\205-\342\204\207\342\204\211-\342\204\223\342\204\225\342\204\226" +
    "\342\204\231-\342\204\235\342\204\240-\342\204\242\342\204\244\342\204\250\342\204\254\342\204\255\342\204\257-\342\204\261\342\204\263-\342\204\271\342\204\273-\342\205\200\342\205\205-\342\205\211\342\205\220-\342\205\277\342\206\211\342\210\254\342\210\255\342\210\257\342\210\260\342\221\240-\342\223\252\342\250\214\342\251\264-\342\251\266" +
    "\342\261\274\342\261\275\342\265\257\342\272\237\342\273\263\342\274\200-\342\277\225\343\200\200\343\200\266\343\200\270-\343\200\272\343\202\233\343\202\234\343\202\237\343\203\277\343\204\261-\343\206\216\343\206\222-\343\206\237\343\210\200-\343\210\236\343\210\240-\343\211\207\343\211\220-\343\211\276" +
    "\343\212\200-\343\213\276\343\214\200-\343\217\277\352\235\260\352\237\270\352\237\271\357\254\200-\357\254\206\357\254\223-\357\254\227\357\254\240-\357\254\251\357\255\217-\357\256\261\357\257\223-\357\264\275\357\265\220-\357\266\217\357\266\222-\357\267\207\357\267\260-\357\267\274\357\270\220-\357\270\231\357\270\260-\357\271\204\357\271\207-\357\271\222\357\271\224-\357\271\246" +
    "\357\271\250-\357\271\253\357\271\260-\357\271\262\357\271\264\357\271\266-\357\273\274\357\274\201-\357\276\276\357\277\202-\357\277\207\357\277\212-\357\277\217\357\277\222-\357\277\227\357\277\232-\357\277\234\357\277\240-\357\277\246\357\277\250-\357\277\256\360\235\220\200-\360\235\221\224\360\235\221\226-\360\235\222\234\360\235\222\236\360\235\222\237\360\235\222\242\360\235\222\245\360\235\222\246" +
    "\360\235\222\251-\360\235\222\254\360\235\222\256-\360\235\222\271\360\235\222\273\360\235\222\275-\360\235\223\203\360\235\223\205-\360\235\224\205\360\235\224\207-\360\235\224\212\360\235\224\215-\360\235\224\224\360\235\224\226-\360\235\224\234\360\235\224\236-\360\235\224\271\360\235\224\273-\360\235\224\276\360\235\225\200-\360\235\225\204\360\235\225\206\360\235\225\212-\360\235\225\220\360\235\225\222-\360\235\232\245\360\235\232\250-\360\235\237\213\360\235\237\216-\360\235\237\277" +
    "\360\236\270\200-\360\236\270\203\360\236\270\205-\360\236\270\237\360\236\270\241\360\236\270\242\360\236\270\244\360\236\270\247\360\236\270\251-\360\236\270\262\360\236\270\264-\360\236\270\267\360\236\270\271\360\236\270\273\360\236\271\202\360\236\271\207\360\236\271\211\360\236\271\213\360\236\271\215-\360\236\271\217\360\236\271\221\360\236\271\222\360\236\271\224" +
    "\360\236\271\227\360\236\271\231\360\236\271\233\360\236\271\235\360\236\271\237\360\236\271\241\360\236\271\242\360\236\271\244\360\236\271\247-\360\236\271\252\360\236\271\254-\360\236\271\262\360\236\271\264-\360\236\271\267\360\236\271\271-\360\236\271\274\360\236\271\276\360\236\272\200-\360\236\272\211\360\236\272\213-\360\236\272\233\360\236\272\241-\360\236\272\243\360\236\272\245-\360\236\272\251" +
    "\360\236\272\253-\360\236\272\273\360\237\204\200-\360\237\204\212\360\237\204\220-\360\237\204\256\360\237\204\260-\360\237\205\217\360\237\205\252\360\237\205\253\360\237\206\220\360\237\210\200-\360\237\210\202\360\237\210\220-\360\237\210\272\360\237\211\200-\360\237\211\210\360\237\211\220\360\237\211\221]
  "

  CLASS_TABLE = {
    119144=>1, 69888=>230, 1768=>230, 2030=>230, 2292=>230, 851=>220, 3864=>220, 119210=>230, 786=>230, 2620=>7, 1441=>230, 119145=>1, 69889=>230, 2031=>230, 2293=>230, 852=>220, 
    3865=>220, 119211=>230, 787=>230, 1442=>220, 69890=>230, 1770=>220, 2032=>230, 2294=>220, 853=>220, 119212=>230, 43232=>230, 3277=>9, 788=>230, 1443=>220, 1771=>230, 2033=>230, 
    2295=>230, 854=>220, 7142=>7, 119213=>230, 43233=>230, 789=>232, 2492=>7, 1444=>220, 7405=>220, 1772=>230, 2034=>220, 2296=>230, 855=>230, 43234=>230, 790=>220, 1445=>220, 
    119149=>226, 1773=>220, 2035=>230, 2297=>220, 856=>232, 43235=>230, 791=>220, 1446=>220, 3149=>9, 119150=>216, 2298=>220, 857=>220, 6752=>9, 43236=>230, 1840=>230, 792=>220, 
    2364=>7, 1447=>220, 119151=>216, 2299=>230, 858=>220, 6098=>9, 43237=>230, 1841=>220, 793=>220, 1448=>230, 119152=>216, 43696=>230, 2300=>230, 859=>230, 43238=>230, 794=>232, 
    7082=>9, 1449=>230, 3021=>9, 1842=>230, 119153=>216, 2301=>230, 860=>233, 43239=>230, 795=>216, 7083=>9, 1450=>220, 1843=>230, 119154=>216, 43698=>230, 2302=>230, 861=>234, 
    69702=>9, 43240=>230, 796=>220, 1451=>230, 1844=>220, 43699=>230, 7412=>230, 862=>234, 7019=>230, 1648=>35, 43241=>230, 797=>220, 2893=>9, 1452=>230, 1845=>230, 43700=>220, 
    43307=>220, 863=>233, 7020=>220, 43766=>9, 43242=>230, 798=>220, 1453=>222, 1846=>230, 43308=>220, 7676=>233, 864=>234, 7021=>230, 43243=>230, 799=>220, 1454=>228, 5908=>9, 
    3157=>84, 1847=>220, 43309=>220, 7677=>220, 865=>234, 7022=>230, 43244=>230, 800=>220, 2765=>9, 1455=>230, 3158=>91, 1848=>220, 65056=>230, 43703=>230, 42655=>230, 7678=>230, 
    7154=>9, 866=>233, 7023=>230, 43245=>230, 801=>202, 1456=>10, 1849=>220, 65057=>230, 43704=>230, 7679=>220, 7155=>9, 867=>230, 7024=>230, 43246=>230, 12330=>218, 8400=>230, 
    802=>202, 1457=>11, 1850=>230, 65058=>230, 43443=>7, 868=>230, 7025=>230, 43247=>230, 12331=>228, 8401=>230, 803=>220, 2637=>9, 1458=>12, 1851=>220, 65059=>230, 869=>230, 
    7026=>230, 6109=>230, 43248=>230, 12332=>232, 8402=>1, 7616=>230, 7223=>7, 1459=>13, 1852=>220, 804=>220, 119163=>220, 65060=>230, 870=>230, 7027=>230, 43249=>230, 12333=>222, 
    8403=>1, 7617=>230, 1460=>14, 1853=>230, 805=>220, 119164=>220, 65061=>230, 11744=>230, 871=>230, 12334=>224, 8404=>230, 7618=>220, 2509=>9, 1461=>15, 1854=>220, 806=>220, 
    119165=>220, 71350=>9, 65062=>230, 11745=>230, 872=>230, 119362=>230, 66045=>220, 12335=>224, 8405=>230, 7619=>230, 6964=>7, 1462=>16, 1855=>230, 807=>202, 119166=>220, 71351=>7, 
    43710=>230, 11746=>230, 873=>230, 119363=>230, 8406=>230, 7620=>230, 1463=>17, 1856=>230, 808=>202, 119167=>220, 43711=>230, 11747=>230, 874=>230, 119364=>230, 8407=>230, 7621=>230, 
    1464=>18, 1857=>230, 809=>220, 2381=>9, 3953=>129, 119168=>220, 11748=>230, 875=>230, 8408=>1, 7622=>230, 1465=>19, 1858=>220, 810=>220, 3954=>130, 119169=>220, 43713=>230, 
    11749=>230, 4151=>7, 876=>230, 8409=>1, 7623=>230, 1466=>19, 1859=>230, 6313=>228, 811=>220, 119170=>220, 11750=>230, 877=>230, 8410=>1, 7624=>230, 1467=>20, 1860=>220, 
    812=>220, 3956=>132, 11751=>230, 4153=>9, 878=>230, 6773=>230, 8411=>230, 7625=>230, 1468=>21, 1861=>230, 813=>220, 2385=>230, 11752=>230, 879=>230, 6774=>230, 4154=>9, 
    8412=>230, 7626=>220, 1469=>22, 1862=>220, 814=>220, 2386=>220, 119173=>230, 11753=>230, 6775=>230, 3893=>220, 7627=>230, 1863=>230, 815=>220, 2387=>230, 119174=>230, 43456=>9, 
    11754=>230, 6776=>230, 42736=>230, 7628=>230, 1471=>23, 1864=>220, 816=>220, 2388=>230, 119175=>230, 64286=>26, 11755=>230, 6777=>230, 3895=>220, 42737=>230, 7629=>234, 1865=>230, 
    817=>220, 119176=>230, 11756=>230, 6778=>230, 68152=>230, 42607=>230, 7630=>214, 1473=>24, 1866=>230, 818=>220, 3962=>130, 119177=>230, 11757=>230, 6779=>230, 3897=>216, 68153=>1, 
    8417=>230, 7631=>220, 819=>220, 3963=>130, 1474=>25, 119178=>220, 11758=>230, 6780=>230, 68154=>220, 7632=>202, 820=>1, 3964=>130, 119179=>220, 11759=>230, 3768=>118, 7633=>230, 
    821=>1, 3965=>130, 1476=>230, 11760=>230, 3769=>118, 7634=>230, 822=>1, 1477=>220, 11761=>230, 6783=>220, 42612=>230, 8421=>1, 7635=>230, 823=>1, 6980=>9, 11762=>230, 
    3640=>103, 42613=>230, 8422=>1, 7636=>230, 6457=>222, 824=>1, 3968=>130, 1479=>18, 11763=>230, 3641=>103, 68159=>9, 42614=>230, 8423=>230, 7637=>230, 6458=>230, 825=>220, 
    1611=>27, 43204=>9, 11764=>230, 2070=>230, 3642=>9, 42615=>230, 8424=>220, 7638=>230, 7376=>230, 6459=>220, 826=>220, 3970=>230, 1612=>28, 11765=>230, 11503=>230, 2071=>230, 
    1809=>36, 42616=>230, 8425=>230, 7639=>230, 7377=>230, 2137=>220, 827=>220, 3971=>230, 1613=>29, 11766=>230, 11504=>230, 2072=>230, 1155=>230, 42617=>230, 8426=>1, 7640=>230, 
    7378=>230, 2138=>220, 828=>220, 3972=>9, 1614=>30, 11767=>230, 11505=>230, 2073=>230, 4038=>220, 1156=>230, 42618=>230, 8427=>1, 7641=>230, 2139=>220, 829=>230, 1615=>31, 
    11768=>230, 1157=>230, 42619=>230, 8428=>220, 7642=>230, 7380=>1, 830=>230, 3974=>230, 1616=>32, 11769=>230, 4957=>230, 2075=>230, 1158=>230, 42620=>230, 8429=>220, 7643=>230, 
    7381=>220, 831=>230, 3975=>230, 4237=>220, 5940=>9, 1617=>33, 11770=>230, 2076=>230, 1159=>230, 1552=>230, 4958=>230, 43014=>9, 42621=>230, 8430=>220, 7644=>230, 7382=>220, 
    832=>230, 1618=>34, 11771=>230, 1553=>230, 4959=>230, 2077=>230, 8431=>220, 7645=>230, 7383=>220, 833=>230, 1619=>230, 1750=>230, 11772=>230, 768=>230, 1554=>230, 2078=>230, 
    8432=>230, 7646=>230, 7384=>220, 834=>230, 1620=>230, 1751=>230, 11773=>230, 769=>230, 1555=>230, 2079=>230, 7647=>230, 7385=>220, 2276=>230, 835=>230, 1621=>220, 1752=>230, 
    11774=>230, 1425=>220, 1556=>230, 2080=>230, 770=>230, 7648=>230, 7386=>230, 2277=>230, 836=>230, 1622=>220, 1753=>230, 69939=>9, 11775=>230, 3784=>122, 1426=>230, 1557=>230, 
    3260=>7, 2081=>230, 771=>230, 7649=>230, 7387=>230, 1623=>230, 1754=>230, 2278=>220, 837=>240, 69940=>9, 43347=>9, 1427=>230, 1558=>230, 2082=>230, 772=>230, 3785=>122, 
    7650=>230, 7388=>220, 1624=>230, 1755=>230, 2279=>230, 838=>230, 1428=>230, 1559=>230, 2083=>230, 773=>230, 3786=>122, 7651=>230, 7389=>220, 1625=>230, 1756=>230, 2280=>230, 
    839=>220, 11647=>9, 1429=>230, 1560=>30, 3656=>107, 774=>230, 3787=>122, 7652=>230, 7390=>220, 1626=>230, 2281=>220, 840=>220, 68109=>220, 1430=>220, 1561=>31, 2085=>230, 
    3657=>107, 775=>230, 7653=>230, 7391=>220, 1627=>230, 2282=>230, 841=>220, 1431=>230, 1562=>32, 2086=>230, 3658=>107, 776=>230, 7654=>230, 7392=>230, 1628=>220, 1759=>230, 
    2283=>230, 842=>230, 68111=>230, 1432=>230, 2087=>230, 3659=>107, 777=>230, 1629=>230, 1760=>230, 2284=>230, 843=>230, 1433=>230, 778=>230, 7394=>1, 1630=>230, 1761=>230, 
    2285=>220, 844=>230, 1434=>222, 3530=>9, 2089=>230, 779=>230, 7395=>1, 1631=>220, 1762=>230, 2286=>220, 845=>220, 69817=>9, 2876=>7, 1435=>220, 2090=>230, 780=>230, 
    7396=>1, 1763=>220, 2287=>220, 846=>220, 70080=>9, 69818=>7, 1436=>230, 2091=>230, 781=>230, 7397=>1, 1764=>230, 2288=>27, 12441=>8, 1437=>230, 2092=>230, 782=>230, 
    119141=>216, 7398=>1, 2027=>230, 2289=>28, 848=>230, 44013=>9, 12442=>8, 1438=>230, 2093=>230, 783=>230, 2748=>7, 119142=>216, 7399=>1, 2028=>230, 2290=>29, 849=>230, 
    1439=>230, 784=>230, 6679=>230, 119143=>1, 7400=>1, 1767=>230, 2029=>230, 2291=>230, 850=>230, 3405=>9, 785=>230, 6680=>220, 1440=>230, 
  }
  CLASS_TABLE.default = 0

  DECOMPOSITION_TABLE = {
    260=>[65, 808], 3907=>[3906, 4023], 194593=>[21062], 8075=>[913, 788, 768, 837], 63822=>[28431], 194854=>[149301], 64083=>[31118], 521=>[105, 783], 7815=>[119, 775], 261=>[97, 808], 2345=>[2344, 2364], 194594=>[21106], 8076=>[913, 787, 769, 837], 63823=>[32047], 194855=>[149524], 64084=>[31296], 
    522=>[73, 785], 12505=>[12504, 12441], 7816=>[87, 803], 262=>[67, 769], 194595=>[21111], 8077=>[913, 788, 769, 837], 63824=>[32311], 194856=>[29562], 64085=>[31361], 523=>[105, 785], 12506=>[12504, 12442], 7817=>[119, 803], 263=>[99, 769], 194596=>[13589], 8078=>[913, 787, 834, 837], 63825=>[38475], 
    194857=>[29579], 64086=>[31680], 524=>[79, 783], 7818=>[88, 775], 264=>[67, 770], 194597=>[21191], 8079=>[913, 788, 834, 837], 63826=>[21202], 194858=>[16044], 64087=>[32244], 525=>[111, 783], 12508=>[12507, 12441], 7819=>[120, 775], 265=>[99, 770], 194598=>[21193], 8080=>[951, 787, 837], 
    63827=>[32907], 194859=>[29605], 64088=>[32265], 526=>[79, 785], 12509=>[12507, 12442], 7820=>[88, 776], 266=>[67, 775], 8602=>[8592, 824], 194599=>[21220], 8081=>[951, 788, 837], 63828=>[20956], 194860=>[16056], 64089=>[32321], 527=>[111, 785], 2611=>[2610, 2620], 7821=>[120, 776], 
    267=>[99, 775], 8603=>[8594, 824], 194600=>[21242], 8082=>[951, 787, 768, 837], 63829=>[20940], 194861=>[16056], 64090=>[32626], 528=>[82, 783], 1049=>[1048, 774], 7822=>[89, 775], 1570=>[1575, 1619], 268=>[67, 780], 194601=>[21253], 8083=>[951, 788, 768, 837], 63830=>[31260], 194862=>[29767], 
    64091=>[32773], 529=>[114, 783], 7823=>[121, 775], 1571=>[1575, 1620], 269=>[99, 780], 2353=>[2352, 2364], 194602=>[21254], 8084=>[951, 787, 769, 837], 63831=>[32190], 194863=>[29788], 64092=>[33261], 530=>[82, 785], 2614=>[2616, 2620], 7824=>[90, 770], 1572=>[1608, 1620], 270=>[68, 780], 
    3917=>[3916, 4023], 194603=>[21271], 8085=>[951, 788, 769, 837], 63832=>[33777], 194864=>[29809], 64093=>[33401], 531=>[114, 785], 7825=>[122, 770], 1573=>[1575, 1621], 271=>[100, 780], 194604=>[21321], 8086=>[951, 787, 834, 837], 63833=>[38517], 194865=>[29829], 64094=>[33401], 532=>[85, 783], 
    7826=>[90, 803], 1574=>[1610, 1620], 2356=>[2355, 2364], 194605=>[21329], 8087=>[951, 788, 834, 837], 63834=>[35712], 194866=>[29898], 64095=>[33879], 533=>[117, 783], 7827=>[122, 803], 194606=>[21338], 8088=>[919, 787, 837], 63835=>[25295], 194867=>[16155], 64096=>[35088], 534=>[85, 785], 
    7828=>[90, 817], 274=>[69, 772], 194607=>[21363], 8089=>[919, 788, 837], 63836=>[27138], 194868=>[29988], 64097=>[35222], 535=>[117, 785], 7829=>[122, 817], 275=>[101, 772], 3922=>[3921, 4023], 194608=>[21373], 8090=>[919, 787, 768, 837], 63837=>[35582], 194869=>[150582], 64098=>[35585], 
    536=>[83, 806], 7830=>[104, 817], 276=>[69, 774], 194609=>[21375], 8091=>[919, 788, 768, 837], 63838=>[20025], 3402=>[3398, 3390], 194870=>[30014], 537=>[115, 806], 7831=>[116, 776], 64099=>[35641], 277=>[101, 774], 194610=>[21375], 8092=>[919, 787, 769, 837], 63839=>[23527], 3403=>[3399, 3390], 
    194871=>[150674], 538=>[84, 806], 7832=>[119, 778], 64100=>[36051], 278=>[69, 775], 194611=>[21375], 8093=>[919, 788, 769, 837], 63840=>[24594], 3404=>[3398, 3415], 194872=>[30064], 539=>[116, 806], 7833=>[121, 778], 3144=>[3142, 3158], 64101=>[36104], 279=>[101, 775], 194612=>[133676], 
    8094=>[919, 787, 834, 837], 63841=>[29575], 194873=>[139679], 8876=>[8866, 824], 64102=>[36790], 280=>[69, 808], 3927=>[3926, 4023], 194613=>[28784], 8095=>[919, 788, 834, 837], 63842=>[30064], 194874=>[30224], 8877=>[8872, 824], 7835=>[383, 775], 64103=>[36920], 281=>[101, 808], 194614=>[21450], 
    8096=>[969, 787, 837], 63843=>[21271], 194875=>[151457], 542=>[72, 780], 8878=>[8873, 824], 64104=>[38627], 282=>[69, 780], 194615=>[21471], 8097=>[969, 788, 837], 63844=>[30971], 194876=>[151480], 543=>[104, 780], 8879=>[8875, 824], 64105=>[38911], 2888=>[2887, 2902], 194616=>[133987], 
    8098=>[969, 787, 768, 837], 63845=>[20415], 283=>[101, 780], 194877=>[151620], 64106=>[38971], 194617=>[21483], 8099=>[969, 788, 768, 837], 63846=>[24489], 284=>[71, 770], 194878=>[16380], 64107=>[24693], 3932=>[3931, 4023], 194618=>[21489], 8100=>[969, 787, 769, 837], 63847=>[19981], 285=>[103, 770], 
    194879=>[16392], 7840=>[65, 803], 64108=>[148206], 8622=>[8596, 824], 2891=>[2887, 2878], 194619=>[21510], 8101=>[969, 788, 769, 837], 63848=>[27852], 286=>[71, 774], 194880=>[30452], 7841=>[97, 803], 64109=>[33304], 2892=>[2887, 2903], 194620=>[21662], 8102=>[969, 787, 834, 837], 63849=>[25976], 
    287=>[103, 774], 194881=>[151795], 7842=>[65, 777], 194621=>[21560], 8103=>[969, 788, 834, 837], 63850=>[32034], 288=>[71, 775], 194882=>[151794], 12532=>[12454, 12441], 7843=>[97, 777], 194622=>[21576], 8104=>[937, 787, 837], 63851=>[21443], 289=>[103, 775], 194883=>[151833], 550=>[65, 775], 
    7844=>[65, 770, 769], 64112=>[20006], 194623=>[21608], 8105=>[937, 788, 837], 63852=>[22622], 290=>[71, 807], 194884=>[151859], 551=>[97, 775], 7845=>[97, 770, 769], 64113=>[20917], 194624=>[21666], 8106=>[937, 787, 768, 837], 63853=>[30465], 291=>[103, 807], 194885=>[30494], 552=>[69, 807], 
    12535=>[12527, 12441], 10972=>[10973, 824], 7846=>[65, 770, 768], 64114=>[20840], 194625=>[21750], 8107=>[937, 788, 768, 837], 63854=>[33865], 292=>[72, 770], 194886=>[30495], 553=>[101, 807], 12536=>[12528, 12441], 7847=>[97, 770, 768], 64115=>[20352], 194626=>[21776], 8108=>[937, 787, 769, 837], 63855=>[35498], 
    293=>[104, 770], 194887=>[30495], 554=>[79, 776, 772], 12537=>[12529, 12441], 7848=>[65, 770, 777], 64116=>[20805], 194627=>[21843], 8109=>[937, 788, 769, 837], 63856=>[27578], 194888=>[30538], 555=>[111, 776, 772], 12538=>[12530, 12441], 7849=>[97, 770, 777], 64117=>[20864], 194628=>[21859], 8110=>[937, 787, 834, 837], 
    63857=>[36784], 194889=>[16441], 556=>[79, 771, 772], 7850=>[65, 770, 771], 64118=>[21191], 194629=>[21892], 8111=>[937, 788, 834, 837], 63858=>[27784], 296=>[73, 771], 194890=>[30603], 557=>[111, 771, 772], 7851=>[97, 770, 771], 64119=>[21242], 194630=>[21892], 8112=>[945, 774], 63859=>[25342], 
    297=>[105, 771], 194891=>[16454], 558=>[79, 775], 7852=>[65, 803, 770], 64120=>[21917], 3945=>[3904, 4021], 194631=>[21913], 8113=>[945, 772], 63860=>[33509], 298=>[73, 772], 194892=>[16534], 559=>[111, 775], 12542=>[12541, 12441], 7853=>[97, 803, 770], 64121=>[21845], 194632=>[21931], 
    8114=>[945, 768, 837], 63861=>[25504], 299=>[105, 772], 194893=>[152605], 560=>[79, 775, 772], 1081=>[1080, 774], 7854=>[65, 774, 769], 64122=>[21913], 194633=>[21939], 8115=>[945, 837], 63862=>[30053], 300=>[73, 774], 194894=>[30798], 561=>[111, 775, 772], 7855=>[97, 774, 769], 64123=>[21986], 
    194634=>[21954], 8116=>[945, 769, 837], 63863=>[20142], 301=>[105, 774], 194895=>[30860], 562=>[89, 772], 7856=>[65, 774, 768], 64124=>[22618], 194635=>[22294], 63864=>[20841], 302=>[73, 808], 194896=>[30924], 563=>[121, 772], 7857=>[97, 774, 768], 64125=>[22707], 2908=>[2849, 2876], 
    194636=>[22022], 8118=>[945, 834], 63865=>[20937], 303=>[105, 808], 194897=>[16611], 7858=>[65, 774, 777], 64126=>[22852], 2909=>[2850, 2876], 194637=>[22295], 8119=>[945, 834, 837], 63866=>[26753], 304=>[73, 775], 194898=>[153126], 2649=>[2582, 2620], 7859=>[97, 774, 777], 64127=>[22868], 
    194638=>[22097], 8120=>[913, 774], 63867=>[31975], 194899=>[31062], 2650=>[2583, 2620], 7860=>[65, 774, 771], 64128=>[23138], 194639=>[22132], 8121=>[913, 772], 63868=>[33391], 194900=>[153242], 2651=>[2588, 2620], 7861=>[97, 774, 771], 64129=>[23336], 194640=>[20999], 8122=>[913, 768], 
    63869=>[35538], 194901=>[153285], 7862=>[65, 803, 774], 64130=>[24274], 3955=>[3953, 3954], 2392=>[2325, 2364], 194641=>[22766], 8123=>[913, 769], 63870=>[37327], 308=>[74, 770], 194902=>[31119], 7863=>[97, 803, 774], 64131=>[24281], 2393=>[2326, 2364], 194642=>[22478], 8124=>[913, 837], 
    63871=>[21237], 309=>[106, 770], 194903=>[31211], 2654=>[2603, 2620], 7864=>[69, 803], 64132=>[24425], 3957=>[3953, 3956], 2394=>[2327, 2364], 194643=>[22516], 63872=>[21570], 310=>[75, 807], 194904=>[16687], 7865=>[101, 803], 64133=>[24493], 3958=>[4018, 3968], 2395=>[2332, 2364], 
    832=>[768], 194644=>[22541], 8126=>[953], 63873=>[22899], 311=>[107, 807], 194905=>[31296], 7866=>[69, 777], 64134=>[24792], 2396=>[2337, 2364], 833=>[769], 194645=>[22411], 63874=>[24300], 194906=>[31306], 7867=>[101, 777], 64135=>[24910], 3960=>[4019, 3968], 
    2397=>[2338, 2364], 194646=>[22578], 63875=>[26053], 313=>[76, 769], 194907=>[31311], 7868=>[69, 771], 64136=>[24840], 2398=>[2347, 2364], 835=>[787], 194647=>[22577], 8129=>[168, 834], 63876=>[28670], 314=>[108, 769], 194908=>[153980], 7869=>[101, 771], 64137=>[24974], 
    2399=>[2351, 2364], 836=>[776, 769], 194648=>[22700], 8130=>[951, 768, 837], 63877=>[31018], 315=>[76, 807], 194909=>[154279], 7870=>[69, 770, 769], 64138=>[24928], 194649=>[136420], 8131=>[951, 837], 63878=>[38317], 316=>[108, 807], 194910=>[154279], 7871=>[101, 770, 769], 64139=>[25074], 
    194650=>[22770], 8132=>[951, 769, 837], 63879=>[39530], 317=>[76, 780], 8653=>[8656, 824], 194911=>[31470], 7872=>[69, 770, 768], 64140=>[25140], 194651=>[22775], 63880=>[40599], 318=>[108, 780], 8654=>[8660, 824], 194912=>[16898], 7873=>[101, 770, 768], 64141=>[25540], 194652=>[22790], 
    8134=>[951, 834], 63881=>[40654], 8655=>[8658, 824], 194913=>[154539], 7874=>[69, 770, 777], 64142=>[25628], 194653=>[22810], 8135=>[951, 834, 837], 63882=>[21147], 194914=>[31686], 7875=>[101, 770, 777], 64143=>[25682], 194654=>[22818], 8136=>[917, 768], 63883=>[26310], 194915=>[31689], 
    7876=>[69, 770, 771], 64144=>[25942], 194655=>[22882], 8137=>[917, 769], 63884=>[27511], 3969=>[3953, 3968], 194916=>[16935], 1104=>[1077, 768], 7877=>[101, 770, 771], 64145=>[26228], 194656=>[136872], 8138=>[919, 768], 63885=>[36706], 323=>[78, 769], 194917=>[154752], 1105=>[1077, 776], 
    7878=>[69, 803, 770], 64146=>[26391], 194657=>[136938], 8139=>[919, 769], 63886=>[24180], 324=>[110, 769], 194918=>[31954], 7879=>[101, 803, 770], 64147=>[26395], 194658=>[23020], 8140=>[919, 837], 63887=>[24976], 325=>[78, 807], 194919=>[17056], 1107=>[1075, 769], 7880=>[73, 777], 
    64148=>[26454], 194659=>[23067], 8141=>[8127, 768], 63888=>[25088], 326=>[110, 807], 194920=>[31976], 7881=>[105, 777], 64149=>[27513], 194660=>[23079], 8142=>[8127, 769], 63889=>[25754], 327=>[78, 780], 194921=>[31971], 7882=>[73, 803], 64150=>[27578], 194661=>[23000], 
    8143=>[8127, 834], 63890=>[28451], 328=>[110, 780], 194922=>[32000], 7883=>[105, 803], 64151=>[27969], 194662=>[23142], 8144=>[953, 774], 63891=>[29001], 194923=>[155526], 1111=>[1110, 776], 7884=>[79, 803], 64152=>[28379], 194663=>[14062], 8145=>[953, 772], 63892=>[29833], 
    194924=>[32099], 7885=>[111, 803], 64153=>[28363], 194664=>[14076], 8146=>[953, 776, 768], 63893=>[31178], 194925=>[17153], 7886=>[79, 777], 64154=>[28450], 8928=>[8828, 824], 194665=>[23304], 8147=>[953, 776, 769], 63894=>[32244], 332=>[79, 772], 194926=>[32199], 7887=>[111, 777], 
    64155=>[28702], 8929=>[8829, 824], 194666=>[23358], 63895=>[32879], 333=>[111, 772], 194927=>[32258], 7888=>[79, 770, 769], 64156=>[29038], 8930=>[8849, 824], 194667=>[23358], 63896=>[36646], 334=>[79, 774], 194928=>[32325], 1116=>[1082, 769], 7889=>[111, 770, 769], 64157=>[30631], 
    8931=>[8850, 824], 194668=>[137672], 8150=>[953, 834], 63897=>[34030], 335=>[111, 774], 194929=>[17204], 1117=>[1080, 768], 7890=>[79, 770, 768], 64158=>[29237], 194669=>[23491], 8151=>[953, 776, 834], 63898=>[36899], 336=>[79, 779], 194930=>[156200], 1118=>[1091, 774], 7891=>[111, 770, 768], 
    64159=>[29359], 194670=>[23512], 8152=>[921, 774], 63899=>[37706], 337=>[111, 779], 194931=>[156231], 7892=>[79, 770, 777], 64160=>[29482], 194671=>[23527], 8153=>[921, 772], 63900=>[21015], 194932=>[17241], 7893=>[111, 770, 777], 64161=>[29809], 194672=>[23539], 8154=>[921, 768], 
    63901=>[21155], 194933=>[156377], 7894=>[79, 770, 771], 64162=>[29958], 194673=>[138008], 8155=>[921, 769], 63902=>[21693], 340=>[82, 769], 3987=>[3986, 4023], 194934=>[32634], 7895=>[111, 770, 771], 64163=>[30011], 194674=>[23551], 63903=>[28872], 341=>[114, 769], 194935=>[156478], 
    7896=>[79, 803, 770], 64164=>[30237], 8938=>[8882, 824], 194675=>[23558], 8157=>[8190, 768], 63904=>[35010], 342=>[82, 807], 194936=>[32661], 7897=>[111, 803, 770], 64165=>[30239], 8939=>[8883, 824], 194676=>[24403], 8158=>[8190, 769], 63905=>[35498], 343=>[114, 807], 194937=>[32762], 
    7898=>[79, 795, 769], 64166=>[30410], 8940=>[8884, 824], 194677=>[23586], 8159=>[8190, 834], 63906=>[24265], 344=>[82, 780], 194938=>[32773], 7899=>[111, 795, 769], 64167=>[30427], 8941=>[8885, 824], 194678=>[14209], 8160=>[965, 774], 63907=>[24565], 345=>[114, 780], 194939=>[156890], 
    7900=>[79, 795, 768], 64168=>[30452], 119134=>[119127, 119141], 194679=>[23648], 8161=>[965, 772], 63908=>[25467], 346=>[83, 769], 194940=>[156963], 7901=>[111, 795, 768], 64169=>[30538], 119135=>[119128, 119141], 194680=>[23662], 8162=>[965, 776, 768], 63909=>[27566], 347=>[115, 769], 194941=>[32864], 
    7902=>[79, 795, 777], 64170=>[30528], 119136=>[119128, 119141, 119150], 194681=>[23744], 8163=>[965, 776, 769], 63910=>[31806], 348=>[83, 770], 194942=>[157096], 7903=>[111, 795, 777], 64171=>[30924], 119137=>[119128, 119141, 119151], 194682=>[23693], 8164=>[961, 787], 63911=>[29557], 349=>[115, 770], 194943=>[32880], 
    7904=>[79, 795, 771], 64172=>[31409], 119138=>[119128, 119141, 119152], 194683=>[138724], 8165=>[961, 788], 63912=>[20196], 350=>[83, 807], 3997=>[3996, 4023], 194944=>[144223], 7905=>[111, 795, 771], 64173=>[31680], 119139=>[119128, 119141, 119153], 194684=>[23875], 8166=>[965, 834], 63913=>[22265], 351=>[115, 807], 
    194945=>[17365], 7906=>[79, 795, 803], 64174=>[31867], 119140=>[119128, 119141, 119154], 194685=>[138726], 8167=>[965, 776, 834], 63914=>[23527], 352=>[83, 780], 194946=>[32946], 7907=>[111, 795, 803], 64175=>[32091], 194686=>[23918], 8168=>[933, 774], 63915=>[23994], 353=>[115, 780], 194947=>[33027], 
    7908=>[85, 803], 64176=>[32244], 194687=>[23915], 8169=>[933, 772], 63916=>[24604], 354=>[84, 807], 194948=>[17419], 7909=>[117, 803], 64177=>[32574], 194688=>[23932], 8170=>[933, 768], 63917=>[29618], 355=>[116, 807], 4002=>[4001, 4023], 194949=>[33086], 7910=>[85, 777], 
    64178=>[32773], 194689=>[24033], 8171=>[933, 769], 63918=>[29801], 356=>[84, 780], 194950=>[23221], 7911=>[117, 777], 64179=>[33618], 194690=>[24034], 8172=>[929, 788], 63919=>[32666], 357=>[116, 780], 194951=>[157607], 7912=>[85, 795, 769], 64180=>[33775], 194691=>[14383], 
    8173=>[168, 768], 63920=>[32838], 194952=>[157621], 7913=>[117, 795, 769], 64181=>[34681], 2964=>[2962, 3031], 194692=>[24061], 8174=>[168, 769], 63921=>[37428], 194953=>[144275], 7914=>[85, 795, 768], 64182=>[35137], 194693=>[24104], 8175=>[96], 63922=>[38646], 360=>[85, 771], 
    4007=>[4006, 4023], 194954=>[144284], 7915=>[117, 795, 768], 64183=>[35206], 1142=>[1140, 783], 194694=>[24125], 63923=>[38728], 361=>[117, 771], 194955=>[33281], 7916=>[85, 795, 777], 64184=>[35222], 1143=>[1141, 783], 194695=>[24169], 63924=>[38936], 362=>[85, 772], 194956=>[33284], 
    7917=>[117, 795, 777], 64185=>[35519], 194696=>[14434], 8178=>[969, 768, 837], 63925=>[20363], 363=>[117, 772], 884=>[697], 194957=>[36766], 7918=>[85, 795, 771], 64186=>[35576], 194697=>[139651], 8179=>[969, 837], 63926=>[31150], 364=>[85, 774], 194958=>[17515], 7919=>[117, 795, 771], 
    64187=>[35531], 194698=>[14460], 8180=>[969, 769, 837], 63927=>[37300], 365=>[117, 774], 4012=>[4011, 4023], 194959=>[33425], 7920=>[85, 795, 803], 64188=>[35585], 194699=>[24240], 63928=>[38584], 366=>[85, 778], 194960=>[33419], 7921=>[117, 795, 803], 64189=>[35582], 194700=>[24243], 
    8182=>[969, 834], 63929=>[24801], 367=>[117, 778], 194961=>[33437], 7922=>[89, 768], 64190=>[35565], 194701=>[24246], 8183=>[969, 834, 837], 63930=>[20102], 368=>[85, 779], 194962=>[21171], 7923=>[121, 768], 64191=>[35641], 194702=>[24266], 8184=>[927, 768], 63931=>[20698], 
    369=>[117, 779], 194963=>[33457], 64192=>[35722], 7924=>[89, 803], 194703=>[172946], 8185=>[927, 769], 63932=>[23534], 370=>[85, 808], 194964=>[33459], 64193=>[36104], 7925=>[121, 803], 8186=>[937, 768], 63933=>[23615], 371=>[117, 808], 194704=>[24318], 194965=>[33469], 
    64194=>[36664], 7926=>[89, 777], 8187=>[937, 769], 63934=>[26009], 372=>[87, 770], 8708=>[8707, 824], 194705=>[140081], 194966=>[33510], 64195=>[36978], 7927=>[121, 777], 8188=>[937, 837], 63935=>[27138], 373=>[119, 770], 894=>[59], 194706=>[140081], 194967=>[158524], 
    64196=>[37273], 7928=>[89, 771], 8189=>[180], 63936=>[29134], 374=>[89, 770], 194707=>[33281], 194968=>[33509], 64197=>[37494], 7929=>[121, 771], 63937=>[30274], 375=>[121, 770], 194708=>[24354], 194969=>[33565], 64198=>[38524], 63938=>[34044], 376=>[89, 776], 
    194709=>[24354], 194970=>[33635], 64199=>[38627], 8192=>[8194], 63939=>[36988], 377=>[90, 769], 8713=>[8712, 824], 194710=>[14535], 194971=>[33709], 64200=>[38742], 8193=>[8195], 63940=>[40845], 378=>[122, 769], 4025=>[3984, 4021], 194711=>[144056], 194972=>[33571], 
    64201=>[38875], 63941=>[26248], 379=>[90, 775], 194712=>[156122], 194973=>[33725], 64202=>[38911], 63942=>[38446], 380=>[122, 775], 8716=>[8715, 824], 901=>[168, 769], 194713=>[24418], 194974=>[33767], 64203=>[38923], 69934=>[69937, 69927], 63943=>[21129], 381=>[90, 780], 
    12364=>[12363, 12441], 902=>[913, 769], 194714=>[24427], 194975=>[33879], 64204=>[38971], 69935=>[69938, 69927], 7936=>[945, 787], 63944=>[26491], 382=>[122, 780], 903=>[183], 194715=>[14563], 194976=>[33619], 64205=>[39698], 7937=>[945, 788], 63945=>[26611], 12366=>[12365, 12441], 
    904=>[917, 769], 194716=>[24474], 194977=>[33738], 64206=>[40860], 7938=>[945, 787, 768], 63946=>[27969], 905=>[919, 769], 194717=>[24525], 194978=>[33740], 64207=>[141386], 7939=>[945, 788, 768], 63947=>[28316], 12368=>[12367, 12441], 906=>[921, 769], 194718=>[24535], 194979=>[33756], 
    64208=>[141380], 7940=>[945, 787, 769], 63948=>[29705], 7680=>[65, 805], 194719=>[24569], 194980=>[158774], 64209=>[144341], 7941=>[945, 788, 769], 63949=>[30041], 12370=>[12369, 12441], 908=>[927, 769], 7681=>[97, 805], 194720=>[24705], 194981=>[159083], 64210=>[15261], 7942=>[945, 787, 834], 
    63950=>[30827], 7682=>[66, 775], 194721=>[14650], 194982=>[158933], 64211=>[16408], 7943=>[945, 788, 834], 63951=>[32016], 12372=>[12371, 12441], 910=>[933, 769], 7683=>[98, 775], 194722=>[14620], 194983=>[17707], 64212=>[16441], 7944=>[913, 787], 63952=>[39006], 911=>[937, 769], 
    7684=>[66, 803], 194723=>[24724], 194984=>[34033], 64213=>[152137], 7945=>[913, 788], 63953=>[20845], 12374=>[12373, 12441], 912=>[953, 776, 769], 7685=>[98, 803], 194724=>[141012], 194985=>[34035], 64214=>[154832], 7946=>[913, 787, 768], 63954=>[25134], 7686=>[66, 817], 194725=>[24775], 
    194986=>[34070], 64215=>[163539], 7947=>[913, 788, 768], 63955=>[38520], 12376=>[12375, 12441], 7687=>[98, 817], 194726=>[24904], 194987=>[160714], 64216=>[40771], 7948=>[913, 787, 769], 63956=>[20523], 7688=>[67, 807, 769], 194727=>[24908], 194988=>[34148], 64217=>[40846], 7949=>[913, 788, 769], 
    63957=>[23833], 12378=>[12377, 12441], 7689=>[99, 807, 769], 194728=>[24910], 194989=>[159532], 7950=>[913, 787, 834], 7690=>[68, 775], 194729=>[24908], 63958=>[28138], 194990=>[17757], 7951=>[913, 788, 834], 12380=>[12379, 12441], 7691=>[100, 775], 194730=>[24954], 63959=>[36650], 194991=>[17761], 
    7952=>[949, 787], 7692=>[68, 803], 194731=>[24974], 63960=>[24459], 194992=>[159665], 7953=>[949, 788], 3264=>[3263, 3285], 12382=>[12381, 12441], 7693=>[100, 803], 194732=>[25010], 63961=>[24900], 194993=>[159954], 7954=>[949, 787, 768], 7694=>[68, 817], 194733=>[24996], 63962=>[26647], 
    194994=>[17771], 7955=>[949, 788, 768], 12384=>[12383, 12441], 7695=>[100, 817], 194734=>[25007], 63963=>[29575], 194995=>[34384], 7956=>[949, 787, 769], 7696=>[68, 807], 194735=>[25054], 63964=>[38534], 194996=>[34396], 7957=>[949, 788, 769], 12386=>[12385, 12441], 7697=>[100, 807], 194736=>[25074], 
    63965=>[21033], 194997=>[34407], 8740=>[8739, 824], 7698=>[68, 813], 194737=>[25078], 63966=>[21519], 194998=>[34409], 9001=>[12296], 7699=>[100, 813], 194738=>[25104], 63967=>[23653], 194999=>[34473], 6918=>[6917, 6965], 9002=>[12297], 7960=>[917, 787], 3271=>[3270, 3285], 
    8742=>[8741, 824], 12389=>[12388, 12441], 7700=>[69, 772, 768], 194739=>[25115], 63968=>[26131], 195000=>[34440], 7961=>[917, 788], 3272=>[3270, 3286], 7701=>[101, 772, 768], 194740=>[25181], 63969=>[26446], 195001=>[34574], 6920=>[6919, 6965], 7962=>[917, 787, 768], 12391=>[12390, 12441], 7702=>[69, 772, 769], 
    194741=>[25265], 63970=>[26792], 195002=>[34530], 7963=>[917, 788, 768], 3274=>[3270, 3266], 7703=>[101, 772, 769], 194742=>[25300], 63971=>[27877], 195003=>[34681], 6922=>[6921, 6965], 7964=>[917, 787, 769], 3275=>[3270, 3266, 3285], 12393=>[12392, 12441], 7704=>[69, 813], 194743=>[25424], 63972=>[29702], 
    195004=>[34600], 8486=>[937], 7965=>[917, 788, 769], 7705=>[101, 813], 194744=>[142092], 63973=>[30178], 195005=>[34667], 6924=>[6923, 6965], 7706=>[69, 816], 194745=>[25405], 63974=>[32633], 195006=>[34694], 7707=>[101, 816], 3018=>[3014, 3006], 194746=>[25340], 63975=>[35023], 
    195007=>[17879], 6926=>[6925, 6965], 7968=>[951, 787], 194747=>[25448], 7708=>[69, 807, 774], 3019=>[3015, 3006], 63976=>[35041], 195008=>[34785], 7969=>[951, 788], 8490=>[75], 194748=>[25475], 7709=>[101, 807, 774], 3020=>[3014, 3031], 63977=>[37324], 195009=>[34817], 7970=>[951, 787, 768], 
    8491=>[65, 778], 194749=>[25572], 416=>[79, 795], 7710=>[70, 775], 63978=>[38626], 195010=>[17913], 7971=>[951, 788, 768], 194750=>[142321], 417=>[111, 795], 12400=>[12399, 12441], 938=>[921, 776], 7711=>[102, 775], 63979=>[21311], 195011=>[34912], 6930=>[6929, 6965], 7972=>[951, 787, 769], 
    194751=>[25634], 12401=>[12399, 12442], 939=>[933, 776], 7712=>[71, 772], 63980=>[28346], 195012=>[34915], 7973=>[951, 788, 769], 194752=>[25541], 940=>[945, 769], 7713=>[103, 772], 63981=>[21533], 195013=>[161383], 7974=>[951, 787, 834], 194753=>[25513], 12403=>[12402, 12441], 941=>[949, 769], 
    7714=>[72, 775], 63982=>[29136], 3546=>[3545, 3530], 195014=>[35031], 7975=>[951, 788, 834], 194754=>[14894], 12404=>[12402, 12442], 942=>[951, 769], 7715=>[104, 775], 63983=>[29848], 195015=>[35038], 7976=>[919, 787], 194755=>[25705], 943=>[953, 769], 7716=>[72, 803], 63984=>[34298], 
    3548=>[3545, 3535], 195016=>[17973], 7977=>[919, 788], 194756=>[25726], 2507=>[2503, 2494], 12406=>[12405, 12441], 944=>[965, 776, 769], 7717=>[104, 803], 63985=>[38563], 3549=>[3545, 3535, 3530], 195017=>[35066], 7978=>[919, 787, 768], 194757=>[25757], 2508=>[2503, 2519], 12407=>[12405, 12442], 7718=>[72, 776], 
    63986=>[40023], 3550=>[3545, 3551], 195018=>[13499], 7979=>[919, 788, 768], 194758=>[25719], 7719=>[104, 776], 63987=>[40607], 195019=>[161966], 7980=>[919, 787, 769], 1728=>[1749, 1620], 194759=>[14956], 12409=>[12408, 12441], 7720=>[72, 807], 63988=>[26519], 195020=>[162150], 7981=>[919, 788, 769], 
    194760=>[25935], 12410=>[12408, 12442], 7721=>[104, 807], 63989=>[28107], 195021=>[18110], 7982=>[919, 787, 834], 1730=>[1729, 1620], 194761=>[25964], 7722=>[72, 814], 63990=>[33256], 195022=>[18119], 7983=>[919, 788, 834], 194762=>[143370], 12412=>[12411, 12441], 7723=>[104, 814], 63991=>[31435], 
    195023=>[35488], 7984=>[953, 787], 194763=>[26083], 12413=>[12411, 12442], 7724=>[73, 816], 63992=>[31520], 195024=>[35565], 7985=>[953, 788], 194764=>[26360], 7725=>[105, 816], 63993=>[31890], 431=>[85, 795], 195025=>[35722], 7986=>[953, 787, 768], 194765=>[26185], 7726=>[73, 776, 769], 
    63994=>[29376], 432=>[117, 795], 195026=>[35925], 7987=>[953, 788, 768], 194766=>[15129], 8769=>[8764, 824], 7727=>[105, 776, 769], 63995=>[28825], 195027=>[162984], 7988=>[953, 787, 769], 194767=>[26257], 7728=>[75, 769], 63996=>[35672], 195028=>[36011], 7989=>[953, 788, 769], 194768=>[15112], 
    7729=>[107, 769], 63997=>[20160], 195029=>[36033], 1217=>[1046, 774], 7990=>[953, 787, 834], 194769=>[15076], 8772=>[8771, 824], 7730=>[75, 803], 63998=>[33590], 195030=>[36123], 1218=>[1078, 774], 7991=>[953, 788, 834], 194770=>[20882], 7731=>[107, 803], 63999=>[21050], 195031=>[36215], 
    7992=>[921, 787], 194771=>[20885], 7732=>[75, 817], 64000=>[20999], 195032=>[163631], 7993=>[921, 788], 194772=>[26368], 7733=>[107, 817], 119227=>[119225, 119141], 64001=>[24230], 8775=>[8773, 824], 195033=>[133124], 7994=>[921, 787, 768], 194773=>[26268], 2524=>[2465, 2492], 7734=>[76, 803], 
    119228=>[119226, 119141], 64002=>[25299], 195034=>[36299], 7995=>[921, 788, 768], 194774=>[32941], 2525=>[2466, 2492], 7735=>[108, 803], 119229=>[119225, 119141, 119150], 64003=>[31958], 8777=>[8776, 824], 195035=>[36284], 7996=>[921, 787, 769], 194775=>[17369], 7736=>[76, 803, 772], 119230=>[119226, 119141, 119150], 64004=>[23429], 
    195036=>[36336], 7997=>[921, 788, 769], 63744=>[35912], 194776=>[26391], 2527=>[2479, 2492], 7737=>[108, 803, 772], 119231=>[119225, 119141, 119151], 64005=>[27934], 195037=>[133342], 7998=>[921, 787, 834], 63745=>[26356], 194777=>[26395], 7738=>[76, 817], 119232=>[119226, 119141, 119151], 64006=>[26292], 195038=>[36564], 
    7999=>[921, 788, 834], 63746=>[36554], 1747=>[1746, 1620], 194778=>[26401], 7739=>[108, 817], 64007=>[36667], 195039=>[36664], 8000=>[959, 787], 63747=>[36040], 194779=>[26462], 7740=>[76, 813], 64008=>[34892], 195040=>[165330], 8001=>[959, 788], 63748=>[28369], 194780=>[26451], 
    7741=>[108, 813], 64009=>[38477], 195041=>[165357], 8002=>[959, 787, 768], 63749=>[20018], 194781=>[144323], 7742=>[77, 769], 64010=>[35211], 195042=>[37012], 8003=>[959, 788, 768], 63750=>[21477], 194782=>[15177], 970=>[953, 776], 7743=>[109, 769], 64011=>[24275], 195043=>[37105], 
    8004=>[959, 787, 769], 63751=>[40860], 194783=>[26618], 971=>[965, 776], 7744=>[77, 775], 64012=>[20800], 195044=>[37137], 1232=>[1040, 774], 8005=>[959, 788, 769], 63752=>[40860], 194784=>[26501], 972=>[959, 769], 7745=>[109, 775], 64013=>[21952], 195045=>[165678], 1233=>[1072, 774], 
    63753=>[22865], 194785=>[26706], 973=>[965, 769], 7746=>[77, 803], 195046=>[37147], 1234=>[1040, 776], 63754=>[37329], 192=>[65, 768], 194786=>[26757], 12436=>[12358, 12441], 974=>[969, 769], 7747=>[109, 803], 195047=>[37432], 1235=>[1072, 776], 8008=>[927, 787], 63755=>[21895], 
    193=>[65, 769], 194787=>[144493], 7748=>[78, 775], 64016=>[22618], 195048=>[37591], 8009=>[927, 788], 63756=>[22856], 194=>[65, 770], 194788=>[26766], 7749=>[110, 775], 195049=>[37592], 8010=>[927, 787, 768], 63757=>[25078], 195=>[65, 771], 194789=>[26655], 7750=>[78, 803], 
    64018=>[26228], 195050=>[37500], 1238=>[1045, 774], 8011=>[927, 788, 768], 63758=>[30313], 196=>[65, 776], 194790=>[26900], 7751=>[110, 803], 195051=>[37881], 1239=>[1077, 774], 8012=>[927, 787, 769], 63759=>[32645], 197=>[65, 778], 194791=>[15261], 979=>[978, 769], 7752=>[78, 817], 
    195052=>[37909], 8013=>[927, 788, 769], 63760=>[34367], 6971=>[6970, 6965], 194792=>[26946], 980=>[978, 776], 7753=>[110, 817], 64021=>[20958], 195053=>[166906], 63761=>[34746], 199=>[67, 807], 194793=>[27043], 7754=>[78, 813], 64022=>[29482], 195054=>[38283], 1242=>[1240, 776], 
    63762=>[35064], 200=>[69, 768], 6973=>[6972, 6965], 194794=>[27114], 7755=>[110, 813], 64023=>[30410], 461=>[65, 780], 195055=>[18837], 1243=>[1241, 776], 8016=>[965, 787], 63763=>[37007], 201=>[69, 769], 194795=>[27304], 7756=>[79, 771, 769], 64024=>[31036], 462=>[97, 780], 
    195056=>[38327], 1244=>[1046, 776], 8017=>[965, 788], 63764=>[27138], 202=>[69, 770], 64285=>[1497, 1460], 194796=>[145059], 12446=>[12445, 12441], 7757=>[111, 771, 769], 64025=>[31070], 463=>[73, 780], 195057=>[167287], 1245=>[1078, 776], 8018=>[965, 787, 768], 63765=>[27931], 203=>[69, 776], 
    6976=>[6974, 6965], 194797=>[27355], 7758=>[79, 771, 776], 64026=>[31077], 464=>[105, 780], 8800=>[61, 824], 195058=>[18918], 1246=>[1047, 776], 8019=>[965, 788, 768], 63766=>[28889], 204=>[73, 768], 64287=>[1522, 1463], 6977=>[6975, 6965], 194798=>[15384], 7759=>[111, 771, 776], 64027=>[31119], 
    465=>[79, 780], 195059=>[38595], 1247=>[1079, 776], 8020=>[965, 787, 769], 63767=>[29662], 205=>[73, 769], 194799=>[27425], 7760=>[79, 772, 768], 64028=>[38742], 466=>[111, 780], 8802=>[8801, 824], 195060=>[23986], 8021=>[965, 788, 769], 63768=>[33853], 206=>[73, 770], 6979=>[6978, 6965], 
    194800=>[145575], 7761=>[111, 772, 768], 64029=>[31934], 467=>[85, 780], 195061=>[38691], 8022=>[965, 787, 834], 63769=>[37226], 207=>[73, 776], 194801=>[27476], 7762=>[79, 772, 769], 64030=>[32701], 468=>[117, 780], 195062=>[168261], 1250=>[1048, 772], 8023=>[965, 788, 834], 63770=>[39409], 
    194802=>[15438], 7763=>[111, 772, 769], 469=>[85, 776, 772], 195063=>[168474], 1251=>[1080, 772], 63771=>[20098], 209=>[78, 771], 194803=>[27506], 7764=>[80, 769], 64032=>[34322], 470=>[117, 776, 772], 195064=>[19054], 1252=>[1048, 776], 8025=>[933, 788], 63772=>[21365], 210=>[79, 768], 
    194804=>[27551], 7765=>[112, 769], 471=>[85, 776, 769], 195065=>[19062], 1253=>[1080, 776], 63773=>[27396], 211=>[79, 769], 194805=>[27578], 7766=>[80, 775], 64034=>[35576], 472=>[117, 776, 769], 195066=>[38880], 1254=>[1054, 776], 8027=>[933, 788, 768], 63774=>[29211], 212=>[79, 770], 
    194806=>[27579], 7767=>[112, 775], 473=>[85, 776, 780], 195067=>[168970], 1255=>[1086, 776], 63775=>[34349], 213=>[79, 771], 194807=>[146061], 7768=>[82, 775], 474=>[117, 776, 780], 195068=>[19122], 8029=>[933, 788, 769], 63776=>[40478], 214=>[79, 776], 194808=>[138507], 7769=>[114, 775], 
    64037=>[36920], 475=>[85, 776, 768], 195069=>[169110], 63777=>[23888], 64298=>[1513, 1473], 194809=>[146170], 7770=>[82, 803], 64038=>[37117], 476=>[117, 776, 768], 195070=>[38923], 1258=>[1256, 776], 8031=>[933, 788, 834], 63778=>[28651], 64299=>[1513, 1474], 194810=>[27726], 7771=>[114, 803], 
    8813=>[8781, 824], 12460=>[12459, 12441], 195071=>[38923], 1259=>[1257, 776], 8032=>[969, 787], 63779=>[34253], 217=>[85, 768], 64300=>[1513, 1468, 1473], 194811=>[146620], 7772=>[82, 803, 772], 478=>[65, 776, 772], 8814=>[60, 824], 195072=>[38953], 1260=>[1069, 776], 8033=>[969, 788], 63780=>[35172], 
    218=>[85, 769], 64301=>[1513, 1468, 1474], 194812=>[27839], 7773=>[114, 803, 772], 479=>[97, 776, 772], 8815=>[62, 824], 12462=>[12461, 12441], 195073=>[169398], 1261=>[1101, 776], 8034=>[969, 787, 768], 63781=>[25289], 219=>[85, 770], 64302=>[1488, 1463], 194813=>[27853], 7774=>[82, 817], 64042=>[39151], 
    480=>[65, 775, 772], 8816=>[8804, 824], 195074=>[39138], 1262=>[1059, 772], 8035=>[969, 788, 768], 63782=>[33240], 220=>[85, 776], 64303=>[1488, 1464], 194814=>[27751], 7775=>[114, 817], 64043=>[39164], 481=>[97, 775, 772], 8817=>[8805, 824], 12464=>[12463, 12441], 195075=>[19251], 1263=>[1091, 772], 
    8036=>[969, 787, 769], 63783=>[34847], 221=>[89, 769], 64304=>[1488, 1468], 194815=>[27926], 7776=>[83, 775], 64044=>[39208], 482=>[198, 772], 195076=>[39209], 1264=>[1059, 776], 8037=>[969, 788, 769], 63784=>[24266], 64305=>[1489, 1468], 194816=>[27966], 7777=>[115, 775], 64045=>[40372], 
    483=>[230, 772], 12466=>[12465, 12441], 195077=>[39335], 1265=>[1091, 776], 8038=>[969, 787, 834], 63785=>[26391], 64306=>[1490, 1468], 194817=>[28023], 7778=>[83, 803], 64046=>[37086], 8820=>[8818, 824], 195078=>[39362], 1266=>[1059, 779], 8039=>[969, 788, 834], 63786=>[28010], 224=>[97, 768], 
    64307=>[1491, 1468], 194818=>[27969], 7779=>[115, 803], 64047=>[38583], 8821=>[8819, 824], 12468=>[12467, 12441], 195079=>[39422], 1267=>[1091, 779], 8040=>[937, 787], 63787=>[29436], 225=>[97, 769], 64308=>[1492, 1468], 194819=>[28009], 7780=>[83, 769, 775], 64048=>[20398], 486=>[71, 780], 
    195080=>[19406], 1268=>[1063, 776], 8041=>[937, 788], 63788=>[37070], 226=>[97, 770], 64309=>[1493, 1468], 194820=>[28024], 7781=>[115, 769, 775], 64049=>[20711], 487=>[103, 780], 4134=>[4133, 4142], 12470=>[12469, 12441], 195081=>[170800], 194560=>[20029], 1269=>[1095, 776], 8042=>[937, 787, 768], 
    63789=>[20358], 227=>[97, 771], 64310=>[1494, 1468], 194821=>[28037], 64050=>[20813], 488=>[75, 780], 8824=>[8822, 824], 7782=>[83, 780, 775], 195082=>[39698], 194561=>[20024], 8043=>[937, 788, 768], 63790=>[20919], 228=>[97, 776], 194822=>[146718], 64051=>[21193], 489=>[107, 780], 
    8825=>[8823, 824], 12472=>[12471, 12441], 7783=>[115, 780, 775], 195083=>[40000], 8044=>[937, 787, 769], 63791=>[21214], 229=>[97, 778], 64312=>[1496, 1468], 194562=>[20033], 194823=>[27956], 64052=>[21220], 490=>[79, 808], 7784=>[83, 803, 775], 195084=>[40189], 1272=>[1067, 776], 8045=>[937, 788, 769], 
    63792=>[25796], 64313=>[1497, 1468], 194563=>[131362], 194824=>[28207], 64053=>[21329], 491=>[111, 808], 12474=>[12473, 12441], 7785=>[115, 803, 775], 195085=>[19662], 8046=>[937, 787, 834], 63793=>[27347], 231=>[99, 807], 64314=>[1498, 1468], 194564=>[20320], 1273=>[1099, 776], 194825=>[28270], 
    64054=>[21917], 492=>[79, 808, 772], 7786=>[84, 775], 195086=>[19693], 8047=>[937, 788, 834], 63794=>[29200], 232=>[101, 768], 64315=>[1499, 1468], 194565=>[20398], 194826=>[15667], 64055=>[22022], 493=>[111, 808, 772], 69786=>[69785, 69818], 12476=>[12475, 12441], 7787=>[116, 775], 195087=>[40295], 
    8048=>[945, 768], 63795=>[30439], 233=>[101, 769], 64316=>[1500, 1468], 194566=>[20411], 194827=>[28363], 64056=>[22120], 494=>[439, 780], 7788=>[84, 803], 195088=>[172238], 8049=>[945, 769], 63796=>[32769], 234=>[101, 770], 194567=>[20482], 194828=>[28359], 64057=>[22592], 
    495=>[658, 780], 69788=>[69787, 69818], 12478=>[12477, 12441], 7789=>[116, 803], 195089=>[19704], 8050=>[949, 768], 63797=>[34310], 235=>[101, 776], 64318=>[1502, 1468], 194568=>[20602], 194829=>[147153], 64058=>[22696], 496=>[106, 780], 8832=>[8826, 824], 7790=>[84, 817], 195090=>[172293], 
    8051=>[949, 769], 63798=>[34396], 236=>[105, 768], 194569=>[20633], 194830=>[28153], 64059=>[23652], 8833=>[8827, 824], 12480=>[12479, 12441], 7791=>[116, 817], 195091=>[172558], 8052=>[951, 768], 63799=>[36335], 237=>[105, 769], 64320=>[1504, 1468], 194570=>[20711], 194831=>[28526], 
    64060=>[23662], 7792=>[84, 813], 195092=>[172689], 8053=>[951, 769], 63800=>[38706], 238=>[105, 770], 64321=>[1505, 1468], 194571=>[20687], 194832=>[147294], 64061=>[24724], 12482=>[12481, 12441], 7793=>[116, 813], 195093=>[40635], 8054=>[953, 768], 63801=>[39791], 239=>[105, 776], 
    194572=>[13470], 194833=>[147342], 64062=>[24936], 500=>[71, 769], 8836=>[8834, 824], 7794=>[85, 804], 195094=>[19798], 8055=>[953, 769], 63802=>[40442], 64323=>[1507, 1468], 194573=>[132666], 194834=>[28614], 64063=>[24974], 501=>[103, 769], 8837=>[8835, 824], 7795=>[117, 804], 
    195095=>[40697], 8056=>[959, 768], 63803=>[30860], 241=>[110, 771], 64324=>[1508, 1468], 194574=>[20813], 194835=>[28729], 64064=>[25074], 12485=>[12484, 12441], 7796=>[85, 816], 195096=>[40702], 8057=>[959, 769], 63804=>[31103], 242=>[111, 768], 194575=>[20820], 194836=>[28702], 
    64065=>[25935], 1024=>[1045, 768], 7797=>[117, 816], 195097=>[40709], 8058=>[965, 768], 63805=>[32160], 243=>[111, 769], 64326=>[1510, 1468], 194576=>[20836], 194837=>[28699], 64066=>[26082], 504=>[78, 768], 8840=>[8838, 824], 12487=>[12486, 12441], 1025=>[1045, 776], 7798=>[85, 813], 
    195098=>[40719], 8059=>[965, 769], 63806=>[33737], 244=>[111, 770], 64327=>[1511, 1468], 194577=>[20855], 194838=>[15766], 64067=>[26257], 505=>[110, 768], 8841=>[8839, 824], 7799=>[117, 813], 195099=>[40726], 8060=>[969, 768], 63807=>[37636], 245=>[111, 771], 64328=>[1512, 1468], 
    194578=>[132380], 194839=>[28746], 64068=>[26757], 506=>[65, 778, 769], 12489=>[12488, 12441], 1027=>[1043, 769], 7800=>[85, 771, 769], 195100=>[40763], 8061=>[969, 769], 63808=>[40575], 246=>[111, 776], 64329=>[1513, 1468], 194579=>[13497], 194840=>[28797], 64069=>[28023], 507=>[97, 778, 769], 
    7801=>[117, 771, 769], 195101=>[173568], 63809=>[35542], 64330=>[1514, 1468], 194580=>[20839], 194841=>[28791], 64070=>[28186], 508=>[198, 769], 7802=>[85, 772, 776], 63810=>[22751], 64331=>[1493, 1465], 194581=>[20877], 194842=>[28845], 64071=>[28450], 509=>[230, 769], 7803=>[117, 772, 776], 
    8064=>[945, 787, 837], 63811=>[24324], 249=>[117, 768], 64332=>[1489, 1471], 194582=>[132427], 194843=>[132389], 64072=>[29038], 510=>[216, 769], 69803=>[69797, 69818], 1031=>[1030, 776], 7804=>[86, 771], 63812=>[31840], 250=>[117, 769], 64333=>[1499, 1471], 194583=>[20887], 8065=>[945, 788, 837], 
    194844=>[28997], 64073=>[29227], 511=>[248, 769], 7805=>[118, 771], 63813=>[32894], 251=>[117, 770], 64334=>[1508, 1471], 194584=>[20900], 8066=>[945, 787, 768, 837], 194845=>[148067], 64074=>[29730], 512=>[65, 783], 7806=>[86, 803], 63814=>[29282], 252=>[117, 776], 194585=>[20172], 
    8067=>[945, 788, 768, 837], 194846=>[29084], 64075=>[30865], 513=>[97, 783], 12496=>[12495, 12441], 7807=>[118, 803], 63815=>[30922], 253=>[121, 769], 194586=>[20908], 8068=>[945, 787, 769, 837], 194847=>[148395], 64076=>[31038], 514=>[65, 785], 12497=>[12495, 12442], 7808=>[87, 768], 194587=>[20917], 
    8069=>[945, 788, 769, 837], 63816=>[36034], 194848=>[29224], 64077=>[31049], 515=>[97, 785], 1036=>[1050, 769], 7809=>[119, 768], 255=>[121, 776], 194588=>[168415], 8070=>[945, 787, 834, 837], 63817=>[38647], 194849=>[29237], 64078=>[31048], 516=>[69, 783], 12499=>[12498, 12441], 1037=>[1048, 768], 
    7810=>[87, 769], 256=>[65, 772], 194589=>[20981], 8071=>[945, 788, 834, 837], 63818=>[22744], 194850=>[29264], 64079=>[31056], 517=>[101, 783], 12500=>[12498, 12442], 1038=>[1059, 774], 7811=>[119, 769], 257=>[97, 772], 194590=>[20995], 8072=>[913, 787, 837], 63819=>[23650], 194851=>[149000], 
    64080=>[31062], 518=>[69, 785], 7812=>[87, 776], 258=>[65, 774], 194591=>[13535], 8073=>[913, 788, 837], 63820=>[27155], 194852=>[29312], 64081=>[31069], 519=>[101, 785], 12502=>[12501, 12441], 7813=>[119, 776], 259=>[97, 774], 194592=>[21051], 8074=>[913, 787, 768, 837], 63821=>[28122], 
    194853=>[29333], 64082=>[31117], 520=>[73, 783], 12503=>[12501, 12442], 7814=>[87, 775], 
  }

  KOMPATIBLE_TABLE = {
    126542=>[1587], 120344=>[81], 64562=>[1601, 1610], 12912=>[4355, 4449], 119828=>[85], 65079=>[123], 8264=>[63, 33], 126543=>[1593], 120345=>[82], 64563=>[1602, 1581], 12913=>[4357, 4449], 119829=>[86], 65080=>[125], 8265=>[33, 63], 120346=>[83], 64564=>[1602, 1605], 
    12914=>[4358, 4449], 65081=>[12308], 119830=>[87], 126545=>[1589], 120347=>[84], 64565=>[1602, 1609], 12915=>[4359, 4449], 65082=>[12309], 119831=>[88], 126546=>[1602], 120348=>[85], 64566=>[1602, 1610], 12916=>[4361, 4449], 65083=>[12304], 119832=>[89], 120349=>[86], 
    64567=>[1603, 1575], 12917=>[4363, 4449], 65084=>[12305], 119833=>[90], 126548=>[1588], 120350=>[87], 64568=>[1603, 1580], 12918=>[4364, 4449], 65085=>[12298], 119834=>[97], 64569=>[1603, 1581], 12919=>[4366, 4449], 120351=>[88], 65086=>[12299], 119835=>[98], 64570=>[1603, 1582], 
    12920=>[4367, 4449], 120352=>[89], 65087=>[12296], 119836=>[99], 126551=>[1582], 64571=>[1603, 1604], 12921=>[4368, 4449], 120353=>[90], 65088=>[12297], 119837=>[100], 64572=>[1603, 1605], 12922=>[4369, 4449], 120354=>[97], 65089=>[12300], 119838=>[101], 126553=>[1590], 
    64573=>[1603, 1609], 12923=>[4370, 4449], 120355=>[98], 65090=>[12301], 119839=>[102], 64574=>[1603, 1610], 12924=>[4366, 4449, 4535, 4352, 4457], 120356=>[99], 65091=>[12302], 119840=>[103], 126555=>[1594], 64575=>[1604, 1580], 12925=>[4364, 4462, 4363, 4468], 120357=>[100], 65092=>[12303], 119841=>[104], 
    64576=>[1604, 1581], 12926=>[4363, 4462], 120358=>[101], 119842=>[105], 126557=>[1722], 64577=>[1604, 1582], 120359=>[102], 8279=>[8242, 8242, 8242, 8242], 9312=>[49], 119843=>[106], 64578=>[1604, 1605], 12928=>[19968], 120360=>[103], 65095=>[91], 9313=>[50], 119844=>[107], 
    126559=>[1647], 64579=>[1604, 1609], 12929=>[20108], 120361=>[104], 65096=>[93], 9314=>[51], 119845=>[108], 64580=>[1604, 1610], 12930=>[19977], 120362=>[105], 65097=>[8254], 9315=>[52], 119846=>[109], 126561=>[1576], 64581=>[1605, 1580], 12931=>[22235], 
    120363=>[106], 65098=>[8254], 9316=>[53], 119847=>[110], 126562=>[1580], 3635=>[3661, 3634], 64582=>[1605, 1581], 12932=>[20116], 120364=>[107], 65099=>[8254], 9317=>[54], 119848=>[111], 64583=>[1605, 1582], 12933=>[20845], 120365=>[108], 65100=>[8254], 
    9318=>[55], 119849=>[112], 126564=>[1607], 64584=>[1605, 1605], 10868=>[58, 58, 61], 12934=>[19971], 120366=>[109], 65101=>[95], 9319=>[56], 119850=>[113], 64585=>[1605, 1609], 10869=>[61, 61], 12935=>[20843], 120367=>[110], 65102=>[95], 8287=>[32], 
    9320=>[57], 119851=>[114], 64586=>[1605, 1610], 10870=>[61, 61, 61], 12936=>[20061], 120368=>[111], 65103=>[95], 9321=>[49, 48], 119852=>[115], 126567=>[1581], 64587=>[1606, 1580], 12937=>[21313], 120369=>[112], 65104=>[44], 9322=>[49, 49], 11388=>[106], 
    119853=>[116], 126568=>[1591], 64588=>[1606, 1581], 12938=>[26376], 120370=>[113], 65105=>[12289], 9323=>[49, 50], 11389=>[86], 119854=>[117], 126569=>[1610], 64589=>[1606, 1582], 12939=>[28779], 120371=>[114], 65106=>[46], 9324=>[49, 51], 119855=>[118], 
    126570=>[1603], 64590=>[1606, 1605], 12940=>[27700], 120372=>[115], 9325=>[49, 52], 119856=>[119], 64591=>[1606, 1609], 12941=>[26408], 120373=>[116], 65108=>[59], 9326=>[49, 53], 119857=>[120], 126572=>[1605], 64592=>[1606, 1610], 12942=>[37329], 120374=>[117], 
    65109=>[58], 9327=>[49, 54], 119858=>[121], 126573=>[1606], 64593=>[1607, 1580], 12943=>[22303], 120375=>[118], 65110=>[63], 9328=>[49, 55], 119859=>[122], 126574=>[1587], 64594=>[1607, 1605], 12944=>[26085], 120376=>[119], 65111=>[33], 9329=>[49, 56], 
    119860=>[65], 126575=>[1593], 64595=>[1607, 1609], 12945=>[26666], 120377=>[120], 65112=>[8212], 9330=>[49, 57], 119861=>[66], 126576=>[1601], 64596=>[1607, 1610], 12946=>[26377], 120378=>[121], 65113=>[40], 9331=>[50, 48], 119862=>[67], 126577=>[1589], 
    64597=>[1610, 1580], 12947=>[31038], 120379=>[122], 65114=>[41], 9332=>[40, 49, 41], 119863=>[68], 126578=>[1602], 64598=>[1610, 1581], 12948=>[21517], 120380=>[65], 65115=>[123], 9333=>[40, 50, 41], 119864=>[69], 64599=>[1610, 1582], 12949=>[29305], 120381=>[66], 
    65116=>[125], 9334=>[40, 51, 41], 119865=>[70], 126580=>[1588], 64600=>[1610, 1605], 12950=>[36001], 120382=>[67], 65117=>[12308], 9335=>[40, 52, 41], 119866=>[71], 126581=>[1578], 64601=>[1610, 1609], 12951=>[31069], 120383=>[68], 65118=>[12309], 9336=>[40, 53, 41], 
    119867=>[72], 126582=>[1579], 64602=>[1610, 1610], 12952=>[21172], 120384=>[69], 65119=>[35], 8304=>[48], 9337=>[40, 54, 41], 119868=>[73], 126583=>[1582], 64603=>[1584, 1648], 12953=>[31192], 120385=>[70], 65120=>[38], 8305=>[105], 9338=>[40, 55, 41], 
    119869=>[74], 12954=>[30007], 120386=>[71], 64604=>[1585, 1648], 65121=>[42], 9339=>[40, 56, 41], 119870=>[75], 126585=>[1590], 12955=>[22899], 120387=>[72], 64605=>[1609, 1648], 65122=>[43], 9340=>[40, 57, 41], 119871=>[76], 126586=>[1592], 12956=>[36969], 
    120388=>[73], 64606=>[32, 1612, 1617], 65123=>[45], 8308=>[52], 9341=>[40, 49, 48, 41], 119872=>[77], 126587=>[1594], 12957=>[20778], 120389=>[74], 64607=>[32, 1613, 1617], 65124=>[60], 8309=>[53], 9342=>[40, 49, 49, 41], 119873=>[78], 126588=>[1646], 12958=>[21360], 
    120390=>[75], 64608=>[32, 1614, 1617], 8310=>[54], 9343=>[40, 49, 50, 41], 119874=>[79], 65125=>[62], 12959=>[27880], 120391=>[76], 64609=>[32, 1615, 1617], 8311=>[55], 9344=>[40, 49, 51, 41], 12443=>[32, 12441], 119875=>[80], 65126=>[61], 126590=>[1697], 12960=>[38917], 
    120392=>[77], 64610=>[32, 1616, 1617], 8312=>[56], 9345=>[40, 49, 52, 41], 12444=>[32, 12442], 119876=>[81], 12961=>[20241], 120393=>[78], 64611=>[32, 1617, 1648], 8313=>[57], 9346=>[40, 49, 53, 41], 119877=>[82], 65128=>[92], 126592=>[1575], 12962=>[20889], 120394=>[79], 
    64612=>[1574, 1585], 8314=>[43], 9347=>[40, 49, 54, 41], 119878=>[83], 65129=>[36], 126593=>[1576], 12963=>[27491], 120395=>[80], 64613=>[1574, 1586], 8315=>[8722], 9348=>[40, 49, 55, 41], 12447=>[12424, 12426], 119879=>[84], 65130=>[37], 126594=>[1580], 12964=>[19978], 
    120396=>[81], 64614=>[1574, 1605], 8316=>[61], 9349=>[40, 49, 56, 41], 119880=>[85], 65131=>[64], 126595=>[1583], 12965=>[20013], 120397=>[82], 64615=>[1574, 1606], 8317=>[40], 9350=>[40, 49, 57, 41], 119881=>[86], 126596=>[1607], 12966=>[19979], 120398=>[83], 
    64616=>[1574, 1609], 8318=>[41], 9351=>[40, 50, 48, 41], 119882=>[87], 126597=>[1608], 12967=>[24038], 120399=>[84], 64617=>[1574, 1610], 8319=>[110], 9352=>[49, 46], 119883=>[88], 126598=>[1586], 11935=>[27597], 12968=>[21491], 120400=>[85], 64618=>[1576, 1585], 
    8320=>[48], 9353=>[50, 46], 119884=>[89], 126599=>[1581], 12969=>[21307], 120401=>[86], 64619=>[1576, 1586], 8321=>[49], 9354=>[51, 46], 119885=>[90], 65136=>[32, 1611], 126600=>[1591], 12970=>[23447], 120402=>[87], 64620=>[1576, 1605], 8322=>[50], 
    9355=>[52, 46], 119886=>[97], 65137=>[1600, 1611], 126601=>[1610], 12971=>[23398], 120403=>[88], 64621=>[1576, 1606], 8323=>[51], 9356=>[53, 46], 119887=>[98], 65138=>[32, 1612], 12972=>[30435], 120404=>[89], 64622=>[1576, 1609], 8324=>[52], 9357=>[54, 46], 
    119888=>[99], 126603=>[1604], 12973=>[20225], 120405=>[90], 64623=>[1576, 1610], 8325=>[53], 9358=>[55, 46], 119889=>[100], 65140=>[32, 1613], 126604=>[1605], 12974=>[36039], 120406=>[97], 64624=>[1578, 1585], 8326=>[54], 9359=>[56, 46], 119890=>[101], 
    126605=>[1606], 12975=>[21332], 120407=>[98], 64625=>[1578, 1586], 8327=>[55], 9360=>[57, 46], 119891=>[102], 65142=>[32, 1614], 126606=>[1587], 12976=>[22812], 120408=>[99], 64626=>[1578, 1605], 8328=>[56], 9361=>[49, 48, 46], 119892=>[103], 65143=>[1600, 1614], 
    126607=>[1593], 12977=>[51, 54], 120409=>[100], 64627=>[1578, 1606], 8329=>[57], 9362=>[49, 49, 46], 65144=>[32, 1615], 126608=>[1601], 12978=>[51, 55], 120410=>[101], 64628=>[1578, 1609], 8330=>[43], 9363=>[49, 50, 46], 119894=>[105], 65145=>[1600, 1615], 126609=>[1589], 
    12979=>[51, 56], 120411=>[102], 64629=>[1578, 1610], 8331=>[8722], 9364=>[49, 51, 46], 119895=>[106], 65146=>[32, 1616], 126610=>[1602], 12980=>[51, 57], 120412=>[103], 64630=>[1579, 1585], 8332=>[61], 9365=>[49, 52, 46], 119896=>[107], 65147=>[1600, 1616], 126611=>[1585], 
    12981=>[52, 48], 120413=>[104], 64631=>[1579, 1586], 8333=>[40], 9366=>[49, 53, 46], 119897=>[108], 65148=>[32, 1617], 126612=>[1588], 12982=>[52, 49], 120414=>[105], 64632=>[1579, 1605], 8334=>[41], 9367=>[49, 54, 46], 119898=>[109], 65149=>[1600, 1617], 126613=>[1578], 
    12983=>[52, 50], 120415=>[106], 64633=>[1579, 1606], 9368=>[49, 55, 46], 119899=>[110], 65150=>[32, 1618], 126614=>[1579], 12984=>[52, 51], 120416=>[107], 64634=>[1579, 1609], 9369=>[49, 56, 46], 119900=>[111], 65151=>[1600, 1618], 8336=>[97], 126615=>[1582], 12985=>[52, 52], 
    120417=>[108], 64635=>[1579, 1610], 9370=>[49, 57, 46], 119901=>[112], 65152=>[1569], 8337=>[101], 126616=>[1584], 12986=>[52, 53], 120418=>[109], 64636=>[1601, 1609], 9371=>[50, 48, 46], 119902=>[113], 65153=>[1570], 8338=>[111], 126617=>[1590], 12987=>[52, 54], 
    120419=>[110], 64637=>[1601, 1610], 9372=>[40, 97, 41], 119903=>[114], 65154=>[1570], 8339=>[120], 126618=>[1592], 12988=>[52, 55], 120420=>[111], 64638=>[1602, 1609], 9373=>[40, 98, 41], 119904=>[115], 65155=>[1571], 8340=>[601], 126619=>[1594], 12989=>[52, 56], 
    120421=>[112], 64639=>[1602, 1610], 9374=>[40, 99, 41], 119905=>[116], 65156=>[1571], 8341=>[104], 12990=>[52, 57], 120422=>[113], 64640=>[1603, 1575], 9375=>[40, 100, 41], 119906=>[117], 65157=>[1572], 8342=>[107], 12991=>[53, 48], 120423=>[114], 64641=>[1603, 1604], 
    9376=>[40, 101, 41], 119907=>[118], 65158=>[1572], 8343=>[108], 12992=>[49, 26376], 120424=>[115], 64642=>[1603, 1605], 9377=>[40, 102, 41], 119908=>[119], 65159=>[1573], 8344=>[109], 12993=>[50, 26376], 120425=>[116], 64643=>[1603, 1609], 119909=>[120], 65160=>[1573], 
    8345=>[110], 9378=>[40, 103, 41], 12994=>[51, 26376], 120426=>[117], 64644=>[1603, 1610], 119910=>[121], 65161=>[1574], 8346=>[112], 9379=>[40, 104, 41], 126625=>[1576], 12995=>[52, 26376], 120427=>[118], 64645=>[1604, 1605], 119911=>[122], 65162=>[1574], 8347=>[115], 
    9380=>[40, 105, 41], 126626=>[1580], 12996=>[53, 26376], 120428=>[119], 64646=>[1604, 1609], 119912=>[65], 65163=>[1574], 8348=>[116], 9381=>[40, 106, 41], 126627=>[1583], 12997=>[54, 26376], 120429=>[120], 64647=>[1604, 1610], 119913=>[66], 65164=>[1574], 9382=>[40, 107, 41], 
    12998=>[55, 26376], 120430=>[121], 64648=>[1605, 1575], 119914=>[67], 65165=>[1575], 9383=>[40, 108, 41], 126629=>[1608], 12999=>[56, 26376], 120431=>[122], 64649=>[1605, 1605], 7834=>[97, 702], 119915=>[68], 65166=>[1575], 9384=>[40, 109, 41], 7835=>[115, 775], 126630=>[1586], 
    13000=>[57, 26376], 120432=>[65], 64650=>[1606, 1585], 119916=>[69], 65167=>[1576], 9385=>[40, 110, 41], 126631=>[1581], 13001=>[49, 48, 26376], 120433=>[66], 64651=>[1606, 1586], 119917=>[70], 65168=>[1576], 9386=>[40, 111, 41], 126632=>[1591], 13002=>[49, 49, 26376], 120434=>[67], 
    64652=>[1606, 1605], 119918=>[71], 65169=>[1576], 9387=>[40, 112, 41], 126633=>[1610], 13003=>[49, 50, 26376], 120435=>[68], 64653=>[1606, 1606], 119919=>[72], 65170=>[1576], 9388=>[40, 113, 41], 13004=>[72, 103], 120436=>[69], 64654=>[1606, 1609], 119920=>[73], 65171=>[1577], 
    9389=>[40, 114, 41], 126635=>[1604], 13005=>[101, 114, 103], 120437=>[70], 64655=>[1606, 1610], 119921=>[74], 65172=>[1577], 9390=>[40, 115, 41], 126636=>[1605], 13006=>[101, 86], 120438=>[71], 64656=>[1609, 1648], 119922=>[75], 65173=>[1578], 9391=>[40, 116, 41], 126637=>[1606], 
    13007=>[76, 84, 68], 120439=>[72], 64657=>[1610, 1585], 119923=>[76], 65174=>[1578], 9392=>[40, 117, 41], 126638=>[1587], 13008=>[12450], 120440=>[73], 64658=>[1610, 1586], 119924=>[77], 65175=>[1578], 8360=>[82, 115], 9393=>[40, 118, 41], 126639=>[1593], 13009=>[12452], 
    120441=>[74], 64659=>[1610, 1605], 119925=>[78], 65176=>[1578], 9394=>[40, 119, 41], 126640=>[1601], 13010=>[12454], 120442=>[75], 64660=>[1610, 1606], 119926=>[79], 65177=>[1579], 9395=>[40, 120, 41], 126641=>[1589], 13011=>[12456], 120443=>[76], 64661=>[1610, 1609], 
    119927=>[80], 65178=>[1579], 9396=>[40, 121, 41], 126642=>[1602], 13012=>[12458], 120444=>[77], 64662=>[1610, 1610], 119928=>[81], 65179=>[1579], 9397=>[40, 122, 41], 126643=>[1585], 13013=>[12459], 120445=>[78], 64663=>[1574, 1580], 119929=>[82], 65180=>[1579], 
    9398=>[65], 126644=>[1588], 13014=>[12461], 120446=>[79], 64664=>[1574, 1581], 119930=>[83], 65181=>[1580], 9399=>[66], 126645=>[1578], 13015=>[12463], 120447=>[80], 64665=>[1574, 1582], 119931=>[84], 65182=>[1580], 9400=>[67], 126646=>[1579], 
    13016=>[12465], 120448=>[81], 1653=>[1575, 1652], 64666=>[1574, 1605], 119932=>[85], 65183=>[1580], 9401=>[68], 126647=>[1582], 13017=>[12467], 120449=>[82], 1654=>[1608, 1652], 64667=>[1574, 1607], 119933=>[86], 65184=>[1580], 9402=>[69], 126648=>[1584], 
    13018=>[12469], 120450=>[83], 1655=>[1735, 1652], 64668=>[1576, 1580], 119934=>[87], 65185=>[1581], 9403=>[70], 126649=>[1590], 13019=>[12471], 120451=>[84], 1656=>[1610, 1652], 64669=>[1576, 1581], 119935=>[88], 65186=>[1581], 9404=>[71], 126650=>[1592], 
    13020=>[12473], 120452=>[85], 64670=>[1576, 1582], 119936=>[89], 65187=>[1581], 9405=>[72], 126651=>[1594], 13021=>[12475], 120453=>[86], 64671=>[1576, 1605], 119937=>[90], 65188=>[1581], 9406=>[73], 13022=>[12477], 120454=>[87], 64672=>[1576, 1607], 
    119938=>[97], 65189=>[1582], 9407=>[74], 13023=>[12479], 120455=>[88], 64673=>[1578, 1580], 119939=>[98], 65190=>[1582], 9408=>[75], 13024=>[12481], 120456=>[89], 64674=>[1578, 1581], 119940=>[99], 65191=>[1582], 9409=>[76], 120457=>[90], 
    64675=>[1578, 1582], 13025=>[12484], 119941=>[100], 65192=>[1582], 9410=>[77], 120458=>[97], 64676=>[1578, 1605], 13026=>[12486], 119942=>[101], 65193=>[1583], 9411=>[78], 120459=>[98], 64677=>[1578, 1607], 13027=>[12488], 119943=>[102], 65194=>[1583], 
    9412=>[79], 120460=>[99], 64678=>[1579, 1605], 13028=>[12490], 119944=>[103], 65195=>[1584], 9413=>[80], 120461=>[100], 64679=>[1580, 1581], 13029=>[12491], 119945=>[104], 65196=>[1584], 9414=>[81], 120462=>[101], 64680=>[1580, 1605], 13030=>[12492], 
    119946=>[105], 65197=>[1585], 9415=>[82], 120463=>[102], 64681=>[1581, 1580], 13031=>[12493], 119947=>[106], 65198=>[1585], 9416=>[83], 120464=>[103], 64682=>[1581, 1605], 13032=>[12494], 119948=>[107], 65199=>[1586], 9417=>[84], 120465=>[104], 
    64683=>[1582, 1580], 13033=>[12495], 119949=>[108], 65200=>[1586], 9418=>[85], 120466=>[105], 64684=>[1582, 1605], 13034=>[12498], 119950=>[109], 65201=>[1587], 9419=>[86], 120467=>[106], 64685=>[1587, 1580], 13035=>[12501], 119951=>[110], 65202=>[1587], 
    9420=>[87], 120468=>[107], 64686=>[1587, 1581], 13036=>[12504], 119952=>[111], 65203=>[1587], 9421=>[88], 120469=>[108], 64687=>[1587, 1582], 13037=>[12507], 119953=>[112], 65204=>[1587], 9422=>[89], 120470=>[109], 64688=>[1587, 1605], 13038=>[12510], 
    119954=>[113], 65205=>[1588], 9423=>[90], 120471=>[110], 64689=>[1589, 1581], 13039=>[12511], 119955=>[114], 65206=>[1588], 9424=>[97], 120472=>[111], 64690=>[1589, 1582], 13040=>[12512], 119956=>[115], 65207=>[1588], 9425=>[98], 120473=>[112], 
    64691=>[1589, 1605], 13041=>[12513], 119957=>[116], 65208=>[1588], 9426=>[99], 120474=>[113], 64692=>[1590, 1580], 13042=>[12514], 119958=>[117], 65209=>[1589], 9427=>[100], 120475=>[114], 64693=>[1590, 1581], 13043=>[12516], 43000=>[294], 119959=>[118], 
    65210=>[1589], 9428=>[101], 120476=>[115], 64694=>[1590, 1582], 13044=>[12518], 43001=>[339], 119960=>[119], 65211=>[1589], 9429=>[102], 120477=>[116], 64695=>[1590, 1605], 13045=>[12520], 119961=>[120], 65212=>[1589], 9430=>[103], 120478=>[117], 
    64696=>[1591, 1581], 13046=>[12521], 119962=>[121], 65213=>[1590], 9431=>[104], 120479=>[118], 64697=>[1592, 1605], 13047=>[12522], 119963=>[122], 65214=>[1590], 9432=>[105], 120480=>[119], 64698=>[1593, 1580], 13048=>[12523], 119964=>[65], 65215=>[1590], 
    9433=>[106], 120481=>[120], 64699=>[1593, 1605], 13049=>[12524], 65216=>[1590], 9434=>[107], 120482=>[121], 64700=>[1594, 1580], 13050=>[12525], 119966=>[67], 65217=>[1591], 9435=>[108], 120483=>[122], 64701=>[1594, 1605], 13051=>[12527], 119967=>[68], 
    65218=>[1591], 9436=>[109], 120484=>[305], 64702=>[1601, 1580], 12019=>[40863], 13052=>[12528], 65219=>[1591], 9437=>[110], 120485=>[567], 64703=>[1601, 1581], 13053=>[12529], 65220=>[1591], 9438=>[111], 64704=>[1601, 1582], 13054=>[12530], 119970=>[71], 
    65221=>[1592], 9439=>[112], 64705=>[1601, 1605], 65222=>[1592], 9440=>[113], 120488=>[913], 64706=>[1602, 1581], 13056=>[12450, 12497, 12540, 12488], 65223=>[1592], 9441=>[114], 120489=>[914], 64707=>[1602, 1605], 13057=>[12450, 12523, 12501, 12449], 119973=>[74], 65224=>[1592], 9442=>[115], 
    120490=>[915], 64708=>[1603, 1580], 13058=>[12450, 12531, 12506, 12450], 119974=>[75], 65225=>[1593], 9443=>[116], 120491=>[916], 64709=>[1603, 1581], 13059=>[12450, 12540, 12523], 65226=>[1593], 9444=>[117], 12543=>[12467, 12488], 120492=>[917], 3763=>[3789, 3762], 64710=>[1603, 1582], 13060=>[12452, 12491, 12531, 12464], 
    65227=>[1593], 9445=>[118], 120493=>[918], 64711=>[1603, 1604], 13061=>[12452, 12531, 12481], 119977=>[78], 65228=>[1593], 9446=>[119], 120494=>[919], 64712=>[1603, 1605], 13062=>[12454, 12457, 12531], 119978=>[79], 65229=>[1594], 9447=>[120], 120495=>[920], 64713=>[1604, 1580], 
    13063=>[12456, 12473, 12463, 12540, 12489], 119979=>[80], 65230=>[1594], 9448=>[121], 120496=>[921], 64714=>[1604, 1581], 13064=>[12456, 12540, 12459, 12540], 119980=>[81], 65231=>[1594], 9449=>[122], 120497=>[922], 64715=>[1604, 1582], 12032=>[19968], 13065=>[12458, 12531, 12473], 65232=>[1594], 9450=>[48], 
    120498=>[923], 64716=>[1604, 1605], 12033=>[20008], 13066=>[12458, 12540, 12512], 119982=>[83], 65233=>[1601], 120499=>[924], 64717=>[1604, 1607], 12034=>[20022], 13067=>[12459, 12452, 12522], 119983=>[84], 65234=>[1601], 120500=>[925], 64718=>[1605, 1580], 12035=>[20031], 13068=>[12459, 12521, 12483, 12488], 
    119984=>[85], 65235=>[1601], 120501=>[926], 64719=>[1605, 1581], 12036=>[20057], 13069=>[12459, 12525, 12522, 12540], 119985=>[86], 65236=>[1601], 120502=>[927], 64720=>[1605, 1582], 12037=>[20101], 13070=>[12460, 12525, 12531], 119986=>[87], 65237=>[1602], 120503=>[928], 64721=>[1605, 1605], 
    12038=>[20108], 13071=>[12460, 12531, 12510], 119987=>[88], 65238=>[1602], 120504=>[929], 64722=>[1606, 1580], 12039=>[20128], 13072=>[12462, 12460], 160=>[32], 119988=>[89], 65239=>[1602], 120505=>[1012], 64723=>[1606, 1581], 12040=>[20154], 13073=>[12462, 12491, 12540], 119989=>[90], 
    65240=>[1602], 120506=>[931], 64724=>[1606, 1582], 12041=>[20799], 13074=>[12461, 12517, 12522, 12540], 119990=>[97], 65241=>[1603], 120507=>[932], 64725=>[1606, 1605], 12042=>[20837], 13075=>[12462, 12523, 12480, 12540], 119991=>[98], 65242=>[1603], 120508=>[933], 64726=>[1606, 1607], 12043=>[20843], 
    13076=>[12461, 12525], 119992=>[99], 65243=>[1603], 120509=>[934], 64727=>[1607, 1580], 12044=>[20866], 13077=>[12461, 12525, 12464, 12521, 12512], 119993=>[100], 65244=>[1603], 120510=>[935], 64728=>[1607, 1605], 12045=>[20886], 13078=>[12461, 12525, 12513, 12540, 12488, 12523], 65245=>[1604], 120511=>[936], 64729=>[1607, 1648], 
    12046=>[20907], 13079=>[12461, 12525, 12527, 12483, 12488], 119995=>[102], 65246=>[1604], 120512=>[937], 64730=>[1610, 1580], 12047=>[20960], 13080=>[12464, 12521, 12512], 168=>[32, 776], 65247=>[1604], 120513=>[8711], 64731=>[1610, 1581], 12048=>[20981], 13081=>[12464, 12521, 12512, 12488, 12531], 119997=>[104], 65248=>[1604], 
    120514=>[945], 64732=>[1610, 1582], 12049=>[20992], 13082=>[12463, 12523, 12476, 12452, 12525], 170=>[97], 119998=>[105], 65249=>[1605], 120515=>[946], 64733=>[1610, 1605], 12050=>[21147], 13083=>[12463, 12525, 12540, 12493], 119999=>[106], 65250=>[1605], 688=>[104], 120516=>[947], 64734=>[1610, 1607], 
    12051=>[21241], 13084=>[12465, 12540, 12473], 120000=>[107], 65251=>[1605], 689=>[614], 120517=>[948], 64735=>[1574, 1605], 12052=>[21269], 13085=>[12467, 12523, 12490], 127232=>[48, 46], 120001=>[108], 65252=>[1605], 690=>[106], 120518=>[949], 64736=>[1574, 1607], 12053=>[21274], 
    13086=>[12467, 12540, 12509], 127233=>[48, 44], 120002=>[109], 65253=>[1606], 691=>[114], 120519=>[950], 64737=>[1576, 1605], 12054=>[21304], 13087=>[12469, 12452, 12463, 12523], 127234=>[49, 44], 175=>[32, 772], 120003=>[110], 65254=>[1606], 692=>[633], 120520=>[951], 64738=>[1576, 1607], 
    12055=>[21313], 13088=>[12469, 12531, 12481, 12540, 12512], 127235=>[50, 44], 65255=>[1606], 693=>[635], 120521=>[952], 64739=>[1578, 1605], 12056=>[21340], 13089=>[12471, 12522, 12531, 12464], 127236=>[51, 44], 120005=>[112], 65256=>[1606], 694=>[641], 120522=>[953], 64740=>[1578, 1607], 12057=>[21353], 
    13090=>[12475, 12531, 12481], 127237=>[52, 44], 178=>[50], 120006=>[113], 65257=>[1607], 695=>[119], 120523=>[954], 64741=>[1579, 1605], 12058=>[21378], 13091=>[12475, 12531, 12488], 127238=>[53, 44], 179=>[51], 120007=>[114], 65258=>[1607], 696=>[121], 120524=>[955], 
    64742=>[1579, 1607], 12059=>[21430], 13092=>[12480, 12540, 12473], 127239=>[54, 44], 180=>[32, 769], 120008=>[115], 65259=>[1607], 120525=>[956], 64743=>[1587, 1605], 12060=>[21448], 13093=>[12487, 12471], 127240=>[55, 44], 181=>[956], 120009=>[116], 65260=>[1607], 120526=>[957], 
    64744=>[1587, 1607], 12061=>[21475], 13094=>[12489, 12523], 127241=>[56, 44], 120010=>[117], 65261=>[1608], 120527=>[958], 64745=>[1588, 1605], 12062=>[22231], 13095=>[12488, 12531], 127242=>[57, 44], 120011=>[118], 65262=>[1608], 120528=>[959], 64746=>[1588, 1607], 12063=>[22303], 
    13096=>[12490, 12494], 184=>[32, 807], 120012=>[119], 65263=>[1609], 8448=>[97, 47, 99], 120529=>[960], 64747=>[1603, 1604], 12064=>[22763], 13097=>[12494, 12483, 12488], 185=>[49], 120013=>[120], 65264=>[1609], 8449=>[97, 47, 115], 120530=>[961], 64748=>[1603, 1605], 12065=>[22786], 
    13098=>[12495, 12452, 12484], 186=>[111], 120014=>[121], 65265=>[1610], 8450=>[67], 120531=>[962], 64749=>[1604, 1605], 12066=>[22794], 13099=>[12497, 12540, 12475, 12531, 12488], 120015=>[122], 65266=>[1610], 8451=>[176, 67], 120532=>[963], 64750=>[1606, 1605], 12067=>[22805], 13100=>[12497, 12540, 12484], 
    188=>[49, 8260, 52], 120016=>[65], 65267=>[1610], 120533=>[964], 3804=>[3755, 3737], 64751=>[1606, 1607], 12068=>[22823], 13101=>[12496, 12540, 12524, 12523], 127248=>[40, 65, 41], 189=>[49, 8260, 50], 120017=>[66], 65268=>[1610], 8453=>[99, 47, 111], 120534=>[965], 3805=>[3755, 3745], 64752=>[1610, 1605], 
    12069=>[22899], 13102=>[12500, 12450, 12473, 12488, 12523], 127249=>[40, 66, 41], 190=>[51, 8260, 52], 120018=>[67], 65269=>[1604, 1570], 8454=>[99, 47, 117], 120535=>[966], 64753=>[1610, 1607], 12070=>[23376], 13103=>[12500, 12463, 12523], 127250=>[40, 67, 41], 120019=>[68], 65270=>[1604, 1570], 8455=>[400], 120536=>[967], 
    64754=>[1600, 1614, 1617], 12071=>[23424], 13104=>[12500, 12467], 127251=>[40, 68, 41], 120020=>[69], 65271=>[1604, 1571], 120537=>[968], 64755=>[1600, 1615, 1617], 12072=>[23544], 13105=>[12499, 12523], 127252=>[40, 69, 41], 120021=>[70], 65272=>[1604, 1571], 8457=>[176, 70], 120538=>[969], 64756=>[1600, 1616, 1617], 
    12073=>[23567], 13106=>[12501, 12449, 12521, 12483, 12489], 127253=>[40, 70, 41], 120022=>[71], 65273=>[1604, 1573], 8458=>[103], 120539=>[8706], 64757=>[1591, 1609], 12074=>[23586], 13107=>[12501, 12451, 12540, 12488], 127254=>[40, 71, 41], 120023=>[72], 65274=>[1604, 1573], 8459=>[72], 120540=>[1013], 64758=>[1591, 1610], 
    12075=>[23608], 13108=>[12502, 12483, 12471, 12455, 12523], 127255=>[40, 72, 41], 120024=>[73], 65275=>[1604, 1575], 8460=>[72], 120541=>[977], 64759=>[1593, 1609], 12076=>[23662], 13109=>[12501, 12521, 12531], 127256=>[40, 73, 41], 120025=>[74], 65276=>[1604, 1575], 8461=>[72], 12593=>[4352], 120542=>[1008], 
    64760=>[1593, 1610], 12077=>[23665], 13110=>[12504, 12463, 12479, 12540, 12523], 127257=>[40, 74, 41], 120026=>[75], 8462=>[104], 12594=>[4353], 120543=>[981], 64761=>[1594, 1609], 12078=>[24027], 13111=>[12506, 12477], 127258=>[40, 75, 41], 120027=>[76], 8463=>[295], 12595=>[4522], 120544=>[1009], 
    64762=>[1594, 1610], 12079=>[24037], 13112=>[12506, 12491, 12498], 127259=>[40, 76, 41], 120028=>[77], 8464=>[73], 12596=>[4354], 120545=>[982], 64763=>[1587, 1609], 12080=>[24049], 13113=>[12504, 12523, 12484], 127260=>[40, 77, 41], 120029=>[78], 8465=>[73], 12597=>[4524], 120546=>[913], 
    64764=>[1587, 1610], 12081=>[24062], 13114=>[12506, 12531, 12473], 127261=>[40, 78, 41], 120030=>[79], 65281=>[33], 8466=>[76], 12598=>[4525], 120547=>[914], 64765=>[1588, 1609], 12082=>[24178], 13115=>[12506, 12540, 12472], 127262=>[40, 79, 41], 120031=>[80], 65282=>[34], 8467=>[108], 
    12599=>[4355], 120548=>[915], 64766=>[1588, 1610], 12083=>[24186], 13116=>[12505, 12540, 12479], 127263=>[40, 80, 41], 120032=>[81], 65283=>[35], 12600=>[4356], 120549=>[916], 64767=>[1581, 1609], 12084=>[24191], 13117=>[12509, 12452, 12531, 12488], 127264=>[40, 81, 41], 120033=>[82], 65284=>[36], 
    8469=>[78], 12601=>[4357], 120550=>[917], 64768=>[1581, 1610], 12085=>[24308], 13118=>[12508, 12523, 12488], 127265=>[40, 82, 41], 120034=>[83], 65285=>[37], 8470=>[78, 111], 12602=>[4528], 120551=>[918], 64769=>[1580, 1609], 12086=>[24318], 13119=>[12507, 12531], 127266=>[40, 83, 41], 
    120035=>[84], 65286=>[38], 12603=>[4529], 120552=>[919], 64770=>[1580, 1610], 12087=>[24331], 13120=>[12509, 12531, 12489], 127267=>[40, 84, 41], 120036=>[85], 65287=>[39], 12604=>[4530], 120553=>[920], 64771=>[1582, 1609], 12088=>[24339], 13121=>[12507, 12540, 12523], 127268=>[40, 85, 41], 
    120037=>[86], 65288=>[40], 8473=>[80], 12605=>[4531], 120554=>[921], 64772=>[1582, 1610], 12089=>[24400], 13122=>[12507, 12540, 12531], 127269=>[40, 86, 41], 120038=>[87], 64256=>[102, 102], 65289=>[41], 8474=>[81], 12606=>[4532], 120555=>[922], 64773=>[1589, 1609], 
    12090=>[24417], 13123=>[12510, 12452, 12463, 12525], 127270=>[40, 87, 41], 120039=>[88], 64257=>[102, 105], 65290=>[42], 8475=>[82], 12607=>[4533], 728=>[32, 774], 120556=>[923], 64774=>[1589, 1610], 12091=>[24435], 13124=>[12510, 12452, 12523], 127271=>[40, 88, 41], 120040=>[89], 64258=>[102, 108], 
    65291=>[43], 8476=>[82], 12608=>[4378], 729=>[32, 775], 120557=>[924], 64775=>[1590, 1609], 12092=>[24515], 13125=>[12510, 12483, 12495], 127272=>[40, 89, 41], 120041=>[90], 64259=>[102, 102, 105], 65292=>[44], 8477=>[82], 12609=>[4358], 730=>[32, 778], 120558=>[925], 
    64776=>[1590, 1610], 12093=>[25096], 13126=>[12510, 12523, 12463], 127273=>[40, 90, 41], 120042=>[97], 64260=>[102, 102, 108], 65293=>[45], 12610=>[4359], 731=>[32, 808], 120559=>[926], 64777=>[1588, 1580], 12094=>[25142], 13127=>[12510, 12531, 12471, 12519, 12531], 127274=>[12308, 83, 12309], 120043=>[98], 64261=>[383, 116], 
    65294=>[46], 12611=>[4360], 732=>[32, 771], 120560=>[927], 64778=>[1588, 1581], 12095=>[25163], 13128=>[12511, 12463, 12525, 12531], 127275=>[67], 120044=>[99], 4348=>[4316], 64262=>[115, 116], 65295=>[47], 8480=>[83, 77], 12612=>[4385], 733=>[32, 779], 120561=>[928], 
    64779=>[1588, 1582], 12096=>[25903], 13129=>[12511, 12522], 127276=>[82], 120045=>[100], 65296=>[48], 8481=>[84, 69, 76], 12613=>[4361], 120562=>[929], 64780=>[1588, 1605], 12097=>[25908], 13130=>[12511, 12522, 12496, 12540, 12523], 127277=>[67, 68], 120046=>[101], 65297=>[49], 8482=>[84, 77], 
    12614=>[4362], 120563=>[1012], 64781=>[1588, 1585], 12098=>[25991], 13131=>[12513, 12460], 127278=>[87, 90], 120047=>[102], 65298=>[50], 12615=>[4363], 736=>[611], 120564=>[931], 64782=>[1587, 1585], 12099=>[26007], 13132=>[12513, 12460, 12488, 12531], 120048=>[103], 65299=>[51], 
    8484=>[90], 12616=>[4364], 737=>[108], 120565=>[932], 64783=>[1589, 1585], 12100=>[26020], 13133=>[12513, 12540, 12488, 12523], 127280=>[65], 120049=>[104], 65300=>[52], 12617=>[4365], 738=>[115], 120566=>[933], 64784=>[1590, 1585], 12101=>[26041], 13134=>[12516, 12540, 12489], 
    127281=>[66], 120050=>[105], 65301=>[53], 12618=>[4366], 739=>[120], 120567=>[934], 64785=>[1591, 1609], 12102=>[26080], 13135=>[12516, 12540, 12523], 127282=>[67], 120051=>[106], 65302=>[54], 12619=>[4367], 740=>[661], 120568=>[935], 64786=>[1591, 1610], 
    12103=>[26085], 13136=>[12518, 12450, 12531], 127283=>[68], 120052=>[107], 65303=>[55], 8488=>[90], 12620=>[4368], 120569=>[936], 64787=>[1593, 1609], 12104=>[26352], 13137=>[12522, 12483, 12488, 12523], 127284=>[69], 120053=>[108], 65304=>[56], 12621=>[4369], 120570=>[937], 
    64788=>[1593, 1610], 12105=>[26376], 13138=>[12522, 12521], 127285=>[70], 120054=>[109], 65305=>[57], 12622=>[4370], 120571=>[8711], 64789=>[1594, 1609], 12106=>[26408], 13139=>[12523, 12500, 12540], 127286=>[71], 120055=>[110], 65306=>[58], 12623=>[4449], 120572=>[945], 
    64790=>[1594, 1610], 12107=>[27424], 13140=>[12523, 12540, 12502, 12523], 127287=>[72], 120056=>[111], 65307=>[59], 8492=>[66], 12624=>[4450], 120573=>[946], 64791=>[1587, 1609], 12108=>[27490], 13141=>[12524, 12512], 127288=>[73], 120057=>[112], 64275=>[1396, 1398], 65308=>[60], 
    8493=>[67], 12625=>[4451], 120574=>[947], 64792=>[1587, 1610], 12109=>[27513], 13142=>[12524, 12531, 12488, 12466, 12531], 127289=>[74], 120058=>[113], 64276=>[1396, 1381], 65309=>[61], 12626=>[4452], 120575=>[948], 64793=>[1588, 1609], 12110=>[27571], 13143=>[12527, 12483, 12488], 127290=>[75], 
    120059=>[114], 64277=>[1396, 1387], 65310=>[62], 8495=>[101], 12627=>[4453], 120576=>[949], 64794=>[1588, 1610], 12111=>[27595], 13144=>[48, 28857], 127291=>[76], 120060=>[115], 64278=>[1406, 1398], 65311=>[63], 8496=>[69], 12628=>[4454], 120577=>[950], 
    64795=>[1581, 1609], 12112=>[27604], 13145=>[49, 28857], 127292=>[77], 120061=>[116], 64279=>[1396, 1389], 65312=>[64], 8497=>[70], 12629=>[4455], 120578=>[951], 64796=>[1581, 1610], 12113=>[27611], 13146=>[50, 28857], 127293=>[78], 120062=>[117], 65313=>[65], 
    12630=>[4456], 120579=>[952], 64797=>[1580, 1609], 12114=>[27663], 13147=>[51, 28857], 127294=>[79], 120063=>[118], 65314=>[66], 8499=>[77], 12631=>[4457], 120580=>[953], 64798=>[1580, 1610], 12115=>[27668], 13148=>[52, 28857], 127295=>[80], 120064=>[119], 
    65315=>[67], 8500=>[111], 12632=>[4458], 120581=>[954], 3852=>[3851], 64799=>[1582, 1609], 12116=>[27700], 13149=>[53, 28857], 127296=>[81], 120065=>[120], 65316=>[68], 7468=>[65], 8501=>[1488], 12633=>[4459], 120582=>[955], 64800=>[1582, 1610], 
    12117=>[28779], 13150=>[54, 28857], 127297=>[82], 120066=>[121], 65317=>[69], 7469=>[198], 8502=>[1489], 12634=>[4460], 120583=>[956], 64801=>[1589, 1609], 12118=>[29226], 13151=>[55, 28857], 127298=>[83], 120067=>[122], 65318=>[70], 7470=>[66], 
    8503=>[1490], 12635=>[4461], 120584=>[957], 64802=>[1589, 1610], 12119=>[29238], 13152=>[56, 28857], 127299=>[84], 120068=>[65], 65319=>[71], 8504=>[1491], 12636=>[4462], 120585=>[958], 64803=>[1590, 1609], 12120=>[29243], 13153=>[57, 28857], 127300=>[85], 
    120069=>[66], 65320=>[72], 7472=>[68], 8505=>[105], 12637=>[4463], 120586=>[959], 64804=>[1590, 1610], 12121=>[29247], 13154=>[49, 48, 28857], 127301=>[86], 64288=>[1506], 65321=>[73], 7473=>[69], 12638=>[4464], 120587=>[960], 64805=>[1588, 1580], 
    12122=>[29255], 13155=>[49, 49, 28857], 127302=>[87], 120071=>[68], 64289=>[1488], 65322=>[74], 7474=>[398], 8507=>[70, 65, 88], 12639=>[4465], 120588=>[961], 64806=>[1588, 1581], 12123=>[29273], 13156=>[49, 50, 28857], 127303=>[88], 120072=>[69], 64290=>[1491], 
    65323=>[75], 7475=>[71], 8508=>[960], 12640=>[4466], 120589=>[962], 64807=>[1588, 1582], 12124=>[29275], 13157=>[49, 51, 28857], 127304=>[89], 120073=>[70], 64291=>[1492], 65324=>[76], 7476=>[72], 8509=>[947], 12641=>[4467], 120590=>[963], 
    64808=>[1588, 1605], 12125=>[29356], 13158=>[49, 52, 28857], 127305=>[90], 120074=>[71], 64292=>[1499], 65325=>[77], 7477=>[73], 8510=>[915], 12642=>[4468], 120591=>[964], 64809=>[1588, 1585], 12126=>[29572], 13159=>[49, 53, 28857], 127306=>[72, 86], 64293=>[1500], 
    65326=>[78], 7478=>[74], 8511=>[928], 12643=>[4469], 120592=>[965], 64810=>[1587, 1585], 12127=>[29577], 13160=>[49, 54, 28857], 127307=>[77, 86], 64294=>[1501], 65327=>[79], 7479=>[75], 8512=>[8721], 12644=>[4448], 120593=>[966], 64811=>[1589, 1585], 
    12128=>[29916], 13161=>[49, 55, 28857], 127308=>[83, 68], 120077=>[74], 64295=>[1512], 65328=>[80], 7480=>[76], 12645=>[4372], 120594=>[967], 64812=>[1590, 1585], 12129=>[29926], 13162=>[49, 56, 28857], 127309=>[83, 83], 120078=>[75], 64296=>[1514], 65329=>[81], 
    7481=>[77], 12646=>[4373], 120595=>[968], 64813=>[1588, 1580], 12130=>[29976], 13163=>[49, 57, 28857], 127310=>[80, 80, 86], 120079=>[76], 64297=>[43], 65330=>[82], 7482=>[78], 12647=>[4551], 120596=>[969], 64814=>[1588, 1581], 12131=>[29983], 13164=>[50, 48, 28857], 
    127311=>[87, 67], 120080=>[77], 65331=>[83], 12648=>[4552], 120597=>[8706], 64815=>[1588, 1582], 12132=>[29992], 13165=>[50, 49, 28857], 120081=>[78], 65332=>[84], 7484=>[79], 8517=>[68], 12649=>[4556], 120598=>[1013], 64816=>[1588, 1605], 12133=>[30000], 
    13166=>[50, 50, 28857], 120082=>[79], 65333=>[85], 7485=>[546], 8518=>[100], 12650=>[4558], 120599=>[977], 64817=>[1587, 1607], 12134=>[30091], 13167=>[50, 51, 28857], 120083=>[80], 65334=>[86], 7486=>[80], 8519=>[101], 12651=>[4563], 120600=>[1008], 
    64818=>[1588, 1607], 12135=>[30098], 13168=>[50, 52, 28857], 120084=>[81], 65335=>[87], 7487=>[82], 8520=>[105], 12652=>[4567], 120601=>[981], 64819=>[1591, 1605], 12136=>[30326], 13169=>[104, 80, 97], 65336=>[88], 7488=>[84], 8521=>[106], 12653=>[4569], 
    120602=>[1009], 64820=>[1587, 1580], 12137=>[30333], 13170=>[100, 97], 120086=>[83], 65337=>[89], 7489=>[85], 12654=>[4380], 120603=>[982], 64821=>[1587, 1581], 12138=>[30382], 13171=>[65, 85], 120087=>[84], 65338=>[90], 7490=>[87], 12655=>[4573], 
    120604=>[913], 64822=>[1587, 1582], 12139=>[30399], 13172=>[98, 97, 114], 120088=>[85], 65339=>[91], 7491=>[97], 12656=>[4575], 120605=>[914], 64823=>[1588, 1580], 12140=>[30446], 13173=>[111, 86], 120089=>[86], 65340=>[92], 7492=>[592], 12657=>[4381], 
    120606=>[915], 64824=>[1588, 1581], 12141=>[30683], 13174=>[112, 99], 65341=>[93], 7493=>[593], 12658=>[4382], 120090=>[87], 120607=>[916], 64825=>[1588, 1582], 12142=>[30690], 13175=>[100, 109], 65342=>[94], 7494=>[7426], 12659=>[4384], 120091=>[88], 
    120608=>[917], 64826=>[1591, 1605], 12143=>[30707], 13176=>[100, 109, 178], 65343=>[95], 7495=>[98], 8528=>[49, 8260, 55], 12660=>[4386], 120092=>[89], 120609=>[918], 64827=>[1592, 1605], 12144=>[31034], 13177=>[100, 109, 179], 65344=>[96], 7496=>[100], 8529=>[49, 8260, 57], 
    12661=>[4387], 120610=>[919], 64828=>[1575, 1611], 12145=>[31160], 13178=>[73, 85], 65345=>[97], 7497=>[101], 8530=>[49, 8260, 49, 48], 12662=>[4391], 120094=>[97], 120611=>[920], 64829=>[1575, 1611], 12146=>[31166], 13179=>[24179, 25104], 65346=>[98], 7498=>[601], 
    8531=>[49, 8260, 51], 12663=>[4393], 120095=>[98], 120612=>[921], 12147=>[31348], 13180=>[26157, 21644], 65347=>[99], 7499=>[603], 8532=>[50, 8260, 51], 11631=>[11617], 12664=>[4395], 120096=>[99], 120613=>[922], 12148=>[31435], 13181=>[22823, 27491], 65348=>[100], 
    7500=>[604], 8533=>[49, 8260, 53], 12665=>[4396], 120097=>[100], 120614=>[923], 12149=>[31481], 13182=>[26126, 27835], 65349=>[101], 7501=>[103], 8534=>[50, 8260, 53], 12666=>[4397], 120098=>[101], 120615=>[924], 12150=>[31859], 13183=>[26666, 24335, 20250, 31038], 65350=>[102], 
    8535=>[51, 8260, 53], 12667=>[4398], 120099=>[102], 120616=>[925], 12151=>[31992], 13184=>[112, 65], 65351=>[103], 7503=>[107], 8536=>[52, 8260, 53], 12668=>[4399], 120100=>[103], 120617=>[926], 12152=>[32566], 13185=>[110, 65], 65352=>[104], 7504=>[109], 
    8537=>[49, 8260, 54], 12669=>[4402], 120101=>[104], 120618=>[927], 12153=>[32593], 13186=>[956, 65], 65353=>[105], 7505=>[331], 8538=>[53, 8260, 54], 12670=>[4406], 120102=>[105], 120619=>[928], 12154=>[32650], 13187=>[109, 65], 65354=>[106], 7506=>[111], 
    8539=>[49, 8260, 56], 12671=>[4416], 120103=>[106], 120620=>[929], 12155=>[32701], 13188=>[107, 65], 65355=>[107], 7507=>[596], 8540=>[51, 8260, 56], 12672=>[4423], 120104=>[107], 120621=>[1012], 12156=>[32769], 13189=>[75, 66], 65356=>[108], 7508=>[7446], 
    8541=>[53, 8260, 56], 12673=>[4428], 120105=>[108], 120622=>[931], 12157=>[32780], 13190=>[77, 66], 65357=>[109], 7509=>[7447], 8542=>[55, 8260, 56], 12674=>[4593], 120106=>[109], 120623=>[932], 12158=>[32786], 13191=>[71, 66], 127338=>[77, 67], 65358=>[110], 
    7510=>[112], 8543=>[49, 8260], 12675=>[4594], 120107=>[110], 120624=>[933], 12159=>[32819], 13192=>[99, 97, 108], 127339=>[77, 68], 65359=>[111], 7511=>[116], 8544=>[73], 12676=>[4439], 120108=>[111], 120625=>[934], 12160=>[32895], 13193=>[107, 99, 97, 108], 
    65360=>[112], 7512=>[117], 8545=>[73, 73], 12677=>[4440], 120109=>[112], 120626=>[935], 12161=>[32905], 13194=>[112, 70], 65361=>[113], 7513=>[7453], 8546=>[73, 73, 73], 12678=>[4441], 120110=>[113], 120627=>[936], 12162=>[33251], 13195=>[110, 70], 
    65362=>[114], 7514=>[623], 8547=>[73, 86], 12679=>[4484], 120111=>[114], 120628=>[937], 12163=>[33258], 13196=>[956, 70], 65363=>[115], 7515=>[118], 8548=>[86], 12680=>[4485], 120112=>[115], 120629=>[8711], 12164=>[33267], 13197=>[956, 103], 
    65364=>[116], 7516=>[7461], 8549=>[86, 73], 12681=>[4488], 120113=>[116], 120630=>[945], 64848=>[1578, 1580, 1605], 12165=>[33276], 13198=>[109, 103], 65365=>[117], 7517=>[946], 8550=>[86, 73, 73], 12682=>[4497], 120114=>[117], 120631=>[946], 64849=>[1578, 1581, 1580], 
    12166=>[33292], 13199=>[107, 103], 65366=>[118], 7518=>[947], 8551=>[86, 73, 73, 73], 12683=>[4498], 120115=>[118], 120632=>[947], 64850=>[1578, 1581, 1580], 12167=>[33307], 13200=>[72, 122], 65367=>[119], 7519=>[948], 8552=>[73, 88], 12684=>[4500], 120116=>[119], 
    120633=>[948], 64851=>[1578, 1581, 1605], 12168=>[33311], 13201=>[107, 72, 122], 64335=>[1488, 1500], 65368=>[120], 7520=>[966], 8553=>[88], 12685=>[4510], 120117=>[120], 120634=>[949], 64852=>[1578, 1582, 1605], 12169=>[33390], 13202=>[77, 72, 122], 64336=>[1649], 65369=>[121], 
    7521=>[967], 8554=>[88, 73], 12686=>[4513], 120118=>[121], 120635=>[950], 64853=>[1578, 1605, 1580], 12170=>[33394], 13203=>[71, 72, 122], 64337=>[1649], 65370=>[122], 7522=>[105], 8555=>[88, 73, 73], 120119=>[122], 120636=>[951], 64854=>[1578, 1605, 1581], 12171=>[33400], 
    13204=>[84, 72, 122], 64338=>[1659], 65371=>[123], 7523=>[114], 8556=>[76], 120120=>[65], 120637=>[952], 64855=>[1578, 1605, 1582], 12172=>[34381], 13205=>[956, 8467], 64339=>[1659], 65372=>[124], 7524=>[117], 8557=>[67], 120121=>[66], 120638=>[953], 
    64856=>[1580, 1605, 1581], 12173=>[34411], 13206=>[109, 8467], 64340=>[1659], 65373=>[125], 7525=>[118], 8558=>[68], 12690=>[19968], 120639=>[954], 64857=>[1580, 1605, 1581], 12174=>[34880], 13207=>[100, 8467], 64341=>[1659], 65374=>[126], 7526=>[946], 8559=>[77], 
    12691=>[20108], 120123=>[68], 120640=>[955], 64858=>[1581, 1605, 1610], 12175=>[34892], 13208=>[107, 8467], 64342=>[1662], 65375=>[10629], 7527=>[947], 8560=>[105], 12692=>[19977], 120124=>[69], 120641=>[956], 64859=>[1581, 1605, 1609], 12176=>[34915], 13209=>[102, 109], 
    65376=>[10630], 7528=>[961], 8561=>[105, 105], 12693=>[22235], 120125=>[70], 64343=>[1662], 120642=>[957], 64860=>[1587, 1581, 1580], 12177=>[35198], 13210=>[110, 109], 65377=>[12290], 7529=>[966], 8562=>[105, 105, 105], 12694=>[19978], 120126=>[71], 64344=>[1662], 
    120643=>[958], 64861=>[1587, 1580, 1581], 12178=>[35211], 13211=>[956, 109], 65378=>[12300], 7530=>[967], 8563=>[105, 118], 12695=>[20013], 64345=>[1662], 120644=>[959], 64862=>[1587, 1580, 1609], 12179=>[35282], 13212=>[109, 109], 65379=>[12301], 8564=>[118], 12696=>[19979], 
    120128=>[73], 64346=>[1664], 120645=>[960], 64863=>[1587, 1605, 1581], 12180=>[35328], 13213=>[99, 109], 65380=>[12289], 8565=>[118, 105], 12697=>[30002], 120129=>[74], 64347=>[1664], 120646=>[961], 12181=>[35895], 13214=>[107, 109], 64864=>[1587, 1605, 1581], 65381=>[12539], 
    8566=>[118, 105, 105], 12698=>[20057], 120130=>[75], 64348=>[1664], 120647=>[962], 12182=>[35910], 13215=>[109, 109, 178], 64865=>[1587, 1605, 1580], 65382=>[12530], 8567=>[118, 105, 105, 105], 12699=>[19993], 120131=>[76], 64349=>[1664], 120648=>[963], 12183=>[35925], 13216=>[99, 109, 178], 
    64866=>[1587, 1605, 1605], 65383=>[12449], 8568=>[105, 120], 12700=>[19969], 120132=>[77], 64350=>[1658], 120649=>[964], 12184=>[35960], 13217=>[109, 178], 64867=>[1587, 1605, 1605], 65384=>[12451], 8569=>[120], 12701=>[22825], 64351=>[1658], 120650=>[965], 12185=>[35997], 
    13218=>[107, 109, 178], 64868=>[1589, 1581, 1581], 8570=>[120, 105], 12702=>[22320], 306=>[73, 74], 120134=>[79], 64352=>[1658], 65385=>[12453], 120651=>[966], 12186=>[36196], 13219=>[109, 109, 179], 64869=>[1589, 1581, 1581], 8571=>[120, 105, 105], 12703=>[20154], 307=>[105, 106], 64353=>[1658], 
    65386=>[12455], 120652=>[967], 12187=>[36208], 13220=>[99, 109, 179], 64870=>[1589, 1605, 1605], 8572=>[108], 64354=>[1663], 65387=>[12457], 120653=>[968], 12188=>[36275], 13221=>[109, 179], 64871=>[1588, 1581, 1605], 8573=>[99], 64355=>[1663], 65388=>[12515], 120654=>[969], 
    12189=>[36523], 13222=>[107, 109, 179], 64872=>[1588, 1581, 1605], 8574=>[100], 120138=>[83], 64356=>[1663], 65389=>[12517], 120655=>[8706], 12190=>[36554], 13223=>[109, 8725, 115], 64873=>[1588, 1580, 1610], 8575=>[109], 120139=>[84], 64357=>[1663], 65390=>[12519], 120656=>[1013], 
    12191=>[36763], 13224=>[109, 8725, 115, 178], 64874=>[1588, 1605, 1582], 120140=>[85], 64358=>[1657], 65391=>[12483], 120657=>[977], 12192=>[36784], 13225=>[80, 97], 64875=>[1588, 1605, 1582], 7544=>[1085], 120141=>[86], 64359=>[1657], 65392=>[12540], 120658=>[1008], 12193=>[36789], 
    13226=>[107, 80, 97], 64876=>[1588, 1605, 1605], 120142=>[87], 64360=>[1657], 65393=>[12450], 120659=>[981], 12194=>[37009], 13227=>[77, 80, 97], 64877=>[1588, 1605, 1605], 120143=>[88], 64361=>[1657], 65394=>[12452], 120660=>[1009], 12195=>[37193], 13228=>[71, 80, 97], 64878=>[1590, 1581, 1609], 
    120144=>[89], 64362=>[1700], 65395=>[12454], 120661=>[982], 12196=>[37318], 13229=>[114, 97, 100], 64879=>[1590, 1582, 1605], 127376=>[68, 74], 64363=>[1700], 65396=>[12456], 120662=>[913], 12197=>[37324], 13230=>[114, 97, 100, 8725, 115], 64880=>[1590, 1582, 1605], 120146=>[97], 64364=>[1700], 
    65397=>[12458], 120663=>[914], 12198=>[37329], 13231=>[114, 97, 100, 8725, 115, 178], 64881=>[1591, 1605, 1581], 319=>[76, 183], 120147=>[98], 64365=>[1700], 65398=>[12459], 120664=>[915], 12199=>[38263], 13232=>[112, 115], 64882=>[1591, 1605, 1581], 320=>[108, 183], 120148=>[99], 64366=>[1702], 
    65399=>[12461], 120665=>[916], 12200=>[38272], 13233=>[110, 115], 64883=>[1591, 1605, 1605], 8585=>[48, 8260, 51], 120149=>[100], 64367=>[1702], 65400=>[12463], 120666=>[917], 12201=>[38428], 13234=>[956, 115], 64884=>[1591, 1605, 1610], 120150=>[101], 64368=>[1702], 65401=>[12465], 
    120667=>[918], 12202=>[38582], 13235=>[109, 115], 64885=>[1593, 1580, 1605], 120151=>[102], 64369=>[1702], 65402=>[12467], 120668=>[919], 12203=>[38585], 13236=>[112, 86], 64886=>[1593, 1605, 1605], 120152=>[103], 64370=>[1668], 65403=>[12469], 120669=>[920], 12204=>[38632], 
    13237=>[110, 86], 64887=>[1593, 1605, 1605], 120153=>[104], 64371=>[1668], 65404=>[12471], 120670=>[921], 12205=>[38737], 13238=>[956, 86], 64888=>[1593, 1605, 1609], 120154=>[105], 64372=>[1668], 65405=>[12473], 120671=>[922], 12206=>[38750], 13239=>[109, 86], 64889=>[1594, 1605, 1605], 
    120155=>[106], 64373=>[1668], 65406=>[12475], 120672=>[923], 12207=>[38754], 13240=>[107, 86], 64890=>[1594, 1605, 1610], 120156=>[107], 64374=>[1667], 65407=>[12477], 120673=>[924], 12208=>[38761], 13241=>[77, 86], 64891=>[1594, 1605, 1609], 329=>[700, 110], 120157=>[108], 
    64375=>[1667], 65408=>[12479], 120674=>[925], 12209=>[38859], 13242=>[112, 87], 64892=>[1601, 1582, 1605], 120158=>[109], 64376=>[1667], 65409=>[12481], 120675=>[926], 12210=>[38893], 13243=>[110, 87], 64893=>[1601, 1582, 1605], 120159=>[110], 64377=>[1667], 65410=>[12484], 
    120676=>[927], 12211=>[38899], 13244=>[956, 87], 64894=>[1602, 1605, 1581], 120160=>[111], 64378=>[1670], 65411=>[12486], 120677=>[928], 12212=>[38913], 13245=>[109, 87], 64895=>[1602, 1605, 1605], 120161=>[112], 64379=>[1670], 65412=>[12488], 120678=>[929], 12213=>[39080], 
    13246=>[107, 87], 64896=>[1604, 1581, 1605], 120162=>[113], 64380=>[1670], 65413=>[12490], 120679=>[1012], 12214=>[39131], 13247=>[77, 87], 64897=>[1604, 1581, 1610], 120163=>[114], 64381=>[1670], 65414=>[12491], 120680=>[931], 12215=>[39135], 13248=>[107, 937], 64898=>[1604, 1581, 1609], 
    120164=>[115], 64382=>[1671], 65415=>[12492], 120681=>[932], 12216=>[39318], 13249=>[77, 937], 64899=>[1604, 1580, 1580], 120165=>[116], 64383=>[1671], 65416=>[12493], 120682=>[933], 12217=>[39321], 13250=>[97, 46, 109, 46], 64900=>[1604, 1580, 1580], 120166=>[117], 64384=>[1671], 
    65417=>[12494], 120683=>[934], 12218=>[39340], 13251=>[66, 113], 64901=>[1604, 1582, 1605], 120167=>[118], 64385=>[1671], 65418=>[12495], 120684=>[935], 12219=>[39592], 13252=>[99, 99], 64902=>[1604, 1582, 1605], 120168=>[119], 64386=>[1677], 65419=>[12498], 120685=>[936], 
    12220=>[39640], 13253=>[99, 100], 64903=>[1604, 1605, 1581], 120169=>[120], 64387=>[1677], 65420=>[12501], 120686=>[937], 12221=>[39647], 13254=>[67, 8725, 107, 103], 64904=>[1604, 1605, 1581], 120170=>[121], 64388=>[1676], 65421=>[12504], 120687=>[8711], 12222=>[39717], 13255=>[67, 111, 46], 
    64905=>[1605, 1581, 1580], 120171=>[122], 64389=>[1676], 65422=>[12507], 120688=>[945], 12223=>[39727], 13256=>[100, 66], 3959=>[4018, 3969], 64906=>[1605, 1581, 1605], 120172=>[65], 64390=>[1678], 65423=>[12510], 120689=>[946], 12224=>[39730], 13257=>[71, 121], 64907=>[1605, 1581, 1610], 
    120173=>[66], 64391=>[1678], 65424=>[12511], 120690=>[947], 12225=>[39740], 13258=>[104, 97], 3961=>[4019, 3969], 64908=>[1605, 1580, 1581], 120174=>[67], 64392=>[1672], 65425=>[12512], 120691=>[948], 12226=>[39770], 13259=>[72, 80], 64909=>[1605, 1580, 1605], 120175=>[68], 
    64393=>[1672], 65426=>[12513], 120692=>[949], 12227=>[40165], 13260=>[105, 110], 64910=>[1605, 1582, 1580], 120176=>[69], 64394=>[1688], 65427=>[12514], 7579=>[594], 120693=>[950], 12228=>[40565], 13261=>[75, 75], 64911=>[1605, 1582, 1605], 120177=>[70], 64395=>[1688], 
    65428=>[12516], 7580=>[99], 120694=>[951], 12229=>[40575], 13262=>[75, 77], 120178=>[71], 64396=>[1681], 65429=>[12518], 7581=>[597], 120695=>[952], 12230=>[40613], 13263=>[107, 116], 120179=>[72], 64397=>[1681], 65430=>[12520], 7582=>[240], 
    120696=>[953], 12231=>[40635], 13264=>[108, 109], 64914=>[1605, 1580, 1582], 120180=>[73], 64398=>[1705], 65431=>[12521], 7583=>[604], 120697=>[954], 12232=>[40643], 13265=>[108, 110], 64915=>[1607, 1605, 1580], 120181=>[74], 64399=>[1705], 65432=>[12522], 7584=>[102], 
    120698=>[955], 12233=>[40653], 13266=>[108, 111, 103], 64916=>[1607, 1605, 1605], 120182=>[75], 64400=>[1705], 65433=>[12523], 7585=>[607], 120699=>[956], 12234=>[40657], 13267=>[108, 120], 64917=>[1606, 1581, 1605], 120183=>[76], 64401=>[1705], 65434=>[12524], 7586=>[609], 
    120700=>[957], 12235=>[40697], 13268=>[109, 98], 64918=>[1606, 1581, 1609], 120184=>[77], 64402=>[1711], 65435=>[12525], 7587=>[613], 120701=>[958], 12236=>[40701], 13269=>[109, 105, 108], 64919=>[1606, 1580, 1605], 120185=>[78], 64403=>[1711], 65436=>[12527], 7588=>[616], 
    120702=>[959], 12237=>[40718], 13270=>[109, 111, 108], 64920=>[1606, 1580, 1605], 120186=>[79], 64404=>[1711], 65437=>[12531], 7589=>[617], 120703=>[960], 12238=>[40723], 13271=>[80, 72], 64921=>[1606, 1580, 1609], 120187=>[80], 64405=>[1711], 65438=>[12441], 7590=>[618], 
    120704=>[961], 12239=>[40736], 13272=>[112, 46, 109, 46], 64922=>[1606, 1605, 1610], 120188=>[81], 64406=>[1715], 65439=>[12442], 7591=>[7547], 120705=>[962], 12240=>[40763], 13273=>[80, 80, 77], 64923=>[1606, 1605, 1609], 120189=>[82], 64407=>[1715], 65440=>[12644], 7592=>[669], 
    120706=>[963], 12241=>[40778], 13274=>[80, 82], 64924=>[1610, 1605, 1605], 120190=>[83], 64408=>[1715], 65441=>[12593], 7593=>[621], 120707=>[964], 12242=>[40786], 13275=>[115, 114], 64925=>[1610, 1605, 1605], 120191=>[84], 64409=>[1715], 65442=>[12594], 7594=>[7557], 
    120708=>[965], 13276=>[83, 118], 64926=>[1576, 1582, 1610], 12243=>[40845], 120192=>[85], 64410=>[1713], 65443=>[12595], 7595=>[671], 120709=>[966], 13277=>[87, 98], 64927=>[1578, 1580, 1610], 12244=>[40860], 120193=>[86], 64411=>[1713], 65444=>[12596], 7596=>[625], 
    120710=>[967], 13278=>[86, 8725, 109], 64928=>[1578, 1580, 1609], 12245=>[40864], 120194=>[87], 64412=>[1713], 65445=>[12597], 7597=>[624], 120711=>[968], 13279=>[65, 8725, 109], 64929=>[1578, 1582, 1610], 120195=>[88], 64413=>[1713], 65446=>[12598], 7598=>[626], 120712=>[969], 
    13280=>[49, 26085], 64930=>[1578, 1582, 1609], 120196=>[89], 64414=>[1722], 65447=>[12599], 7599=>[627], 120713=>[8706], 13281=>[50, 26085], 64931=>[1578, 1605, 1610], 120197=>[90], 64415=>[1722], 65448=>[12600], 7600=>[628], 120714=>[1013], 13282=>[51, 26085], 64932=>[1578, 1605, 1609], 
    120198=>[97], 64416=>[1723], 65449=>[12601], 7601=>[629], 120715=>[977], 13283=>[52, 26085], 64933=>[1580, 1605, 1610], 120199=>[98], 64417=>[1723], 65450=>[12602], 7602=>[632], 120716=>[1008], 13284=>[53, 26085], 64934=>[1580, 1581, 1609], 120200=>[99], 64418=>[1723], 
    65451=>[12603], 7603=>[642], 120717=>[981], 64935=>[1580, 1605, 1609], 13285=>[54, 26085], 120201=>[100], 64419=>[1723], 65452=>[12604], 7604=>[643], 120718=>[1009], 890=>[32, 837], 64936=>[1587, 1582, 1609], 13286=>[55, 26085], 120202=>[101], 64420=>[1728], 65453=>[12605], 
    7605=>[427], 120719=>[982], 64937=>[1589, 1581, 1610], 13287=>[56, 26085], 120203=>[102], 64421=>[1728], 65454=>[12606], 7606=>[649], 120720=>[913], 64938=>[1588, 1581, 1610], 13288=>[57, 26085], 120204=>[103], 64422=>[1729], 65455=>[12607], 7607=>[650], 120721=>[914], 
    64939=>[1590, 1581, 1610], 13289=>[49, 48, 26085], 120205=>[104], 64423=>[1729], 65456=>[12608], 7608=>[7452], 120722=>[915], 64940=>[1604, 1580, 1610], 8125=>[32, 787], 13290=>[49, 49, 26085], 120206=>[105], 64424=>[1729], 65457=>[12609], 7609=>[651], 120723=>[916], 64941=>[1604, 1605, 1610], 
    13291=>[49, 50, 26085], 120207=>[106], 64425=>[1729], 65458=>[12610], 7610=>[652], 120724=>[917], 64942=>[1610, 1581, 1610], 8127=>[32, 787], 13292=>[49, 51, 26085], 120208=>[107], 64426=>[1726], 65459=>[12611], 7611=>[122], 120725=>[918], 64943=>[1610, 1580, 1610], 8128=>[32, 834], 
    13293=>[49, 52, 26085], 120209=>[108], 64427=>[1726], 65460=>[12612], 7612=>[656], 8129=>[32, 776, 834], 120726=>[919], 64944=>[1610, 1605, 1610], 13294=>[49, 53, 26085], 120210=>[109], 1415=>[1381, 1410], 64428=>[1726], 65461=>[12613], 7613=>[657], 120727=>[920], 64945=>[1605, 1605, 1610], 
    13295=>[49, 54, 26085], 383=>[115], 120211=>[110], 64429=>[1726], 65462=>[12614], 7614=>[658], 120728=>[921], 900=>[32, 769], 64946=>[1602, 1605, 1610], 13296=>[49, 55, 26085], 120212=>[111], 64430=>[1746], 65463=>[12615], 7615=>[952], 901=>[32, 776, 769], 120729=>[922], 
    64947=>[1606, 1581, 1610], 13297=>[49, 56, 26085], 120213=>[112], 64431=>[1746], 65464=>[12616], 120730=>[923], 64948=>[1602, 1605, 1581], 13298=>[49, 57, 26085], 120214=>[113], 64432=>[1747], 65465=>[12617], 120731=>[924], 64949=>[1604, 1581, 1605], 13299=>[50, 48, 26085], 120215=>[114], 64433=>[1747], 
    65466=>[12618], 120732=>[925], 64950=>[1593, 1605, 1610], 13300=>[50, 49, 26085], 120216=>[115], 65467=>[12619], 120733=>[926], 64951=>[1603, 1605, 1610], 13301=>[50, 50, 26085], 120217=>[116], 65468=>[12620], 120734=>[927], 64952=>[1606, 1580, 1581], 13302=>[50, 51, 26085], 120218=>[117], 65469=>[12621], 
    120735=>[928], 64953=>[1605, 1582, 1610], 13303=>[50, 52, 26085], 120219=>[118], 65470=>[12622], 120736=>[929], 64954=>[1604, 1580, 1605], 13304=>[50, 53, 26085], 120220=>[119], 120737=>[1012], 64955=>[1603, 1605, 1605], 13305=>[50, 54, 26085], 120221=>[120], 8141=>[32, 787, 768], 120738=>[931], 64956=>[1604, 1580, 1605], 
    13306=>[50, 55, 26085], 120222=>[121], 8142=>[32, 787, 769], 120739=>[932], 64957=>[1606, 1580, 1581], 13307=>[50, 56, 26085], 120223=>[122], 65474=>[12623], 8143=>[32, 787, 834], 120740=>[933], 64958=>[1580, 1581, 1610], 13308=>[50, 57, 26085], 120224=>[65], 65475=>[12624], 120741=>[934], 64959=>[1581, 1580, 1610], 
    13309=>[51, 48, 26085], 120225=>[66], 65476=>[12625], 120742=>[935], 64960=>[1605, 1580, 1610], 13310=>[51, 49, 26085], 120226=>[67], 65477=>[12626], 120743=>[936], 64961=>[1601, 1605, 1610], 13311=>[103, 97, 108], 120227=>[68], 65478=>[12627], 120744=>[937], 64962=>[1576, 1581, 1610], 120228=>[69], 
    65479=>[12628], 120745=>[8711], 64963=>[1603, 1605, 1605], 120229=>[70], 120746=>[945], 64964=>[1593, 1580, 1605], 120230=>[71], 120747=>[946], 64965=>[1589, 1605, 1605], 120231=>[72], 65482=>[12629], 120748=>[947], 64966=>[1587, 1582, 1610], 120232=>[73], 65483=>[12630], 12800=>[40, 4352, 41], 
    120749=>[948], 64967=>[1606, 1580, 1610], 120233=>[74], 65484=>[12631], 12801=>[40, 4354, 41], 120750=>[949], 120234=>[75], 65485=>[12632], 12802=>[40, 4355, 41], 120751=>[950], 120235=>[76], 65486=>[12633], 12803=>[40, 4357, 41], 120752=>[951], 120236=>[77], 65487=>[12634], 
    12804=>[40, 4358, 41], 120753=>[952], 12288=>[32], 120237=>[78], 12805=>[40, 4359, 41], 8157=>[32, 788, 768], 120754=>[953], 120238=>[79], 12806=>[40, 4361, 41], 8158=>[32, 788, 769], 120755=>[954], 120239=>[80], 65490=>[12635], 12807=>[40, 4363, 41], 8159=>[32, 788, 834], 120756=>[955], 
    120240=>[81], 65491=>[12636], 12808=>[40, 4364, 41], 120757=>[956], 120241=>[82], 65492=>[12637], 12809=>[40, 4366, 41], 120758=>[957], 120242=>[83], 65493=>[12638], 12810=>[40, 4367, 41], 120759=>[958], 120243=>[84], 65494=>[12639], 12811=>[40, 4368, 41], 120760=>[959], 
    120244=>[85], 65495=>[12640], 12812=>[40, 4369, 41], 120761=>[960], 120245=>[86], 12813=>[40, 4370, 41], 120762=>[961], 120246=>[87], 12814=>[40, 4352, 4449, 41], 120763=>[962], 120247=>[88], 65498=>[12641], 12815=>[40, 4354, 4449, 41], 120764=>[963], 120248=>[89], 65499=>[12642], 
    12816=>[40, 4355, 4449, 41], 120765=>[964], 120249=>[90], 64467=>[1709], 65500=>[12643], 12817=>[40, 4357, 4449, 41], 120766=>[965], 120250=>[97], 64468=>[1709], 12818=>[40, 4358, 4449, 41], 120767=>[966], 120251=>[98], 64469=>[1709], 12819=>[40, 4359, 4449, 41], 120768=>[967], 120252=>[99], 
    64470=>[1709], 12820=>[40, 4361, 4449, 41], 120769=>[968], 120253=>[100], 64471=>[1735], 65504=>[162], 12821=>[40, 4363, 4449, 41], 8173=>[32, 776, 768], 120770=>[969], 120254=>[101], 64472=>[1735], 65505=>[163], 12822=>[40, 4364, 4449, 41], 8174=>[32, 776, 769], 120771=>[8706], 120255=>[102], 
    64473=>[1734], 65506=>[172], 12823=>[40, 4366, 4449, 41], 120772=>[1013], 120256=>[103], 64474=>[1734], 65507=>[175], 12824=>[40, 4367, 4449, 41], 120773=>[977], 127488=>[12411, 12363], 120257=>[104], 64475=>[1736], 65508=>[166], 12825=>[40, 4368, 4449, 41], 120774=>[1008], 127489=>[12467, 12467], 
    120258=>[105], 64476=>[1736], 65509=>[165], 12826=>[40, 4369, 4449, 41], 120775=>[981], 127490=>[12469], 120259=>[106], 64477=>[1655], 65510=>[8361], 12827=>[40, 4370, 4449, 41], 120776=>[1009], 120260=>[107], 64478=>[1739], 12828=>[40, 4364, 4462, 41], 120777=>[982], 120261=>[108], 
    64479=>[1739], 65512=>[9474], 12829=>[40, 4363, 4457, 4364, 4453, 4523, 41], 120778=>[988], 120262=>[109], 64480=>[1733], 65513=>[8592], 10764=>[8747, 8747, 8747, 8747], 12830=>[40, 4363, 4457, 4370, 4462, 41], 120779=>[989], 120263=>[110], 64481=>[1733], 65514=>[8593], 120264=>[111], 64482=>[1737], 65515=>[8594], 
    12832=>[40, 19968, 41], 120265=>[112], 64483=>[1737], 65516=>[8595], 12833=>[40, 20108, 41], 120782=>[48], 126464=>[1575], 120266=>[113], 64484=>[1744], 65517=>[9632], 12834=>[40, 19977, 41], 120783=>[49], 126465=>[1576], 120267=>[114], 64485=>[1744], 65518=>[9675], 
    12835=>[40, 22235, 41], 120784=>[50], 126466=>[1580], 120268=>[115], 64486=>[1744], 12836=>[40, 20116, 41], 120785=>[51], 126467=>[1583], 120269=>[116], 64487=>[1744], 12837=>[40, 20845, 41], 8189=>[32, 769], 120786=>[52], 120270=>[117], 64488=>[1609], 12838=>[40, 19971, 41], 
    120787=>[53], 8190=>[32, 788], 126469=>[1608], 120271=>[118], 64489=>[1609], 12839=>[40, 20843, 41], 120788=>[54], 126470=>[1586], 120272=>[119], 64490=>[1574, 1575], 12840=>[40, 20061, 41], 8192=>[32], 120789=>[55], 127504=>[25163], 126471=>[1581], 120273=>[120], 
    64491=>[1574, 1575], 12841=>[40, 21313, 41], 8193=>[32], 120790=>[56], 65008=>[1589, 1604, 1746], 127505=>[23383], 126472=>[1591], 120274=>[121], 64492=>[1574, 1749], 12842=>[40, 26376, 41], 120791=>[57], 65009=>[1602, 1604, 1746], 8194=>[32], 127506=>[21452], 126473=>[1610], 120275=>[122], 
    64493=>[1574, 1749], 12843=>[40, 28779, 41], 120792=>[48], 65010=>[1575, 1604, 1604, 1607], 8195=>[32], 127507=>[12487], 126474=>[1603], 120276=>[65], 64494=>[1574, 1608], 12844=>[40, 27700, 41], 120793=>[49], 65011=>[1575, 1603, 1576, 1585], 8196=>[32], 127508=>[20108], 126475=>[1604], 120277=>[66], 
    64495=>[1574, 1608], 12845=>[40, 26408, 41], 120794=>[50], 65012=>[1605, 1581, 1605, 1583], 8197=>[32], 127509=>[22810], 126476=>[1605], 120278=>[67], 64496=>[1574, 1735], 12846=>[40, 37329, 41], 120795=>[51], 65013=>[1589, 1604, 1593, 1605], 8198=>[32], 127510=>[35299], 126477=>[1606], 120279=>[68], 
    64497=>[1574, 1735], 12847=>[40, 22303, 41], 120796=>[52], 65014=>[1585, 1587, 1608, 1604], 8199=>[32], 127511=>[22825], 126478=>[1587], 452=>[68, 381], 120280=>[69], 64498=>[1574, 1734], 12848=>[40, 26085, 41], 120797=>[53], 65015=>[1593, 1604, 1610, 1607], 8200=>[32], 127512=>[20132], 126479=>[1593], 
    453=>[68, 382], 120281=>[70], 64499=>[1574, 1734], 12849=>[40, 26666, 41], 120798=>[54], 65016=>[1608, 1587, 1604, 1605], 8201=>[32], 127513=>[26144], 126480=>[1601], 454=>[100, 382], 120282=>[71], 64500=>[1574, 1736], 12850=>[40, 26377, 41], 120799=>[55], 65017=>[1589, 1604, 1609], 8202=>[32], 
    127514=>[28961], 126481=>[1589], 455=>[76, 74], 120283=>[72], 64501=>[1574, 1736], 12851=>[40, 31038, 41], 120800=>[56], 65018=>[1589, 1604, 1609, 32, 1575, 1604, 1604, 1607, 32, 1593, 1604, 1610, 1607, 32, 1608, 1587, 1604, 1605], 127515=>[26009], 126482=>[1602], 456=>[76, 106], 120284=>[73], 64502=>[1574, 1744], 12852=>[40, 21517, 41], 120801=>[57], 65019=>[1580, 1604, 32, 1580, 1604, 1575, 1604, 1607], 
    127516=>[21069], 126483=>[1585], 457=>[108, 106], 120285=>[74], 64503=>[1574, 1744], 12853=>[40, 29305, 41], 120802=>[48], 65020=>[1585, 1740, 1575, 1604], 127517=>[24460], 126484=>[1588], 458=>[78, 74], 120286=>[75], 64504=>[1574, 1744], 12854=>[40, 36001, 41], 120803=>[49], 127518=>[20877], 
    126485=>[1578], 459=>[78, 106], 120287=>[76], 64505=>[1574, 1609], 12855=>[40, 31069, 41], 120804=>[50], 976=>[946], 127519=>[26032], 126486=>[1579], 460=>[110, 106], 120288=>[77], 64506=>[1574, 1609], 12856=>[40, 21172, 41], 120805=>[51], 977=>[952], 127520=>[21021], 
    126487=>[1582], 120289=>[78], 64507=>[1574, 1609], 12857=>[40, 20195, 41], 120806=>[52], 978=>[933], 8209=>[8208], 127521=>[32066], 126488=>[1584], 120290=>[79], 64508=>[1740], 12858=>[40, 21628, 41], 979=>[933, 769], 120807=>[53], 12342=>[12306], 127522=>[29983], 
    126489=>[1590], 120291=>[80], 64509=>[1740], 12859=>[40, 23398, 41], 980=>[933, 776], 120808=>[54], 127523=>[36009], 126490=>[1592], 120292=>[81], 64510=>[1740], 12860=>[40, 30435, 41], 120809=>[55], 981=>[966], 12344=>[21313], 127524=>[22768], 126491=>[1594], 
    120293=>[82], 64511=>[1740], 12861=>[40, 20225, 41], 120810=>[56], 982=>[960], 12345=>[21316], 127525=>[21561], 126492=>[1646], 120294=>[83], 64512=>[1574, 1580], 12862=>[40, 36039, 41], 120811=>[57], 12346=>[21317], 127526=>[28436], 126493=>[1722], 120295=>[84], 
    64513=>[1574, 1581], 12863=>[40, 21332, 41], 120812=>[48], 8215=>[32, 819], 127527=>[25237], 126494=>[1697], 120296=>[85], 64514=>[1574, 1605], 12864=>[40, 31085, 41], 120813=>[49], 127528=>[25429], 126495=>[1647], 120297=>[86], 64515=>[1574, 1609], 12865=>[40, 20241, 41], 120814=>[50], 
    127529=>[19968], 120298=>[87], 64516=>[1574, 1610], 12866=>[40, 33258, 41], 120815=>[51], 127530=>[19977], 126497=>[1576], 120299=>[88], 64517=>[1576, 1580], 12867=>[40, 33267, 41], 120816=>[52], 127531=>[36938], 126498=>[1580], 120300=>[89], 64518=>[1576, 1581], 12868=>[21839], 
    120817=>[53], 127532=>[24038], 120301=>[90], 64519=>[1576, 1582], 12869=>[24188], 120818=>[54], 127533=>[20013], 126500=>[1607], 120302=>[97], 64520=>[1576, 1605], 12870=>[25991], 120819=>[55], 127534=>[21491], 120303=>[98], 64521=>[1576, 1609], 12871=>[31631], 
    120820=>[56], 127535=>[25351], 120304=>[99], 64522=>[1576, 1610], 120821=>[57], 127536=>[36208], 126503=>[1581], 120305=>[100], 64523=>[1578, 1580], 120822=>[48], 65040=>[44], 127537=>[25171], 120306=>[101], 64524=>[1578, 1581], 120823=>[49], 65041=>[12289], 
    127538=>[31105], 126505=>[1610], 120307=>[102], 64525=>[1578, 1582], 120824=>[50], 65042=>[12290], 127539=>[31354], 126506=>[1603], 120308=>[103], 64526=>[1578, 1605], 120825=>[51], 65043=>[58], 8228=>[46], 127540=>[21512], 126507=>[1604], 120309=>[104], 
    64527=>[1578, 1609], 120826=>[52], 65044=>[59], 8229=>[46, 46], 127541=>[28288], 126508=>[1605], 120310=>[105], 64528=>[1578, 1610], 120827=>[53], 65045=>[33], 8230=>[46, 46, 46], 127542=>[26377], 126509=>[1606], 120311=>[106], 64529=>[1579, 1580], 120828=>[54], 
    65046=>[63], 127543=>[26376], 126510=>[1587], 120312=>[107], 64530=>[1579, 1605], 8748=>[8747, 8747], 12880=>[80, 84, 69], 120829=>[55], 65047=>[12310], 127544=>[30003], 126511=>[1593], 120313=>[108], 64531=>[1579, 1609], 8749=>[8747, 8747, 8747], 12881=>[50, 49], 120830=>[56], 
    65048=>[12311], 127545=>[21106], 126512=>[1601], 120314=>[109], 64532=>[1579, 1610], 12882=>[50, 50], 120831=>[57], 65049=>[8230], 127546=>[21942], 126513=>[1589], 120315=>[110], 64533=>[1580, 1581], 8751=>[8750, 8750], 12883=>[50, 51], 126514=>[1602], 120316=>[111], 
    64534=>[1580, 1605], 8752=>[8750, 8750, 8750], 12884=>[50, 52], 120317=>[112], 64535=>[1581, 1580], 12885=>[50, 53], 126516=>[1588], 120318=>[113], 64536=>[1581, 1605], 12886=>[50, 54], 126517=>[1578], 120319=>[114], 64537=>[1582, 1580], 12887=>[50, 55], 1008=>[954], 8239=>[32], 
    126518=>[1579], 120320=>[115], 64538=>[1582, 1581], 12888=>[50, 56], 1009=>[961], 127552=>[12308, 26412, 12309], 126519=>[1582], 120321=>[116], 64539=>[1582, 1605], 12889=>[50, 57], 1010=>[962], 127553=>[12308, 19977, 12309], 120322=>[117], 64540=>[1587, 1580], 12890=>[51, 48], 127554=>[12308, 20108, 12309], 
    126521=>[1590], 120323=>[118], 64541=>[1587, 1581], 12891=>[51, 49], 1012=>[920], 8243=>[8242, 8242], 127555=>[12308, 23433, 12309], 120324=>[119], 64542=>[1587, 1582], 12892=>[51, 50], 119808=>[65], 1013=>[949], 8244=>[8242, 8242, 8242], 127556=>[12308, 28857, 12309], 126523=>[1594], 497=>[68, 90], 
    120325=>[120], 64543=>[1587, 1605], 12893=>[51, 51], 119809=>[66], 127557=>[12308, 25171, 12309], 498=>[68, 122], 120326=>[121], 64544=>[1589, 1581], 12894=>[51, 52], 119810=>[67], 8246=>[8245, 8245], 127558=>[12308, 30423, 12309], 499=>[100, 122], 120327=>[122], 64545=>[1589, 1605], 12895=>[51, 53], 
    119811=>[68], 8247=>[8245, 8245, 8245], 127559=>[12308, 21213, 12309], 120328=>[65], 64546=>[1590, 1580], 12896=>[4352], 119812=>[69], 1017=>[931], 127560=>[12308, 25943, 12309], 120329=>[66], 64547=>[1590, 1581], 12897=>[4354], 119813=>[70], 120330=>[67], 64548=>[1590, 1582], 12898=>[4355], 
    119814=>[71], 120331=>[68], 64549=>[1590, 1605], 12899=>[4357], 119815=>[72], 126530=>[1580], 120332=>[69], 64550=>[1591, 1581], 12900=>[4358], 119816=>[73], 8252=>[33, 33], 120333=>[70], 64551=>[1591, 1605], 12901=>[4359], 119817=>[74], 120334=>[71], 
    64552=>[1592, 1605], 12902=>[4361], 119818=>[75], 8254=>[32, 773], 120335=>[72], 64553=>[1593, 1580], 12903=>[4363], 119819=>[76], 120336=>[73], 64554=>[1593, 1605], 12904=>[4364], 119820=>[77], 127568=>[24471], 126535=>[1581], 120337=>[74], 64555=>[1594, 1580], 
    12905=>[4366], 119821=>[78], 65072=>[8229], 127569=>[21487], 120338=>[75], 64556=>[1594, 1605], 12906=>[4367], 119822=>[79], 65073=>[8212], 126537=>[1610], 120339=>[76], 64557=>[1601, 1580], 12907=>[4368], 42864=>[42863], 119823=>[80], 65074=>[8211], 
    120340=>[77], 64558=>[1601, 1581], 12908=>[4369], 119824=>[81], 65075=>[95], 126539=>[1604], 120341=>[78], 64559=>[1601, 1582], 12909=>[4370], 119825=>[82], 65076=>[95], 120342=>[79], 64560=>[1601, 1605], 12910=>[4352, 4449], 119826=>[83], 65077=>[40], 
    126541=>[1606], 120343=>[80], 64561=>[1601, 1609], 12911=>[4354, 4449], 119827=>[84], 65078=>[41], 8263=>[63, 63], 
  }

  COMPOSITION_TABLE = {
    [101, 785]=>519, [1099, 776]=>1273, [7949, 837]=>8077, [105, 777]=>7881, [109, 769]=>7743, [110, 775]=>7749, [7865, 770]=>7879, [8819, 824]=>8821, [8839, 824]=>8841, [117, 816]=>7797, [105, 776]=>239, [107, 780]=>489, [12381, 12441]=>12382, [111, 772]=>333, [7950, 837]=>8078, [12527, 12441]=>12535, 
    [114, 769]=>341, [117, 783]=>533, [100, 813]=>7699, [7864, 770]=>7878, [12454, 12441]=>12532, [919, 837]=>8140, [949, 769]=>941, [116, 780]=>357, [115, 770]=>349, [119, 778]=>7832, [949, 768]=>8050, [2887, 2903]=>2892, [959, 788]=>8001, [7951, 837]=>8079, [115, 769]=>347, [97, 805]=>7681, 
    [98, 803]=>7685, [101, 813]=>7705, [107, 817]=>7733, [112, 775]=>7767, [2887, 2902]=>2888, [119, 776]=>7813, [230, 769]=>509, [226, 777]=>7849, [12379, 12441]=>12380, [3015, 3006]=>3019, [117, 780]=>468, [274, 769]=>7702, [953, 774]=>8144, [99, 807]=>231, [228, 772]=>479, [1110, 776]=>1111, 
    [117, 779]=>369, [104, 817]=>7830, [97, 803]=>7841, [112, 769]=>7765, [115, 775]=>7777, [274, 768]=>7700, [8834, 824]=>8836, [231, 769]=>7689, [3014, 3006]=>3018, [117, 778]=>367, [116, 776]=>7831, [275, 769]=>7703, [953, 772]=>8145, [945, 788]=>7937, [117, 777]=>7911, [114, 775]=>7769, 
    [275, 768]=>7701, [945, 787]=>7936, [117, 776]=>252, [8835, 824]=>8837, [12377, 12441]=>12378, [101, 808]=>281, [105, 816]=>7725, [230, 772]=>483, [7984, 769]=>7988, [101, 807]=>553, [110, 817]=>7753, [953, 769]=>943, [229, 769]=>507, [69787, 69818]=>69788, [7984, 768]=>7986, [119, 770]=>373, 
    [117, 774]=>365, [953, 768]=>8054, [119, 769]=>7811, [118, 771]=>7805, [116, 775]=>7787, [7985, 769]=>7989, [347, 775]=>7781, [100, 807]=>7697, [951, 787]=>7968, [119, 768]=>7809, [7985, 768]=>7987, [12375, 12441]=>12376, [117, 772]=>363, [234, 769]=>7871, [8025, 834]=>8031, [346, 775]=>7780, 
    [117, 771]=>361, [119, 775]=>7815, [103, 807]=>291, [101, 803]=>7865, [108, 817]=>7739, [234, 768]=>7873, [959, 769]=>972, [117, 770]=>251, [69785, 69818]=>69786, [114, 780]=>345, [234, 771]=>7877, [959, 768]=>8056, [949, 788]=>7953, [117, 769]=>250, [114, 783]=>529, [100, 803]=>7693, 
    [949, 787]=>7952, [117, 768]=>249, [12373, 12441]=>12374, [115, 780]=>353, [97, 808]=>261, [122, 769]=>378, [121, 775]=>7823, [114, 785]=>531, [98, 817]=>7687, [107, 803]=>7731, [108, 813]=>7741, [951, 788]=>7969, [953, 776]=>970, [1046, 776]=>1244, [120, 775]=>7819, [104, 807]=>7721, 
    [1043, 769]=>1027, [12479, 12441]=>12480, [111, 808]=>491, [12371, 12441]=>12372, [122, 770]=>7825, [121, 772]=>563, [234, 777]=>7875, [1040, 774]=>1232, [1047, 776]=>1246, [121, 771]=>7929, [105, 803]=>7883, [107, 807]=>311, [117, 795]=>432, [110, 813]=>7755, [121, 770]=>375, [239, 769]=>7727, 
    [969, 788]=>8033, [121, 769]=>253, [353, 775]=>7783, [122, 775]=>380, [104, 803]=>7717, [12477, 12441]=>12478, [969, 787]=>8032, [658, 780]=>495, [12369, 12441]=>12370, [121, 768]=>7923, [1045, 776]=>1025, [69937, 69927]=>69934, [352, 775]=>7782, [111, 803]=>7885, [3398, 3415]=>3404, [7992, 769]=>7996, 
    [8804, 824]=>8816, [7992, 768]=>7994, [965, 776]=>971, [1045, 774]=>1238, [12399, 12442]=>12401, [108, 807]=>316, [110, 803]=>7751, [7993, 769]=>7997, [12475, 12441]=>12476, [8805, 824]=>8817, [12399, 12441]=>12400, [104, 814]=>7723, [7993, 768]=>7995, [965, 774]=>8160, [100, 817]=>7695, [109, 803]=>7747, 
    [550, 772]=>480, [168, 769]=>901, [121, 778]=>7833, [120, 776]=>7821, [122, 780]=>382, [965, 772]=>8161, [1040, 776]=>1234, [168, 768]=>8173, [69938, 69927]=>69935, [3263, 3285]=>3264, [121, 777]=>7927, [110, 807]=>326, [117, 785]=>535, [108, 803]=>7735, [551, 772]=>481, [12473, 12441]=>12474, 
    [121, 776]=>255, [105, 808]=>303, [101, 816]=>7707, [244, 777]=>7893, [1045, 768]=>1024, [1046, 774]=>1217, [553, 774]=>7709, [1050, 769]=>1036, [965, 769]=>973, [8884, 824]=>8940, [965, 768]=>8058, [1048, 772]=>1250, [1054, 776]=>1254, [552, 774]=>7708, [245, 776]=>7759, [12471, 12441]=>12472, 
    [970, 769]=>912, [8801, 824]=>8802, [8885, 824]=>8941, [7770, 772]=>7772, [970, 768]=>8146, [1048, 774]=>1049, [1575, 1619]=>1570, [8032, 837]=>8096, [12541, 12441]=>12542, [971, 769]=>944, [8882, 824]=>8938, [12392, 12441]=>12393, [7771, 772]=>7773, [1048, 768]=>1037, [961, 788]=>8165, [971, 768]=>8162, 
    [7885, 770]=>7897, [245, 772]=>557, [8033, 837]=>8097, [961, 787]=>8164, [12469, 12441]=>12470, [8883, 824]=>8939, [244, 769]=>7889, [7884, 770]=>7896, [244, 768]=>7891, [246, 772]=>555, [8034, 837]=>8098, [8000, 769]=>8004, [8741, 824]=>8742, [969, 769]=>974, [12390, 12441]=>12391, [244, 771]=>7895, 
    [245, 769]=>7757, [8000, 768]=>8002, [8033, 834]=>8039, [969, 768]=>8060, [1575, 1621]=>1573, [8190, 769]=>8158, [360, 769]=>7800, [8035, 837]=>8099, [8001, 769]=>8005, [1575, 1620]=>1571, [12467, 12441]=>12468, [8190, 768]=>8157, [8001, 768]=>8003, [8032, 834]=>8038, [361, 769]=>7801, [3014, 3031]=>3020, 
    [558, 772]=>560, [252, 780]=>474, [8036, 837]=>8100, [8739, 824]=>8740, [12388, 12441]=>12389, [69, 783]=>516, [84, 813]=>7792, [1048, 776]=>1252, [90, 817]=>7828, [65, 775]=>550, [79, 795]=>416, [83, 803]=>7778, [965, 788]=>8017, [559, 772]=>561, [8037, 837]=>8101, [65, 774]=>258, 
    [67, 770]=>264, [68, 780]=>270, [12465, 12441]=>12466, [965, 787]=>8016, [248, 769]=>511, [362, 776]=>7802, [85, 813]=>7798, [67, 769]=>262, [82, 803]=>7770, [8038, 837]=>8102, [65, 772]=>256, [69, 780]=>282, [363, 776]=>7803, [83, 807]=>350, [67, 775]=>266, [65, 771]=>195, 
    [7968, 837]=>8080, [7779, 775]=>7785, [937, 837]=>8188, [8039, 837]=>8103, [83, 806]=>536, [65, 770]=>194, [978, 769]=>979, [82, 807]=>342, [73, 785]=>522, [69, 777]=>7866, [66, 775]=>7682, [65, 769]=>193, [7969, 837]=>8081, [1063, 776]=>1268, [7778, 775]=>7784, [252, 772]=>470, 
    [8040, 837]=>8104, [85, 808]=>370, [65, 768]=>192, [69, 776]=>203, [71, 780]=>486, [1059, 774]=>1038, [65, 783]=>512, [69, 775]=>278, [87, 803]=>7816, [7970, 837]=>8082, [7936, 769]=>7940, [8041, 837]=>8105, [12530, 12441]=>12538, [1729, 1620]=>1730, [71, 770]=>284, [69, 774]=>276, 
    [7936, 768]=>7938, [7969, 834]=>7975, [2962, 3031]=>2964, [252, 769]=>472, [8875, 824]=>8879, [12385, 12441]=>12386, [86, 803]=>7806, [71, 769]=>500, [84, 807]=>354, [79, 785]=>526, [68, 775]=>7690, [7971, 837]=>8083, [7937, 769]=>7941, [1059, 772]=>1262, [252, 768]=>476, [8042, 837]=>8106, 
    [8008, 769]=>8012, [940, 837]=>8116, [85, 804]=>7794, [84, 806]=>538, [69, 772]=>274, [65, 780]=>461, [7937, 768]=>7939, [7968, 834]=>7974, [1059, 779]=>1266, [8041, 834]=>8047, [8008, 768]=>8010, [2503, 2494]=>2507, [8127, 769]=>8142, [8872, 824]=>8877, [85, 803]=>7908, [71, 775]=>288, 
    [69, 771]=>7868, [7972, 837]=>8084, [8043, 837]=>8107, [8009, 769]=>8013, [12528, 12441]=>12536, [8127, 768]=>8141, [71, 774]=>286, [65, 778]=>197, [69, 770]=>202, [8040, 834]=>8046, [1240, 776]=>1242, [8009, 768]=>8011, [8873, 824]=>8878, [84, 803]=>7788, [65, 777]=>7842, [70, 775]=>7710, 
    [69, 769]=>201, [7973, 837]=>8085, [978, 776]=>980, [1059, 776]=>1264, [8044, 837]=>8108, [12529, 12441]=>12537, [942, 837]=>8132, [67, 780]=>268, [71, 772]=>7712, [65, 776]=>196, [69, 768]=>200, [1241, 776]=>1243, [79, 779]=>336, [73, 775]=>304, [82, 817]=>7774, [7974, 837]=>8086, 
    [8045, 837]=>8109, [76, 780]=>317, [73, 774]=>300, [1608, 1620]=>1572, [79, 777]=>7886, [90, 803]=>7826, [72, 775]=>7714, [75, 769]=>7728, [7975, 837]=>8087, [8046, 837]=>8110, [73, 772]=>298, [74, 770]=>308, [79, 776]=>214, [913, 774]=>8120, [89, 803]=>7924, [79, 783]=>524, 
    [73, 771]=>296, [7976, 837]=>8088, [3274, 3285]=>3275, [2352, 2364]=>2353, [8047, 837]=>8111, [12411, 12442]=>12413, [945, 837]=>8115, [417, 771]=>7905, [416, 769]=>7898, [78, 780]=>327, [73, 770]=>206, [1141, 783]=>1143, [12411, 12441]=>12412, [913, 772]=>8121, [921, 788]=>7993, [1610, 1620]=>1574, 
    [65, 785]=>514, [7977, 837]=>8089, [416, 768]=>7900, [73, 769]=>205, [8048, 837]=>8114, [921, 787]=>7992, [432, 803]=>7921, [416, 771]=>7904, [417, 769]=>7899, [72, 770]=>292, [73, 768]=>204, [79, 780]=>465, [1140, 783]=>1142, [8866, 824]=>8876, [12408, 12441]=>12409, [945, 834]=>8118, 
    [73, 783]=>520, [7978, 837]=>8090, [7944, 769]=>7948, [417, 768]=>7901, [78, 769]=>323, [77, 775]=>7744, [79, 771]=>213, [490, 772]=>492, [913, 769]=>902, [78, 768]=>504, [7944, 768]=>7946, [7977, 834]=>7983, [72, 780]=>542, [79, 770]=>212, [913, 768]=>8122, [7979, 837]=>8091, 
    [7945, 769]=>7949, [1069, 776]=>1260, [78, 771]=>209, [79, 769]=>211, [491, 772]=>493, [2355, 2364]=>2356, [8016, 769]=>8020, [12408, 12442]=>12410, [927, 787]=>8008, [194, 769]=>7844, [7945, 768]=>7947, [7976, 834]=>7982, [3270, 3266]=>3274, [73, 780]=>463, [79, 768]=>210, [8016, 768]=>8018, 
    [951, 834]=>8134, [4133, 4142]=>4134, [84, 817]=>7790, [194, 768]=>7846, [7980, 837]=>8092, [79, 775]=>558, [76, 769]=>313, [8017, 769]=>8021, [919, 769]=>905, [194, 771]=>7850, [3545, 3551]=>3550, [416, 777]=>7902, [79, 774]=>334, [72, 776]=>7718, [8017, 768]=>8019, [919, 768]=>8138, 
    [6929, 6965]=>6930, [69, 785]=>518, [1067, 776]=>1272, [7981, 837]=>8093, [73, 777]=>7880, [77, 769]=>7742, [78, 775]=>7748, [8052, 837]=>8130, [12495, 12442]=>12497, [85, 816]=>7796, [75, 780]=>488, [417, 777]=>7903, [79, 772]=>332, [73, 776]=>207, [12495, 12441]=>12496, [7982, 837]=>8094, 
    [82, 769]=>340, [85, 783]=>532, [68, 813]=>7698, [12405, 12442]=>12407, [951, 837]=>8131, [917, 769]=>904, [84, 780]=>356, [83, 770]=>348, [12405, 12441]=>12406, [917, 768]=>8136, [927, 788]=>8009, [7983, 837]=>8095, [83, 769]=>346, [65, 805]=>7680, [66, 803]=>7684, [69, 813]=>7704, 
    [75, 817]=>7732, [80, 775]=>7766, [87, 776]=>7812, [198, 769]=>508, [194, 777]=>7848, [431, 777]=>7916, [85, 780]=>467, [12402, 12441]=>12403, [921, 774]=>8152, [196, 772]=>478, [1078, 776]=>1245, [85, 779]=>368, [65, 803]=>7840, [67, 807]=>199, [80, 769]=>7764, [83, 775]=>7776, 
    [383, 775]=>7835, [2344, 2364]=>2345, [199, 769]=>7688, [1075, 769]=>1107, [85, 778]=>366, [921, 772]=>8153, [913, 788]=>7945, [1072, 774]=>1233, [1079, 776]=>1247, [85, 777]=>7910, [82, 775]=>7768, [12402, 12442]=>12404, [913, 787]=>7944, [69, 808]=>280, [73, 816]=>7724, [85, 776]=>220, 
    [953, 834]=>8150, [198, 772]=>482, [7952, 769]=>7956, [69, 807]=>552, [78, 817]=>7752, [921, 769]=>906, [197, 769]=>506, [7952, 768]=>7954, [7985, 834]=>7991, [431, 771]=>7918, [87, 770]=>372, [85, 774]=>364, [921, 768]=>8154, [87, 769]=>7810, [86, 771]=>7804, [12488, 12441]=>12489, 
    [84, 775]=>7786, [1077, 776]=>1105, [68, 807]=>7696, [7841, 774]=>7863, [7953, 769]=>7957, [1746, 1620]=>1747, [919, 787]=>7976, [8781, 824]=>8813, [87, 768]=>7808, [431, 769]=>7912, [85, 772]=>362, [202, 769]=>7870, [7953, 768]=>7955, [7984, 834]=>7990, [87, 775]=>7814, [3548, 3530]=>3549, 
    [1077, 774]=>1239, [3270, 3285]=>3271, [431, 768]=>7914, [85, 771]=>360, [71, 807]=>290, [69, 803]=>7864, [76, 817]=>7738, [7840, 774]=>7862, [202, 768]=>7872, [927, 769]=>908, [8025, 769]=>8029, [3545, 3535]=>3548, [82, 780]=>344, [85, 770]=>219, [202, 771]=>7876, [927, 768]=>8184, 
    [917, 788]=>7961, [1256, 776]=>1258, [6921, 6965]=>6922, [8025, 768]=>8027, [12486, 12441]=>12487, [82, 783]=>528, [68, 803]=>7692, [85, 769]=>218, [7841, 770]=>7853, [917, 787]=>7960, [8060, 837]=>8178, [3270, 3286]=>3272, [83, 780]=>352, [65, 808]=>260, [85, 768]=>217, [1257, 776]=>1259, 
    [1072, 776]=>1235, [90, 769]=>377, [89, 775]=>7822, [82, 785]=>530, [66, 817]=>7686, [75, 803]=>7730, [76, 813]=>7740, [7840, 770]=>7852, [1749, 1620]=>1728, [8776, 824]=>8777, [921, 776]=>938, [919, 788]=>7977, [6923, 6965]=>6924, [12484, 12441]=>12485, [3545, 3530]=>3546, [965, 834]=>8166, 
    [1077, 768]=>1104, [1078, 774]=>1218, [6978, 6965]=>6979, [88, 775]=>7818, [72, 807]=>7720, [2503, 2519]=>2508, [79, 808]=>490, [1082, 769]=>1116, [90, 770]=>7824, [89, 772]=>562, [202, 777]=>7874, [1080, 772]=>1251, [1086, 776]=>1255, [89, 771]=>7928, [73, 803]=>7882, [75, 807]=>310, 
    [85, 795]=>431, [78, 813]=>7754, [432, 769]=>7913, [417, 803]=>7907, [89, 770]=>374, [207, 769]=>7726, [937, 788]=>8041, [6925, 6965]=>6926, [971, 834]=>8167, [1080, 774]=>1081, [432, 768]=>7915, [90, 775]=>379, [72, 803]=>7716, [89, 769]=>221, [937, 787]=>8040, [12445, 12441]=>12446, 
    [969, 837]=>8179, [432, 771]=>7919, [416, 803]=>7906, [89, 768]=>7922, [439, 780]=>494, [970, 834]=>8151, [1080, 768]=>1117, [79, 803]=>7884, [7960, 769]=>7964, [7960, 768]=>7962, [7993, 834]=>7999, [933, 776]=>939, [969, 834]=>8182, [76, 807]=>315, [78, 803]=>7750, [7961, 769]=>7965, 
    [8032, 769]=>8036, [8773, 824]=>8775, [2887, 2878]=>2891, [7734, 772]=>7736, [12367, 12441]=>12368, [72, 814]=>7722, [7961, 768]=>7963, [7992, 834]=>7998, [933, 774]=>8168, [8032, 768]=>8034, [12481, 12441]=>12482, [68, 817]=>7694, [77, 803]=>7746, [8715, 824]=>8716, [3142, 3158]=>3144, [8033, 769]=>8037, 
    [7735, 772]=>7737, [432, 777]=>7917, [90, 780]=>381, [88, 776]=>7820, [933, 772]=>8169, [8033, 768]=>8035, [8182, 837]=>8183, [89, 777]=>7926, [78, 807]=>325, [85, 785]=>534, [76, 803]=>7734, [8712, 824]=>8713, [8771, 824]=>8772, [12365, 12441]=>12366, [89, 776]=>376, [73, 808]=>302, 
    [69, 816]=>7706, [212, 777]=>7892, [168, 834]=>8129, [101, 783]=>517, [116, 813]=>7793, [1080, 776]=>1253, [122, 817]=>7829, [97, 775]=>551, [111, 795]=>417, [115, 803]=>7779, [933, 769]=>910, [97, 774]=>259, [99, 770]=>265, [100, 780]=>271, [974, 837]=>8180, [933, 768]=>8170, 
    [117, 813]=>7799, [99, 769]=>263, [114, 803]=>7771, [213, 776]=>7758, [97, 772]=>257, [12363, 12441]=>12364, [101, 780]=>283, [258, 769]=>7854, [259, 771]=>7861, [7936, 837]=>8064, [115, 807]=>351, [99, 775]=>267, [97, 771]=>227, [258, 768]=>7856, [8850, 824]=>8931, [115, 806]=>537, 
    [97, 770]=>226, [259, 769]=>7855, [258, 771]=>7860, [929, 788]=>8172, [6917, 6965]=>6918, [7937, 837]=>8065, [1095, 776]=>1269, [114, 807]=>343, [105, 785]=>523, [101, 777]=>7867, [98, 775]=>7683, [97, 769]=>225, [213, 772]=>556, [259, 768]=>7857, [101, 776]=>235, [117, 808]=>371, 
    [97, 768]=>224, [103, 780]=>487, [212, 769]=>7888, [12507, 12442]=>12509, [69797, 69818]=>69803, [97, 783]=>513, [7938, 837]=>8066, [101, 775]=>279, [119, 803]=>7817, [212, 768]=>7890, [214, 772]=>554, [7968, 769]=>7972, [8660, 824]=>8654, [12507, 12441]=>12508, [1091, 774]=>1118, [937, 769]=>911, 
    [8828, 824]=>8928, [12358, 12441]=>12436, [431, 803]=>7920, [101, 774]=>277, [103, 770]=>285, [212, 771]=>7894, [213, 769]=>7756, [7937, 834]=>7943, [7968, 768]=>7970, [937, 768]=>8186, [6919, 6965]=>6920, [118, 803]=>7807, [7939, 837]=>8067, [103, 769]=>501, [116, 807]=>355, [111, 785]=>527, 
    [100, 775]=>7691, [7969, 769]=>7973, [12504, 12441]=>12505, [1091, 772]=>1263, [8040, 769]=>8044, [8829, 824]=>8929, [117, 804]=>7795, [116, 806]=>539, [101, 772]=>275, [97, 780]=>462, [7936, 834]=>7942, [7969, 768]=>7971, [8118, 837]=>8119, [1091, 779]=>1267, [8849, 824]=>8930, [8040, 768]=>8042, 
    [258, 777]=>7858, [7940, 837]=>8068, [117, 803]=>7909, [103, 775]=>289, [101, 771]=>7869, [220, 780]=>473, [8658, 824]=>8655, [8707, 824]=>8708, [8826, 824]=>8832, [8041, 769]=>8045, [8190, 834]=>8159, [101, 770]=>234, [97, 778]=>229, [103, 774]=>287, [12504, 12442]=>12506, [8041, 768]=>8043, 
    [259, 777]=>7859, [933, 788]=>8025, [7941, 837]=>8069, [116, 803]=>7789, [101, 769]=>233, [97, 777]=>7843, [102, 775]=>7711, [1091, 776]=>1265, [8827, 824]=>8833, [62, 824]=>8815, [216, 769]=>510, [101, 768]=>232, [97, 776]=>228, [99, 780]=>269, [103, 772]=>7713, [3399, 3390]=>3403, 
    [6970, 6965]=>6971, [7942, 837]=>8070, [111, 779]=>337, [114, 817]=>7775, [8656, 824]=>8653, [108, 780]=>318, [105, 774]=>301, [3398, 3390]=>3402, [1030, 776]=>1031, [7943, 837]=>8071, [111, 777]=>7887, [122, 803]=>7827, [104, 775]=>7715, [107, 769]=>7729, [332, 769]=>7762, [60, 824]=>8814, 
    [12463, 12441]=>12464, [12501, 12442]=>12503, [111, 776]=>246, [105, 772]=>299, [106, 770]=>309, [332, 768]=>7760, [6972, 6965]=>6973, [945, 774]=>8112, [12501, 12441]=>12502, [7944, 837]=>8072, [121, 803]=>7925, [111, 783]=>525, [105, 771]=>297, [220, 772]=>469, [333, 769]=>7763, [8822, 824]=>8824, 
    [61, 824]=>8800, [913, 837]=>8124, [105, 770]=>238, [110, 780]=>328, [333, 768]=>7761, [8596, 824]=>8622, [945, 772]=>8113, [953, 788]=>7985, [7945, 837]=>8073, [12498, 12441]=>12499, [97, 785]=>515, [105, 769]=>237, [8764, 824]=>8769, [8823, 824]=>8825, [12461, 12441]=>12462, [953, 787]=>7984, 
    [105, 768]=>236, [220, 769]=>471, [104, 770]=>293, [111, 780]=>466, [6974, 6965]=>6976, [7946, 837]=>8074, [111, 771]=>245, [220, 768]=>475, [7976, 769]=>7980, [8127, 834]=>8143, [110, 769]=>324, [105, 783]=>521, [109, 775]=>7745, [945, 769]=>940, [12498, 12442]=>12500, [110, 768]=>505, 
    [111, 770]=>244, [7945, 834]=>7951, [7976, 768]=>7978, [104, 780]=>543, [945, 768]=>8048, [8594, 824]=>8603, [6975, 6965]=>6977, [111, 769]=>243, [110, 771]=>241, [7947, 837]=>8075, [7977, 769]=>7981, [1101, 776]=>1261, [12459, 12441]=>12460, [959, 787]=>8000, [111, 768]=>242, [226, 769]=>7845, 
    [7944, 834]=>7950, [7977, 768]=>7979, [12383, 12441]=>12384, [105, 780]=>464, [8017, 834]=>8023, [116, 817]=>7791, [226, 768]=>7847, [7948, 837]=>8076, [111, 775]=>559, [108, 769]=>314, [8818, 824]=>8820, [951, 769]=>942, [8838, 824]=>8840, [106, 780]=>496, [226, 771]=>7851, [111, 774]=>335, 
    [104, 776]=>7719, [951, 768]=>8052, [8016, 834]=>8022, [8134, 837]=>8135, [8592, 824]=>8602, 
  }

end