from collections import defaultdict

import logging
l = logging.getLogger("rex.exploit.techniques")

import archinfo

from ..shellcode import Shellcode

from .allarch_jmpsp import X86JmpSP, AMD64JmpSP, ARMJmpSP, MIPS32JmpSP
from .linux_x86_binsh import LinuxX86Binsh
from .linux_amd64_binsh import LinuxAMD64Binsh
from .linux_arm_binsh import LinuxARMBinsh
from .linux_arm_dupsh import LinuxARMDupsh
from .linux_x86_connectback import LinuxX86Connectback
from .linux_amd64_connectback import LinuxAMD64Connectback
from .linux_mips32_connectback import LinuxMIPS32Connectback
from .linux_x86_dupsh import LinuxX86Dupsh
from .linux_amd64_dupsh import LinuxAMD64Dupsh
from .linux_mips32_dupsh import LinuxMIPS32Dupsh
from .linux_mips32_binsh import LinuxMIPS32Binsh
from .x86_setregister import X86SetRegister
from .x86_leakaddress import X86LeakAddress

Shellcodes = defaultdict(dict)

for s in Shellcode.__subclasses__():
    for os in s.os:
        for arch_id in s.arches:
            arch_name = archinfo.arch_from_id(arch_id).name
            if not arch_name in Shellcodes[os]:
                Shellcodes[os][arch_name] = { }
            Shellcodes[os][arch_name][s.name] = s

Shellcodes = dict(Shellcodes)
