from rex.exploit.cgc import CGCType2Exploit

class CGCType2ShellcodeExploit(CGCType2Exploit):
    '''
    A CGC type2 exploit object, which leaks the memory contents at an address
    with shellcode.
    '''

    def __init__(self, crash, shc_sym_mem, address_var, length_var):
        '''
        :param crash: a crash object which has been modified to exploit a
        vulnerability
        :param shc_sym_mem: symbolic memory variable representing shellcode
        :param address_var: variable of the the address
        :param length_var: variable of the length
        '''
        super(CGCType2ShellcodeExploit, self).__init__(crash, bypasses_nx=False, bypasses_aslr=False)

        self.method_name = 'shellcode'

        self._mem = shc_sym_mem
        self._arg_vars = [address_var, length_var]

        st = self.crash.state
        self._output_leak_idx = st.solver.eval(st.posix.fd[1].write_pos)

        self._generate_formula()

    def __str__(self):
        return "shellcode type2"
