import claripy
from rex.exploit import CannotExploit
from rex.exploit.cgc import CGCType1Exploit


class CGCType1CircumstantialExploit(CGCType1Exploit):
    '''
    A CGC type1 exploit object, which sets a register via Rop.
    '''

    def __init__(self, crash, register, reg_bitmask, ip_bitmask, reg_mem, value_var, ip_var):
        '''
        :param crash: a crash object which has been modified to exploit a vulnerability
        :param register: the register set by the exploit
        :param reg_bitmask: the bitmask indicating the bits of the register can be controlled
        :param ip_bitmask: the bitmask indicating the bits of the ip can be controlled
        :param reg_mem: memory containing the register setting content
        :param value_var: claripy variable representing the value to set the register to
        :param ip_var: claripy variable representing the value to set ip to
        '''
        super(CGCType1CircumstantialExploit, self).__init__(crash, register, bypasses_nx=True, bypasses_aslr=True,
                                                            reg_bitmask=reg_bitmask, ip_bitmask=ip_bitmask)

        self.method_name = 'circumstantial'

        self._arg_vars = [value_var, ip_var]

        self._mem = claripy.Concat(reg_mem[0], reg_mem[1])

        self._generate_formula()

    def __str__(self):
        return "<%s> circumstantial type1" % self.register
