// ui/ozone/public/mojom/gesture_properties_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/gesture_properties_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-params-data.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-import-headers.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace ozone {
namespace mojom {
GesturePropValue::GesturePropValue() : tag_(Tag::INTS) {
  data_.ints = new std::vector<int32_t>;
}

GesturePropValue::~GesturePropValue() {
  DestroyActive();
}


void GesturePropValue::set_ints(
    std::vector<int32_t> ints) {
  if (tag_ == Tag::INTS) {
    *(data_.ints) = std::move(ints);
  } else {
    DestroyActive();
    tag_ = Tag::INTS;
    data_.ints = new std::vector<int32_t>(
        std::move(ints));
  }
}
void GesturePropValue::set_shorts(
    std::vector<int16_t> shorts) {
  if (tag_ == Tag::SHORTS) {
    *(data_.shorts) = std::move(shorts);
  } else {
    DestroyActive();
    tag_ = Tag::SHORTS;
    data_.shorts = new std::vector<int16_t>(
        std::move(shorts));
  }
}
void GesturePropValue::set_bools(
    std::vector<bool> bools) {
  if (tag_ == Tag::BOOLS) {
    *(data_.bools) = std::move(bools);
  } else {
    DestroyActive();
    tag_ = Tag::BOOLS;
    data_.bools = new std::vector<bool>(
        std::move(bools));
  }
}
void GesturePropValue::set_str(
    const std::string& str) {
  if (tag_ == Tag::STR) {
    *(data_.str) = std::move(str);
  } else {
    DestroyActive();
    tag_ = Tag::STR;
    data_.str = new std::string(
        std::move(str));
  }
}
void GesturePropValue::set_reals(
    std::vector<double> reals) {
  if (tag_ == Tag::REALS) {
    *(data_.reals) = std::move(reals);
  } else {
    DestroyActive();
    tag_ = Tag::REALS;
    data_.reals = new std::vector<double>(
        std::move(reals));
  }
}

void GesturePropValue::DestroyActive() {
  switch (tag_) {

    case Tag::INTS:

      delete data_.ints;
      break;
    case Tag::SHORTS:

      delete data_.shorts;
      break;
    case Tag::BOOLS:

      delete data_.bools;
      break;
    case Tag::STR:

      delete data_.str;
      break;
    case Tag::REALS:

      delete data_.reals;
      break;
  }
}

bool GesturePropValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char GesturePropertiesService::Name_[] = "ui.ozone.mojom.GesturePropertiesService";

class GesturePropertiesService_ListDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_ListDevices_ForwardToCallback(
      GesturePropertiesService::ListDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::ListDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_ListDevices_ForwardToCallback);
};

class GesturePropertiesService_ListProperties_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_ListProperties_ForwardToCallback(
      GesturePropertiesService::ListPropertiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::ListPropertiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_ListProperties_ForwardToCallback);
};

class GesturePropertiesService_GetProperty_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_GetProperty_ForwardToCallback(
      GesturePropertiesService::GetPropertyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::GetPropertyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_GetProperty_ForwardToCallback);
};

class GesturePropertiesService_SetProperty_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_SetProperty_ForwardToCallback(
      GesturePropertiesService::SetPropertyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::SetPropertyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_SetProperty_ForwardToCallback);
};

GesturePropertiesServiceProxy::GesturePropertiesServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GesturePropertiesServiceProxy::ListDevices(
    ListDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "ui::ozone::mojom::GesturePropertiesService::ListDevices");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_ListDevices_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_ListDevices_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_ListDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GesturePropertiesServiceProxy::ListProperties(
    int32_t in_device_id, ListPropertiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::GesturePropertiesService::ListProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("device_id", in_device_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_ListProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_ListProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->device_id = in_device_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListProperties");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_ListProperties_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GesturePropertiesServiceProxy::GetProperty(
    int32_t in_device_id, const std::string& in_name, GetPropertyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::GesturePropertiesService::GetProperty", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("device_id", in_device_id);
      raw_value->SetString("name", in_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_GetProperty_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_GetProperty_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->device_id = in_device_id;
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in GesturePropertiesService.GetProperty request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("GetProperty");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_GetProperty_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GesturePropertiesServiceProxy::SetProperty(
    int32_t in_device_id, const std::string& in_name, GesturePropValuePtr in_value, SetPropertyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::GesturePropertiesService::SetProperty", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("device_id", in_device_id);
      raw_value->SetString("name", in_name);
      raw_value->SetString("value", base::trace_event::ValueToString(in_value, "<value of type GesturePropValuePtr>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_SetProperty_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_SetProperty_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->device_id = in_device_id;
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in GesturePropertiesService.SetProperty request");
  typename decltype(params->value)::BufferWriter value_writer;
  value_writer.AllocateInline(buffer, &params->value);
  mojo::internal::Serialize<::ui::ozone::mojom::GesturePropValueDataView>(
      in_value, buffer, &value_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in GesturePropertiesService.SetProperty request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("SetProperty");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_SetProperty_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GesturePropertiesService_ListDevices_ProxyToResponder {
 public:
  static GesturePropertiesService::ListDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GesturePropertiesService_ListDevices_ProxyToResponder> proxy(
        new GesturePropertiesService_ListDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GesturePropertiesService_ListDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_ListDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GesturePropertiesService_ListDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::ListDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<int32_t, std::string>& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_ListDevices_ProxyToResponder);
};

bool GesturePropertiesService_ListDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::GesturePropertiesService::ListDevicesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_ListDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_ListDevices_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  base::flat_map<int32_t, std::string> p_result{};
  GesturePropertiesService_ListDevices_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void GesturePropertiesService_ListDevices_ProxyToResponder::Run(
    const base::flat_map<int32_t, std::string>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::ListDevicesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginDictionary("result");
      for (const auto& item0 : in_result) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type int32_t>"), item0.second);
      }
      raw_value->EndDictionary();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_ListDevices_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_ListDevices_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  const mojo::internal::ContainerValidateParams result_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  mojo::internal::Serialize<mojo::MapDataView<int32_t, mojo::StringDataView>>(
      in_result, buffer, &result_writer, &result_validate_params,
      &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::ListDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_ListProperties_ProxyToResponder {
 public:
  static GesturePropertiesService::ListPropertiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GesturePropertiesService_ListProperties_ProxyToResponder> proxy(
        new GesturePropertiesService_ListProperties_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GesturePropertiesService_ListProperties_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_ListProperties_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GesturePropertiesService_ListProperties_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::ListPropertiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_properties);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_ListProperties_ProxyToResponder);
};

bool GesturePropertiesService_ListProperties_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::GesturePropertiesService::ListPropertiesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_ListProperties_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_ListProperties_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<std::string> p_properties{};
  GesturePropertiesService_ListProperties_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadProperties(&p_properties))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_properties));
  return true;
}

void GesturePropertiesService_ListProperties_ProxyToResponder::Run(
    const std::vector<std::string>& in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::ListPropertiesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("properties");
      for (const auto& item0 : in_properties) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_ListProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_ListProperties_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->properties)::BaseType::BufferWriter
      properties_writer;
  const mojo::internal::ContainerValidateParams properties_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_properties, buffer, &properties_writer, &properties_validate_params,
      &serialization_context);
  params->properties.Set(
      properties_writer.is_null() ? nullptr : properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::ListPropertiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListProperties");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_GetProperty_ProxyToResponder {
 public:
  static GesturePropertiesService::GetPropertyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GesturePropertiesService_GetProperty_ProxyToResponder> proxy(
        new GesturePropertiesService_GetProperty_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GesturePropertiesService_GetProperty_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_GetProperty_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GesturePropertiesService_GetProperty_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::GetPropertyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_read_only, GesturePropValuePtr in_value);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_GetProperty_ProxyToResponder);
};

bool GesturePropertiesService_GetProperty_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::GesturePropertiesService::GetPropertyCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_GetProperty_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_GetProperty_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_is_read_only{};
  GesturePropValuePtr p_value{};
  GesturePropertiesService_GetProperty_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_is_read_only = input_data_view.is_read_only();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_read_only), 
std::move(p_value));
  return true;
}

void GesturePropertiesService_GetProperty_ProxyToResponder::Run(
    bool in_is_read_only, GesturePropValuePtr in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::GetPropertyCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_read_only", in_is_read_only);
      raw_value->SetString("value", base::trace_event::ValueToString(in_value, "<value of type GesturePropValuePtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_GetProperty_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_GetProperty_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_read_only = in_is_read_only;
  typename decltype(params->value)::BufferWriter value_writer;
  value_writer.AllocateInline(buffer, &params->value);
  mojo::internal::Serialize<::ui::ozone::mojom::GesturePropValueDataView>(
      in_value, buffer, &value_writer, true, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::GetPropertyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("GetProperty");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_SetProperty_ProxyToResponder {
 public:
  static GesturePropertiesService::SetPropertyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GesturePropertiesService_SetProperty_ProxyToResponder> proxy(
        new GesturePropertiesService_SetProperty_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GesturePropertiesService_SetProperty_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_SetProperty_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GesturePropertiesService_SetProperty_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::SetPropertyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SetGesturePropErrorCode in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GesturePropertiesService_SetProperty_ProxyToResponder);
};

bool GesturePropertiesService_SetProperty_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::GesturePropertiesService::SetPropertyCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_SetProperty_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_SetProperty_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SetGesturePropErrorCode p_error{};
  GesturePropertiesService_SetProperty_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void GesturePropertiesService_SetProperty_ProxyToResponder::Run(
    SetGesturePropErrorCode in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::SetPropertyCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGesturePropertiesService_SetProperty_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::ui::ozone::mojom::internal::GesturePropertiesService_SetProperty_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::ui::ozone::mojom::SetGesturePropErrorCode>(
      in_error, &params->error);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::GesturePropertiesService::SetPropertyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("SetProperty");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GesturePropertiesServiceStubDispatch::Accept(
    GesturePropertiesService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kGesturePropertiesService_ListDevices_Name: {
      break;
    }
    case internal::kGesturePropertiesService_ListProperties_Name: {
      break;
    }
    case internal::kGesturePropertiesService_GetProperty_Name: {
      break;
    }
    case internal::kGesturePropertiesService_SetProperty_Name: {
      break;
    }
  }
  return false;
}

// static
bool GesturePropertiesServiceStubDispatch::AcceptWithResponder(
    GesturePropertiesService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGesturePropertiesService_ListDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::GesturePropertiesService::ListDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::GesturePropertiesService::ListDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GesturePropertiesService_ListDevices_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_ListDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GesturePropertiesService_ListDevices_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 0, false);
        return false;
      }
      GesturePropertiesService::ListDevicesCallback callback =
          GesturePropertiesService_ListDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListDevices(std::move(callback));
      return true;
    }
    case internal::kGesturePropertiesService_ListProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::GesturePropertiesService::ListProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::GesturePropertiesService::ListProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GesturePropertiesService_ListProperties_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_ListProperties_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_device_id{};
      GesturePropertiesService_ListProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 1, false);
        return false;
      }
      GesturePropertiesService::ListPropertiesCallback callback =
          GesturePropertiesService_ListProperties_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListProperties(
std::move(p_device_id), std::move(callback));
      return true;
    }
    case internal::kGesturePropertiesService_GetProperty_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::GesturePropertiesService::GetProperty",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::GesturePropertiesService::GetProperty");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GesturePropertiesService_GetProperty_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_GetProperty_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_device_id{};
      std::string p_name{};
      GesturePropertiesService_GetProperty_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 2, false);
        return false;
      }
      GesturePropertiesService::GetPropertyCallback callback =
          GesturePropertiesService_GetProperty_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProperty(
std::move(p_device_id), 
std::move(p_name), std::move(callback));
      return true;
    }
    case internal::kGesturePropertiesService_SetProperty_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::GesturePropertiesService::SetProperty",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::GesturePropertiesService::SetProperty");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GesturePropertiesService_SetProperty_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_SetProperty_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_device_id{};
      std::string p_name{};
      GesturePropValuePtr p_value{};
      GesturePropertiesService_SetProperty_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 3, false);
        return false;
      }
      GesturePropertiesService::SetPropertyCallback callback =
          GesturePropertiesService_SetProperty_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProperty(
std::move(p_device_id), 
std::move(p_name), 
std::move(p_value), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGesturePropertiesServiceValidationInfo[] = {
    {internal::kGesturePropertiesService_ListDevices_Name,
     {&internal::GesturePropertiesService_ListDevices_Params_Data::Validate,
      &internal::GesturePropertiesService_ListDevices_ResponseParams_Data::Validate}},
    {internal::kGesturePropertiesService_ListProperties_Name,
     {&internal::GesturePropertiesService_ListProperties_Params_Data::Validate,
      &internal::GesturePropertiesService_ListProperties_ResponseParams_Data::Validate}},
    {internal::kGesturePropertiesService_GetProperty_Name,
     {&internal::GesturePropertiesService_GetProperty_Params_Data::Validate,
      &internal::GesturePropertiesService_GetProperty_ResponseParams_Data::Validate}},
    {internal::kGesturePropertiesService_SetProperty_Name,
     {&internal::GesturePropertiesService_SetProperty_Params_Data::Validate,
      &internal::GesturePropertiesService_SetProperty_ResponseParams_Data::Validate}},
};

bool GesturePropertiesServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::GesturePropertiesService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGesturePropertiesServiceValidationInfo);
}

bool GesturePropertiesServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::GesturePropertiesService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGesturePropertiesServiceValidationInfo);

}
}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {

// static
bool UnionTraits<::ui::ozone::mojom::GesturePropValue::DataView, ::ui::ozone::mojom::GesturePropValuePtr>::Read(
    ::ui::ozone::mojom::GesturePropValue::DataView input,
    ::ui::ozone::mojom::GesturePropValuePtr* output) {
  using UnionType = ::ui::ozone::mojom::GesturePropValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::INTS: {
      std::vector<int32_t> result_ints;
      if (!input.ReadInts(&result_ints))
        return false;

      *output = UnionType::NewInts(
          std::move(result_ints));
      break;
    }
    case Tag::SHORTS: {
      std::vector<int16_t> result_shorts;
      if (!input.ReadShorts(&result_shorts))
        return false;

      *output = UnionType::NewShorts(
          std::move(result_shorts));
      break;
    }
    case Tag::BOOLS: {
      std::vector<bool> result_bools;
      if (!input.ReadBools(&result_bools))
        return false;

      *output = UnionType::NewBools(
          std::move(result_bools));
      break;
    }
    case Tag::STR: {
      std::string result_str;
      if (!input.ReadStr(&result_str))
        return false;

      *output = UnionType::NewStr(
          std::move(result_str));
      break;
    }
    case Tag::REALS: {
      std::vector<double> result_reals;
      if (!input.ReadReals(&result_reals))
        return false;

      *output = UnionType::NewReals(
          std::move(result_reals));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif