// ui/accessibility/mojom/ax_tree_update.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"







namespace ax {
namespace mojom {
class AXTreeUpdateDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeUpdateDataView> {
  using Data = ::ax::mojom::internal::AXTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXTreeUpdateDataView {
 public:
  AXTreeUpdateDataView() {}

  AXTreeUpdateDataView(
      internal::AXTreeUpdate_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool has_tree_data() const {
    return data_->has_tree_data;
  }
  inline void GetTreeDataDataView(
      ::ax::mojom::AXTreeDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTreeData(UserType* output) {
    
    auto* pointer = data_->tree_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeDataDataView>(
        pointer, output, context_);
  }
  int32_t node_id_to_clear() const {
    return data_->node_id_to_clear;
  }
  int32_t root_id() const {
    return data_->root_id;
  }
  inline void GetNodesDataView(
      mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNodes(UserType* output) {
    
    auto* pointer = data_->nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventFrom(UserType* output) const {
    auto data_value = data_->event_from;
    return mojo::internal::Deserialize<::ax::mojom::EventFrom>(
        data_value, output);
  }

  ::ax::mojom::EventFrom event_from() const {
    return static_cast<::ax::mojom::EventFrom>(data_->event_from);
  }
  inline void GetEventIntentsDataView(
      mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventIntents(UserType* output) {
    
    auto* pointer = data_->event_intents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        pointer, output, context_);
  }
 private:
  internal::AXTreeUpdate_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeUpdateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXTreeUpdate_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->has_tree_data = Traits::has_tree_data(input);
    decltype(Traits::tree_data(input)) in_tree_data = Traits::tree_data(input);
    typename decltype((*output)->tree_data)::BaseType::BufferWriter
        tree_data_writer;
    mojo::internal::Serialize<::ax::mojom::AXTreeDataDataView>(
        in_tree_data, buffer, &tree_data_writer, context);
    (*output)->tree_data.Set(
        tree_data_writer.is_null() ? nullptr : tree_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->tree_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_data in AXTreeUpdate struct");
    (*output)->node_id_to_clear = Traits::node_id_to_clear(input);
    (*output)->root_id = Traits::root_id(input);
    decltype(Traits::nodes(input)) in_nodes = Traits::nodes(input);
    typename decltype((*output)->nodes)::BaseType::BufferWriter
        nodes_writer;
    const mojo::internal::ContainerValidateParams nodes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>>(
        in_nodes, buffer, &nodes_writer, &nodes_validate_params,
        context);
    (*output)->nodes.Set(
        nodes_writer.is_null() ? nullptr : nodes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes in AXTreeUpdate struct");
    mojo::internal::Serialize<::ax::mojom::EventFrom>(
        Traits::event_from(input), &(*output)->event_from);
    decltype(Traits::event_intents(input)) in_event_intents = Traits::event_intents(input);
    typename decltype((*output)->event_intents)::BaseType::BufferWriter
        event_intents_writer;
    const mojo::internal::ContainerValidateParams event_intents_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        in_event_intents, buffer, &event_intents_writer, &event_intents_validate_params,
        context);
    (*output)->event_intents.Set(
        event_intents_writer.is_null() ? nullptr : event_intents_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->event_intents.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_intents in AXTreeUpdate struct");
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeUpdate_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeUpdateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXTreeUpdateDataView::GetTreeDataDataView(
    ::ax::mojom::AXTreeDataDataView* output) {
  auto pointer = data_->tree_data.Get();
  *output = ::ax::mojom::AXTreeDataDataView(pointer, context_);
}
inline void AXTreeUpdateDataView::GetNodesDataView(
    mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>* output) {
  auto pointer = data_->nodes.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>(pointer, context_);
}
inline void AXTreeUpdateDataView::GetEventIntentsDataView(
    mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output) {
  auto pointer = data_->event_intents.Get();
  *output = mojo::ArrayDataView<::ax::mojom::EventIntentDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_