// ui/accessibility/mojom/ax_event_intent.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"







namespace ax {
namespace mojom {
class EventIntentDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::EventIntentDataView> {
  using Data = ::ax::mojom::internal::EventIntent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class EventIntentDataView {
 public:
  EventIntentDataView() {}

  EventIntentDataView(
      internal::EventIntent_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCommand(UserType* output) const {
    auto data_value = data_->command;
    return mojo::internal::Deserialize<::ax::mojom::Command>(
        data_value, output);
  }

  ::ax::mojom::Command command() const {
    return static_cast<::ax::mojom::Command>(data_->command);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputEventType(UserType* output) const {
    auto data_value = data_->input_event_type;
    return mojo::internal::Deserialize<::ax::mojom::InputEventType>(
        data_value, output);
  }

  ::ax::mojom::InputEventType input_event_type() const {
    return static_cast<::ax::mojom::InputEventType>(data_->input_event_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextBoundary(UserType* output) const {
    auto data_value = data_->text_boundary;
    return mojo::internal::Deserialize<::ax::mojom::TextBoundary>(
        data_value, output);
  }

  ::ax::mojom::TextBoundary text_boundary() const {
    return static_cast<::ax::mojom::TextBoundary>(data_->text_boundary);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMoveDirection(UserType* output) const {
    auto data_value = data_->move_direction;
    return mojo::internal::Deserialize<::ax::mojom::MoveDirection>(
        data_value, output);
  }

  ::ax::mojom::MoveDirection move_direction() const {
    return static_cast<::ax::mojom::MoveDirection>(data_->move_direction);
  }
 private:
  internal::EventIntent_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::EventIntentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::EventIntentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::EventIntent_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::ax::mojom::Command>(
        Traits::command(input), &(*output)->command);
    mojo::internal::Serialize<::ax::mojom::InputEventType>(
        Traits::input_event_type(input), &(*output)->input_event_type);
    mojo::internal::Serialize<::ax::mojom::TextBoundary>(
        Traits::text_boundary(input), &(*output)->text_boundary);
    mojo::internal::Serialize<::ax::mojom::MoveDirection>(
        Traits::move_direction(input), &(*output)->move_direction);
  }

  static bool Deserialize(::ax::mojom::internal::EventIntent_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::EventIntentDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {




}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_SHARED_H_