// third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class SpeechSynthesisUtteranceDataView;

class SpeechSynthesisVoiceDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SpeechSynthesisUtteranceDataView> {
  using Data = ::blink::mojom::internal::SpeechSynthesisUtterance_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SpeechSynthesisVoiceDataView> {
  using Data = ::blink::mojom::internal::SpeechSynthesisVoice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class SpeechSynthesisVoiceListObserverInterfaceBase {};

using SpeechSynthesisVoiceListObserverPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
class SpeechSynthesisClientInterfaceBase {};

using SpeechSynthesisClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisClientInterfaceBase>;
class SpeechSynthesisInterfaceBase {};

using SpeechSynthesisPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisInterfaceBase>;


class SpeechSynthesisUtteranceDataView {
 public:
  SpeechSynthesisUtteranceDataView() {}

  SpeechSynthesisUtteranceDataView(
      internal::SpeechSynthesisUtterance_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLang(UserType* output) {
    
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetVoiceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVoice(UserType* output) {
    
    auto* pointer = data_->voice.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  double volume() const {
    return data_->volume;
  }
  double rate() const {
    return data_->rate;
  }
  double pitch() const {
    return data_->pitch;
  }
 private:
  internal::SpeechSynthesisUtterance_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpeechSynthesisVoiceDataView {
 public:
  SpeechSynthesisVoiceDataView() {}

  SpeechSynthesisVoiceDataView(
      internal::SpeechSynthesisVoice_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetVoiceUriDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVoiceUri(UserType* output) {
    
    auto* pointer = data_->voice_uri.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLang(UserType* output) {
    
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool is_local_service() const {
    return data_->is_local_service;
  }
  bool is_default() const {
    return data_->is_default;
  }
 private:
  internal::SpeechSynthesisVoice_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeechSynthesisUtteranceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeechSynthesisUtteranceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SpeechSynthesisUtterance_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::text(input)) in_text = Traits::text(input);
    typename decltype((*output)->text)::BaseType::BufferWriter
        text_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text, buffer, &text_writer, context);
    (*output)->text.Set(
        text_writer.is_null() ? nullptr : text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in SpeechSynthesisUtterance struct");
    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    typename decltype((*output)->lang)::BaseType::BufferWriter
        lang_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_lang, buffer, &lang_writer, context);
    (*output)->lang.Set(
        lang_writer.is_null() ? nullptr : lang_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lang.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lang in SpeechSynthesisUtterance struct");
    decltype(Traits::voice(input)) in_voice = Traits::voice(input);
    typename decltype((*output)->voice)::BaseType::BufferWriter
        voice_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_voice, buffer, &voice_writer, context);
    (*output)->voice.Set(
        voice_writer.is_null() ? nullptr : voice_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->voice.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null voice in SpeechSynthesisUtterance struct");
    (*output)->volume = Traits::volume(input);
    (*output)->rate = Traits::rate(input);
    (*output)->pitch = Traits::pitch(input);
  }

  static bool Deserialize(::blink::mojom::internal::SpeechSynthesisUtterance_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpeechSynthesisUtteranceDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeechSynthesisVoiceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeechSynthesisVoiceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SpeechSynthesisVoice_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::voice_uri(input)) in_voice_uri = Traits::voice_uri(input);
    typename decltype((*output)->voice_uri)::BaseType::BufferWriter
        voice_uri_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_voice_uri, buffer, &voice_uri_writer, context);
    (*output)->voice_uri.Set(
        voice_uri_writer.is_null() ? nullptr : voice_uri_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->voice_uri.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null voice_uri in SpeechSynthesisVoice struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in SpeechSynthesisVoice struct");
    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    typename decltype((*output)->lang)::BaseType::BufferWriter
        lang_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_lang, buffer, &lang_writer, context);
    (*output)->lang.Set(
        lang_writer.is_null() ? nullptr : lang_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lang.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lang in SpeechSynthesisVoice struct");
    (*output)->is_local_service = Traits::is_local_service(input);
    (*output)->is_default = Traits::is_default(input);
  }

  static bool Deserialize(::blink::mojom::internal::SpeechSynthesisVoice_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpeechSynthesisVoiceDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void SpeechSynthesisUtteranceDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SpeechSynthesisUtteranceDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SpeechSynthesisUtteranceDataView::GetVoiceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->voice.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void SpeechSynthesisVoiceDataView::GetVoiceUriDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->voice_uri.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SpeechSynthesisVoiceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SpeechSynthesisVoiceDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_